/* fill an integer array with the length of the axes of an n-dimensional
 * image.
 *
 * if NAXES are  1, 1, 100, 128, 3  (NAXIS = 5)
 *  the number of real dimensions as returned by getimaginfo is 3
 *  nlengths(array, 2) will return  100, 128 in array
 *  nlengths(array, 3) will return  100, 128, 3
 *  nlengths(array, 4) will return  100, 128, 3, 1
 *   that is if n is greater than the number of real dimensions the "unreal"
 *   dimensions are considered to have length 1
 *
 *   the imaginfo struct should already be filled by getimaginfo()
 */

#include "imaginfo.h"

void nlengths(image, array, n)
struct imaginfo *image;
int array[];
int n;
{

     int imagedim, index;

     for(imagedim=0, index=0 ; imagedim < image->ndim && index < n; imagedim++)
	  if(image->naxis[imagedim] > 1)
	     array[index++] = image->naxis[imagedim];

     while(index < n)
	     array[index++] = 1;

     /* that all folk's ! */
}
