/* command line parameter fetching routine */
/* debug stuff too */
/* #Copyright (C) 1992, California Institute of Technology. */
/* #U.S. Government Sponsorship under NASA Contract NAS7-918 */
/* #is acknowledged. */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "squawk.h"
#include "imaginfo.h"
#include "flatten.h"

int debug;    /* any routine in the package needs access to this. */

int main(argc,argv)
int argc;
char *argv[];
{

    char strbuf[BUFSIZ], infilnam[BUFSIZ], outfilnam[BUFSIZ];
    char *bufptr;
    char *cptr;
    int *arrayptr;
    int nints, howmany;
    int point_counter;
    int realloc_counter;
    int points_to_go;
    /* for debugging */
    int di, *diptr;

    debug = 0;

    if(argc > 1) { /* right now we only support formatted input on stdin   */
		   /* any arguments are completely bogus                   */
	if(argv[1][0] == '-'){
	   debug = atoi(&(argv[1][1]));
           }
        else {
           fprintf(stderr,"%s reads stdin, and takes no arguments\n", argv[0]);
	   exit(1);
	   }
	}

    if(debug) fprintf(stderr,"Debug set to %d\n", debug);
   
    if((bufptr = (char *)malloc(STARTPTS * INTSPERPT * sizeof(int))) == (char *) NULL){
	fprintf(stderr,"No space to store reference points!\n");
	exit(1);
	}

    if(fgets(strbuf, BUFSIZ, stdin) == (char *) NULL){
      fprintf(stderr,"Bad filename read (1)\n");
      exit(1);
    }
    /* strip trailing newline character */
    cptr = strchr(strbuf, '\n');
    if (cptr != (char *) 0) *cptr = '\0';
    strcpy(infilnam, strbuf);

    if(fgets(strbuf, BUFSIZ, stdin) == (char *) NULL){
      fprintf(stderr,"Bad filename read (2)\n");
      exit(1);
    }
    /* strip trailing newline character */
    cptr = strchr(strbuf, '\n');
    if (cptr != (char *) 0) *cptr = '\0';
    strcpy(outfilnam, strbuf);

    arrayptr = (int *) bufptr;
    point_counter = 0;
    realloc_counter = 0;
    points_to_go = STARTPTS;

    while( fgets( strbuf, BUFSIZ, stdin) != (char *) NULL){
      if((nints = sscanf(strbuf, "%d%d", arrayptr, arrayptr+1)) < 2)
	 continue; /* ignore the line, probably a comment */
      point_counter++ ;
      arrayptr += INTSPERPT ;
      if(! --points_to_go){ /* ran out of room, need to realloc */
	 realloc_counter++;
	 howmany = (STARTPTS + (realloc_counter * REALLOCPTS)) * INTSPERPT ;
         if((bufptr = (char *)realloc(bufptr, howmany * sizeof(int))) == (char *) NULL){
             fprintf(stderr,"No space to store reference points!\n");
             exit(1);
             }
         /* reset array pointer */
         arrayptr = ((int *) bufptr) + (point_counter * INTSPERPT);
         points_to_go = REALLOCPTS;
      }
    }
    if (debug == 13){
	fprintf(stderr,"Interpreted inputs:\n");
	fprintf(stderr,"Input file = %s\n", infilnam);
	fprintf(stderr,"Output file= %s\n", outfilnam);
	fprintf(stderr,"Number of reference points = %d\n", point_counter);
	diptr = (int *) bufptr;
	fprintf(stderr,"Point   X    Y \n");
	fprintf(stderr,"---------------\n");
	for (di = 0; di < point_counter; di++, diptr+=2)
	  fprintf(stderr,"%4d %4d %4d\n", di, *diptr,*(diptr+1));

	fprintf(stderr,"Terminating on Debug mode = %d\n", debug);
	exit(debug);
       } 

    if(conductor(infilnam, outfilnam, (int *) bufptr, point_counter) != 0)
       fprintf(stderr, "Flatten didn't work.\n");

    free(bufptr);
    exit(0);
    return(0);
}
