/* RBH changes 9-18-96: */
/*   decreased BLANK32, MAX32 by 1  */
/*   decreased DEL32 by 2   */
#include <stdio.h>
#include "squawk.h"
#include <math.h>
#ifdef NOTDEF
#include <values.h>
#endif /* NOTDEF */
#include "imaginfo.h"
#include "im_proto.h"

#ifndef MAXDOUBLE
#include <float.h>
#define MAXDOUBLE DBL_MAX
#endif

/* sizes of numbers */

#define BYTE_SIZE 8
#define BLANK8 255
#define BLANK16 -32768
#define BLANK32 -2147483647
#define MAX8 254.
#define MIN8 0.
#define DEL8 254.   /* this is the true range of DN */
#define MAX16 32767.
#define MIN16 -MAX16
#define DEL16 65534.
/* #define MAX32 1000000000 */ /* Use this if there are severe roundoff errors */
#define MAX32 2147483646.   /* This is the best (-1) */
#define MIN32 -MAX32
#define DEL32 4294967292.

#define MAX(a,b)    (a>b)?a:b
#define MIN(a,b)    (a<b)?a:b

void hdrclean(pixel, image)
PIXEL *pixel;
struct imaginfo *image;
{
    
    int bitpix; /* contains the value of bitpix the output image will have */
    double dmin, dmax; /* datamax and datamin */
    double bscale, b_zero;
    double max; /* max DN value for a given bitpix */
    double min; /* min DN value for a given bitpix */
    double delta; /* range of DN for a given bitpix */
    PIXEL imblank;
    char linebuf[81];
    int blank;
    int errval;
    int count;
    extern int debug;

    /* First find out what were dealing with, bitpix= ? */
    errval = im_rkey_i(image->fid, &bitpix, "BITPIX");

    /* position at first keyword */ 
    if(im_rkey_t(image->fid,linebuf,"1") < 0)
      squawk(Terminal,"Couldn't rewind header on output image! Giving up");

       if(errval == -1){
       squawk(Tolerable,"No BITPIX value set for output image");
       squawk(Tolerable,"I'll set and use BITPIX = 32");
       bitpix = 32;
       if(im_wkey_i(image->fid, bitpix, "BITPIX") < 0)
	  squawk(Terminal,"Unable to create BITPIX card");
       }
       else if(errval < -1)
	  squawk(Terminal,"cleanup: couldn't read output header");
	  
     /* if we survive that then we should be ok */

     /* scan the image to find max and min pixel */
     im_blank(&imblank);
     count = image->npixels;
     dmin = MAXDOUBLE;
     dmax = -MAXDOUBLE;
     while(count--){
       if(*pixel != image->blank){
            dmax = MAX(*pixel,dmax);
            dmin = MIN(*pixel,dmin);
	    }
       else
	    *pixel = imblank;  /* Force whatever we're using internally as
				* blank to be the external value.
				*/
       pixel++;
     }

    errval = 0;
    switch (bitpix)
    {
	case 8:
	{
	    blank = BLANK8;
	    max   = MAX8 ;
	    min   = MIN8 ;
	    delta = DEL8 ;
            errval = 1;
	    break;
	}
	case 16:
	{
	    blank = BLANK16;
	    max   = MAX16 ;
	    min   = MIN16 ;
	    delta = DEL16 ;
            errval = 1;
	    break;
	}
	case 32:
	{
	    blank = BLANK32;
	    max   = MAX32 ;
	    min   = MIN32 ;
	    delta = DEL32 ;
            errval = 1;
	    break;
	}
	case -32:
	{
	    /* Don't worry about Bscale and B_zero
	     * just update DATAMAX and DATAMIN
             */
            break;
        }
	default:
	    squawk(Terminal,"HELP! Serious error bad bitpix");
	
    }

     /* only update the B* cards if we're dealing with integer pixels */
     if(errval){
       /* select the best way of pushing pixels into the DN space */
       /* we can always do at least this well: */
       bscale = (dmax - dmin) / delta ;
       b_zero =  (dmax + dmin) / 2.;
       /*but*/
#ifdef NEVERDEFINED
  This is a nice idea but not implemented right
      if((dmax - dmin) <= delta){  /* Just map Pixel 1 to 1 with DN */
	  if(dmax <= max && dmin >= min ){ 
	     bscale = 1.0;
	     b_zero = 0.0;
          }
	  else {  /* The range fits, but the is an offset */
	     bscale = 1.0;
	     b_zero = dmin;
	  }
       } 
#endif

       if(im_wkey_i(image->fid, blank, "BLANK") < 0)
	  squawk(Terminal,"Unable to update BLANK card");

       if(im_wkey_d(image->fid, bscale, "BSCALE") < 0)
	  squawk(Terminal,"Unable to update BSCALE card");

       if(im_wkey_d(image->fid, b_zero, "BZERO") < 0)
	  squawk(Terminal,"Unable to update BZERO card");
     }

       if(im_wkey_d(image->fid, dmax, "DATAMAX") < 0)
	  squawk(Terminal,"Unable to update DATAMAX card");

       if(im_wkey_d(image->fid, dmin, "DATAMIN") < 0)
	  squawk(Terminal,"Unable to update DATAMIN card");

     if(debug > 6){
	fprintf(stderr,
	   "Cleanup decided on these values for the output header:\n");
	fprintf(stderr,"Based on BITPIX = %d\n", bitpix);
        fprintf(stderr,"BLANK    == %d\n", blank);
        fprintf(stderr,"BSCALE   == %.10g\n", bscale);
        fprintf(stderr,"BZERO    == %.10g\n", b_zero);
        fprintf(stderr,"DATAMAX  == %.10g\n", dmax);
        fprintf(stderr,"DATAMIN  == %.10g\n", dmin);
	}

}
