/* get generally useful image information                    */
/* imag->fid must be valid.. ie the image is already open    */
/* return the number of real image dimensions in the image   */
/*   i.e. the number of NAXISn's with lengths greater than 1 */
#include "squawk.h"
#include "imaginfo.h"
#include <stdio.h>
#include "im_proto.h"

int
getimaginfo(imag)
struct imaginfo *imag;
{
     extern int debug;
     char skey[9];
     int counter;
     int realdims;

    if(debug>5)
	fprintf(stderr,"getinfo> entry\n");

        im_blank(&imag->blank);  /* whaddaya mean "BLANK" ? */
#if EBUG
    if(debug>5)
	fprintf(stderr,"getinfo> get naxis\n");
#endif
/* number of axes in this image */
	if(im_rkey_i(imag->fid, &imag->ndim, "NAXIS") < 0)
		squawk(Terminal,"Error getting imageinfo");
/* now get the length of each of them... */
    if(debug>5)
	fprintf(stderr,"getinfo> get naxisn's\n");

	realdims = 0;
	imag->npixels = 1;
	for(counter=0; counter < imag->ndim; counter++){
	sprintf(skey,"NAXIS%d",counter+1);
	if(im_rkey_i(imag->fid, &imag->naxis[counter], skey) < 0)
		squawk(Terminal,"Error getting imageinfo");
	imag->npixels *= imag->naxis[counter];   /* calculate total # of pixels */
	if (imag->naxis[counter] > 1) realdims++;
	}
/* TODO:: get DATAMAX,DATAMIN, BSCALE & BZERO too */
        return(realdims); 
}
