/* #Copyright (C) 1992, California Institute of Technology. */
/* #U.S. Government Sponsorship under NASA Contract NAS7-918 */
/* #is acknowledged. */
#include <stdio.h>
#include <stdlib.h>
#include "imaginfo.h"
#include "flatten.h"
#define MAXORDER  5

void mk2darray();
int solvlin();

int
flatten( pixels, sx, sy, array, narefs, blank)
PIXEL *pixels;
int sx;  /* no. samples */
int sy;  /* no. lines   */
int array[]; /* reference pixel coordinate array */
int narefs;  /* number of reference coordinates */
PIXEL blank;
{



   register int  i, j, counter;
   double sumx, sumy, sumxy, sumxx, sumyy, sumz, sumxz, sumyz;
   extern int debug;
   int    **arefs;
   PIXEL  *pixptr;
   double coeff_mat[3][3];
   double lscoeffs[3];
   double soln_vector[3];
   double z;
   /* for debugging */
   int di;

   if(debug > 3) fprintf(stderr,"flatten> executing...\n");
   if(debug > 7){
      fprintf(stderr,"flatten> input parameters\n");
      fprintf(stderr," samples = %d, lines = %d, reference point count = %d\n",
		 sx, sy, narefs);
   }
   mk2darray(array, INTSPERPT, narefs, &arefs);
    if (debug == 14){
	fprintf(stderr,"Interpreted inputs in flatten:\n");
	fprintf(stderr,"Number of reference points = %d\n", narefs);
	fprintf(stderr,"Point   X    Y \n");
	fprintf(stderr,"---------------\n");
	for (di = 0; di < narefs; di++)
	  fprintf(stderr,"%4d %4d %4d\n", di, arefs[di][0], arefs[di][1]);

	fprintf(stderr,"Terminating on Debug mode = %d\n", debug);
	exit(debug);
       } 

   sumx = sumy = sumxy = sumxx = sumyy = sumz = sumxz = sumyz = 0.0;

   for(i = 0, counter = 0; i<narefs; i++){
      if(arefs[i][0] > sx || arefs[i][1] > sy ) continue;
      counter++;
      pixptr = pixels +(((arefs[i][1] -1)*sx) + arefs[i][0] -1) ;
      if(debug > 8) fprintf(stderr,"ref %d: value = %.6g\n", i,  *pixptr);
      sumx += arefs[i][0];
      sumy += arefs[i][1];
      sumxy += (double) arefs[i][0] * arefs[i][1];
      sumxx += (double) arefs[i][0] * arefs[i][0];
      sumyy += (double) arefs[i][1] * arefs[i][1];
      sumz  += *pixptr;
      sumxz += (double) (*pixptr)  *  arefs[i][0];
      sumyz += (double) (*pixptr)  *  arefs[i][1];
   }   
      if(debug > 7){
	fprintf(stderr, "flatten(7) Dumping accumulators...\n");
	fprintf(stderr, "counter = %d\n", counter);
	fprintf(stderr, "sumx    = %g\n", sumx);
	fprintf(stderr, "sumy    = %g\n", sumy);
	fprintf(stderr, "sumz    = %g\n", sumz);
	fprintf(stderr, "sumxx   = %g\n", sumxx);
	fprintf(stderr, "sumxy   = %g\n", sumxy);
	fprintf(stderr, "sumxz   = %g\n", sumxz);
	fprintf(stderr, "sumyy   = %g\n", sumyy);
	fprintf(stderr, "sumyz   = %g\n", sumyz);
	fprintf(stderr, "\n");
      }
/* note that matricies are organized as  coeff_mat[row][column]  */
      coeff_mat[0][0] = counter ;
      coeff_mat[1][0] = sumx ;
      coeff_mat[2][0] = sumy ;

      coeff_mat[0][1] = sumx ;
      coeff_mat[1][1] = sumxx;
      coeff_mat[2][1] = sumxy;

      coeff_mat[0][2] = sumy ;
      coeff_mat[1][2] = sumxy;
      coeff_mat[2][2] = sumyy;

      lscoeffs[0] = sumz ;
      lscoeffs[1] = sumxz;
      lscoeffs[2] = sumyz;

      /* Now go away and solve the system */
      /* counter -> 3, we are solving a matrix order 3! */
      if(solvlin(coeff_mat, 3, lscoeffs, soln_vector) )
	 return(-1);  /* Something really screwy... this shouldn't happen */

      /* if the thing got solved right, soln_vector[012] has the coeffs
       * A, B, C resp, to  Z = A + Bx + Cy, so for each non-blank pixel,
       * calculate Z and subtract:  Pixel - Z = NewPixel
       * Crisco! it's flattened.
       */
     if(debug > 2){
       fprintf(stderr,
         "Least Squares fit plane defined by Z = A + B(samp) + C(line)\n");
       fprintf(stderr,"where,\n");
       fprintf(stderr,"A = %.6f\n", soln_vector[0]);
       fprintf(stderr,"B = %.6f\n", soln_vector[1]);
       fprintf(stderr,"C = %.6f\n", soln_vector[2]);
     }

     for(i=1;i<=sy;i++)  /* for all lines */
       for(j=1;j<=sx;j++){  /* and all samples on each line */

         if(*pixels == blank){
	   pixels++;
	   continue;
         }

	 z = soln_vector[0] + j * soln_vector[1] + i * soln_vector[2] ;
	 *pixels++ -= z; 

       }

       /* that should be the whole enchillada */
       return(0);

}
#define Matrix 3
#ifdef Matrix
/* This version of solvlin uses Cauchy's Rule
 * to solve the system of equations;
 */
int
solvlin(mat, n, b, x)
double mat[][3], *b, *x;
int n;
{

     register int i, j, k, l;
     double t[3];
     double a[3][3];
     double det3(), delta;
     extern int debug;

     if(debug > 5) fprintf(stderr, "solvlin(det3)> executing...\n");
     if (n != 3 ) return (-1); /* This one ONLY works for order 3 */
     
     for(i=0;i<n;i++){
       for(j=0;j<n;j++)
	  a[i][j] = mat[i][j];

       t[i] = b[i];
     }

     if(debug > 8){
      fprintf(stderr,"solvlin> To solve [M] * X = B, for X where:\n");
      for(i=0;i<n;i++)
       for(j=0;j<n;j++)
	fprintf(stderr,"M[%d][%d] = %f\n", i, j, a[i][j]);
      for(i=0;i<n;i++)
	fprintf(stderr,"B[%d]     = %f\n", i, t[i]);
     }

     delta = det3(a);
     if(debug > 8) fprintf(stderr,"Found Delta = %f\n", delta);
     if(delta == 0.0) return (-10); /* no solution exists! */

     for(j=0;j<n;j++){
       for(k=0;k<n;k++){
         for(l=0;l<n;l++) a[k][l] = mat[k][l];
       }
       for(i=0;i<n;i++) a[i][j] = t[i];
       x[j] = det3(a) / delta ;
     if(debug > 8) fprintf(stderr,"Found x[%d] = %f\n", j, x[j]);
     }

     if(debug > 5) fprintf(stderr, "solvlin(det3)> packing up...\n");
     return(0);

}
#endif

void
mk2darray(a, size, count, ptr)
int *a;
int size, count;
int *(**ptr);
{
       char *buffer;
       int  **ptrlist, i;

       if((buffer = (char *)malloc(sizeof(int *)*count)) == (char *) NULL){
	fprintf(stderr, "Flatten needs space for ptrlist, ran out of memory\n");
        exit(1);
	}

       ptrlist = (int **) buffer;

       for(i = 0; i < count; i++){
	  ptrlist[i] = a;
	  a += size;
       }

       *ptr = (int **) buffer;
}
/*
 * Calculate the floating point determinant of A
 */
double det3(a) 
double a[][3];
{

      double result;

      result=(a[0][0] * a[1][1] * a[2][2])+
	     (a[0][1] * a[1][2] * a[2][0])+
             (a[0][2] * a[1][0] * a[2][1])-
	     (a[0][2] * a[1][1] * a[2][0])-
	     (a[0][1] * a[1][0] * a[2][2])-
	     (a[0][0] * a[1][2] * a[2][1]);

	return (result);

}
