/* conductor.c :: handles application specific setup and takedown of
 *               images, that is the before and after housekeeping
 *               chores involved with getting images to and from,
 *               a unary operator (the engine).
 *
 *    Rick Ebert  October,1987       rick@ipac.caltech.edu
 *     modified to use the New image i/o routines: October, 1988
 */
/* #Copyright (C) 1992, California Institute of Technology. */
/* #U.S. Government Sponsorship under NASA Contract NAS7-918 */
/* #is acknowledged. */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <sys/time.h>
#include <sys/resource.h>
#include "squawk.h"
#include "imaginfo.h"
#define  HIST_VER  "V1.1"  /* version number that goes in image headers */
#include "flatten.h"
#include "im_proto.h"


int
conductor(ifilname, ofilname, array, npoints)
char *ifilname, *ofilname;
int array[]; /* array of reference points, */
                        /* to go to flatten or whomever */
int npoints;    /* number of points in array */
{

	int fids[2];
	char *bufptr;
	PIXEL *pixptr;
        struct imaginfo  inputimag, outputimag;
	int axis_size[2];
	int flatten();
	/* version number for HISTORY card */
        static char history_version[] = HIST_VER ;
	char string[81];

        struct rlimit resorc;

        extern int debug;  /* main set this up for us */
	int npixels;

	if((inputimag.fid =im_open(ifilname, READ))  < 0)
		squawk(Terminal, "Error opening input file");

        /* open output file */
	if((outputimag.fid =im_open(ofilname, WRITE))  < 0)
		squawk(Terminal, "Error opening input file");

/* get generally useful image information                    */

        if(getimaginfo(&inputimag) != 2)
	   squawk(Terminal,"Input must 2 dimensional image or subimage");
       
	npixels = inputimag.npixels;

	nlengths(&inputimag, axis_size, 2); /* get # samples, # lines */

/* Set-up more of the inputimag struct */

	outputimag.blank = inputimag.blank;
        inputimag.bscale = 1;
	inputimag.b_zero  = 0;
	outputimag.npixels = inputimag.npixels;

/* create some space to read in the pixels    */

#ifndef hpux
	if(npixels > 1000000){ /* That's four MB of image memory */
	   getrlimit(RLIMIT_DATA, &resorc);
	   resorc.rlim_cur = resorc.rlim_max ;
           setrlimit(RLIMIT_DATA, &resorc);
         }
#endif /* hpux */
	if(debug >5) fprintf(stderr,"Going to malloc pixptr\n");
	if((bufptr = (char *) malloc(npixels * SIZPIXEL)) == (char *) 0)
		squawk(Terminal, "Can't get enough image memory");

	pixptr = (PIXEL *) bufptr;  /* pixptr points to pixel buffer */

/* read in the pixels */
	if(debug >5) fprintf(stderr,"Going to read pixels\n");
	if(im_rpix_r(inputimag.fid, pixptr, npixels) != npixels)
		squawk(Terminal, "Error reading pixels");
#ifdef DEBUG
     inpix = pixptr; /* set */
 if(debug == 12){
        fprintf(stderr,"conductor: debug: Print out all pixels going in...\n");
 for (j = 0 ; j < inputimag.naxis[2]; j++)          /* the lines */
   for(i = 0; i < inputimag.naxis[1]; i++)          /* the samples */
     fprintf(stderr,"%f ", *inpix++);
     fprintf(stderr,"\nEnd of input pixel buffer\n");
     inpix = pixptr; /* reset after use */
  }
#endif
	/* copy input header to output image...*/

	if(debug >5) fprintf(stderr,"Copy header...\n");
	fids[0]=inputimag.fid;
	fids[1]=0;
	im_hdr(outputimag.fid, fids, (char *) 0);

/* perform the operation on the pixel buffer (*pixptr) here */

	/*user_defined_function();*/
        if (flatten(pixptr, axis_size[0], axis_size[1],
		array, npoints, inputimag.blank)){
	    fprintf(stderr, "Error in flatten, can't continue\n");
	    exit (1);
         }

/* update the header to agree with the new image in the output */

/* add a comment to say what we've done                         */
	 if(debug >5) fprintf(stderr,"Update the header\n");
	sprintf(string,
	  "HISTORY Flattened, planar subtraction (IPAC flatten %s)",
	     history_version); 
	im_wkey_t(outputimag.fid, string, AT_END);

/* The fix-up business goes here...
 *  Get the new datamax and datamin, calculate a new bscale and bzero if
 *  needed etc.  Adjust the rest of the header.
 */
        /* fix-up-function(); */
	hdrclean(pixptr, &outputimag );
/* write the pixel buffer to the output image, and close up shop */
/* Make no more changes to the header after this line!           */

	if(debug >5) fprintf(stderr,"Write the new pixels\n");
	if(im_wpix_r(outputimag.fid, pixptr, npixels) != npixels) 
 		squawk(Terminal, "Error writing pixels to output");

/* we're done! */
	if(debug >5) fprintf(stderr,"Close the images\n");
	if(im_close(inputimag.fid) < 0)
		squawk(Tolerable,"Error closing input image");
	if(im_close(outputimag.fid) < 0)
		squawk(Tolerable,"Error closing output image");

	/* TODO: should free all buffer before exiting */
	free(bufptr); /* free imag memory */
	return(0);  /* Successful Completion */

}
