#include <stdio.h> 
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "contour.h"

#define  TRUE  1
#define  FALSE !TRUE

int x_out, y_out;
int nx, ny;

double rat, pi = 3.14159265358979;

FILE *outf;

static int ps_page   = 1;
static int ps_empty  = 1;
static int ps_outlen = 0;

static int ps_xmin   = 0; 
static int ps_ymin   = 0; 
static int ps_xmax;
static int ps_ymax;

static double ps_xminr = 0.; 
static double ps_yminr = 0.; 
static double ps_xmaxr; 
static double ps_ymaxr;

void ps_init()
{
   double ratio;

   ratio = (double) nx / (double) ny;
   if (ratio > 1700./2200.)
   {
      ps_xmax = 1700;
      ps_ymax = (int)((1./ratio) * 1700.);
   }
   else
   {
      ps_xmax = (int)(ratio * 2200.);
      ps_ymax = 2200;
   }
}

int ps_open(name, file)
char *name, *file;
{
   if (outf != (FILE *)NULL)
      fclose(outf);

   if (strlen(file) != 0)
      outf = fopen(file, "w");
   else
      outf = stdout;

   if(outf == (FILE *)NULL)
      return(-1);

   fprintf(outf, "%%!PS-Adobe-2.0 EPSF-1.2\n");
   fprintf(outf, "%%%%Title: %s\n", name);
   fprintf(outf, "%%%%Creator: CONTOUR-PLOT\n");
   fprintf(outf, "%%%%Pages: 1\n");
   fprintf(outf, "%%%%BoundingBox: %d %d %d %d\n", 
	   ps_xmin, ps_ymin, ps_xmax, ps_ymax);
   fprintf(outf, "%%%%ImageBox: %d %d %d %d\n", 
	   ps_xmin, ps_ymin, ps_xmax, ps_ymax);
   fprintf(outf, "%%%%EndComments\n");
   fprintf(outf, "%%%%BeginProcSet: contour-plot\n");
   fprintf(outf, "/m { moveto } bind def\n");
   fprintf(outf, "/l { lineto } bind def\n");
   fprintf(outf, "/s { stroke } bind def\n");
   /*
   fprintf(outf, "/F { findfont exch scalefont setfont} bind def\n", name);
   */
   fprintf(outf, "/F { findfont exch scalefont setfont} bind def\n");
   fprintf(outf, "/t { show } bind def\n");
   fprintf(outf, "/S { scale } bind def\n");
   fprintf(outf, "/T { translate } bind def\n");
   fprintf(outf, "/r { rotate } bind def\n");
   fprintf(outf, "%%%%EndProcSet: contour-plot\n");
   fprintf(outf, "%%%%EndProlog\n");
   fprintf(outf, "%%%%BeginSetup\n");
   fprintf(outf, "1 setlinejoin\n");
   fprintf(outf, "1 setlinecap\n");
   fprintf(outf, "0.34 0.34 S\n"); 
   fprintf(outf, "45 25  T\n"); 
   fprintf(outf, "/Times-Roman findfont 25 scalefont setfont\n");;
   fprintf(outf, "%%%%EndSetup\n\n");
   fprintf(outf, "%%%%Page: %d %d\n", ps_page, ps_page);
   fflush(outf);
   return(0);
}

void ps_close()
{
   fprintf(outf, "showpage\n\n");
   fprintf(outf, "%%%%Trailer\n");
   fprintf(outf, "%%%%EOF\n");
   
   fflush(outf);
}

void ps_clear()
{
   if (ps_empty) 
      return;

   ++ps_page;
   fprintf(outf, "showpage\n\n");
   fprintf(outf, "%%%%Page: %d %d\n", ps_page, ps_page);

   ps_empty=1;
}



void ps_wind(xmin, xmax, ymin, ymax)

double xmin, xmax, ymin, ymax;
{
   ps_xminr = xmin;
   ps_xmaxr = xmax;
   ps_yminr = ymin;
   ps_ymaxr = ymax;
}

void ps_scale(x, y, ix, iy)
double x, y;
int *ix, *iy;
{
   double ratio;

   x_out = FALSE;
   y_out = FALSE;

   ratio = (double) nx /(double) ny; 

   if (ratio > (1700./2200.))
   {
      *ix = (x - ps_xminr + 0.5) / (ps_xmaxr - ps_xminr) * 1700;
      *iy = (y - ps_yminr + 0.5) / (ps_ymaxr - ps_yminr) * 1./ratio * 1700;

      if (*ix < 0 || *ix > 1700)
	 x_out = TRUE;
      if (*iy < 0 || *iy > (int) (1./ratio * 1700))
	 y_out = TRUE;
   }

   else
   {
      *ix = (x - ps_xminr + 0.5) / (ps_xmaxr - ps_xminr) * ratio * 2200;
      *iy = (y - ps_yminr + 0.5) / (ps_ymaxr - ps_yminr) * 2200;

      if (*ix < 0 || *ix > (int) (ratio * 2200))
	 x_out = TRUE;
      if (*iy < 0 || *iy > 2200)
	 y_out = TRUE;
   }
}



void ps_polyline(num, pnts_x, pnts_y)
int num;
float *pnts_x, *pnts_y;
{
   float x, y;
   int i, start, ix, iy;

   start = num;

   for (i=0; i<num; i++)
      {
      x = pnts_x[i];
      y = pnts_y[i];

      ps_scale(x, y, &ix, &iy);

      if (x_out == FALSE && y_out == FALSE)
	 {
	 start = i;
         fprintf(outf, "%%!polyline\n");
         fprintf(outf, " %3d %3d m", ix, iy);
         ps_outlen += 10;
         if (ps_outlen >= 70)
            {
            fprintf(outf, "\n");
            ps_outlen = 0;
            }
	 break;
     	 }
     }


   for(i=start+1; i<num; ++i)
   {
      x = pnts_x[i];
      y = pnts_y[i];

      ps_scale(x, y, &ix, &iy);

      if (x_out == FALSE && y_out == FALSE)
	 {
         fprintf(outf, " %3d %3d l", ix, iy);
         ps_outlen += 10;
         if (ps_outlen >= 70)
            {
            fprintf(outf, "\n");
            ps_outlen = 0;
            }
         }
   }

   if (start < num)
      {
      fprintf(outf, " s\n\n");
      ps_outlen = 0;
      }
   
   fflush(outf);
}

void ps_label(x, y, str)
char *str;
float x, y;
{
   int ix, iy;

   ps_scale(x, y, &ix, &iy);

   if (x_out == FALSE && y_out == FALSE)
   {
      fprintf(outf, " %3d %3d m ", ix, iy);
      fprintf(outf, "(%s) t\n\n", str);
   }
}

void ps_border(x1, x2, y1, y2)
float x1, x2, y1, y2;
{
   float px[5], py[5];

   px[0] = x1;
   py[0] = y1;
   px[1] = x2;
   py[1] = y1;
   px[2] = x2;
   py[2] = y2;
   px[3] = x1;
   py[3] = y2;
   px[4] = x1;
   py[4] = y1;

   ps_polyline(5, px, py);
}
