#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#ifdef NOTDEF
#include <values.h>
#endif /* NOTDEF */
#include "im_proto.h"

#ifndef MAXDOUBLE
#include <float.h>
#define MAXDOUBLE DBL_MAX
#define MAXFLOAT FLT_MAX
#endif


#include "cmap.h"
#include "contour.h"

#define TRUE   1
#define FALSE !TRUE

#define MAXPT 1024
#define HISTSIZ 4096
#define MAXLVL 40

static char Id1[] = "@(#)cmap.c   RBH        980119";

double Round();
void get_level(double ptile, double *level);
void cmaperrmsg();

int nbrgud, nx, ny;
double **z, datamin, datamax;

extern CPOLY *contours();

int main(argc, argv)

int argc;
char **argv;
{
   double plt_scale, y_pixel_size;
   int fd, imstat, maxpts, stat;
   int m, maxlvls;
   int file_type, bitpix, naxis, pixels, lines, naxis3;
   int blank_set;
   int pla_done = 0;
   char psfile[256], outfile[256];

   char bunit[80];
   double bscale, b_zero, blank;
   double glong, crpix1, cdelt1, glat, crpix2, equinox=1950., epoch=1950.;
   double cdelt2, twist, crval3, iraf_max, iraf_min;
   double levels[MAXLVL+1], percntile, mult, start_lvl, mult_to_n; 

   int crpix1int, crpix2int;
   int lbl, incr_style, do_per, do_vec;

   char ctype1[16], ctype2[16];

   char s[3], csys[3], maptype[16];

   char *ptmp, *ptr;
   float fblank, *x, *y;
   double blank_flag;

   int i, j, k;

   int nconts, npt;


   /* varibles for plate projection */
   char   pltdecsn[10];
   double plt_rah, plt_ram, plt_ras, plt_decd, plt_decm, plt_decs,
	  plt_amdx1, plt_amdx2, plt_amdx3, plt_amdx4, plt_amdx5, 
	  plt_amdx6, plt_amdx7, plt_amdx8, plt_amdx9, plt_amdx10,
	  plt_amdx11,plt_amdx12,plt_amdx13,plt_amdx14,plt_amdx15,
	  plt_amdx16,plt_amdx17,plt_amdx18,plt_amdx19,plt_amdx20,
	  plt_amdy1, plt_amdy2, plt_amdy3, plt_amdy4, plt_amdy5, 
	  plt_amdy6, plt_amdy7, plt_amdy8, plt_amdy9, plt_amdy10,
	  plt_amdy11,plt_amdy12,plt_amdy13,plt_amdy14,plt_amdy15,
	  plt_amdy16,plt_amdy17,plt_amdy18,plt_amdy19,plt_amdy20,
	  plt_ppo1,plt_ppo2,plt_ppo3,plt_ppo4,plt_ppo5,plt_ppo6,
	  plt_xoff,plt_yoff, plt_xsz,plt_ysz,decsn;
   
   CPOLY *conts;
   FILE  *outf=NULL;

   lbl        = FALSE;                              /* default to no labels */
   incr_style = 1;                                  /* default to log       */
   do_vec     = FALSE;                              /* default to no vector 
						       file                 */
   *psfile = '\0';                                  /* default to stdout    */

   while (argc > 3)
   {
      if (argv[1][0] == '-')
      {
	 if (!strcmp(argv[1], "-o")) 
	 {
            strcpy(psfile, argv[2]);
	 }
	 else if (!strcmp(argv[1], "-v"))
	 {
            strcpy(outfile, argv[2]);
            outf = fopen(outfile, "w");
	    do_vec = TRUE;
	 }
      argc -= 2;
      argv += 2;
      }

      else
	 break;
   }

   if (argc > 5)
   {
      fprintf(stderr, "cmap: "); 
      for (i=5; i<argc; i++)
	 fprintf(stderr, "'%s' ", argv[i]);
      fprintf(stderr, "-- illegal option(s)\n");
      cmaperrmsg();
      exit(1);
   }

   /* Open the image file */

   if(argc > 1)
      fd = im_open(argv[1], "read");
   else
   {
      fprintf(stderr, "cmap: need an image file name.\n");
      cmaperrmsg();
      exit(1);
   }

   if (fd == -1)
   {
      fprintf(stderr, "cmap: %s -- not a proper image file.\n", argv[1]);
      exit(1);
   }

   if (fd < 0)
   {
      fprintf(stderr, "cmap: %s -- Error opening or reading file.\n", argv[1]);
      exit(1);
   }

   /* Get the option for the starting level */

   do_per  = TRUE;                                  /* default ot percntile */

   percntile = 0.7;
   if (argc > 2)
   {
      if (!strncmp(argv[2], "lin", 3))
	 incr_style = 2;
      else if (!strncmp(argv[2], "log", 3))
	 incr_style = 1;
      else if (!strncmp(argv[2], "stretch", 7))
	 incr_style = 3;

      else
      {
         do_per  = FALSE;
         ptr = argv[2];
         while(*ptr++ != '\0' || *ptr ++ == ' ')
         {
	    if (*ptr == '%')
	    {
	       *ptr = '\0';
	       percntile = atof(argv[2])/100.;
	       if (percntile > 1. || percntile < 0.)
	       {
	          fprintf(stderr, "cmap: '%s' -- start_percent must be between 0. and 1.\n", argv[2]);
		  cmaperrmsg();
	          exit(1);
	       }
	       do_per = TRUE;
            }
         }

         if (do_per == FALSE)
         {
	    start_lvl = atof(argv[2]);
	    if (start_lvl == 0.0 && argv[2][0] != '0')
	    {
	       fprintf(stderr, "cmap: '%s' -- illegal option\n", argv[2]);
	       cmaperrmsg();
	       exit(1);
	    }
	 }
      }
   }

   mult = 1.414;
   if (argc > 3)
   {
      if (!strncmp(argv[3], "lin", 3))
	 incr_style = 2;
      else if (!strncmp(argv[3], "log", 3))
	 incr_style = 1;
      else if (!strncmp(argv[3], "stretch", 7))
	 incr_style = 3;
      else
      {
         mult = atof(argv[3]);
	 if (mult == 0.0 && argv[2][0] != '0')
	 {
	    fprintf(stderr, "cmap: '%s' -- illegal option\n", argv[3]);
	    cmaperrmsg();
	    exit(1);
	 }
         if (mult < 0 )
         {
	    fprintf(stderr, "increasement factor must be greater than 0.\n");
	    exit(1);
         }
      }
   }

   if (argc > 4)
   {
      if (!strncmp(argv[4], "lin", 3))
	 incr_style = 2;
      else if (!strncmp(argv[4], "log", 3))
	 incr_style = 1;
      else if (!strncmp(argv[4], "stretch", 7))
	 incr_style = 3;
      else
      {
	 fprintf(stderr, "cmap: '%s' -- illegal option.\n", argv[4]);
	 cmaperrmsg();
	 exit(1);
      }
   }

   /* Read the image header information */

   blank_set = FALSE;
   im_blankd(&blank_flag);

   imstat = im_rkey_i(fd, &file_type, "filetype");
   imstat = im_rkey_i(fd, &bitpix,    "BITPIX");
   imstat = im_rkey_i(fd, &naxis,     "NAXIS");
   imstat = im_rkey_i(fd, &pixels,    "NAXIS1");
   imstat = im_rkey_i(fd, &lines,     "NAXIS2");
   imstat = im_rkey_i(fd, &naxis3,    "NAXIS3");
   imstat = im_rkey_c(fd,  bunit,     "BUNIT");
   imstat = im_rkey_d(fd, &bscale,    "BSCALE");
   imstat = im_rkey_d(fd, &b_zero,    "BZERO");
   imstat = im_rkey_d(fd, &blank,     "BLANK");

   if (imstat >= 0)
   {
      blank_set = TRUE;
      if ((bitpix < 0) && (file_type != 3))
      {
	 fprintf(stderr, "warning:  BLANK header line ignored - \n");
	 fprintf(stderr, "          BLANK keyword is illegal in floating point FITS file\n");
      }
   }

   if ((bitpix == -64) && (file_type != 3))
   {
      im_blankd(&blank);
      blank_set = TRUE;
   }

   if ((bitpix == -32) && (file_type != 3))
   {
      im_blank(&fblank);
      blank = (double) fblank;
      blank_set = TRUE;
   }

   if ((bitpix < 0) && (file_type == 3))
   {
      /* IRAF floating point */
      blank = blank_flag; /* internally we use NaN */
   }

   imstat = im_rkey_d(fd, &glong,  "CRVAL1");
   imstat = im_rkey_d(fd, &crpix1, "CRPIX1");

   if (imstat >= 0)
      crpix1int = Round(crpix1);

   imstat = im_rkey_c(fd, ctype1,  "CTYPE1");

   if (imstat >= 0)
   {
      ctype1[8] = '\0';

      strcpy(maptype, "unspecified");

      if (strncmp(ctype1+4, "-TAN", 4) == 0)
	 strcpy(maptype, "gnomonic");

      if (strncmp(ctype1+4, "-SIN", 4) == 0)
	 strcpy(maptype, "orthographic");

      if (strncmp(ctype1+4, "-CAR", 4) == 0)
	 strcpy(maptype, "cartesian");

      if (strncmp(ctype1+4, "-NCP", 4) == 0)
	 strcpy(maptype, "ncp");

      if (strncmp(ctype1+4, "-AIT", 4) == 0)
	 strcpy(maptype, "aitoff");

      if (strncmp(ctype1+4, "----", 4) == 0)
	 strcpy(maptype, "linear");

      if (strncmp(ctype1+4, "    ", 4) == 0)
	 strcpy(maptype, "linear");

      ptmp = strchr(ctype1, '-');

      if (ptmp != 0)
	 *ptmp = '\0';   /* change - to EOS */

      ptmp = strchr(ctype1, ' ');

      if (ptmp != 0)
	 *ptmp = '\0';   /* change space to EOS */
   }

   imstat = im_rkey_d(fd, &cdelt1,  "CDELT1");
   imstat = im_rkey_d(fd, &glat,    "CRVAL2");
   imstat = im_rkey_d(fd, &crpix2,  "CRPIX2");

   if (imstat >= 0)
      crpix2int = Round(crpix2);

   imstat = im_rkey_d(fd, &equinox, "EQUINOX");
   imstat = im_rkey_d(fd, &epoch,   "EPOCH");
   imstat = im_rkey_c(fd, ctype2,  "CTYPE2");

   if (imstat >= 0)
   {
      ctype2[8] = '\0';

      if (strncmp(ctype2+4, "-TAN", 4) == 0)
	 strcpy(maptype, "gnomonic");

      if (strncmp(ctype2+4, "-SIN", 4) == 0)
	 strcpy(maptype, "orthographic");

      if (strncmp(ctype2+4, "-NCP", 4) == 0)
	 strcpy(maptype, "ncp");

      if (strncmp(ctype2+4, "-AIT", 4) == 0)
	 strcpy(maptype, "aitoff");

      if (strncmp(ctype2+4, "----", 4) == 0)
	 strcpy(maptype, "linear");

      if (strncmp(ctype2+4, "    ", 4) == 0)
	 strcpy(maptype, "linear");

      ptmp = strchr(ctype2, '-');

      if (ptmp != 0)
	 *ptmp = '\0';   /* change - to EOS */

      ptmp = strchr(ctype2, ' ');

      if (ptmp != 0)
	 *ptmp = '\0';   /* change space to EOS */
   }

   cdelt2 = 0.0;
   imstat = im_rkey_d(fd, &cdelt2,   "CDELT2");
   imstat = im_rkey_d(fd, &twist,    "CROTA2");
   imstat = im_rkey_d(fd, &crval3,   "CRVAL3");
   imstat = im_rkey_d(fd, &iraf_max, "DATAMAX");
   imstat = im_rkey_d(fd, &iraf_min, "DATAMIN");

   /* handle Plate projection */
   imstat = im_rkey_d(fd, &plt_rah, "PLTRAH");
   if (imstat >= 0)
   {
	 pla_done = 1;
	 strcpy(maptype, "plate");
	 imstat = im_rkey_d(fd, &plt_scale,  "PLTSCALE");
	 imstat = im_rkey_d(fd, &plt_rah,    "PLTRAH"  );
	 imstat = im_rkey_d(fd, &plt_ram,    "PLTRAM"  );
	 imstat = im_rkey_d(fd, &plt_ras,    "PLTRAS"  );
	 imstat = im_rkey_c(fd, pltdecsn,    "PLTDECSN");
	 imstat = im_rkey_d(fd, &plt_decd,   "PLTDECD" );
	 imstat = im_rkey_d(fd, &plt_decm,   "PLTDECM" );
	 imstat = im_rkey_d(fd, &plt_decs,   "PLTDECS" );
	 imstat = im_rkey_d(fd, &plt_xoff,   "CNPIX1"  );
	 imstat = im_rkey_d(fd, &plt_yoff,   "CNPIX2"  );
	 imstat = im_rkey_d(fd, &plt_amdx1,  "AMDX1"   );
	 imstat = im_rkey_d(fd, &plt_amdx2,  "AMDX2"   );
	 imstat = im_rkey_d(fd, &plt_amdx3,  "AMDX3"   );
	 imstat = im_rkey_d(fd, &plt_amdx4,  "AMDX4"   );
	 imstat = im_rkey_d(fd, &plt_amdx5,  "AMDX5"   );
	 imstat = im_rkey_d(fd, &plt_amdx6,  "AMDX6"   );
	 imstat = im_rkey_d(fd, &plt_amdx7,  "AMDX7"   );
	 imstat = im_rkey_d(fd, &plt_amdx8,  "AMDX8"   );
	 imstat = im_rkey_d(fd, &plt_amdx9,  "AMDX9"   );
	 imstat = im_rkey_d(fd, &plt_amdx10, "AMDX10"  );
	 imstat = im_rkey_d(fd, &plt_amdx11, "AMDX11"  );
	 imstat = im_rkey_d(fd, &plt_amdx12, "AMDX12"  );
	 imstat = im_rkey_d(fd, &plt_amdx13, "AMDX13"  );
	 imstat = im_rkey_d(fd, &plt_amdx14, "AMDX14"  );
	 imstat = im_rkey_d(fd, &plt_amdx15, "AMDX15"  );
	 imstat = im_rkey_d(fd, &plt_amdx16, "AMDX16"  );
	 imstat = im_rkey_d(fd, &plt_amdx17, "AMDX17"  );
	 imstat = im_rkey_d(fd, &plt_amdx18, "AMDX18"  );
	 imstat = im_rkey_d(fd, &plt_amdx19, "AMDX19"  );
	 imstat = im_rkey_d(fd, &plt_amdx20, "AMDX20"  );
	 imstat = im_rkey_d(fd, &plt_amdy1,  "AMDY1"   );
	 imstat = im_rkey_d(fd, &plt_amdy2,  "AMDY2"   );
	 imstat = im_rkey_d(fd, &plt_amdy3,  "AMDY3"   );
	 imstat = im_rkey_d(fd, &plt_amdy4,  "AMDY4"   );
	 imstat = im_rkey_d(fd, &plt_amdy5,  "AMDY5"   );
	 imstat = im_rkey_d(fd, &plt_amdy6,  "AMDY6"   );
	 imstat = im_rkey_d(fd, &plt_amdy7,  "AMDY7"   );
	 imstat = im_rkey_d(fd, &plt_amdy8,  "AMDY8"   );
	 imstat = im_rkey_d(fd, &plt_amdy9,  "AMDY9"   );
	 imstat = im_rkey_d(fd, &plt_amdy10, "AMDY10"  );
	 imstat = im_rkey_d(fd, &plt_amdy11, "AMDY11"  );
	 imstat = im_rkey_d(fd, &plt_amdy12, "AMDY12"  );
	 imstat = im_rkey_d(fd, &plt_amdy13, "AMDY13"  );
	 imstat = im_rkey_d(fd, &plt_amdy14, "AMDY14"  );
	 imstat = im_rkey_d(fd, &plt_amdy15, "AMDY15"  );
	 imstat = im_rkey_d(fd, &plt_amdy16, "AMDY16"  );
	 imstat = im_rkey_d(fd, &plt_amdy17, "AMDY17"  );
	 imstat = im_rkey_d(fd, &plt_amdy18, "AMDY18"  );
	 imstat = im_rkey_d(fd, &plt_amdy19, "AMDY19"  );
	 imstat = im_rkey_d(fd, &plt_amdy20, "AMDY20"  );
	 imstat = im_rkey_d(fd, &plt_ppo1,   "PPO1"    );
	 imstat = im_rkey_d(fd, &plt_ppo2,   "PPO2"    );
	 imstat = im_rkey_d(fd, &plt_ppo3,   "PPO3"    );
	 imstat = im_rkey_d(fd, &plt_ppo4,   "PPO4"    );
	 imstat = im_rkey_d(fd, &plt_ppo5,   "PPO5"    );
	 imstat = im_rkey_d(fd, &plt_ppo6,   "PPO6"    );
	 imstat = im_rkey_d(fd, &plt_xsz,    "XPIXELSZ");
	 imstat = im_rkey_d(fd, &plt_ysz,    "YPIXELSZ");

	 imstat = im_rkey_d(fd, &y_pixel_size, "YPIXELSZ");
	 if (cdelt2 == 0.0)
	 {
	    cdelt2 = plt_scale * y_pixel_size / 1000 / 3600;
	 }
   }


   /* Set the file coordinate system according to the file header */

   s[0] = ctype1[0];
   s[1] = ctype1[1];
   s[2] = '\0';

   if (strcmp(s, "RA") == 0)
      strcpy(csys, "eq");

   else if (strcmp(s, "LL") == 0)
      strcpy(csys, "eq");

   else if (strcmp(s, "GL") == 0)
      strcpy(csys, "ga");

   else if (strcmp(s, "LO") == 0)
      strcpy(csys, "ga");

   else if (strcmp(s, "EL") == 0)
      strcpy(csys, "ec");

   if (do_vec == TRUE)
   {
      fprintf(outf, "pixels    = %d\n",  pixels);
      fprintf(outf, "lines     = %d\n",  lines);
      if (!pla_done)
      {
         fprintf(outf, "glong     = %-g\n", glong);
         fprintf(outf, "crpix1    = %-g\n", crpix1);
         fprintf(outf, "cdelt1    = %-g\n", cdelt1);
         fprintf(outf, "cdelt2    = %-g\n", cdelt2);
         fprintf(outf, "glat      = %-g\n", glat);
         fprintf(outf, "crpix2    = %-g\n", crpix2);
         fprintf(outf, "crpix1int = %d\n",  crpix1int);
         fprintf(outf, "crpix2int = %d\n",  crpix2int);
      }
      else
      {
	 strcpy(csys, "equatorial");
	 glong = (plt_rah+plt_ram/60.+plt_ras/3600.)*15.;
	 decsn = 1.;
         if (strncmp(pltdecsn, "-", 1) == 1)
	    decsn = -1.;
	 glat  = decsn*(plt_decd+plt_decm/60.+plt_decs/3600.);
	 fprintf(outf, "platescale= %-g\n",  plt_scale);
         fprintf(outf, "platera   = %-g\n",  glong);
         fprintf(outf, "platedec  = %-g\n",  glat);
         fprintf(outf, "platexsz  = %16.13e\n",  plt_xsz);
         fprintf(outf, "plateysz  = %16.13e\n",  plt_ysz);
         fprintf(outf, "platexoff = %-g\n",  plt_xoff);
         fprintf(outf, "plateyoff = %-g\n",  plt_yoff);
         fprintf(outf, "amdx1     = %16.13e\n",  plt_amdx1);
         fprintf(outf, "amdx2     = %16.13e\n",  plt_amdx2);
         fprintf(outf, "amdx3     = %16.13e\n",  plt_amdx3);
         fprintf(outf, "amdx4     = %16.13e\n",  plt_amdx4);
         fprintf(outf, "amdx5     = %16.13e\n",  plt_amdx5);
         fprintf(outf, "amdx6     = %16.13e\n",  plt_amdx6);
         fprintf(outf, "amdx7     = %16.13e\n",  plt_amdx7);
         fprintf(outf, "amdx8     = %16.13e\n",  plt_amdx8);
         fprintf(outf, "amdx9     = %16.13e\n",  plt_amdx9);
         fprintf(outf, "amdx10    = %16.13e\n",  plt_amdx10);
         fprintf(outf, "amdx11    = %16.13e\n",  plt_amdx11);
         fprintf(outf, "amdx12    = %16.13e\n",  plt_amdx12);
         fprintf(outf, "amdx13    = %16.13e\n",  plt_amdx13);
         fprintf(outf, "amdx14    = %16.13e\n",  plt_amdx14);
         fprintf(outf, "amdx15    = %16.13e\n",  plt_amdx15);
         fprintf(outf, "amdx16    = %16.13e\n",  plt_amdx16);
         fprintf(outf, "amdx17    = %16.13e\n",  plt_amdx17);
         fprintf(outf, "amdx18    = %16.13e\n",  plt_amdx18);
         fprintf(outf, "amdx19    = %16.13e\n",  plt_amdx19);
         fprintf(outf, "amdx20    = %16.13e\n",  plt_amdx20);
         fprintf(outf, "amdy1     = %16.13e\n",  plt_amdy1);
         fprintf(outf, "amdy2     = %16.13e\n",  plt_amdy2);
         fprintf(outf, "amdy3     = %16.13e\n",  plt_amdy3);
         fprintf(outf, "amdy4     = %16.13e\n",  plt_amdy4);
         fprintf(outf, "amdy5     = %16.13e\n",  plt_amdy5);
         fprintf(outf, "amdy6     = %16.13e\n",  plt_amdy6);
         fprintf(outf, "amdy7     = %16.13e\n",  plt_amdy7);
         fprintf(outf, "amdy8     = %16.13e\n",  plt_amdy8);
         fprintf(outf, "amdy9     = %16.13e\n",  plt_amdy9);
         fprintf(outf, "amdy10    = %16.13e\n",  plt_amdy10);
         fprintf(outf, "amdy11    = %16.13e\n",  plt_amdy11);
         fprintf(outf, "amdy12    = %16.13e\n",  plt_amdy12);
         fprintf(outf, "amdy13    = %16.13e\n",  plt_amdy13);
         fprintf(outf, "amdy14    = %16.13e\n",  plt_amdy14);
         fprintf(outf, "amdy15    = %16.13e\n",  plt_amdy15);
         fprintf(outf, "amdy16    = %16.13e\n",  plt_amdy16);
         fprintf(outf, "amdy17    = %16.13e\n",  plt_amdy17);
         fprintf(outf, "amdy18    = %16.13e\n",  plt_amdy18);
         fprintf(outf, "amdy19    = %16.13e\n",  plt_amdy19);
         fprintf(outf, "amdy20    = %16.13e\n",  plt_amdy20);
         fprintf(outf, "ppo1      = %16.13e\n",  plt_ppo1);
         fprintf(outf, "ppo2      = %16.13e\n",  plt_ppo2);
         fprintf(outf, "ppo3      = %16.13e\n",  plt_ppo3);
         fprintf(outf, "ppo4      = %16.13e\n",  plt_ppo4);
         fprintf(outf, "ppo5      = %16.13e\n",  plt_ppo5);
         fprintf(outf, "ppo6      = %16.13e\n",  plt_ppo6);
      }
      fprintf(outf, "maptype   = %s\n",  maptype);
      fprintf(outf, "csys      = %s\n",  csys);
      fprintf(outf, "equinox   = %-g\n", equinox);
      fprintf(outf, "epoch     = %-g\n", epoch);
   }

   /* Allocate image array space */

   nx = pixels;
   ny = lines;

   z = (double **) malloc((unsigned)(ny * sizeof(double *)));
   if (z == NULL)
   {
      fprintf(stderr, "Can't allocate required memory\n");
      exit(1);
   }

   for(j=0; j<ny; ++j)
   {
      *(z+j) = (double *) malloc((unsigned)(nx * sizeof(double)));
      if (z+j == NULL)
      {
	 fprintf(stderr, "Can't allocate required memory\n");
	 exit(1);
      }
   }

   /* Allocate plot vector space */

   maxpts = MAXPT;
   x = (float *)malloc((unsigned int)(maxpts * sizeof(float)));
   if (x == NULL)
   {
      fprintf(stderr, "Can't allocate required memory\n");
      exit(1);
   }

   y = (float *)malloc((unsigned int)(maxpts * sizeof(float)));
   if (y == NULL)
   {
      fprintf(stderr, "Can't allocate required memory\n");
      exit(1);
   }

   maxlvls = MAXLVL;

   /* Read the data */

   if (cdelt2 >= 0)
      for(j=0; j<ny; ++j)
        im_rpix_d(fd, z[j], nx);


   else
      for(j=0; j<ny; ++j)
	im_rpix_d(fd, z[ny-1-j], nx);

   /* Find the data max, min and number of good pixels */

   datamin =  MAXDOUBLE;
   datamax = -MAXDOUBLE;

   nbrgud = 0;

   for(j=0; j<ny; ++j)
   {
      for(i=0; i<nx; ++i)
      {
	 if(!isnan(z[j][i]))
	 {
	    nbrgud++; 

	    if(z[j][i] > datamax)
	    {
	       datamax = z[j][i];
	    }

	    if(z[j][i] < datamin)
	    {
	       datamin = z[j][i];
	    }
	 }
      }
   }

   /* Determine the levels according to the percentile */

   m=0;

   if (do_per == TRUE)
   {
      get_level(percntile, &levels[0]);
      if ((incr_style == 1) && (levels[0] <=0))
      {
	fprintf(stderr,
	    "contour error:  %f percentile level is negative (%g)\n",
	    percntile, levels[0]);
	exit(1);
      }
   }
   else
      levels[0] = start_lvl;

   mult_to_n = 1;
   while((levels[m] <= datamax) && (m < maxlvls))
   {
      if (incr_style == 1)
      {
	 /* logarithmic */
	 levels[m+1] = levels[m] * mult;
      }
      else if (incr_style == 3)
      {
	 /* geometric */
	 levels[m+1] = ((datamax - levels[0]) * .01 * mult_to_n) + levels[0];
	 mult_to_n = mult_to_n * mult;
      }
      else if (incr_style == 2)
      {
	 /* linear */
         levels[m+1] = levels[m] + mult;
      }
      m++;
   }

#ifdef DEBUG
   for(k=0; k<m; k++)
       fprintf(stderr, "level[%d] = %g\n", k, levels[k]);
#endif /* DEBUG */


   /* Initialize Post Script file when needed */

   ps_init();

   stat = ps_open("Contour Plot", psfile);
   if(stat < 0)
   {
      fprintf(stderr, "cmap: '%s' -- invalid PostScript file path\n", psfile);
      exit(1);
   }

   ps_wind(0., (double) nx, 0., (double) ny);

   /* Find the contours */

   for(k=0; k<m; k++)
   {
      conts = contours(z, nx, ny, levels[k], blank_flag);

      nconts = conts->npoly;

      if (do_vec == TRUE)
      {
         fprintf(outf, "#l%10.1f %10d\n", levels[k], nconts);
         fflush(outf);
      }

      for(i=0; i<nconts; ++i)
      {
	 npt = conts->poly[i]->npts;

	 if (do_vec == TRUE)
	 {
	    fprintf(outf, "#c%10d %10d\n", i, npt);

	    for(j=0; j<npt; ++j)
	       fprintf(outf, "%12.5f %10.5f\n", 
	          conts->poly[i]->pnt[j]->x, conts->poly[i]->pnt[j]->y);
         }

	 for(j=0; j<npt; ++j)
	 {
	    if (j == maxpts)
	    {
	       maxpts += MAXPT;

	       x = (float *)realloc((char *)x, (unsigned int) (maxpts *
	            sizeof(float)));
	       if (x == NULL)
	       {
                  fprintf(stderr, "Can't allocate required memory\n");
                  exit(1);
	       }
	       y = (float *)realloc((char *)y, (unsigned int) (maxpts *
	            sizeof(float)));
	       if (y == NULL)
	       {
                  fprintf(stderr, "Can't allocate required memory\n");
                  exit(1);
	       }
	    }

	    x[j] = conts->poly[i]->pnt[j]->x;
	    y[j] = conts->poly[i]->pnt[j]->y;
	 }

	 ps_polyline(npt, x, y);
      }
   }
  ps_close();
  exit(0);
  return(0);
}


void get_level(ptile, level)
double ptile, *level;
{
   int i, j, rtot, index=0, hist[HISTSIZ], start_pt = 0;
   double histml, level_right, level_left; 

   for (i=0; i<HISTSIZ; i++)
      hist[i] = 0;

   histml = HISTSIZ / (datamax - datamin);

   for(j=0; j<ny; ++j)
   {
      for(i=0; i<nx; ++i)
      {
	 if (!isnan(z[j][i]))
	 {
	    index = (z[j][i]-datamin) * histml;
	    if (index <= HISTSIZ && index >= 0)
	       hist[index] = hist[index] + 1;
         }
      }
   }

   rtot = 0;
   for (i=0; i<HISTSIZ; i++)
   {
      rtot = rtot + hist[i];
      if (rtot > (int) (ptile * nbrgud))
      {
         start_pt = i-1;
	 break;
      }
   }

   *level = start_pt / histml + datamin;

   /* adust up one if start_pt is close to zero */

   level_right = (start_pt + 1) / histml + datamin;
   level_left  = (start_pt - 1) / histml + datamin;
      
   if ((level_right > 0) && (level_left < 0))
      *level = level_right;
}

double Round(x)

double x;

{
   if( x - (double) floor(x) < 0.5)
      return(floor(x));
   else
      return(ceil(x));
}

void cmaperrmsg()

{

      fprintf(stderr, "Usage: cmap [-o test.ps (postscript file)] [-v test.v (contour vector file)] myimage [ 70%c | 0.7 (starting percentile) [1.414 (increasement amount)]] [ lin | log (linear or logarithmic increasement)]\n", '\045');

}
