/*****************************************************************************
*    Converts the sexgicimal longitude and latitude to the decimal longitude
*    and latitude.                                                           *  *    input :  sexgicimal longitude and latitude                              *
*             "xxhxxmxx.xs", "xx xx xx.x",  "xx:xx:xx.x",  "xxxxxx"          *
*             "xxdxxmxx.xs", "xx xx xx.x",  "xx:xx:xx.x",  "xxxxxx"          *
*    output:  decimal longtitude and latitude                                *
*             xxx.xxxx,  xxxx.xxxx                                           *
*    return value :
*             0  both are converted successfully                             *
*             1  syntax error in longitude                                   *
*             2  syntax error in latitude                                    *
*             3  syntax error in both                                        *
*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include "gks.h"
#include "agra.h"

static int check_f(char *s);

int sex2dd(cra, cdec, ra, dec)

double *ra, *dec;
char *cra, *cdec;

   {
   char   crain[40], cdecin[40], *subst[10];
   char   tmph[40], tmpd[40], tmpm[40], tmps[40];
   char   chr, *p;
   int    ideg, syntax, lonstatus, latstatus;
   double  scale, hr, deg, min, sec;
   int    i, leng;
   int    isign, nsub, nh, nd, nm, ns;


   strcpy(crain , cra);
   strcpy(cdecin , cdec);

/*     RA ----------------------------------                       */

   ideg = FALSE;
   hr  = 0;
   min = 0;
   sec = 0;

   strcpy(tmph , "0");
   strcpy(tmpm , "0");
   strcpy(tmps , "0");


/*    Determine the Sign on the RA                             */

   isign = 1;
   leng = strlen(crain);

   i = 0;
   while (crain[i] == ' ')
      i++;
   if (crain[i] == '-')
      {
      isign = -1;
      crain[i] = ' ';
      }
   else if (crain[i] == '+') 
      crain[i] = ' ';

/*     Find the positions of the 'h' (or 'd'), 'm', and 's'     */

   nd = 0;
   nh = -1;
   nm = -1;
   ns = -1;
   leng = strlen(crain);
   for(i = 0; i<=leng-1; i++)
      {
      chr = crain[i];
      if (chr == 'h'  ||  chr == 'H') 
	 {
	 nh = i;
/*	 nm = leng + 1;
	 ns = leng + 1;
*/
         }
      else if (chr == 'd' ||  chr == 'D') 
	 {
	 ideg = TRUE;
	 nh = i;
/*	 nm = leng + 1;
	 ns = leng + 1;
*/
         }

      if (chr == 'm' || chr == 'M') 
	 nm = i;
      if (chr == 's' || chr == 'S') 
	 ns = i;
      }

/*     Extract the Integer Hours, Minutes, and Seconds    */

   if (nh > 0) 
      {
      p = crain;
      strcpy(tmph , p);
      tmph[nh] ='\0';
      }
   if (nm-1 > nh) 
      {
      p = crain+nh+1;
      strcpy(tmpm , p);
      tmpm[nm-nh-1] = '\0';
      }
   if(ns-1 > nm) 
      {
      p = crain+nm+1;
      strcpy(tmps , p);
      tmps[ns-nm-1] ='\0';
      }



/*     If There are No 'hms', Find the Substrings             */
   nsub = 0;

   if (nh == -1 && nm == -1 && ns == -1) 
      {
      substr(crain, subst, &nsub);
       if (nsub >= 3) 
	  {
	      strcpy(tmph , subst[0]);
	      strcpy(tmpm , subst[1]);
	      strcpy(tmps , subst[2]);
	  }

       if (nsub == 2) 
	  {
	      strcpy(tmpm , subst[0]);
	      strcpy(tmps , subst[1]);
	  }

       if (nsub == 1) 
	      strcpy(tmps , subst[0]);
       }
    else if (nm == -1 && ns == -1)
       {
       substr( (crain+nh+1), subst, &nsub);
       if (nsub == 2) 
	  {
	      strcpy(tmpm , subst[0]);
	      strcpy(tmps , subst[1]);
	  }

       if (nsub == 1) 
	      strcpy(tmpm , subst[0]);
       }
    else if (ns == -1)
       {
       substr( (crain+nm+1), subst, &nsub);
       if (nsub == 1) 
	      strcpy(tmps , subst[0]);
       }
/*     If the Number is Too Big, Assume +hhmmss.s         */

    syntax = check_f(tmps);
    if (syntax ==TRUE)
       syntax = check_f(tmpm);
    if (syntax ==TRUE)
       syntax = check_f(tmph);
    
    lonstatus = syntax;
    if (syntax == TRUE)
       {
	 sec = atof(tmps);
	 if (sec >  60.) 
	    {
	    i = (int) (sec/10000.);
	    hr = (double) i;
	    i = (int) ((sec - hr*10000.) / 100.);
	    min = (double) i;
	    sec = sec - hr*10000. - min*100.;
	    }
	 else
	    {
	    hr =  atof(tmph);
	    min = atof(tmpm);
	    sec = atof(tmps);
	    }
        } 

/*     Generate the RA in Decimal Degrees                    */

      scale = 15.;
      if (ideg  ==  TRUE) 
	 scale = 1.;
      *ra = isign * scale * (hr + (min/60.) + (sec/3600.));


/*     DEC -------------------------------------             */


      deg = 0;
      min = 0;
      sec = 0;
      strcpy(tmpd , "0");
      strcpy(tmpm , "0");
      strcpy(tmps , "0");


/*     Determine the Sign on the Dec                         */

   isign = 1;
   leng = strlen(cdecin);

   i = 0;
   while (cdecin[i] ==' ')
      i++;
   if (cdecin[i] == '-') 
      {
      isign = -1;
      cdecin[i] = ' ';
      }
   else if (cdecin[i] == '+') 
      cdecin[i] = ' ';


/*     Find the positions of the 'h' (or 'd'), 'm', and 's'     */

   nd = -1;
   nm = -1;
   ns = -1;
   leng = strlen(cdecin);
   for(i = 0; i<=leng-1; i++)
      {
      chr = cdecin[i];
      if (chr == 'd' ||  chr == 'D') 
	 {
	 nd = i;
/*	 nm = leng + 1;
	 ns = leng + 1;
*/
         }

      if (chr == 'm' || chr == 'M') 
	 nm = i;
      if (chr == 's' || chr == 'S') 
	 ns = i;
      }

/*     Extract the Integer Hours, Minutes, and Seconds    */

   if (nd > 0) 
      {
      p=cdecin;
      strcpy(tmpd , cdecin);
      tmpd[nd] ='\0';
      }
   if (nm-1 > nd) 
      {
      p =cdecin+nd+1;
      strcpy(tmpm , p);
      tmpm[nm-nd-1] = '\0';
      }
   if(ns-1 > nm) 
      {
      p =cdecin+nm+1;
      strcpy(tmps , p);
      tmps[ns-nm-1] ='\0';
      }


/*     If There are No 'hms', Find the Substrings             */

   nsub = 0;
   if (nd == -1 && nm == -1 && ns == -1) 
      {
      substr(cdecin, subst, &nsub);
       if (nsub >= 3) 
	  {
	      strcpy(tmpd , subst[0]);
	      strcpy(tmpm , subst[1]);
	      strcpy(tmps , subst[2]);
	  }

       if (nsub == 2) 
	  {
	      strcpy(tmpm , subst[0]);
	      strcpy(tmps , subst[1]);
	  }
       if (nsub == 1) 
	   strcpy(tmps , subst[0]);

       }
    else if (nm == -1 && ns == -1)
       {
       substr( (cdecin+nd+1), subst, &nsub);
       if (nsub == 2) 
	  {
	      strcpy(tmpm , subst[0]);
	      strcpy(tmpm , subst[0]);
	      strcpy(tmps , subst[1]);
	  }

       if (nsub == 1) 
	      strcpy(tmpm , subst[0]);
       }
    else if (ns == -1)
       {
       substr( (cdecin+nm+1), subst, &nsub);
       if (nsub == 1) 
	      strcpy(tmps , subst[0]);
       }

/*     If the Number is Too Big, Assume +hhmmss.s         */


/*     If the Number is Too Big, Assume +ddmmss.s         */

    syntax = check_f(tmps);
    if (syntax ==TRUE)
       syntax = check_f(tmpm);
    if (syntax ==TRUE)
       syntax = check_f(tmpd);
    
    latstatus = syntax;
    if (syntax == TRUE)
       {
       sec = atof(tmps);
	 if (sec >  60.) 
	    {
	    i = (int) (sec/10000.);
	    deg = (double) i;
	    i = (int) ((sec - deg*10000.) / 100.);
	    min= (double) i;
	    sec = sec - deg*10000. - min*100.;
	    }
	 else
	    {
	    deg = atof(tmpd);
	    min = atof(tmpm);
	    sec = atof(tmps);
	    }
         }


/*     Generate the DEC in Decimal Degrees              */

      *dec = isign * (deg + (min/60.) + (sec/3600.));

/*   returned value reflects the syntax of RA and DEC    */

      if (lonstatus == FALSE && latstatus == FALSE)
      	 return(3);
      else if (lonstatus == FALSE)
	 return(1);
      else if (latstatus == FALSE)
	 return(2);
      else return(0);
}




static int check_f(s)
char *s;
{
   int   len, i;

   len = strlen(s);
   while (s[len] ==' ')
      len--;

   i = 0;
   while (s[i] == ' ' || s[i] =='+')
      i++;

   while (isdigit(s[i]) != 0)
      i++;

   if (s[i] == '.')
      i++;

   while (isdigit(s[i]) != 0)
      i++;

   if (s[i] =='e' || s[i] =='E')
      i++;
   
   while (isdigit(s[i]) != 0)
      i++;

   if (i == len)
      return(TRUE);
   else
      return(FALSE);
}
