#include <stdio.h>
#include <string.h>
#include <math.h>
#include "gks.h"
#include "agra.h"

extern int ws_act, csproj[], csgrid[], csdata[],
                   sysdata[], sysproj[], sysgrid[];
extern int AA[4][4]; 

extern void E(), eclequ(), eclgal(), eclsgal(), equecl(), equgal(), 
	    equsgal(), galecl(), galequ(), galsgal(), sgalecl(), 
	    sgalequ(), sgalgal();

extern void (*func[])();

extern int n, xcol, ycol, file_found;
extern double **x;
extern double dtr, rtd;
extern double lon0r, lat0r;
extern double eqnxdata[], eqnxproj[], eqnxgrid[], epoch[];

void scale(mctype, mapinfo)

char *mctype;
PARA *mapinfo;
{
   int i;
   int tr, tr_inverse;
   int fullsize = FALSE;
   double lonc, latc, glon, glat;
   double xx0, yy0, zz0, xx = 0., yy = 0., zz = 0., LL;
   double u0, v0, u, v, su, sv;
   
   void (*maptype)();

   tr = AA[csdata[ws_act]][csproj[ws_act]];
   tr_inverse = AA[csproj[ws_act]][csproj[ws_act]];

   maptype = gnomonic;
   strcpy(mapinfo->proj, "gnomonic");

   /* calculate mcent in the sense of "average" */


   for (i=0; i<n; i++)
      {
      xx += cos(x[xcol][i]*dtr) * cos(x[ycol][i]*dtr);
      yy += sin(x[xcol][i]*dtr) * cos(x[ycol][i]*dtr);
      zz += sin(x[ycol][i]*dtr);
      }

   xx = xx/n;
   yy = yy/n;
   zz = zz/n;

   LL = sqrt(xx*xx + yy*yy + zz*zz);

   if (LL == 0.0)
      {
      xx = 1.;
      yy = 0.;
      zz = 0.;
      }
   else
      {
      xx = xx/LL;
      yy = yy/LL;
      zz = zz/LL;
      }

   lonc= rtd * atan2(yy, xx);
   latc= rtd * asin(zz);
   
   switch(cs(mctype))
      {
      case PROJECTION:
	 tr = AA[csdata[ws_act]][csproj[ws_act]];
	 tr_inverse = AA[csproj[ws_act]][csproj[ws_act]];
	 jcnvc2(sysdata[ws_act], eqnxdata[ws_act], lonc, latc,
		sysproj[ws_act], eqnxproj[ws_act], &mapinfo->mcent.lon,
		&mapinfo->mcent.lat, epoch[ws_act]);
	 break;

      case DATA:
	 tr = AA[csdata[ws_act]][csdata[ws_act]];
	 tr_inverse = AA[csproj[ws_act]][csdata[ws_act]];
	 jcnvc2(sysdata[ws_act], eqnxdata[ws_act], lonc, latc,
		sysdata[ws_act], eqnxdata[ws_act], &mapinfo->mcent.lon,
		&mapinfo->mcent.lat, epoch[ws_act]);
	 break;

      case GRID:
	 tr = AA[csdata[ws_act]][csgrid[ws_act]];
	 tr_inverse = AA[csproj[ws_act]][csgrid[ws_act]];
	 jcnvc2(sysdata[ws_act], eqnxdata[ws_act], lonc, latc,
		sysgrid[ws_act], eqnxgrid[ws_act], &mapinfo->mcent.lon,
		&mapinfo->mcent.lat, epoch[ws_act]);
	 break;

      default:
	 printf("Illegal option.\n");
	 break;
      }
   /*
   (*func[tr])(lonc, latc, &mapinfo->mcent.lon, &mapinfo->mcent.lat);
   */

   /* Calculate the biggest angualr distance between points and mcent; 
      if it is larger than 90 and proj type is gnomonic, then set proj 
      to aitoff */
   
   xx0 = cos(lonc*dtr) * cos(latc*dtr);
   yy0 = sin(lonc*dtr) * cos(latc*dtr);
   zz0 = sin(latc*dtr);
      
   for (i=0; i<n; i++)
     {
     xx = cos(x[xcol][i]*dtr) * cos(x[ycol][i]*dtr);
     yy = sin(x[xcol][i]*dtr) * cos(x[ycol][i]*dtr);
     zz = sin(x[ycol][i]*dtr);
     if ( xx0*xx + yy0*yy + zz0*zz <= 0. )
	{
        fullsize = TRUE;
	if (strncmp(mapinfo->proj, "gno", 3) == 0)
           {
           maptype = aitoff;
	   strcpy(mapinfo->proj, "aitoff");
           break;
           }
	}
     }

   /* set pcent to be mcent */

   tr = AA[csdata[ws_act]][csproj[ws_act]];
   /*
   (*func[tr])(lonc, latc, &mapinfo->pcent.lon, &mapinfo->pcent.lat);
   */
   jcnvc2(sysdata[ws_act], eqnxdata[ws_act], lonc, latc,
  	  sysproj[ws_act], eqnxproj[ws_act], &mapinfo->pcent.lon,
	  &mapinfo->pcent.lat, epoch[ws_act]);

   if (mapinfo->pcent.lon >  180.) mapinfo->pcent.lon -= 360.;
   if (mapinfo->pcent.lon < -180.) mapinfo->pcent.lon += 360.;

   /* if data are in all sky, set pcent.lat 0, choose pcent.lon 
      to be 0 or 180 and size to 360. 180. */

   if (fullsize)
      {
      if (mapinfo->pcent.lon >= -90. && mapinfo->pcent.lon <= 90.) 
	 mapinfo->pcent.lon = 0.;

      else
	 mapinfo->pcent.lon = 180.;

      mapinfo->pcent.lat = 0.;

      switch(cs(mctype))
         {
         case PROJECTION:
	    tr = AA[csdata[ws_act]][csproj[ws_act]];
	    tr_inverse = AA[csproj[ws_act]][csproj[ws_act]];
	    jcnvc2(sysproj[ws_act], eqnxproj[ws_act], 
		   mapinfo->pcent.lon, mapinfo->pcent.lat,
	   	   sysproj[ws_act], eqnxproj[ws_act], 
		   &mapinfo->mcent.lon, &mapinfo->mcent.lat, epoch[ws_act]);
	    break;

         case DATA:
	    tr = AA[csdata[ws_act]][csdata[ws_act]];
	    tr_inverse = AA[csproj[ws_act]][csdata[ws_act]];
	    jcnvc2(sysproj[ws_act], eqnxproj[ws_act], 
		   mapinfo->pcent.lon,  mapinfo->pcent.lat, 
	   	   sysdata[ws_act], eqnxdata[ws_act], 
		   &mapinfo->mcent.lon, &mapinfo->mcent.lat, epoch[ws_act]);
	    break;

         case GRID:
	    tr = AA[csdata[ws_act]][csgrid[ws_act]];
	    tr_inverse = AA[csproj[ws_act]][csgrid[ws_act]];
	    jcnvc2(sysproj[ws_act], eqnxproj[ws_act], 
	           mapinfo->pcent.lon,  mapinfo->pcent.lat,
		   sysgrid[ws_act], eqnxgrid[ws_act], 
		   &mapinfo->mcent.lon, &mapinfo->mcent.lat, epoch[ws_act]);
	    break;

         default:
	    printf("Illegal option.\n");
	    break;
         }
      /*
      (*func[tr_inverse])( mapinfo->pcent.lon,  mapinfo->pcent.lat, 
	          &mapinfo->mcent.lon, &mapinfo->mcent.lat);
      */
      su = 360.;
      sv = 180.;
      }

   /* we can get u0 and v0 now, calculate every u and v, and then 
      get su and sv */

   if (lonc >  180.) lonc -= 360.;
   if (lonc < -180.) lonc += 360.;
   lon0r = mapinfo->pcent.lon * dtr;
   lat0r = mapinfo->pcent.lat * dtr;

   if (fullsize == FALSE)
      {
      /*
      (*func[tr])(lonc, latc, &glon, &glat);
      */
      jcnvc2(sysdata[ws_act], eqnxdata[ws_act], lonc, latc,
  	     sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);
      if (glon > 180.) glon -= 360.;
      if (glon <-180.) glon += 360.;
      maptype(glon, glat, &u0, &v0);
      for (i=0; i<n; i++)
         {
	 /*
         (*func[tr])(x[xcol][i], x[ycol][i], &glon, &glat);
	 */
         jcnvc2(sysdata[ws_act], eqnxdata[ws_act], x[xcol][i], x[ycol][i],
  	        sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);
	 if (x[xcol][i] >  180.) x[xcol][i] -= 360.;
	 if (x[xcol][i] < -180.) x[xcol][i] += 360.;
	 if (glon > 180.) glon -= 360.;
	 if (glon <-180.) glon += 360.;
         maptype(glon, glat, &u, &v);
         if (i==0)
	    {
	    su = 2*fabs(u-u0);
	    sv = 2*fabs(v-v0);
	    }
         if (2*fabs(u-u0) > su) su = 2*fabs(u-u0);
         if (2*fabs(v-v0) > sv) sv = 2*fabs(v-v0);
         }
      }
      mapinfo->size.su = su;
      mapinfo->size.sv = sv;
}
