#include <stdio.h> 
#include <string.h>
#include <math.h>
#include "gks.h"
#include "agra.h"

extern int ws_act;
extern double rat[], res[], chh;
extern double xmin[], xmax[], ymin[], ymax[];
extern double Xmin[], Xmax[], Ymin[], Ymax[];

extern FILE *psout[];

int x_out, y_out;
static int ps_page[10]   = {1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
static int ps_empty = 1;
static int ps_outlen[10] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

static int ps_xmin[10]   = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}; 
static int ps_ymin[10]   = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}; 
static int ps_xmax[10];
static int ps_ymax[10];

static double ps_xminr[10] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}; 
static double ps_yminr[10] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}; 
static double ps_xmaxr[10]; 
static double ps_ymaxr[10];

int file_pos[10], style_pos[10];

void ps_scale(double x, double y, int *ix, int *iy);

void ps_init()
{
   double pageratio = 17./22.;

   if (rat[ws_act] > pageratio)
      {
      ps_xmax[ws_act] = (int) res[ws_act];
      ps_ymax[ws_act] = (int)((1./rat[ws_act]) * res[ws_act]);
      }
   else
      {
      ps_xmax[ws_act] = (int)(rat[ws_act] * res[ws_act] * 1./pageratio );
      ps_ymax[ws_act] = (int)(res[ws_act] * 1./pageratio); 
      }
}

void ps_open(name, file)
char *name, *file;
{
   int ixmin, ixmax, iymin, iymax;  /* bound for grid only (not including
					  the labels) */

   if (psout[ws_act] != NULL)
      fclose(psout[ws_act]);

   psout[ws_act] = fopen(file, "w");

   fprintf(psout[ws_act], "%%!PS-Adobe-2.0 EPSF-1.2\n");
   fprintf(psout[ws_act], "%%%%Title: %s\n", name);
   fprintf(psout[ws_act], "%%%%Creator: ADS\n");
   fprintf(psout[ws_act], "%%%%Pages: 1\n");

   ps_scale(xmin[ws_act], ymin[ws_act], &ixmin, &iymin);
   ps_scale(xmax[ws_act], ymax[ws_act], &ixmax, &iymax);

   fprintf(psout[ws_act], "%%%%ImageBox:    %d %d %d %d\n", 
	   ixmin, iymin, ixmax, iymax);

   ps_scale(Xmin[ws_act], Ymin[ws_act], &ixmin, &iymin);
   ps_scale(Xmax[ws_act], Ymax[ws_act], &ixmax, &iymax);

   fprintf(psout[ws_act], "%%%%BoundingBox: %d %d %d %d\n", 
	   ixmin, iymin, ixmax, iymax);

   fprintf(psout[ws_act], "%%%%EndComments\n");
   fprintf(psout[ws_act], "%%%%BeginProcSet: ads\n");
   fprintf(psout[ws_act], "/m { moveto } bind def\n");
   fprintf(psout[ws_act], "/l { lineto } bind def\n");
   fprintf(psout[ws_act], "/f { closepath fill } bind def\n");
   fprintf(psout[ws_act], "/s { stroke } bind def\n");
   fprintf(psout[ws_act], "/F { findfont exch scalefont setfont} bind def\n");
   fprintf(psout[ws_act], "/t { show } bind def\n");
   fprintf(psout[ws_act], "/S { scale } bind def\n");
   fprintf(psout[ws_act], "/T { translate } bind def\n");
   fprintf(psout[ws_act], "/r { rotate } bind def\n");
   fprintf(psout[ws_act], "/c { setrgbcolor } bind def\n");
   fprintf(psout[ws_act], "%%%%EndProcSet: ads\n");
   fprintf(psout[ws_act], "%%%%EndProlog\n");
   fprintf(psout[ws_act], "%%%%BeginSetup\n");
   fprintf(psout[ws_act], "1 setlinejoin\n");
   fprintf(psout[ws_act], "1 setlinecap\n");
   fprintf(psout[ws_act], "0.34 0.34 S\n"); 
   fprintf(psout[ws_act], "45 25    T\n"); 
   style_pos[ws_act] = ftell(psout[ws_act]);
   fprintf(psout[ws_act], "\n\n\n\n");
   fprintf(psout[ws_act], "%%%%EndSetup\n\n");
   fprintf(psout[ws_act], "%%%%Page: %d %d\n", ps_page[ws_act], ps_page[ws_act]);
   fflush(psout[ws_act]);
}



void ps_setstyle(file_num, style)
int file_num;
char *style;
{
   fseek(psout[file_num], style_pos[file_num], 0);

   if (strncmp(style, "land", 4) == 0)
   {
      fprintf(psout[file_num], "1700 0 T\n");
      fprintf(psout[file_num], "90 r\n");
      fprintf(psout[file_num], "1.294 1.294 S\n");
   }
   
   else if (strncmp(style, "port", 4) == 0)
   {
      fprintf(psout[file_num], "        \n");
      fprintf(psout[file_num], "    \n");
      fprintf(psout[file_num], "             \n");
   }

   fseek(psout[file_num], 0, 2);

}

void ps_close()
{
   file_pos[ws_act] = ftell(psout[ws_act]);
   fprintf(psout[ws_act], "showpage\n\n");
   fprintf(psout[ws_act], "%%%%Trailer\n");
   fprintf(psout[ws_act], "%%%%EOF\n");
   
   fflush(psout[ws_act]);
}

void ps_clearend()
{
   fseek(psout[ws_act], file_pos[ws_act], 0);
   fprintf(psout[ws_act], "           \n\n");
   fprintf(psout[ws_act], "           \n");
   fprintf(psout[ws_act], "           \n");
   fflush(psout[ws_act]);
   fseek(psout[ws_act], file_pos[ws_act], 0);
}

void ps_wind(xmin, xmax, ymin, ymax)

double xmin, xmax, ymin, ymax;
{
   ps_xminr[ws_act] = xmin;
   ps_xmaxr[ws_act] = xmax;
   ps_yminr[ws_act] = ymin;
   ps_ymaxr[ws_act] = ymax;

}

void ps_scale(x, y, ix, iy)
double x, y;
int *ix, *iy;
{
   double pageratio = 17./22.;

   x_out = FALSE;
   y_out = FALSE;

   if (rat[ws_act] > pageratio)
   {
      *ix = (x - ps_xminr[ws_act])
           /(ps_xmaxr[ws_act] - ps_xminr[ws_act]) * res[ws_act];
      *iy = (y - ps_yminr[ws_act])
           /(ps_ymaxr[ws_act] - ps_yminr[ws_act]) * 
	    1./rat[ws_act] * res[ws_act];

      if (*ix < 0 || *ix > res[ws_act])
         x_out = TRUE;
      if (*iy < 0 || *iy > (int) (1./rat[ws_act] * res[ws_act]))
	 y_out = TRUE;

   }
   else
   {
      *ix = (x - ps_xminr[ws_act])
           /(ps_xmaxr[ws_act] - ps_xminr[ws_act]) 
	    * rat[ws_act] * res[ws_act] * 1./pageratio;
      *iy = (y - ps_yminr[ws_act])
	   /(ps_ymaxr[ws_act] - ps_yminr[ws_act]) 
	    * res[ws_act] * 1./pageratio;
      if (*ix < 0 || *ix > (int) (rat[ws_act] * res[ws_act] * 1./pageratio)) 
	 x_out = TRUE;
      if (*iy < 0 || *iy > res[ws_act] * 1./pageratio )
	 y_out = TRUE;
      
   }
}



void ps_polyline(num, pnts)
int num;
Gpoint *pnts;
{
   double x, y;
   int i, start, ix, iy;

   start = num;

   for (i=0; i<num; i++)
      {
      x = pnts[i].x;
      y = pnts[i].y;
      ps_scale(x, y, &ix, &iy);
      if (x_out == FALSE && y_out == FALSE)
	 {
	 /*
         update(ix, iy);
	 */
	 start = i;
	 fprintf(psout[ws_act], "%%!polyline\n");
         fprintf(psout[ws_act], " %3d %3d m", ix, iy);
         ps_outlen[ws_act] += 10;
         if (ps_outlen[ws_act] >= 70)
            {
            fprintf(psout[ws_act], "\n");
            ps_outlen[ws_act] = 0;
            }
	 break;
     	 }
     }


   for(i=start+1; i<num; ++i)
   {
      x = pnts[i].x;
      y = pnts[i].y;
      ps_scale(x, y, &ix, &iy);

      if (x_out == FALSE && y_out == FALSE)
	 {
	 /*
         update(ix, iy);
	 */
         fprintf(psout[ws_act], " %3d %3d l", ix, iy);
         ps_outlen[ws_act] += 10;
         if (ps_outlen[ws_act] >= 70)
            {
            fprintf(psout[ws_act], "\n");
            ps_outlen[ws_act] = 0;
            }
         }
   }

   if (start < num)
      {
      fprintf(psout[ws_act], " s\n\n");
      ps_outlen[ws_act] = 0;
      }
}



void ps_fill(num, pnts)
int num;
Gpoint *pnts;
{
   double x, y;
   int i, start, ix, iy;

   start = num;

   for (i=0; i<num; i++)
      {
      x = pnts[i].x;
      y = pnts[i].y;
      ps_scale(x, y, &ix, &iy);
      if (x_out == FALSE && y_out == FALSE)
	 {
	 /*
	 update(ix, iy);
	 */
	 start = i;
	 fprintf(psout[ws_act], "%%!filledarea\n");
	 fprintf(psout[ws_act], " %3d %3d m", ix, iy);
	 ps_outlen[ws_act] += 10;
	 if (ps_outlen[ws_act] >= 70)
	    {
	    fprintf(psout[ws_act], "\n");
	    ps_outlen[ws_act] = 0;
	    }
         break;
	 }
      }

   for(i=start+1; i<num; ++i)
   {
      x = pnts[i].x;
      y = pnts[i].y;
      ps_scale(x, y, &ix, &iy);

      if (x_out == FALSE && y_out == FALSE)
	 {
	 /*
         update(ix, iy);
	 */
         fprintf(psout[ws_act], " %3d %3d l", ix, iy);

         ps_outlen[ws_act] += 10;
         if(ps_outlen[ws_act] >= 70)
            {
	    fprintf(psout[ws_act], "\n");
	    ps_outlen[ws_act] = 0;
            }
         }
   }

   if (start < num)
      {
      fprintf(psout[ws_act], " f\n\n");
      ps_outlen[ws_act] = 0;
      }
}

void ps_color(colorind)
int colorind;
{
   int red, green, blue;
   char colorname[10];

   *colorname = '\0';

   switch(colorind)
      {
      case BLACK:
	 red   = 255;
	 green = 255;
	 blue  = 255;
	 strcpy(colorname, "black");
         break;

      case WHITE:
	 red   = 0;
	 green = 0;
	 blue  = 0;
	 strcpy(colorname, "white");
         break;

      case RED:
	 red   = 255;
	 green = 0;
	 blue  = 0;
	 strcpy(colorname, "red");
         break;

      case GREEN:
	 red   = 0;
	 green = 255;
	 blue  = 0;
	 strcpy(colorname, "green");
         break;

      case YELLOW:
	 red   = 255;
	 green = 255;
	 blue  = 0;
	 strcpy(colorname, "yellow");
         break;

      case BLUE:
	 red   = 0;
	 green = 0;
	 blue  = 255;
	 strcpy(colorname, "blue");
         break;

      case MAGENTA:
	 red   = 255;
	 green = 0;
	 blue  = 255;
	 strcpy(colorname, "magenta");
         break;

      case CYAN:
	 red   = 0;
	 green = 255;
	 blue  = 255;
	 strcpy(colorname, "cyan");
         break;
      }

   fprintf(psout[ws_act], "%%!color %s\n", colorname);
   fprintf(psout[ws_act], " %3d %3d %3d c\n\n", red, green, blue);
   fflush(psout[ws_act]);
}

#ifdef NOTDEF
update(x, y)
int x, y;
{
   if (x<ps_xmin[ws_act]) 
      ps_xmin[ws_act]=x; 
   else if (x>ps_xmax[ws_act]) 
      ps_xmax[ws_act]=x;

   if (y<ps_ymin[ws_act]) 
      ps_ymin[ws_act]=y; 
   else if (y>ps_ymax[ws_act]) 
      ps_ymax[ws_act]=y;

   ps_empty=0;
}
#endif /* NOTDEF */

