/* File saoimage/wcslib/platepos.c
 * May 4, 1995
 * By Doug Mink, Harvard-Smithsonian Center for Astrophysics

 * Compute WCS from Digital Sky Survey plate fit

        platepos() converts from pixel location to RA,Dec 
        platexy()  converts from RA,Dec         to pixel location   

    where "(RA,Dec)" are more generically (long,lat). These functions
    are based on the astrmcal.c portion of GETIMAGE, which is distributed
    with the Digital Sky Survey.
*/
#include <string.h>
#include <stdio.h>
#include <math.h>
#include "img.h"

int platepos (xpix, ypix, imgp, xpos, ypos)

/* Routine to determine accurate position for pixel coordinates */
/* returns 0 if successful otherwise 1 = angle too large for projection; */
/* based on amdpos() from getimage */

/* Input: */
double	xpix;		/* x pixel number  (RA or long without rotation) */
double	ypix;		/* y pixel number  (dec or lat without rotation) */
struct img *imgp;

/* Output: */
double	*xpos;		/* x (RA) coordinate (deg) */
double	*ypos;		/* y (dec) coordinate (deg) */

{
  double x, y, xmm, ymm, xmm2, ymm2, xmm3, ymm3, x2y2;
  double xi, xir, eta, etar, raoff, ra, dec;
  double cond2r = 1.745329252e-2;
  double cons2r = 206264.8062470964;
  double twopi = 6.28318530717959;
  double ctan, ccos;

/*  Ignore magnitude and color terms 
  double mag = 0.0;
  double color = 0.0; */

/* Convert from pixels to millimeters */

  x = xpix + imgp->x_pixel_offset - 1;
  y = ypix + imgp->y_pixel_offset - 1;
  xmm = (imgp->ppo_coeff[2] - x * imgp->x_pixel_size) / 1000.0;
  ymm = (y * imgp->y_pixel_size - imgp->ppo_coeff[5]) / 1000.0;
  xmm2 = xmm * xmm;
  ymm2 = ymm * ymm;
  xmm3 = xmm * xmm2;
  ymm3 = ymm * ymm2;
  x2y2 = xmm2 + ymm2;

/*  Compute coordinates from x,y and plate model */

  xi =  imgp->amd_x_coeff[ 0]*xmm	+ imgp->amd_x_coeff[ 1]*ymm +
	imgp->amd_x_coeff[ 2]		+ imgp->amd_x_coeff[ 3]*xmm2 +
	imgp->amd_x_coeff[ 4]*xmm*ymm	+ imgp->amd_x_coeff[ 5]*ymm2 +
	imgp->amd_x_coeff[ 6]*(x2y2)	+ imgp->amd_x_coeff[ 7]*xmm3 +
	imgp->amd_x_coeff[ 8]*xmm2*ymm	+ imgp->amd_x_coeff[ 9]*xmm*ymm2 +
	imgp->amd_x_coeff[10]*ymm3	+ imgp->amd_x_coeff[11]*xmm*(x2y2) +
	imgp->amd_x_coeff[12]*xmm*x2y2*x2y2;

/*  Ignore magnitude and color terms 
	+ imgp->amd_x_coeff[13]*mag	+ imgp->amd_x_coeff[14]*mag*mag +
	imgp->amd_x_coeff[15]*mag*mag*mag + imgp->amd_x_coeff[16]*mag*xmm +
	imgp->amd_x_coeff[17]*mag*x2y2	+ imgp->amd_x_coeff[18]*mag*xmm*x2y2 +
	imgp->amd_x_coeff[19]*color; */

  eta =	imgp->amd_y_coeff[ 0]*ymm	+ imgp->amd_y_coeff[ 1]*xmm +
	imgp->amd_y_coeff[ 2]		+ imgp->amd_y_coeff[ 3]*ymm2 +
	imgp->amd_y_coeff[ 4]*xmm*ymm	+ imgp->amd_y_coeff[ 5]*xmm2 +
	imgp->amd_y_coeff[ 6]*(x2y2)	+ imgp->amd_y_coeff[ 7]*ymm3 +
	imgp->amd_y_coeff[ 8]*ymm2*xmm	+ imgp->amd_y_coeff[ 9]*ymm*xmm2 +
	imgp->amd_y_coeff[10]*xmm3	+ imgp->amd_y_coeff[11]*ymm*(x2y2) +
	imgp->amd_y_coeff[12]*ymm*x2y2*x2y2;

/*  Ignore magnitude and color terms 
	+ imgp->amd_y_coeff[13]*mag	+ imgp->amd_y_coeff[14]*mag*mag +
	imgp->amd_y_coeff[15]*mag*mag*mag + imgp->amd_y_coeff[16]*mag*ymm +
	imgp->amd_y_coeff[17]*mag*x2y2)	+ imgp->amd_y_coeff[18]*mag*ymm*x2y2 +
	imgp->amd_y_coeff[19]*color; */

/* Convert to radians */

  xir = xi / cons2r;
  etar = eta / cons2r;

/* Convert to RA and Dec */

  ctan = tan (imgp->plate_dec);
  ccos = cos (imgp->plate_dec);
  raoff = atan2 (xir / ccos, 1.0 - etar * ctan);
  ra = raoff + imgp->plate_ra;
  if (ra < 0.0) ra = ra + twopi;
  *xpos = ra / cond2r;

  dec = atan (cos (raoff) / ((1.0 - (etar * ctan)) / (etar + ctan)));
  *ypos = dec / cond2r;
  return 0;
}

/* Mar  6 1995	Original version of this code
   May  4 1995	Fix eta cross terms which were all in y
 */
