
/*//////////////////////////////////////////////////////////////////////
/                                                                     /
/     Determines the Sexigesimal equivalent of Decimal Degree input   /
/                                                                     /
/     input  : coord       decimal degrees                            /
/     input  : hd          hours (0) or degrees (1)                   /
/     output : cstr        sexigesimal expression                     /
/                                                                     /
//////////////////////////////////////////////////////////////////////*/

#include <stdio.h>
#include <string.h>
#include <math.h>

#define HOUR 0
#define DEG  1

void mapsex(coord, cstr, hd)
double  coord;
char    *cstr;        
int        hd;
{
   char   sign;
   double res;
   int    coordd, coordm, coords;
   char   str[10];
   int    i;

   if(fabs(coord) < 1.e-6)
      coord = 0.;

   if(fabs(coord - 360.) < 1.e-6)
      coord = 0.;


   sign = '+';
   if (coord < 0.0) 
      sign = '-';
   if (coord == 0.0)
      sign = ' ';

   if(hd == HOUR && coord < 0.)
      res = coord + 360.;
   else
      res=fabs(coord);

   res = res + 0.05/3600.0;
   if(hd == HOUR)
      res = res/15.;

   coordd=(int) res;
   res=(res-(double) coordd)*60.0;
   coordm=(int) res;
   res=(res-(double) coordm)*60.0;
   coords=(int) res;

   if(coords == 60)
   {
      coordm=coordm+1;
      coords=0;
   }

   if(coordm == 60)
   {
      coordd=coordd+1;
      coordm=0;
   }

   for(i=0; i<strlen(cstr); ++i)
      cstr[i] = '\0';

   for(i=0; i<strlen(str); ++i)
      str[i] = '\0';

   if(hd == DEG)
      sprintf(cstr, "%c", sign);

   sprintf(str, "%2d", coordd);
   if(str[0] == ' ')
      str[0] = '0';
   strcat(cstr, str);
   
   if (coord == 0.0)
      strcpy(cstr, "00");

   if (hd == DEG)
   {
      sprintf(str, "d");
      strcat(cstr, str);
   }

   else
   {
      sprintf(str, "h");
      strcat(cstr, str);
   }

   sprintf(str, "%2dm", coordm);
   if(str[0] == ' ')
      str[0] = '0';
   if(coordm != 0 || coords != 0)
      strcat(cstr, str);

   sprintf(str, "%2ds", coords);
   if(str[0] == ' ')
      str[0] = '0';
   if(coords != 0)
      strcat(cstr, str);
}
