#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "gks.h"
#include "agra.h" 

#define LSIZE   132

extern int ws_act, do_cursor, csproj[], csgrid[], csdata[], cslab[], csloc[],
           sysproj[], sysgrid[], sysdata[], syslab[], sysloc[];
extern int ait_done[], car_done[], gno_done[], cyl_done[],
	   ncp_done[], ort_done[], pla_done[],
	   sysproj[], sysgrid[];

extern int labcs_done[], llabel_done[];
extern int tr, tr_inverse, mode;
extern int AA[4][4];

extern void (*map[10])(), (*map_inv[10])();
extern void E(), eclequ(), eclgal(), eclsgal(), equecl(), equgal(), 
	      equsgal(), galecl(), galequ(), galsgal(), sgalecl(), 
	      sgalequ(), sgalgal();

extern void (*func[])();
extern double dtr, rtd, pi;
extern double xmin[], xmax[], ymin[], ymax[],
              eqnxproj[], eqnxgrid[], eqnxdata[], eqnxlab[],eqnxloc[], epoch[];

extern PARA para[];
extern FILE   *fd;

int    load_font_done = 0;
double pcent, lonsplitp, lonsplitm;

double curve_setup();
void   curve_value();
static void faspec(double lon0, double lat0, double lon1, double lat1, 
    double lon2, double lat2);
static void facurve(double lon0, double lat0, double lon1, double lat1, 
    double lon2, double lat2);
static int bigjump(Gpoint *points);
static void merrorbar(double lon0, double lat0, double err, int dir, double e);
static int crossing(double lon0, double lat0, double lon1, double lat1, 
    int ws_act);
static int outside(Gpoint *points);
static void swap(double *x, double *y);
static void mputlabel(double lon0, double lat0, int n, char *str, double exp, 
    double size, double ang);
static void load_font();



/*****************************************************************************/
/*                                                                           */
/* DRAWSYMBOL - Routine to draw a symbol on the sky at a particular location */
/*                                                                           */
/*****************************************************************************/

void drawsymbol(double lon0, double lat0, 
	   int nsides, int ptype, double expand, double rotate)
{
   int    i;

   double lon1, lat1, lon2, lat2, lon[20], lat[20], longi, lati, theta[20];
   double angle, exp;
   double uu, vv, t1, t2;

   double glon, glat;

   Gpoint mqt[2];
   

   if(debug)
   {
      printf("debug> drawsymbol: lon0   = %-g\n", lon0);
      printf("debug> drawsymbol: lat0   = %-g\n", lat0);
      printf("debug> drawsymbol: nsides = %d \n", nsides);
      printf("debug> drawsymbol: ptype  = %d \n", ptype);
      printf("debug> drawsymbol: expand = %-g\n", expand);
      printf("debug> drawsymbol: rotate = %-g\n", rotate);
      printf("\n");
      fflush(stdout);
   }

   exp = expand / 2. * dtr;

   while (lon0 >  180.) lon0 -= 360.;
   while (lon0 < -180.) lon0 += 360.;


   /* There are two main types of symbols; polygons and 'special'   */
   /* ones.  Since real polygons can't have nsides = 0, we use this */
   /* to flag the special symbols.                                  */

   if (nsides > 0)
   {
      /* "Special" cases CROSS and X are actually         */
      /* skeletal 4-sided symbols with specific rotations */

      if (ptype == PTYPE_CROSS 
       || ptype == PTYPE_X)
      {
	 nsides = 4;

	 if (ptype == PTYPE_CROSS)
	    rotate = 45.*dtr;

	 if (ptype == PTYPE_X)
	    rotate = 0.;

	 ptype = PTYPE_SKELETAL;
      }

      if(debug)
      {
	 printf("debug> drawsymbol: nsides = %d, rotation %8.4f\n",
	    nsides, rotate);
	 fflush(stdout);
      }


      /* For polygons, compute the locations of the vertices */

      for (i=0; i<=nsides; i++)
      {
	 if (nsides == (int)(nsides/2) * 2)
	    theta[i] = -rotate + pi/nsides + i*2.*pi/nsides;
	 else
	    theta[i] = -rotate + i*2.*pi/nsides;
	    
	 t1 = (sin(exp)*cos(theta[i])*cos(lat0*dtr)+sin(lat0*dtr)*cos(exp));

	 if (t1 >  1.) t1 =  1.;
	 if (t1 < -1.) t1 = -1.;

	 lati = asin(t1) * rtd;

	 longi = lon0 + rtd*atan2( sin(exp)*sin(theta[i]), 
				  (cos(exp)*cos(lat0*dtr) -
				   sin(exp)*cos(theta[i])*sin(lat0*dtr)));
	 lon[i] = longi;
	 lat[i] = lati;

	 if (i == nsides)
	 {
	    theta[i] = theta[0];
	    lon  [i] = lon  [0];
	    lat  [i] = lat  [0];
	 }

	 if (lon[i] >  180.) lon[i] -= 360.;
	 if (lon[i] < -180.) lon[i] += 360.;

	 if(debug)
	 {
	    printf("debug> drawsymbol: theta lon lat = %8.4f %8.4f %8.4f\n", 
	       theta[i], lon[i], lat[i]);
	 }
      }

      if(debug)
      {
	 printf("\n");
	 fflush(stdout);
      }



      /* Now that we know the symbol vertices, we need to draw the       */
      /* symbols on the 'sky'.  It is simplest here to switch based on   */
      /* point 'type' (open, skeletal, starred, or solid) since they get */
      /* drawn very differently.                                         */

      switch(ptype)
      {

	 case PTYPE_OPEN:

	    lon1 = lon[0];
	    lat1 = lat[0];

	    for (i=1; i<=nsides; i++)
	    {
	       lon2 = lon[i];
	       lat2 = lat[i]; 

	       skycurve(lon1, lat1, lon2, lat2, "great");

	       lon1 = lon[i];
	       lat1 = lat[i];
	    }

	 break;


	 case PTYPE_SKELETAL:

	    lon1 = lon0;
	    lat1 = lat0;

	    for (i=0; i<nsides; i++)
	    {
	       lon2 = lon[i];
	       lat2 = lat[i];

	       skycurve(lon1, lat1, lon2, lat2, "great");
	    }

	 break;


	 case PTYPE_STARRED:

	    nsides = 2 * nsides;
	    exp    = exp / 2.;

	    for (i=0; i<=nsides; i++)
	    {
	       if (nsides == (int)(nsides/4) * 4)
		  theta[i] = -rotate + 2*pi/nsides + i*2*pi/nsides;
	       else
		  theta[i] = -rotate               + i*2*pi/nsides;

	       if (i == (int)(i/2) * 2)
		  exp = 2 * exp;
	       else
		  exp = exp / 2;

	       t1 = (sin(exp)*cos(theta[i])*cos(lat0*dtr)
		    +sin(lat0*dtr)*cos(exp));

	       if (t1 >  1.) t1 =  1.;
	       if (t1 < -1.) t1 = -1.;

	       lati  = asin(t1);
	       lati  = lati*rtd;

	       longi = lon0 + rtd*atan2( sin(exp)*sin(theta[i]), 
					(cos(exp)*cos(lat0*dtr) -
					 sin(exp)*cos(theta[i])*sin(lat0*dtr)));

	       lon[i] = longi;
	       lat[i] = lati;

	       if (i == nsides)
	       {
		  theta[i] = theta[0];
		  lon  [i] = lon  [0];
		  lat  [i] = lat  [0];
	       }
	    }

	    lon1 = lon[0];
	    lat1 = lat[0];

	    for (i=0; i<=nsides; i++)
	    {
	       lon2 = lon[i];
	       lat2 = lat[i];

	       skycurve(lon1, lat1, lon2, lat2, "great");

	       lon1 = lon[i];
	       lat1 = lat[i];
	    }

	 break;


	 case PTYPE_SOLID:

	 lon1 = lon[0];
	 lat1 = lat[0];

	 pcent = para[ws_act].pcent.lon;

	 lonsplitp =     pcent + 180.;
	 lonsplitm = lonsplitp - 360.;

	 tr = AA[csdata[ws_act]][csproj[ws_act]];

	 jcnvc2(sysdata[ws_act], eqnxdata[ws_act],  lon0,  lat0,
		sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);

	 lon0 = glon;
	 lat0 = glat;

	 jcnvc2(sysdata[ws_act], eqnxdata[ws_act],  lon1,  lat1,
		sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);

	 lon1 = glon;
	 lat1 = glat;

	 if (lon0 > lonsplitp) lon0 -= 360.;
	 if (lon0 < lonsplitm) lon0 += 360.;
	 if (lon1 > lonsplitp) lon1 -= 360.;
	 if (lon1 < lonsplitm) lon1 += 360.;

	 for (i=1; i<=nsides; i++)
	 {
	    lon2 = lon[i];
	    lat2 = lat[i]; 

	    jcnvc2(sysdata[ws_act], eqnxdata[ws_act],  lon2,  lat2,
		   sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);

	    lon2 = glon;
	    lat2 = glat;

	    if (lon2 > lonsplitp) lon2 -= 360.;
	    if (lon2 < lonsplitm) lon2 += 360.;

	    if ((fabs(lon1-lon0)>180.) || (fabs(lon2-lon0)>180.))
	       faspec(lon0, lat0, lon1, lat1, lon2, lat2);
	    else
	       facurve(lon0, lat0, lon1, lat1, lon2, lat2);

	    lon1 = lon2;
	    lat1 = lat2;
	 }

	 break;


	 default:

	    if (mode == INTERACTIVE)
	       printf(" Illegal option of parameter 2\n");

	 break;
      }
   }



   /* For special shapes (currently, the only one is PTYPE_CIRCLE) */

   else
   {
      for (angle=0.; angle<=360.; angle += 5.)
      {
	 t1 = (sin(exp)*cos(angle*dtr)+tan(lat0*dtr)*cos(exp))/
	      (cos(lat0*dtr)+tan(lat0*dtr)*sin(lat0*dtr));

         if (t1 >  1.) t1 =  1.;
	 if (t1 < -1.) t1 = -1.;

	 lati = asin(t1);

	 t2 = sin(exp)*sin(angle*dtr)/cos(lati);

	 lati = lati*rtd;

	 if (t2 >  1.) t2 =  1.;
	 if (t2 < -1.) t2 = -1.;

         longi = lon0 + asin(t2)*rtd;

         if (longi >  180.) longi -= 360.;
	 if (longi < -180.) longi += 360.;

         jcnvc2(sysdata[ws_act], eqnxdata[ws_act], longi, lati,
                sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);

	 map[ws_act](glon, glat, &uu, &vv);

	 mqt[1].x = uu;
	 mqt[1].y = vv;

	 if(angle == 0.)
	 {
	    mqt[0].x = uu;
	    mqt[0].y = vv;
	 }

	 if(!bigjump(mqt))
	 {
	     gpolyline(2, mqt);
	    f_polyline(2, mqt);
	 }
	    
	 mqt[0].x = mqt[1].x;
	 mqt[0].y = mqt[1].y;
      }
   }
}



static void merrorbar(lon0, lat0, err, dir, e)

double lon0, lat0, err, e;
int   dir;
{
   double lon, lat, lon1, lat1, lon2, lat2, theta, theta1, theta2; 
   double t1, t2;

   switch(dir)
      {
      case 1:
	 theta  =  90.;
	 theta1 =   0.;
	 theta2 = 180.;
	 break;
      case 2:
	 theta  =   0.;
	 theta1 = 270.;
	 theta2 =  90.;
	 break;
      case 3:
	 theta  = 270.;
	 theta1 =   0.;
	 theta2 = 180.;
	 break;
      case 4:
	 theta  = 180.;
	 theta1 = 270.;
	 theta2 =  90.;
	 break;
      default:
         if (mode == INTERACTIVE)
	    printf("Illegal option with '%d'\n", dir); 
	 break;
      }
   t1 = (sin(err*dtr)*cos(theta*dtr)+tan(lat0*dtr)*cos(err*dtr))/
        (cos(lat0*dtr)+tan(lat0*dtr)*sin(lat0*dtr));
   if (t1 >  1.) t1 =  1.;
   if (t1 < -1.) t1 = -1.;
   lat = asin(t1);
   lat = lat*rtd;
   t2  = sin(err*dtr)*sin(theta*dtr)/cos(lat*dtr);
   if (t2 >  1.) t2 =  1.;
   if (t2 < -1.) t2 = -1.;
   lon = lon0 + asin(t2)*rtd; 
   skycurve(lon0, lat0, lon, lat, "great");

   t1 = (sin(e*dtr)*cos(theta1*dtr)+tan(lat*dtr)*cos(e*dtr))/
        (cos(lat*dtr)+tan(lat*dtr)*sin(lat*dtr));
   if (t1 >  1.) t1 =  1.;
   if (t1 < -1.) t1 = -1.;
   lat1 = asin(t1);
   lat1 = lat1*rtd;
   t2  = sin(e*dtr)*sin(theta1*dtr)/cos(lat1*dtr);
   if (t2 >  1.) t2 =  1.;
   if (t2 < -1.) t2 = -1.;
   lon1 = lon + asin(t2)*rtd; 

   t1 = (sin(e*dtr)*cos(theta2*dtr)+tan(lat*dtr)*cos(e*dtr))/
        (cos(lat*dtr)+tan(lat*dtr)*sin(lat*dtr));
   if (t1 >  1.) t1 =  1.;
   if (t1 < -1.) t1 = -1.;
   lat2 = asin(t1);
   lat2 = lat2*rtd;
   t2  = sin(e*dtr)*sin(theta2*dtr)/cos(lat2*dtr);
   if (t2 >  1.) t2 =  1.;
   if (t2 < -1.) t2 = -1.;
   lon2 = lon + asin(t2)*rtd; 

   skycurve(lon1, lat1, lon2, lat2, "great");

} 


/*************************************************************************/
/*                                                                       */
/* SKYCURVE -- Routine to draw a curve on the sky                        */
/*                                                                       */
/*************************************************************************/

void skycurve(double lon1, double lat1, double lon2, double lat2, char *curtype)
{
   double angle, maxang, dang;
   double lon, lat, glon, glat;
   double uu, vv;

   Gpoint mqt[2];

   if(debug)
   {
      printf("debug> skycurve: lon1 = %8.4f\n", lon1);
      printf("debug> skycurve: lat1 = %8.4f\n", lat1);
      printf("debug> skycurve: lon2 = %8.4f\n", lon2);
      printf("debug> skycurve: lat2 = %8.4f\n", lat2);
      printf("debug> skycurve: type = [%s]\n\n", curtype);
      fflush(stdout);
   }


   /* Are we drawing great circles, constant latitude circles, or */
   /* straight lines on the map?                                  */

   switch(cs(curtype))
   {
      /* Great circle curve */

      case GREAT:

	 /* First check to see if this curve even has the potential */
	 /* for crossing the region of the map                      */

         if(!crossing(lon1, lat1, lon2, lat2, ws_act))
	    break;


	 /* Pick the angle increment along the curve to be drawn */

	 if ((xmax[ws_act]-xmin[ws_act]) < (ymax[ws_act]-ymin[ws_act]))
	    dang = (xmax[ws_act]-xmin[ws_act])/100.;
	 else
	    dang = (ymax[ws_act]-ymin[ws_act])/100.;


	 /* Set up the process for travelling along the curve */

	 maxang = curve_setup(lon1, lat1, lon2, lat2);


	 /* Get the uv location of the starting point */

	 curve_value(0., &lon, &lat);
	 jcnvc2(sysdata[ws_act], eqnxdata[ws_act], lon, lat,
	       sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);

	 map[ws_act](glon, glat, &uu, &vv);

	 mqt[0].x = uu;
	 mqt[0].y = vv;


	 /* Stepping along the curve */

	 for (angle=0.; angle<maxang; angle+=dang)
	 {
	    curve_value(angle, &lon, &lat);

	    jcnvc2(sysdata[ws_act], eqnxdata[ws_act], lon, lat,
	    sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);

	    map[ws_act](glon, glat, &uu, &vv);

	    mqt[1].x = uu;
	    mqt[1].y = vv;

	    if (outside(mqt))
	    {
	       mqt[0].x = mqt[1].x;
	       mqt[0].y = mqt[1].y;
	       continue;
	    }

	    if(!bigjump(mqt))
	    {
		gpolyline(2, mqt);
	       f_polyline(2, mqt);
	    }

	    mqt[0].x = mqt[1].x;
	    mqt[0].y = mqt[1].y;
	 }

	 curve_value(maxang, &lon, &lat);
	 jcnvc2(sysdata[ws_act], eqnxdata[ws_act], lon, lat,
	 sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);

	 map[ws_act](glon, glat, &uu, &vv);

	 mqt[1].x = uu;
	 mqt[1].y = vv;

	 if (outside(mqt))
	    break;

	 if(!bigjump(mqt))
	 {
	     gpolyline(2, mqt);
	    f_polyline(2, mqt);
	 }

	 break;



      /* Linear on the map surface (but with the correct end points) */

      case LINEAR:

      jcnvc2(sysdata[ws_act], eqnxdata[ws_act], lon1, lat1,
	 sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);

      map[ws_act](glon, glat, &uu, &vv);

      mqt[0].x = uu;
      mqt[0].y = vv;

      jcnvc2(sysdata[ws_act], eqnxdata[ws_act], lon2, lat2,
	 sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);

      map[ws_act](glon, glat, &uu, &vv);

      mqt[1].x = uu;
      mqt[1].y = vv;

      if (outside(mqt))
	 break;

      if(!bigjump(mqt))
      {
	  gpolyline(2, mqt);
	 f_polyline(2, mqt);
      }
      
      break;



      case LAT:

      dang = (xmax[ws_act] - xmin[ws_act])/100.;

      if (lon2 < lon1)
      {
      swap(&lon1, &lon2);
      swap(&lat1, &lat2);
      }

      jcnvc2(sysdata[ws_act], eqnxdata[ws_act], lon1, lat1,
	 sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);

      map[ws_act](glon, glat, &uu, &vv);

      mqt[0].x = uu;
      mqt[0].y = vv;

      for (lon=lon1; lon<=lon2; lon+=dang)
      {
	 jcnvc2(sysdata[ws_act], eqnxdata[ws_act], lon, lat1,
	    sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);

	 map[ws_act](glon, glat, &uu, &vv);

	 mqt[1].x = uu;
	 mqt[1].y = vv;

	 if (outside(mqt))
	 {
	    mqt[0].x = mqt[1].x;
	    mqt[0].y = mqt[1].y;
	    continue;
	 }

	 if(!bigjump(mqt))
	 {
	     gpolyline(2, mqt);
	    f_polyline(2, mqt);
	 }
	 
	 mqt[0].x = mqt[1].x;
	 mqt[0].y = mqt[1].y;
      }
      
      jcnvc2(sysdata[ws_act], eqnxdata[ws_act], lon2, lat1,
	 sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);

      map[ws_act](glon, glat, &uu, &vv);

      mqt[1].x = uu;
      mqt[1].y = vv;

      if (outside(mqt))
      break;

      if(!bigjump(mqt))
      {
	  gpolyline(2, mqt);
	 f_polyline(2, mqt);
      }

      break;


      default:

	 if (mode == INTERACTIVE)
	 printf("Illegal option with '%s'\n", curtype);
	 break;
   }
}

/*************************************************************************/
/*                                                                       */
/* CROSSING -- Check to see if a curve has the potential to cross the    */
/* area of interest (map region).  Done by taking the cross product of   */
/* the two segment end-points (thus getting the vector tangential to     */
/* the plane defined by the great circle through these points), then     */
/* taking the dot product of this with the image center (which gives     */
/* the angle on the sky between the tangent vector and the center of     */
/* the image).  90 minus this is the distance between the image center   */
/* and the point of closest approach of the great circle.                */
/*                                                                       */
/*************************************************************************/

static int crossing(double lon0, double lat0, double lon1, double lat1, 
    int ws_act)
{
   double loni, lati, new_loni, new_lati;

   double x0, y0, z0;
   double x1, y1, z1;
   double xi, yi, zi;
   double xc, yc, zc;

   double len, dot, ang;


   /* End points */

   lon0 = lon0 * dtr;
   lat0 = lat0 * dtr;

   lon1 = lon1 * dtr;
   lat1 = lat1 * dtr;

   x0 = cos(lon0) * cos(lat0);
   y0 = sin(lon0) * cos(lat0);
   z0 = sin(lat0);

   x1 = cos(lon1) * cos(lat1);
   y1 = sin(lon1) * cos(lat1);
   z1 = sin(lat1);


   /* Image center */

   loni = para[ws_act].mcent.lon;
   lati = para[ws_act].mcent.lat;
     
   setcs(flag[ws_act], 1, loni, lati, &new_loni, &new_lati);
   jcnvc2(sysgrid[ws_act], eqnxgrid[ws_act], new_loni, new_lati,
          sysdata[ws_act], eqnxdata[ws_act], &loni, &lati, epoch[ws_act]);
   
   loni = loni * dtr;
   lati = lati * dtr;

   xi = cos(loni) * cos(lati);
   yi = sin(loni) * cos(lati);
   zi = sin(lati);


   /* Cross product */

   xc =  y0*z1 - y1*z0;
   yc = -x0*z1 + x1*z0;
   zc =  x0*y1 - x1*y0;

   len = sqrt(xc*xc + yc*yc + zc*zc);

   xc = xc / len;
   yc = yc / len;
   zc = zc / len;


   /* Dot product */

   dot = xi*xc + yi*yc + zi*zc;
   ang = acos(dot) / dtr;

   ang = fabs(90. - ang);

   if(ang <= para[ws_act].maxsize)
      return(1);
   else
      return(0);
}


double lonref, sinphi, cosphi, sind0, cosd0;

double curve_setup(double lon0, double lat0, double lon1, double lat1)
{
   double x0, y0, z0;
   double x1, y1, z1;

   double dist, thetam, sintm, costm;

   lon0 = lon0 * dtr;
   lat0 = lat0 * dtr;

   lon1 = lon1 * dtr;
   lat1 = lat1 * dtr;

   lonref = lon0;

   x0 = cos(lon0) * cos(lat0);
   y0 = sin(lon0) * cos(lat0);
   z0 = sin(lat0);

   x1 = cos(lon1) * cos(lat1);
   y1 = sin(lon1) * cos(lat1);
   z1 = sin(lat1);

   dist = fabs(x0*x1 + y0*y1 + z0*z1);

   if(dist > 1.)
      dist = 1.;

   thetam = acos(dist) / dtr;

   if(thetam == 0.)
   {
      sinphi = 0.;
      cosphi = 0.;
      return(thetam);
   }

   costm = dist;
  sintm = sqrt(1. - dist * dist);

   sind0 = sin(lat0);
   cosd0 = cos(lat0);

   sinphi = (sin(lon1-lon0) * cos(lat1))/sintm;
   cosphi = (sin(lat1) - sind0*costm) / (cosd0*sintm);

   return(thetam);
}


void curve_value(double theta, double *lon, double *lat)
{
   double sina, cosa, sind;

   theta = theta * dtr;

   sina = sin(theta);
   cosa = cos(theta);

   sind = cosa*sind0 + sina*cosphi*cosd0; 

   *lat = asin(sind) / dtr;

   *lon = (atan2(sina*sinphi*cosd0, cosa-sind*sind0) + lonref) / dtr;
}



static int outside(Gpoint *points)
{
   /* Returns 0 (false) if either endpoint is inside the map window */

   if(points[0].x >= xmin[ws_act] && points[0].x <= xmax[ws_act]
   && points[0].y >= ymin[ws_act] && points[0].y <= ymax[ws_act])
      return(0);

   if(points[1].x >= xmin[ws_act] && points[1].x <= xmax[ws_act]
   && points[1].y >= ymin[ws_act] && points[1].y <= ymax[ws_act])
      return(0);

   return 1;
}



static int bigjump(Gpoint *points)
{
   /* Returns 1 (true) if the distance between  the points is too */
   /* large (implies we wrapped around the sky)                   */

   if (sqrt((points[0].x-points[1].x)*(points[0].x-points[1].x)+
	    (points[0].y-points[1].y)*(points[0].y-points[1].y)) > 35.)
      return 1;

   return 0;
}



/********************************************/
/*                                          */
/*  This subroutine fills arbitrary sector  */
/*                                          */
/********************************************/

static void facurve(lon0, lat0, lon1, lat1, lon2, lat2)

double lon0, lat0, lon1, lat1, lon2, lat2;   
{
   Gpoint mqt[3];
   double lon, lat;
   double uu, vv, dang;
   double max_dist();


   tr = AA[csdata[ws_act]][csproj[ws_act]];

   if ((xmax[ws_act]-xmin[ws_act]) < (ymax[ws_act]-ymin[ws_act]))
       dang = (xmax[ws_act]-xmin[ws_act])/100.;
   else
       dang = (ymax[ws_act]-ymin[ws_act])/100.;

   if (lon0 > lonsplitp) lon0 -= 360.;
   if (lon0 < lonsplitm) lon0 += 360.;
   if (lon1 > lonsplitp) lon1 -= 360.;
   if (lon1 < lonsplitm) lon1 += 360.;
   if (lon2 > lonsplitp) lon2 -= 360.;
   if (lon2 < lonsplitm) lon2 += 360.;

   if (lon2 < lon1)                           
      {					     
      swap(&lon1, &lon2);             
      swap(&lat1, &lat2);
      }

   /*
   (*func[tr])(lon0, lat0, &glon, &glat);
   */
   map[ws_act](lon0, lat0, &uu, &vv);
   mqt[0].x = uu;
   mqt[0].y = vv;

   /*
   (*func[tr])(lon1, lat1, &glon, &glat);
   */
   map[ws_act](lon1, lat1, &uu, &vv);
   mqt[1].x = uu;
   mqt[1].y = vv;

   if (lon2 == lon1)
      {
      if (lat1 > lat2)
	 swap(&lat1, &lat2);

      /*
      (*func[tr])(lon1, lat1, &glon, &glat);
      */
      map[ws_act](lon1, lat1, &uu, &vv);
      mqt[1].x = uu;
      mqt[1].y = vv;

      for (lat=lat1; lat<=lat2; lat+=dang)
	 {
	 /*
	 (*func[tr])(lon1, lat, &glon, &glat);
	 */
	 map[ws_act](lon1, lat, &uu, &vv);
	 mqt[2].x = uu;
	 mqt[2].y = vv;
         if (max_dist(mqt[0], mqt[1], mqt[2]) < 25.)
            {
            gfillarea(3, mqt);
            ps_fill(3, mqt);
            }
	 mqt[1].x = mqt[2].x;
	 mqt[1].y = mqt[2].y;
	 }
      }

   if (lon2-lon1<dang)      
      {
      /*
      (*func[tr])(lon2, lat2, &glon, &glat);
      */
      map[ws_act](lon2, lat2, &uu, &vv);
      mqt[2].x = uu;
      mqt[2].y = vv;
      if (max_dist(mqt[0], mqt[1], mqt[2]) < 25.)
         {
         gfillarea(3, mqt);
         ps_fill(3, mqt);
         }
      }

   else if (lon2-lon1>=dang)
      {
      if (lon2 - lon1 < 180.)
         {
         for (lon=lon1; lon<=lon2; lon+=dang)
             {
             lat = atan((sin((lon-lon1)*dtr)*tan(lat2*dtr)+
  	              sin((lon2-lon)*dtr)*tan(lat1*dtr))/
	              sin((lon2-lon1)*dtr));
             lat = lat * rtd;
	     /*
	     (*func[tr])(lon, lat, &glon, &glat);
	     */
             map[ws_act](lon, lat, &uu, &vv);
             mqt[2].x = uu;
             mqt[2].y = vv;
	     if (max_dist(mqt[0], mqt[1], mqt[2]) < 25.)
	        {
                gfillarea(3, mqt);
	        ps_fill(3, mqt);
	        }
	     mqt[1].x = mqt[2].x;
             mqt[1].y = mqt[2].y;
             }
	 /*
         (*func[tr])(lon2, lat2, &glon, &glat);
	 */
         map[ws_act](lon2, lat2, &uu, &vv);
         mqt[2].x = uu;
         mqt[2].y = vv;
         if (max_dist(mqt[0], mqt[1], mqt[2]) < 25.)
	    {
            gfillarea(3, mqt);
            ps_fill(3, mqt);
	    }
         }

      else
	 {
	 /*
	 (*func[tr])(lon2, lat2, &glon, &glat);
	 */
         map[ws_act](lon2, lat2, &uu, &vv);
         mqt[1].x = uu;
         mqt[1].y = vv;

         for (lon=lon2; lon<=lonsplitp; lon+=dang)
	    {
             lat = atan((sin((lon-lon1)*dtr)*tan(lat2*dtr)+
  	              sin((lon2-lon)*dtr)*tan(lat1*dtr))/
	              sin((lon2-lon1)*dtr));
             lat = lat * rtd;
	     /*
	     (*func[tr])(lon, lat, &glon, &glat);
	     */
             map[ws_act](lon, lat, &uu, &vv);
             mqt[2].x = uu;
             mqt[2].y = vv;
	     if (max_dist(mqt[0], mqt[1], mqt[2]) < 25.)
	        {
                gfillarea(3, mqt);
	        ps_fill(3, mqt);
	        }
	     mqt[1].x = mqt[2].x;
             mqt[1].y = mqt[2].y;
             }
         lon = lonsplitp;
         lat = atan((sin((lon-lon1)*dtr)*tan(lat2*dtr)+
  	             sin((lon2-lon)*dtr)*tan(lat1*dtr))/
	             sin((lon2-lon1)*dtr));
         lat = lat * rtd;
	 /*
	 (*func[tr])(lon, lat, &glon, &glat);
	 */
         map[ws_act](lon, lat, &uu, &vv);
         mqt[2].x = uu;
         mqt[2].y = vv;
	 if (max_dist(mqt[0], mqt[1], mqt[2]) < 25.)
	    {
            gfillarea(3, mqt);
	    ps_fill(3, mqt);
	    }

         lon = lonsplitm;
         lat = atan((sin((lon-lon1)*dtr)*tan(lat2*dtr)+
  	             sin((lon2-lon)*dtr)*tan(lat1*dtr))/
	             sin((lon2-lon1)*dtr));
         lat = lat * rtd;
	 /*
	 (*func[tr])(lon, lat, &glon, &glat);
	 */
         map[ws_act](lon, lat, &uu, &vv);
         mqt[1].x = uu;
         mqt[1].y = vv;

         for (lon = lonsplitm; lon <= lon1; lon+=dang)
	    {
             lat = atan((sin((lon-lon1)*dtr)*tan(lat2*dtr)+
  	              sin((lon2-lon)*dtr)*tan(lat1*dtr))/
	              sin((lon2-lon1)*dtr));
             lat = lat * rtd;
	     /*
	     (*func[tr])(lon, lat, &glon, &glat);
	     */
             map[ws_act](lon, lat, &uu, &vv);
             mqt[2].x = uu;
             mqt[2].y = vv;
	     if (max_dist(mqt[0], mqt[1], mqt[2]) < 25.)
	        {
                gfillarea(3, mqt);
	        ps_fill(3, mqt);
	        }
	     mqt[1].x = mqt[2].x;
             mqt[1].y = mqt[2].y;
             }
	 /*
	 (*func[tr])(lon1, lat1, &glon, &glat);
	 */
         map[ws_act](lon1, lat1, &uu, &vv);
         mqt[2].x = uu;
         mqt[2].y = vv;
	 if (max_dist(mqt[0], mqt[1], mqt[2]) < 25.)
	    {
            gfillarea(3, mqt);
	    ps_fill(3, mqt);
	    }
	 }
      }
}

static void faspec(lon0, lat0, lon1, lat1, lon2, lat2)

double lon0, lat0, lon1, lat1, lon2, lat2;
{
   double lonedge[4];                           /* four points at edge */
   double latedge[4], midlat, midlatplus;	/* four points at edge */
   double phi1, phi2; 
   double dang;

   if ((xmax[ws_act]-xmin[ws_act]) < (ymax[ws_act]-ymin[ws_act]))
       dang = (xmax[ws_act]-xmin[ws_act])/100.;
   else
       dang = (ymax[ws_act]-ymin[ws_act])/100.;

   if (lon0 >= pcent)
      {
      lonedge[0] = lonedge[1] = lonsplitp;
      lonedge[2] = lonedge[3] = lonsplitm;
      }

   else
      {
      lonedge[0] = lonedge[1] = lonsplitm;
      lonedge[2] = lonedge[3] = lonsplitp;
      }

   if ((fabs(lon1-lon0)>180.) && (fabs(lon2-lon0)>180.))
      {
      phi1 = atan2(cos(lat1*dtr)*sin((lon1-lon0)*dtr), 
		   sin(lat1*dtr)*cos(lat0*dtr)-
		   cos(lat1*dtr)*sin(lat0*dtr)*cos((lon1-lon0)*dtr));

      phi2 = atan2(cos(lat2*dtr)*sin((lon2-lon0)*dtr), 
		   sin(lat2*dtr)*cos(lat0*dtr)-
		   cos(lat2*dtr)*sin(lat0*dtr)*cos((lon2-lon0)*dtr));
      
      latedge[0] = rtd*atan((sin((lonsplitp-lon0)*dtr)+
			    tan(phi1)*sin(lat0*dtr)*cos((lonsplitp-lon0)*dtr))/
			    (tan(phi1)*cos(lat0*dtr)));

      latedge[1] = rtd*atan((sin((lonsplitp-lon0)*dtr)+
			    tan(phi2)*sin(lat0*dtr)*cos((lonsplitp-lon0)*dtr))/
			    (tan(phi2)*cos(lat0*dtr)));

      latedge[2] = latedge[0];
      latedge[3] = latedge[1];

      facurve(lon0, lat0, lonedge[0], latedge[0], lonedge[1], latedge[1]); 

      facurve(lonedge[2], latedge[2], lon1, lat1, lon2, lat2);
      facurve(lon1, lat1, lonedge[2], latedge[2], lonedge[3], latedge[3]); 
      facurve(lon2, lat2, lonedge[2], latedge[2], lonedge[3], latedge[3]); 
      }

   else
      {
      if ((fabs(lon1-lon0) > 180.) && (fabs(lon2-lon0) < 180.))
	 {
	 swap(&lon1, &lon2);
	 swap(&lat1, &lat2);
	 }

      latedge[0] = rtd*atan((sin((lonsplitp-lon1)*dtr)*tan(lat2*dtr)+
			    sin((lon2-lonsplitp)*dtr)*tan(lat1*dtr))/
			    sin((lon2-lon1)*dtr));

      phi2 = atan2(cos(lat2*dtr)*sin((lon2-lon0)*dtr), 
		   sin(lat2*dtr)*cos(lat0*dtr)-
		   cos(lat2*dtr)*sin(lat0*dtr)*cos((lon2-lon0)*dtr));

      latedge[1] = rtd*atan((sin((lonsplitp-lon0)*dtr)+
			    tan(phi2)*sin(lat0*dtr)*cos((lonsplitp-lon0)*dtr))/
			   (tan(phi2)*cos(lat0*dtr)));

      latedge[2] = latedge[0];
      latedge[3] = latedge[1];

      midlat = (latedge[2] + latedge[3])/2.;

      facurve(lon0, lat0, lon1, lat1, lonedge[0], latedge[0]); 
      facurve(lon0, lat0, lonedge[0], latedge[0], lonedge[1], latedge[1]); 

      facurve(lonedge[2], midlat, lonedge[2], latedge[2], lon2, lat2); 
      facurve(lon2, lat2, lonedge[2], midlat, lonedge[3], latedge[3]); 
      midlatplus = midlat + dang;
      facurve(lonedge[2], midlat, lonedge[2], midlatplus, lonedge[2],
	      latedge[2]);
      }
}




static void mputlabel(lon0, lat0, n, str, exp, size, ang)

double lon0, lat0, exp, size, ang;
int    n;
char   *str;
{
   double lon, lat;

   switch(n)
      {
      case 1:
	 lat = lat0 - exp;
	 lon = lon0 + exp/cos(lat*dtr);
	 break;
      case 2:
	 lat = lat0 - exp;
	 lon = lon0;
	 break;
      case 3:
	 lat = lat0 - exp;
	 lon = lon0 - exp/cos(lat*dtr);
	 break;
      case 4:
	 lat = lat0;
	 lon = lon0 + exp/cos(lat*dtr);
	 break;
      case 5:
	 lat = lat0;
	 lon = lon0;
	 break;
      case 6:
	 lat = lat0;
	 lon = lon0 - exp/cos(lat*dtr);
	 break;
      case 7:
	 lat = lat0 + exp;
	 lon = lon0 + exp/cos(lat*dtr);
	 break;
      case 8: 
	 lat = lat0 + exp;
	 lon = lon0;
	 break;
      case 9:
	 lat = lat0 + exp;
	 lon = lon0 - exp/cos(lat*dtr);
	 break;
      default:
	 if (mode == INTERACTIVE)
	    printf("Illegal option with parameter 3\n");
      }

      mlabel(lon, lat, str, size);
}

static void swap(x, y)

double *x, *y;
{
   double temp;

   temp = *x;
   *x   = *y;
   *y   = temp;
}

void mlabel(lon0, lat0, str, ch)
double lon0, lat0, ch;
char *str;
{
   int i, j, k;
   int index, len, nchar, nglyph, strlength, ref;
   int nstroke[200], chlen[200];
   int oldfont, newfont;
   int font_change = FALSE;
   int ix[200][150], iy[200][150];

   double jump;
   double lonlab, latlab, lontmp, lattmp, dlon; 
   double glon0, glat0, glon, glat;
   double utmp, vtmp, u, v, theta, x, y;
   double boxymin, boxymax, tmp;

   char line[132], dum[132], *cptr, *p;

   Gint   n;
   Gpoint pt[200];
   
   dlon = (xmax[ws_act]-xmin[ws_act])/400.;
   oldfont = 'r';
   strlength = 0;
   boxymin = boxymax = 82.;
   p = str;

   if (!load_font_done)
      load_font();

   if (load_font_done)
   {
   nchar = 0;
   while (*p != '\0')
      {
      if (*p == '\\')
	 {
	 p++;
	 if (*p == '\\')
	    {
	    font_change = FALSE;
	    p++;
	    oldfont = (unsigned int)(*p);
	    p++;
	    }
         else
	    {
	    font_change = TRUE;
	    newfont = (unsigned int)(*p);
	    p++;
	    }
         }

      nglyph = (int)(*p);

      if (font_change == TRUE)
	 {
         index = read_char(newfont, nglyph);
	 font_change = FALSE;
	 }
      else
         index = read_char(oldfont, nglyph);

      rewind(fd);

      while(FOREVER)
	 {
	 if (fgets(line, LSIZE, fd) == (char *)NULL)
	    if (mode == INTERACTIVE)
	       printf("Cannot find character #%d\n", index);

         line[strlen(line)-1] = '\0';

         strcpy(dum, line);
         dum[5] = '\0';
         ref = atoi(dum);
         if (ref == index)
	    break;
         }
      
      len = strlen(line);

      strcpy(dum, line);
      cptr = dum + 5;
      dum[8] = '\0';
      nstroke[nchar] = atoi(cptr);

      cptr = line+8;
      k = 0;
      len -= 8;

      for (j=0; j<nstroke[nchar]; ++j)
	  {
          ix[nchar][j] = (unsigned int) *cptr;
          iy[nchar][j] = (unsigned int) *(cptr+1);

	  if (j == 0)
	     {
	     /* leave 3 units bigger than the actual width of the
		character */
	     chlen[nchar] = iy[nchar][j] - ix[nchar][j]; 
	     strlength += chlen[nchar];
	     }
          
          if (nchar==0 && j==1)
	     {
	     boxymin = iy[nchar][j];
	     boxymax = iy[nchar][j];
	     }	  

          if (j >= 1 && (iy[nchar][j] < boxymin)) 
             boxymin= iy[nchar][j];
	  if (j >= 1 && (iy[nchar][j] > boxymax)) 
             boxymax = iy[nchar][j];

          cptr += 2;
	  ++k;

	  if (2*k == len && j < nstroke[nchar]-1)
	     {
	     fgets(line, LSIZE, fd);
	     line[strlen(line)-1] = '\0';

	     k = 0;
	     cptr = line;
	     len = strlen(line);
	     }
          }

      nchar += 1;
      p++;
      }

   tmp = boxymin;   
   boxymin = -boxymax;
   boxymax = -tmp;

   jump   = 0;

   if (labcs_done[ws_act] == FALSE || llabel_done[ws_act]== TRUE)
   {
   if (llabel_done[ws_act]== TRUE)
      {
      u = lon0;
      v = lat0;
      } 

   else if (labcs_done[ws_act] == FALSE)
      {
      tr = AA[csloc[ws_act]][csproj[ws_act]];
      /*
      (*func[tr])(lon0, lat0, &glon,  &glat);
      */
      jcnvc2(sysloc[ws_act],  eqnxloc[ws_act], lon0, lat0,
             sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);
      map[ws_act](glon, glat, &u, &v);
      }

   for (i=0; i<nchar; i++)
       {
       n = 0;
       if (i==0)
	  jump = chlen[i]/2.;
       else
	  jump += (chlen[i-1] + chlen[i])/2.;

       for (j=1;j<nstroke[i];++j)
       {
          if (ix[i][j] == 32)
	     {
	        gpolyline(n, pt);
		f_polyline(n, pt);

	     n = 0;
       	     }
          else
	     {
	     pt[n].x = u+ch/(boxymax-boxymin)*
	       (ix[i][j]-82-strlength/2+jump);
	     pt[n].y = v+ch/(boxymax-boxymin)*(-iy[i][j]+82);
	     ++n;
             }
       }

       if (nstroke[i] > 1)
	  {
	     gpolyline(n, pt);
	     f_polyline(n, pt);
	  }
       }
   }
        
   else
   {
   for (i=0; i<nchar; i++)
       {
       n = 0;
       if (i==0)
	  jump = chlen[i]/2.;
       else
	  jump += (chlen[i-1] + chlen[i])/2.;

       tr = AA[csloc[ws_act]][cslab[ws_act]];
       /*
       (*func[tr])(lon0, lat0, &glon0, &glat0);
       */
       jcnvc2(sysloc[ws_act],  eqnxloc[ws_act], lon0, lat0,
              syslab[ws_act],  eqnxlab[ws_act], &glon0, &glat0, epoch[ws_act]);

       lonlab = glon0 + (strlength/2-jump-chlen[i]/2.)
            	        *ch/(boxymax-boxymin)/cos(glat0*dtr);

       latlab = glat0;
       lontmp = lonlab - dlon;
       lattmp = glat0;

       tr = AA[cslab[ws_act]][csproj[ws_act]];
       /*
       (*func[tr])(lonlab, latlab, &glon,  &glat); 
       */
       jcnvc2(syslab[ws_act],  eqnxlab[ws_act], lonlab, latlab,
              sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);
       map[ws_act](glon, glat, &u, &v);

       /*
       (*func[tr])(lontmp, lattmp, &glon,  &glat); 
       */
       jcnvc2(syslab[ws_act],  eqnxlab[ws_act], lontmp, lattmp,
              sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);
       map[ws_act](glon, glat, &utmp, &vtmp);

       theta = atan2(vtmp-v, utmp-u);

       for (j=1; j<nstroke[i]; ++j)
	   {
	   if (ix[i][j] == 32)
	      {
	         gpolyline(n, pt);
		 f_polyline(n, pt);

	      n = 0;
	      }

           else
	      {
	      x = ch/(boxymax-boxymin)*( ix[i][j]-82);
	      y = ch/(boxymax-boxymin)*(-iy[i][j]+82);
	      pt[n].x = u + (x*cos(theta)-y*sin(theta));
	      pt[n].y = v + (x*sin(theta)+y*cos(theta));
	      ++n;
	      }
           }
       
       if (nstroke[i] > 1)
	  {
	     gpolyline(n, pt);
	     f_polyline(n, pt);
	  }
       }
       }
   }
}

void setcs(mctype, mode, lonc, latc, center1, center2)
char *mctype; 
double lonc, latc, *center1, *center2;
int mode;
{
   double glonc, glatc, uu0, vv0;

   if (lonc > 180.) lonc -= 360.;
   if (lonc <-180.) lonc += 360.;

   switch(cs(mctype))
      {
      case PROJECTION:
	 if (mode == 0)
	    {
	    /*
	    if (cyl_done[ws_act] && lat0r == 0.)
	       lon0r = lonc*dtr;
	    */
	    map[ws_act](lonc, latc, &uu0, &vv0);
	    *center1 = uu0;
	    *center2 = vv0;
	    }
	 else if (mode == 1)
	    {
	    tr = AA[csproj[ws_act]][csgrid[ws_act]];
	    /*
            (*func[tr])(lonc, latc, &glonc, &glatc);
	    */
            jcnvc2(sysproj[ws_act], eqnxproj[ws_act], lonc, latc,
                   sysgrid[ws_act], eqnxgrid[ws_act], &glonc, &glatc, epoch[ws_act]);
	    *center1 = glonc;
	    *center2 = glatc;
	    }
	 break;
      case DATA:
	 if (mode == 0)
	    {
	    tr = AA[csdata[ws_act]][csproj[ws_act]];
	    /*
	    (*func[tr])(lonc, latc, &glonc, &glatc);
	    */
            jcnvc2(sysdata[ws_act], eqnxdata[ws_act], lonc, latc,
                   sysproj[ws_act], eqnxproj[ws_act], &glonc, &glatc, epoch[ws_act]);
	    if (glonc > 180.) glonc -= 360.;
	    if (glonc <-180.) glonc += 360.;
	    if (car_done[ws_act] && lat0r == 0.)
	       lon0r = glonc*dtr;
	    map[ws_act](glonc, glatc, &uu0, &vv0);
	    *center1 = uu0;
	    *center2 = vv0;
	    }
         else if (mode == 1)
	    {
	    tr = AA[csdata[ws_act]][csgrid[ws_act]];
	    /*
	    (*func[tr])(lonc, latc, &glonc, &glatc);
	    */
            jcnvc2(sysdata[ws_act], eqnxdata[ws_act], lonc, latc,
                   sysgrid[ws_act], eqnxgrid[ws_act], &glonc, &glatc, epoch[ws_act]);
	    *center1 = glonc;
	    *center2 = glatc;
	    }
	 break;
      case GRID:
	 if (mode == 0)
	    {
	    tr = AA[csgrid[ws_act]][csproj[ws_act]];
	    /*
	    (*func[tr])(lonc, latc, &glonc, &glatc);
	    */
            jcnvc2(sysgrid[ws_act], eqnxgrid[ws_act], lonc, latc,
                   sysproj[ws_act], eqnxproj[ws_act], &glonc, &glatc, epoch[ws_act]);
	    if (glonc > 180.) glonc -= 360.;
	    if (glonc <-180.) glonc += 360.;
	    if (car_done[ws_act] && lat0r == 0.)
	       lon0r = glonc*dtr;
	    map[ws_act](glonc, glatc, &uu0, &vv0);
	    *center1 = uu0;
	    *center2 = vv0;
	    }
         else if (mode == 1)
	    {
	    *center1 = lonc;
	    *center2 = latc;
	    }
	 break;
      case UV:
	 if (mode == 0)
	    {
	    *center1 = lonc;
	    *center2 = latc;
	    }
	 else if (mode == 1)
	    {
	    if (car_done[ws_act] && lat0r == 0.)
	       lon0r = lonc*dtr;
            map_inv[ws_act](lonc, latc, &glonc, &glatc);
	    tr_inverse = AA[csproj[ws_act]][csgrid[ws_act]];
	    /*
	    (*func[tr_inverse])(glonc, glatc, &lonc, &latc);
	    */
            jcnvc2(sysproj[ws_act], eqnxproj[ws_act], glonc, glatc,
                   sysgrid[ws_act], eqnxgrid[ws_act], &lonc, &latc, epoch[ws_act]);
	    if (lonc >  180.) lonc -= 360.;
	    if (lonc < -180.) lonc += 360.;
	    *center1 = lonc;
	    *center2 = latc;
	    }
	 break;
      default:
	 if (mode == INTERACTIVE)
	    printf("Illegal option with [%s]\n", mctype);
      }
}

double max_dist(p1, p2, p3)
Gpoint p1, p2, p3;
{
   double d1, d2, d3;

   d1 = sqrt((p1.x-p2.x)*(p1.x-p2.x) + (p1.y-p2.y)*(p1.y-p2.y));
   d2 = sqrt((p1.x-p3.x)*(p1.x-p3.x) + (p1.y-p3.y)*(p1.y-p3.y));
   d3 = sqrt((p3.x-p2.x)*(p3.x-p2.x) + (p3.y-p2.y)*(p3.y-p2.y));
   
   if (d2 >= d1)
      d1 = d2; 
   if (d3 >= d1)
      d1 = d3;

   return(d1);
}

static void load_font()
{
   char fname[132];

   if (getenv("AGRAFONT") != NULL)
      fd = fopen(getenv("AGRAFONT"), "r");
   else if (getenv("AGRADIR") != NULL)
      {
      *fname = '\0';
      strcpy(fname, getenv("AGRADIR"));
      strcat(fname, "/font/hershey_oc.dat");
      fd = fopen(fname, "r");
      }
   
   else
      {
      *fname = '\0';
      strcpy(fname, AGRADIR);
      strcat(fname, "/font/hershey_oc.dat");
      fd = fopen(fname, "r");

      if (fd == NULL)
         {
         *fname = '\0';
         strcpy(fname, "../font/hershey_oc.dat");
         fd = fopen(fname, "r");
         }
      if (fd == NULL)
         {
         fd = fopen("hershey_oc.dat", "r");
         }
      }

   if (fd != NULL)
      load_font_done = 1;
   
   else if (mode == INTERACTIVE)
      {
      printf("Font data is not found.\n");
      fflush(stdout);
      }
}
