#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "gks.h"
#include "agra.h" 

extern double dtr, rtd, pi;

static double llon=0., llat=0., lrot=0.;



/*****************************************************************************/
/*                                                                           */
/* LDRAW_SETUP -- Set up the reference location for "local" drawing          */
/*                                                                           */
/*****************************************************************************/

void ldraw_setup(double lon0, double lat0)
{
   if(debug)
   {
      printf("debug> ldraw_setup: lon0   = %-g\n", lon0);
      printf("debug> ldraw_setup: lat0   = %-g\n", lat0);
      printf("\n");
      fflush(stdout);
   }

   while (lon0 >  180.) lon0 -= 360.;
   while (lon0 < -180.) lon0 += 360.;

   llon = lon0 * dtr;
   llat = lat0 * dtr;
}



/*****************************************************************************/
/*                                                                           */
/* LDRAW_ROTATE -- Set up the rotation angle for "local" drawing             */
/*                                                                           */
/*****************************************************************************/

void ldraw_rotate(double rotate)
{
   if(debug)
   {
      printf("debug> ldraw_setup: rotate = %-g\n", rotate);
      printf("\n");
      fflush(stdout);
   }

   lrot = rotate * dtr;
}




/*****************************************************************************/
/*                                                                           */
/* LDRAW_TRANSFORM  -- Convert a relative motion into sky coordinates        */
/*                                                                           */
/*****************************************************************************/

void ldraw_transform(double rlon, double rlat, double *lon, double *lat)
{
   double x, y, z;
   double xrot, yrot, zrot;
   double xlat, ylat, zlat;
   double xlon, ylon, zlon;

   if(debug)
   {
      printf("debug> ldraw_transform: rlon = %-g\n", rlon);
      printf("debug> ldraw_transform: rlat = %-g\n", rlat);
      printf("\n");
      fflush(stdout);
   }

   x = cos(rlon*dtr) * cos(rlat*dtr);
   y = sin(rlon*dtr) * cos(rlat*dtr);
   z = sin(rlat*dtr);

   if(debug)
   {
      printf("debug> ldraw_transform: x = %-g\n", x);
      printf("debug> ldraw_transform: y = %-g\n", y);
      printf("debug> ldraw_transform: z = %-g\n", z);
      printf("\n");
      fflush(stdout);
   }

   xrot =  x;
   yrot =  y * cos(lrot) + z * sin(lrot);
   zrot = -y * sin(lrot) + z * cos(lrot);

   if(debug)
   {
      printf("debug> ldraw_transform: xrot = %-g\n", xrot);
      printf("debug> ldraw_transform: yrot = %-g\n", yrot);
      printf("debug> ldraw_transform: zrot = %-g\n", zrot);
      printf("\n");
      fflush(stdout);
   }

   xlat =  xrot * cos(llat) - zrot * sin(llat);
   ylat =  yrot;
   zlat =  xrot * sin(llat) + zrot * cos(llat);

   if(debug)
   {
      printf("debug> ldraw_transform: xlat = %-g\n", xlat);
      printf("debug> ldraw_transform: ylat = %-g\n", ylat);
      printf("debug> ldraw_transform: zlat = %-g\n", zlat);
      printf("\n");
      fflush(stdout);
   }

   xlon = xlat * cos(llon) - ylat * sin(llon);
   ylon = xlat * sin(llon) + ylat * cos(llon);
   zlon = zlat;

   if(debug)
   {
      printf("debug> ldraw_transform: xlon = %-g\n", xlon);
      printf("debug> ldraw_transform: ylon = %-g\n", ylon);
      printf("debug> ldraw_transform: zlon = %-g\n", zlon);
      printf("\n");
      fflush(stdout);
   }

   *lon = atan2(ylon, xlon) / dtr;
   *lat = asin(zlon) / dtr;

   if(debug)
   {
      printf("debug> ldraw_transform: lon = %-g\n", *lon);
      printf("debug> ldraw_transform: lat = %-g\n", *lat);
      printf("\n");
      fflush(stdout);
   }
}
