#include <stdio.h> 
#include <string.h>
#include <math.h>
#include "gks.h"
#include "agra.h"
#include "wcs.h"
#include "img.h"

extern int ws_act, grid_eq, lcs_done, flipsign;
extern int csproj[], csgrid[], csdata[], cslab[];
extern int ait_done[], car_done[], gno_done[], cyl_done[], 
	   ncp_done[], ort_done[], pla_done[],
	   sysproj[], sysgrid[];

extern int AA[4][4];

extern void E(), eclequ(), eclgal(), eclsgal(), equecl(), equgal(), 
	      equsgal(), galecl(), galequ(), galsgal(), sgalecl(), 
	      sgalequ(), sgalgal();

extern void (*func[])(); 

extern double lon0r, lat0r, rtwist[], eqnxproj[], eqnxgrid[], epoch[];
        
extern double xmin[], xmax[], ymin[], ymax[];

extern double pi, dtr, rtd, gexpand, chh;
extern void (*map[10])(), (*map_inv[10])();

struct img *coef_set;

int    nlab, llabel_done[10];
double boxx[5];
double boxy[5];
double vertx[100], verty[100];
double dx[100], dy[100];
double u0[10], v0[10];

Gint   ws_id;

void draw_grid(old_lonc, old_latc, flag, su, sv, rotate)
double old_lonc, old_latc, su, sv, rotate;
char   *flag;
{
   int i;
   int pole = FALSE, two_pole = FALSE;
   int tr, tr_inverse;
   int h_lab = 0;

   double lonc, latc;
   double lon, lat, lontmp;
   double glon, glat;
   double u, v, u_old, v_old;

   double lonmin, lonmax, latmin, latmax, latsta, latend;
   double dlon, dlat, dangle1, dangle2, dspace1, dspace2;
   double R, distance;
   double lchh;

   double theta;

   static double angle[20] = {0.5/3600.,1./3600.,2./3600.,5./3600,10./3600.,
			      20./3600., 50./3600., 2./60., 5./60., 10./60.,
			      20./60.,50./60.,2.,5.,10.,20.,50.,90.,180.,360.};
		    
   static double dangle[19] = {0.1/3600.,0.2/3600.,0.5/3600.,1./3600.,2./3600.,
			       5./3600.,10./3600.,0.5/60.,1./60.,2./60.,5./60.,
			       10./60., 0.5, 1., 2., 5., 10., 15., 45.};

   double dist();

   Gpoint   pts[2];

   int lright, lleft, ltop, lbottom, gcs_done, cut=0, long_top=1;

   double ulab, vlab, ulab1, vlab1;
   double lonlab, glonlab;

   char   str[40];

   lchh = gexpand * chh;

   pole = FALSE;
   two_pole = FALSE;
   gcs_done = FALSE;

   for (i=0; i<10; i++)
       llabel_done[i] = TRUE;

   tr         = AA[csgrid[ws_act]][csproj[ws_act]];
   tr_inverse = AA[csproj[ws_act]][csgrid[ws_act]];

   /* Calculate center of box */

   setcs(flag, 1, old_lonc, old_latc, &lonc, &latc); 

   if (lonc >  180.) lonc -= 360.;
   if (lonc < -180.) lonc += 360.;

   /* Special treatment for Cartesian projection only when the latitute
      of the projection is 0. */

   /*
   if (car_done[ws_act] && lat0r == 0.)
      lon0r = lonc*dtr;
   */

   /* Calculate the range of grid to be drawn */

   R = sqrt(su/2. * su/2. + sv/2. * sv/2.);

   if (fabs(latc) == 90.)
      {
      lonmax = lonc + 180.;
      lonmin = lonc - 180.;
      pole   = TRUE;
      }
   else
      {
      lonmax = lonc + 1.5 * R/cos(latc*dtr);
      lonmin = lonc - 1.5 * R/cos(latc*dtr);
      }
   
   latmax = latc + R;
   latmin = latc - R;

   if (latmax > 90.)
      latmax =  90.;

   if (latmin < -90.)
      latmin = -90.;

   if (latmax == 90. || latmin == -90.)
      {
      lonmax = lonc + 180.;
      lonmin = lonc - 180.;
      pole = TRUE;
      }

   if (latmax == 90. && latmin == -90.)
      two_pole = TRUE;

   dlon = (lonmax - lonmin);
   if (R > 90.) R = 90.;
   dlat = 2. * R;

   /* Decide the space of grid */

   for (i=0; i<=18; i++)
      if (angle[i] <= dlon && dlon <= angle[i+1])
	 {
         dangle1 = dangle[i];
         break;
	 }

   for (i=0; i<=17; i++) 
      if (angle[i] <= dlat && dlat <= angle[i+1])
	 {
	 dangle2 = dangle[i];
	 break;
	 }
   if (dlon != 360.)
      lonlab = (int)(((lonmax+lonmin)/2.)/dangle1) * dangle1;
   else
      {
      if (lonc/dangle1 - (int)(lonc/dangle1) <= 0.5)
         lonlab=(int)(lonc/dangle1)*dangle1;
      else
         lonlab=((int)(lonc/dangle1)+1)*dangle1;
      }

   dspace1 = dangle1/20.;
   dspace2 = dangle2/20.;

   /* To determine which side draw which labels */

   lat = 0.;
   jcnvc2(sysgrid[ws_act], eqnxgrid[ws_act], lonlab, lat,
	  sysproj[ws_act], eqnxproj[ws_act], &glonlab, &glat, epoch[ws_act]);
   map[ws_act](glonlab, glat, &ulab, &vlab);

   jcnvc2(sysgrid[ws_act], eqnxgrid[ws_act], lonlab+dspace1, lat,
          sysproj[ws_act], eqnxproj[ws_act], &glonlab, &glat, epoch[ws_act]);
   map[ws_act](glonlab, glat, &ulab1, &vlab1); 

   if (fabs((vlab1-vlab)/(ulab1-ulab)) <
       (ymax[ws_act]-ymin[ws_act])/(xmax[ws_act]-xmin[ws_act]))
   {
      long_top = 1;
   }
   else
   {
      long_top = 0;
   }

   /* Set up longitude labels */
   
   nlab = 0;
   for(lon =(int)((lonc-dlon/2.)/dangle1)*dangle1;
       lon<=(int)((lonc+dlon/2.)/dangle1)*dangle1; lon+=dangle1)
   {
      lright  = FALSE;
      lleft   = FALSE;
      ltop    = FALSE;
      lbottom = FALSE;

      if (grid_eq == TRUE)
          mapsex(lon, str, 0);
      else
	  {
          if (lon < 0.) 
	     lontmp = lon + 360.;
	  else if (lon > 360.)
	     lontmp = lon - 360.;
          else
	     lontmp = lon;
          mapsex(lontmp, str, 1);
	  }

      if (pole && (gno_done[ws_act] == TRUE || ort_done[ws_act] == TRUE))
	 {
	 if (latc > 0.)
	    {
	    latmax =  90. - dangle2;
	    if ((int)(lon/90.) * 90. == lon)
	       latmax = 90.;
            }
         else
	    {
	    latmin = -90. + dangle2;
	    if ((int)(lon/90.) * 90. == lon)
	       latmin = -90.;
            }
         }

      for (lat=latmin; lat<=latmax; lat+=dspace2)
	 {
	 h_lab = 0;

	 if (two_pole)
	    lat = 0.;

	 jcnvc2(sysgrid[ws_act], eqnxgrid[ws_act], lon, lat,
		sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);
	 map[ws_act](glon, glat, &u, &v);

	 /*
	 if (car_done[ws_act])
	 {
            if (u < xmin[ws_act]) u += (xmax[ws_act]-xmin[ws_act]);
            if (u > xmax[ws_act]) u -= (xmax[ws_act]-xmin[ws_act]);
	 }
	 */

	 /* the case of two poles */

	 if (two_pole)
	    {
	    dx[nlab] = strlen(str) * lchh;
	    dy[nlab] = lchh;
	    ulab = u;
	    vlab = v;
	    mlabel(u, v, str, lchh);
	    vertx[nlab] = ulab;
	    verty[nlab] = vlab;
	    ++nlab;
	    break;
            }


	if (lat == latmin)
	{
	   u_old = u;
	   v_old = v;
        }

	if (long_top == 0)
	{
         /* right side */

	    ulab = xmax[ws_act] + (strlen(str)+2)*lchh/2.;
	    if ( !lright && ( u == xmax[ws_act] ||  
			      (u-xmax[ws_act])*(u_old-xmax[ws_act]) < 0.))
	       {
	       vlab = v;
	       if ( vlab <= ymax[ws_act] && vlab >= ymin[ws_act])
	          {
	          mlabel(ulab, vlab, str, lchh);
	          h_lab = 1;
	          lright = TRUE;
	          }
	       }

	 /* left side */

	    ulab = xmin[ws_act] - (1+strlen(str))*lchh/2.;
	    if ( !lleft && ( u == xmin[ws_act] || 
			     (u-xmin[ws_act])*(u_old-xmin[ws_act]) < 0.)) 
	       {
	       vlab = v;
	       if (   vlab > ymin[ws_act] && vlab < ymax[ws_act])
		  {
	          mlabel(ulab, vlab, str, lchh);
	          h_lab = 1;
	          lleft = TRUE;
		  }
	       }
	    u_old=u;
	 }

	 if (long_top == 1)
	 {

	 /* top  */

	    vlab = ymax[ws_act]+lchh;
	    if ( !ltop && !h_lab && ( v == ymax[ws_act] ||
				     (v-ymax[ws_act])*(v_old-ymax[ws_act])<0.))
	       {
	       ulab = u;
	       if (   ulab > xmin[ws_act]
		   && ulab < xmax[ws_act])
	          {
	          mlabel(ulab, vlab, str, lchh);
	          ltop = TRUE;
	          }
	       }
         
	 /* bottom */

	    vlab = ymin[ws_act]-lchh;
	    if ( !lbottom && !h_lab &&(v == ymin[ws_act] ||
				      (v-ymin[ws_act])*(v_old-ymin[ws_act])<0.))
	       {
	       ulab = u;
	       if (   ulab > xmin[ws_act]
		   && ulab < xmax[ws_act])
		  {
	          mlabel(ulab, vlab, str, lchh);
	          lbottom = TRUE;
		  }
	       }
	    v_old=v;
	 }
         }
   }


   /* Set up latitude labels */

   latsta = (int)((latc-dlat/2.)/dangle2)*dangle2;
   latend = (int)((latc+dlat/2.)/dangle2)*dangle2;

   if (pole)
   {
      if (   ait_done[ws_act] || cyl_done[ws_act] 
	  || ort_done[ws_act] || ncp_done[ws_act]
	  || pla_done[ws_act] || car_done[ws_act])
         {
	 if (!two_pole)
	    {
	    if (latc>0)      latend =  90. - dangle2;
	    else if (latc<0) latsta = -90. + dangle2;
	    }
	 else
	    {
            latend =  90. - dangle2;
	    latsta = -90. + dangle2;
	    }
	 }
      else if (gno_done[ws_act])
	 {
         if (latc > 0.)
            latend =  90. - dangle2;
         else
            latsta = -90. + dangle2;
         }
   }

   for(lat=latsta; lat<=latend; lat+=dangle2) 
   {
      lright  = FALSE;
      lleft   = FALSE;
      ltop    = FALSE;
      lbottom = FALSE;

      mapsex(lat, str, 1);
      if (two_pole)
      {
	 if (lat != 0.0)
	 {
         lon = 0.;
         jcnvc2(sysgrid[ws_act], eqnxgrid[ws_act],   lon,   lat,
                sysproj[ws_act], eqnxproj[ws_act], &glonlab, &glat, 
                epoch[ws_act]);
         map[ws_act](glonlab, glat, &ulab, &vlab);
	 /*
         if (car_done[ws_act])
	 {
            if (ulab < xmin[ws_act]) ulab += (xmax[ws_act]-xmin[ws_act]);
            if (ulab > xmax[ws_act]) ulab -= (xmax[ws_act]-xmin[ws_act]);
	 }
	 */

	 dx[nlab] = strlen(str) * lchh;
	 dy[nlab] = lchh;
	 mlabel(ulab, vlab, str, lchh);
	 vertx[nlab] = ulab;
	 verty[nlab] = vlab;
	 ++nlab;
	 }
      }

      else
      {
	 for (lon=lonmin; lon<=lonmax; lon += dspace1)
	 {
	 jcnvc2(sysgrid[ws_act], eqnxgrid[ws_act], lon, lat,
		sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);
	 map[ws_act](glon, glat, &u, &v);
	 /*
         if (car_done[ws_act])
	 {
            if (u < xmin[ws_act]) u += (xmax[ws_act]-xmin[ws_act]);
            if (u > xmax[ws_act]) u -= (xmax[ws_act]-xmin[ws_act]);
	 }
	 */

         if (lon==lonmin)
	 {
	    u_old = u;
	    v_old = v;
         }

	 if (long_top == 1)
	 {

         /* right side */

	    ulab = xmax[ws_act] + (strlen(str)+2)*lchh/2.;
	    /*
	    printf("lon=%6.2f,lat=%5.2f,u=%8.4f,v=%8.4f\n",
                    lon, lat, u, v);
	    printf("lat=%-g, vlab=%g, u=%-g, u_old=%-g\n",
		    lat, vlab, u, u_old);
	    */
	    if ( !lright && (u == xmax[ws_act] ||
			    (u-xmax[ws_act])*(u_old-xmax[ws_act]) < 0.))
	       {
	       vlab = v;
	       /*
	       printf("lon=%-g, lat=%-g,vlab=%-g,u=%-g,u_old=%-g,xmax=%-g\n", 
		       lon, lat, vlab, u, u_old, xmax[ws_act]);
	       */
	       if (   vlab < ymax[ws_act] && vlab > ymin[ws_act])
                  {
	          mlabel(ulab, vlab, str, lchh);
	          h_lab = 1;
	          lright = TRUE;
	          }
	       }

	 /* left side */

	    ulab = xmin[ws_act] - (strlen(str)+1)*lchh/2.;
	    if ( !lleft && ( u == xmin[ws_act] || 
			    (u-xmin[ws_act])*(u_old-xmin[ws_act]) < 0.)) 
	       {
	       vlab = v;
	       if (vlab > ymin[ws_act] && vlab < ymax[ws_act])
	          {
	          mlabel(ulab, vlab, str, lchh);
	          h_lab = 1;
	          lleft = TRUE;
		  }
	       }
	    u_old=u;
	 }

	 if (long_top == 0)
	 {
	 /* top  */

	    vlab = ymax[ws_act]+lchh;
	    if ( !ltop && !h_lab && (v == ymax[ws_act] ||
				     (v-ymax[ws_act])*(v_old-ymax[ws_act])<=0.))
	       {
	       ulab = u;
	       if (   ulab > xmin[ws_act]
		   && ulab < xmax[ws_act])
		  {
	          mlabel(ulab, vlab, str, lchh);
	          ltop = TRUE;
		  }
	       }
         
	 /* bottom */

	    vlab = ymin[ws_act]-lchh;
	    if ( !lbottom && !h_lab && (v == ymin[ws_act] ||
				       (v-ymin[ws_act])*(v_old-ymin[ws_act])<0.))
	       {
	       ulab = u;
	       if (   ulab > xmin[ws_act]+lchh && ulab < xmax[ws_act]-lchh)
		  {
	          mlabel(ulab, vlab, str, lchh);
	          lbottom = TRUE;
		  }
	       }
            v_old=v;
	 }
	 }
      }
   }

   llabel_done[ws_act] = FALSE;

   /* Draw the coordinate overlay */

         /* Longitude lines */

   for(lon =(int)((lonc-dlon/2.)/dangle1)*dangle1;
       lon<=(int)((lonc+dlon/2.)/dangle1)*dangle1; lon+=dangle1)
   {
      if (pole)
      {
	 if (   ait_done[ws_act] || cyl_done[ws_act] 
	     || ncp_done[ws_act]
	     || pla_done[ws_act] || car_done[ws_act])
	    {
	    latmin = -90.;
	    latmax =  90.;
	    if (fabs(lon-90.*(int)(lon/90.)) > 0.001)
	       {
	       latmin = -90. + dangle2;
	       latmax =  90. - dangle2;
	       }
	    }

	 else if (gno_done[ws_act] || ort_done[ws_act])
	    {
	    if (latc > 0.)
	       {
	       latmax = 90. - dangle2;
	       if ((int)(lon/90.) * 90. == lon)
	          latmax = 90.;
               }
            else
	       {
	       latmin = -90. + dangle2;
	       if ((int)(lon/90.) * 90. == lon)
	          latmin = -90.;
               }
            }
      }

      lat = latmin; 

      jcnvc2(sysgrid[ws_act], eqnxgrid[ws_act], lon, lat,
             sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);

      map[ws_act](glon, glat, &u, &v);
      /*
      if (car_done[ws_act])
      {
          if (u < xmin[ws_act]) u += (xmax[ws_act]-xmin[ws_act]);
          if (u > xmax[ws_act]) u -= (xmax[ws_act]-xmin[ws_act]);
      }
      */

      pts[0].x = u;
      pts[0].y = v;

      if (!two_pole)
      {
      for(lat=latmin; lat<=latmax; lat+=dspace2)
      {
         jcnvc2(sysgrid[ws_act], eqnxgrid[ws_act], lon, lat,
                sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);

	 map[ws_act](glon, glat, &u, &v);
	 /*
         if (car_done[ws_act])
         {
             if (u < xmin[ws_act]) u += (xmax[ws_act]-xmin[ws_act]);
             if (u > xmax[ws_act]) u -= (xmax[ws_act]-xmin[ws_act]);
         }
	 */

	 pts[1].x = u;
	 pts[1].y = v;
	 if (!pla_done[ws_act])
	    distance = dist(pts[0], pts[1]);   
	 else
	    distance = dist(pts[0], pts[1])*dtr;
	 if(distance < 20.)
	    {
	    if (pts[0].x <= xmax[ws_act] && pts[0].x >= xmin[ws_act] &&
		pts[0].y <= ymax[ws_act] && pts[0].y >= ymin[ws_act] && 
	        pts[1].x <= xmax[ws_act] && pts[1].x >= xmin[ws_act] &&
		pts[1].y <= ymax[ws_act] && pts[1].y >= ymin[ws_act]) 
               {
		   gpolyline(2, pts);
		   f_polyline(2, pts);
	       }
            }

	 pts[0].x = pts[1].x;
	 pts[0].y = pts[1].y;
      }
      }
      else
      {
      for(lat=latmin; lat<=latmax; lat+=dspace2)
      {
         jcnvc2(sysgrid[ws_act], eqnxgrid[ws_act], lon, lat,
                sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);

	 map[ws_act](glon, glat, &u, &v);
	 /*
         if (car_done[ws_act])
         {
             if (u < xmin[ws_act]) u += (xmax[ws_act]-xmin[ws_act]);
             if (u > xmax[ws_act]) u -= (xmax[ws_act]-xmin[ws_act]);
         }
	 */

	 pts[1].x = u;
	 pts[1].y = v;
	 if (!pla_done[ws_act])
	    distance = dist(pts[0], pts[1]);   
	 else
	    distance = dist(pts[0], pts[1])*dtr;
	 if(distance < 20.)
	    {
            for (i=0; i<nlab; i++)
	       {
	       if((fabs(pts[1].x-vertx[i]) < 1.25*dx[i]/2.  &&
		  fabs(pts[1].y-verty[i])  < 1.25*dy[i]/2.) ||
		  (fabs(pts[0].x-vertx[i]) < 1.25*dx[i]/2.  &&
		  fabs(pts[0].y-verty[i])  < 1.25*dy[i]/2.))
		  cut = i;
	       }
            if ((fabs(pts[1].x-vertx[cut]) >= 1.25*dx[cut]/2.  ||
		fabs(pts[1].y-verty[cut])  >= 1.25*dy[cut]/2.) &&
		(fabs(pts[0].x-vertx[cut]) >= 1.25*dx[cut]/2.  ||
		fabs(pts[0].y-verty[cut])  >= 1.25*dy[cut]/2.))
               {
		   gpolyline(2, pts);
		   f_polyline(2, pts);
	       }
            }

	 pts[0].x = pts[1].x;
	 pts[0].y = pts[1].y;
      }
      }

      lat = latmax;

      jcnvc2(sysgrid[ws_act], eqnxgrid[ws_act], lon, lat,
             sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);

      map[ws_act](glon, glat, &u, &v);
      /*
      if (car_done[ws_act])
      {
         if (u < xmin[ws_act]) u += (xmax[ws_act]-xmin[ws_act]);
         if (u > xmax[ws_act]) u -= (xmax[ws_act]-xmin[ws_act]);
      }
      */

      pts[1].x = u;
      pts[1].y = v;
      if (!pla_done[ws_act])
         distance = dist(pts[0], pts[1]);   
      else
         distance = dist(pts[0], pts[1])*dtr;
      if(distance < 20.)
	 {
	    if (pts[0].x <= xmax[ws_act] && pts[0].x >= xmin[ws_act] &&
		pts[0].y <= ymax[ws_act] && pts[0].y >= ymin[ws_act] && 
	        pts[1].x <= xmax[ws_act] && pts[1].x >= xmin[ws_act] &&
		pts[1].y <= ymax[ws_act] && pts[1].y >= ymin[ws_act]) 
            {
                gpolyline(2, pts);
		f_polyline(2, pts);
	    }
         }
   }

   
         /* Latitude lines */

   for(lat=latsta; lat<=latend; lat+=dangle2) 
   {
      lon = lonmin;

      /*
      (*func[tr])(lon, lat, &glon, &glat);
      */
      jcnvc2(sysgrid[ws_act], eqnxgrid[ws_act], lon, lat,
             sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);

      map[ws_act](glon, glat, &u, &v);
      /*
      if (car_done[ws_act])
      {
         if (u < xmin[ws_act]) u += (xmax[ws_act]-xmin[ws_act]);
         if (u > xmax[ws_act]) u -= (xmax[ws_act]-xmin[ws_act]);
      }
      */

      pts[0].x = u;
      pts[0].y = v;

     if (!two_pole)
     {
     for(lon=lonmin; lon<=lonmax; lon+=dspace1)
         {
         jcnvc2(sysgrid[ws_act], eqnxgrid[ws_act], lon, lat,
                sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);

	 map[ws_act](glon, glat, &u, &v);
	 /*
         if (car_done[ws_act])
         {
            if (u < xmin[ws_act]) u += (xmax[ws_act]-xmin[ws_act]);
            if (u > xmax[ws_act]) u -= (xmax[ws_act]-xmin[ws_act]);
         }
	 */

	 pts[1].x = u;
	 pts[1].y = v;
         if (!pla_done[ws_act])
            distance = dist(pts[0], pts[1]);   
         else
            distance = dist(pts[0], pts[1])*dtr;
         if(distance < 20.)
	    {
	    if (pts[0].x <= xmax[ws_act] && pts[0].x >= xmin[ws_act] &&
		pts[0].y <= ymax[ws_act] && pts[0].y >= ymin[ws_act] && 
	        pts[1].x <= xmax[ws_act] && pts[1].x >= xmin[ws_act] &&
		pts[1].y <= ymax[ws_act] && pts[1].y >= ymin[ws_act]) 
	       {
		   gpolyline(2, pts);
		   f_polyline(2, pts);
	       }
            }
	 pts[0].x = pts[1].x;
	 pts[0].y = pts[1].y;
         }
      }
     else
     {
      for(lon=lonmin; lon<=lonmax; lon+=dspace1)
         {
         jcnvc2(sysgrid[ws_act], eqnxgrid[ws_act], lon, lat,
                sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);

	 map[ws_act](glon, glat, &u, &v);
	 /*
         if (car_done[ws_act])
         {
            if (u < xmin[ws_act]) u += (xmax[ws_act]-xmin[ws_act]);
            if (u > xmax[ws_act]) u -= (xmax[ws_act]-xmin[ws_act]);
         }
	 */

	 pts[1].x = u;
	 pts[1].y = v;
         if (!pla_done[ws_act])
            distance = dist(pts[0], pts[1]);   
         else
            distance = dist(pts[0], pts[1])*dtr;
         if(distance < 20.)
	    {
            for (i=0; i<nlab; i++)
	       {
	       if((fabs(pts[1].x-vertx[i]) < 1.25*dx[i]/2.  &&
		  fabs(pts[1].y-verty[i])  < 1.25*dy[i]/2.) ||
		  (fabs(pts[0].x-vertx[i]) < 1.25*dx[i]/2.  &&
		  fabs(pts[0].y-verty[i])  < 1.25*dy[i]/2.))
		  cut = i;
	       }

            if ((fabs(pts[1].x-vertx[cut]) >= 1.25*dx[cut]/2.  ||
		fabs(pts[1].y-verty[cut])  >= 1.25*dy[cut]/2.) &&
		(fabs(pts[0].x-vertx[cut]) >= 1.25*dx[cut]/2.  ||
		fabs(pts[0].y-verty[cut])  >= 1.25*dy[cut]/2.))
	       {
		   gpolyline(2, pts);
		   f_polyline(2, pts);
	       }
            }
	 pts[0].x = pts[1].x;
	 pts[0].y = pts[1].y;
         }
      }
      lon = lonmax;

      jcnvc2(sysgrid[ws_act], eqnxgrid[ws_act], lon, lat,
             sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);

      map[ws_act](glon, glat, &u, &v);
      /*
      if (car_done[ws_act])
      {
         if (u < xmin[ws_act]) u += (xmax[ws_act]-xmin[ws_act]);
         if (u > xmax[ws_act]) u -= (xmax[ws_act]-xmin[ws_act]);
      }
      */

      pts[1].x = u;
      pts[1].y = v;
      if (!pla_done[ws_act])
         distance = dist(pts[0], pts[1]);   
      else
         distance = dist(pts[0], pts[1])*dtr;
      if(distance < 20.)
	 {
	    if (pts[0].x <= xmax[ws_act] && pts[0].x >= xmin[ws_act] &&
		pts[0].y <= ymax[ws_act] && pts[0].y >= ymin[ws_act] && 
	        pts[1].x <= xmax[ws_act] && pts[1].x >= xmin[ws_act] &&
		pts[1].y <= ymax[ws_act] && pts[1].y >= ymin[ws_act]) 
	    {
	        gpolyline(2, pts);
		f_polyline(2, pts);
	    }
         }
   }

   /* If aitoff, draw map outline */

   if (ait_done[ws_act])
      {
      pts[0].x = 2. * sqrt(2.) * rtd;
      pts[0].y = 0.;
      if (!two_pole)
      {
      for (theta = 0.; theta <= 360.; theta += 2.)
         {
         pts[1].x = rtd * 2. * sqrt(2.) * cos(theta * dtr);
         pts[1].y = rtd      * sqrt(2.) * sin(theta * dtr);

	 if (pts[0].x <= xmax[ws_act] && pts[0].x >= xmin[ws_act] &&
	     pts[0].y <= ymax[ws_act] && pts[0].y >= ymin[ws_act] && 
	     pts[1].x <= xmax[ws_act] && pts[1].x >= xmin[ws_act] &&
	     pts[1].y <= ymax[ws_act] && pts[1].y >= ymin[ws_act]) 
	 {
             gpolyline(2, pts);
	     f_polyline(2, pts);
         }

         pts[0].x = pts[1].x;
         pts[0].y = pts[1].y;
         }
      }
      else
      {
      for (theta = 0.; theta <= 360.; theta += 2.)
         {
         pts[1].x = rtd * 2. * sqrt(2.) * cos(theta * dtr);
         pts[1].y = rtd      * sqrt(2.) * sin(theta * dtr);

	 for (i=0; i<nlab; i++)
	    {
	    if ((fabs(pts[1].x-vertx[i]) < 1.05*dx[i]/2.  &&
		fabs(pts[1].y-verty[i])  < 1.05*dy[i]/2.) ||
                (fabs(pts[0].x-vertx[i]) < 1.05*dx[i]/2.  &&
		fabs(pts[0].y-verty[i])  < 1.05*dy[i]/2.))
		cut = i;
	    }
         if ((fabs(pts[1].x-vertx[cut]) >= 1.05*dx[cut]/2.  ||
	     fabs(pts[1].y-verty[cut])  >= 1.05*dy[cut]/2.) &&
	     (fabs(pts[0].x-vertx[cut]) >= 1.05*dx[cut]/2.  ||
	     fabs(pts[0].y-verty[cut])  >= 1.05*dy[cut]/2.))
            {
                gpolyline(2, pts);
		f_polyline(2, pts);
	    }
         pts[0].x = pts[1].x;
         pts[0].y = pts[1].y;
         }
      }
      }
   
}

void aitoff(lon, lat, u, v)

double lon, lat;
double *u, *v;
{
   double lonr, latr, sgn, rho, theta, temp;

   latr = lat * dtr;
   lonr = lon * dtr;

   if (lonr - lon0r >  180.*dtr) lonr -= 2.*180.*dtr;
   if (lonr - lon0r < -180.*dtr) lonr += 2.*180.*dtr;

   sgn = 1.;
   if (latr < 0) sgn = -1.;

   rho = acos(cos(latr) * cos((lonr-lon0r)/2.));

   if (((rho < 0.0001)   && (rho > -0.0001)) ||
       ((rho < 180.0001) && (rho > 179.9999)))
      theta = 0.;
   else
      {
      temp = cos(latr)*sin((lonr-lon0r)/2.)/sin(rho);

      if (temp >  1.) temp =  1.;
      if (temp < -1.) temp = -1.;

      theta = asin(temp);
      }

   *u =     - rtd * 4. * sin(rho/2.) * sin(theta);
   *v = sgn * rtd * 2. * sin(rho/2.) * cos(theta);

   *u = flipsign * *u;
}

void a_inverse(u, v, lon, lat)

double u, v, *lon, *lat;
{
   double xx, yy, temp, lonr, latr;
   double t1, t2;

   /*
   u  = flipsign * u;
   */
   xx = -(u/2.)* dtr;
   yy =  (v/2.)* dtr;

   temp = sqrt(fabs(4.- xx * xx -4.* yy * yy));

   t1 = temp * yy;
   if (t1 >  1.) t1 =  1.;
   if (t1 < -1.) t1 = -1.;
   latr = asin(t1);

   t2 = temp * xx / (2. * cos(latr));
   if (t2 >  1.) t2 =  1.;
   if (t2 < -1.) t2 = -1.;
   lonr = 2. * asin(t2);

   *lon = (lon0r + lonr) * rtd;
   *lat = latr * rtd;
}

void cartesian(lon, lat, u, v)
double lon, lat, *u, *v;
{
   int j;
   char   pcode[4];
   double theta, phi, line, samp, x, y; 

   struct celprm cel;

   struct prjprm prj;

   if (lon > 180. ) 
   {
      lon -= 360.;
   }
   if (lon < -180.) 
   {
      lon += 360.;
   }

   strcpy(pcode, "CAR");
   prj.flag = 0;
   prj.r0 = rtd;
   for (j = 0; j < 10; prj.p[j++] = 0.0);

   cel.ref[0] = lon0r * rtd;
   cel.ref[1] = lat0r * rtd;
   cel.ref[2] = 999.0;                     /* new FITS keyword LONGPOLE */
   cel.ref[3] = 999.0;                     /* new FITS keyword LATPOLE  */
   cel.flag   = 0;

   celfwd(pcode, lon, lat, &cel, &phi, &theta, &prj, &x, &y);


   samp = -x; 
   line = y;

   *u =  samp * cos(rtwist[ws_act]) + line * sin(rtwist[ws_act]);
   *v = -samp * sin(rtwist[ws_act]) + line * cos(rtwist[ws_act]);

   *u = flipsign * *u;

}

void ca_inverse(u, v, lon, lat)
double u, v, *lon, *lat;
{
   int j;
   char pcode[4];
   double x, y, phi, theta;
   struct celprm cel;

   struct prjprm prj;

   strcpy(pcode, "CAR");

   prj.flag = 0;
   prj.r0 = rtd;
   for (j = 0; j < 10; prj.p[j++] = 0.0);

   cel.ref[0] = lon0r * rtd;
   cel.ref[1] = lat0r * rtd;
   cel.ref[2] = 999.0;                     /* new FITS keyword LONGPOLE */
   cel.ref[3] = 999.0;                     /* new FITS keyword LATPOLE  */
   cel.flag   = 0;

   /*
   u = flipsign * u;
   */
   x =  - (u * cos(rtwist[ws_act]) - v * sin(rtwist[ws_act]));
   y =    (u * sin(rtwist[ws_act]) + v * cos(rtwist[ws_act]));

   /* smm: changed &lon, &lat to lon, lat */
   celrev(pcode, x, y, &prj, &phi, &theta, &cel, lon, lat);

}

void cylindrical(lon, lat, u, v)
double lon, lat;
double *u, *v;
{
   double line, samp;
   
   samp = - (lon - lon0r*rtd);
   line =   (lat - lat0r*rtd);

   *u =  samp * cos(rtwist[ws_act]) + line * sin(rtwist[ws_act]);
   *v = -samp * sin(rtwist[ws_act]) + line * cos(rtwist[ws_act]);

   *u = flipsign * *u;
}

void cy_inverse(u, v, lon, lat)

double u, v, *lon, *lat;
{
   double lonr, latr;

   /*
   u = flipsign * u;
   */

   lonr = (u*cos(rtwist[ws_act]) - v*sin(rtwist[ws_act])) + lon0r;
   latr = (u*sin(rtwist[ws_act]) + v*cos(rtwist[ws_act])) + lat0r;

   *lon = lonr * rtd;
   *lat = latr * rtd;

   if (*lat >   90.) *lat  =  90.;
   if (*lat <  -90.) *lat  = -90.;
}

void gnomonic(lon, lat, u, v)
double lon, lat;
double *u, *v;
{
   double lonr, latr;
   double aa, f, samp, line;

   lonr = lon * dtr;
   latr = lat * dtr;
   
   aa   =                   cos(latr) * cos(lonr - lon0r);
   f    =  1./(sin(lat0r) * sin(latr) + aa * cos(lat0r));
   samp =             - f * cos(latr) * sin(lonr - lon0r);
   line = f * (cos(lat0r) * sin(latr) - aa * sin(lat0r));

   *u   =   rtd * ( samp * cos(rtwist[ws_act]) + line * sin(rtwist[ws_act]));
   *v   =   rtd * (-samp * sin(rtwist[ws_act]) + line * cos(rtwist[ws_act]));
   
   *u = flipsign * *u;
}

void g_inverse(u, v, lon, lat)
double u, v, *lon, *lat;
{
   double lonr, latr;
   double a, b, x, y, xx, yy;

   /*
   u = flipsign * u;
   */

   x = dtr * (u * cos(rtwist[ws_act]) - v * sin(rtwist[ws_act]));
   y = dtr * (u * sin(rtwist[ws_act]) + v * cos(rtwist[ws_act]));

   if (x == 0. && y == 0.)
      y = 1.0;

   a = atan(sqrt(pow(x, 2.) + pow(y, 2.)));
   b = atan2(-x, -y);

   xx = sin(lat0r) * sin(a) * cos(b) + cos(lat0r) * cos(a);
   yy = sin(a) * sin(b);

   if (xx == 0. && yy == 0.)
      xx = 1.0;

   lonr = lon0r + atan2(yy, xx);
   latr = asin(sin(lat0r) * cos(a) - cos(lat0r) * sin(a) * cos(b));

   *lon = lonr * rtd;
   *lat = latr * rtd;
}

void ncp(lon, lat, u, v)
double lon, lat, *u, *v;
{
   double lonr, latr;
   double samp, line;
   
   lonr = lon * dtr;
   latr = lat * dtr;

   samp =  cos(latr) * sin(lonr - lon0r);
   line = (cos(lat0r) - cos(latr) * cos(lonr - lon0r)) / sin(lat0r);

   *u = - rtd * ( samp * cos(rtwist[ws_act]) + line * sin(rtwist[ws_act]));
   *v =   rtd * (-samp * sin(rtwist[ws_act]) + line * cos(rtwist[ws_act]));

   *u = flipsign * *u;
}

void nc_inverse(u, v, lon, lat)
double u, v, *lon, *lat;
{
   double sign = 1.;
   double lonr, latr;
   double x, y, a;

   /*
   u = flipsign * u;
   */

   x = dtr * (u * cos(rtwist[ws_act]) - v * sin(rtwist[ws_act]));
   y = dtr * (u * sin(rtwist[ws_act]) + v * cos(rtwist[ws_act]));

   x=-x;
   a = cos(lat0r) - y * sin(lat0r);

   lonr = lon0r + atan2(x, a);

   if (lat0r < 0)
      sign = -sign;
   latr = sign * acos(a/cos(lonr-lon0r));

   *lon = lonr * rtd;
   *lat = latr * rtd;
}

void plate(lon, lat, u, v)
double lon, lat, *u, *v;
{
   double samp, line, lonr, latr;

   lonr = lon * dtr;
   latr = lat * dtr;

   amdinv(coef_set, lonr, latr, 0.0, 0.0, &samp, &line);

   *u = samp;
   *v = line;

   *u = flipsign * *u;

}

void pl_inverse(u, v, lon, lat)
double u, v, *lon, *lat;
{
   double lontmp, lattmp;

   /*
   u = flipsign * u;
   */
   platepos(u, v, coef_set, &lontmp, &lattmp);

   *lon = lontmp;
   *lat = lattmp;
}

void orthographic(lon, lat, u, v)
double lon, lat, *u, *v;
{
   double lonr, latr;
   double samp, line;
   
   lonr = lon * dtr;
   latr = lat * dtr;

   samp = -cos(latr) * sin(lonr - lon0r);
   line =  sin(latr) * cos(lat0r) - cos(latr) * sin(lat0r) * cos(lonr - lon0r);

   *u = rtd * ( samp * cos(rtwist[ws_act]) + line * sin(rtwist[ws_act]));
   *v = rtd * (-samp * sin(rtwist[ws_act]) + line * cos(rtwist[ws_act]));

   *u = flipsign * *u;

}

void or_inverse(u, v, lon, lat)
double u, v, *lon, *lat;
{
   double lonr, latr;
   double x, y, a;

   /*
   u = flipsign * u;
   */

   x = dtr * (u * cos(rtwist[ws_act]) - v * sin(rtwist[ws_act]));
   y = dtr * (u * sin(rtwist[ws_act]) + v * cos(rtwist[ws_act]));

   x=-x;

   if ((1.-x*x-y*y) < 0.)
   {
      printf("undefined location.\n");
      return;
   }

   a = sqrt(1.-x*x-y*y);

   lonr = lon0r + atan2(x, cos(lat0r) * a - y * sin(lat0r));
   latr = asin(y * cos(lat0r) + sin(lat0r) * a);

   *lon = lonr * rtd;
   *lat = latr * rtd;
}

double dist(a, b)
Gpoint a;
Gpoint b;
{
   return(sqrt((a.x-b.x)*(a.x-b.x) + (a.y-b.y)*(a.y-b.y)));
}

#ifdef NOTDEF
static int too_near(x0, y0, x1, y1)
double x0, y0, x1, y1;
{
   double d;

   if ((xmax[ws_act]-xmin[ws_act]) <= (ymax[ws_act]-ymin[ws_act]))
      d = (xmax[ws_act]-xmin[ws_act]);
   else 
      d = (ymax[ws_act]-ymin[ws_act]); 

   if ( sqrt((x0-x1)*(x0-x1)+(y0-y1)*(y0-y1)) <= 0.03*d )
      return(0);

   else 
      return(1);

}
#endif /* NOTDEF */
