#include <stdio.h>
#include <string.h>
#include <math.h>
#include "gks.h"
#include "agra.h"

/*
extern double xmin[], xmax[], ymin[], ymax[];
*/
extern double Xmin[], Ymax[], Ymin[], Ymax[];

extern int setup[], ws_act;

Glimit    Wind[10];
Glimit    Viewport[10];
Glimit    WsWindow[10];
Glimit    WsViewport[10];

void gks_setup(wsid)
Gint wsid;
{
   Gchar    *ws_type;
 
   Gstrlist  wstypes;
   Gdspsize  dspsz;

   Gint      nt       = 1;

   double    ratio, rx, ry;

   Wind[ws_act].xmin = Xmin[ws_act];
   Wind[ws_act].xmax = Xmax[ws_act];
   Wind[ws_act].ymin = Ymin[ws_act];
   Wind[ws_act].ymax = Ymax[ws_act];

   ratio = (Wind[ws_act].xmax-Wind[ws_act].xmin)/
	   (Wind[ws_act].ymax-Wind[ws_act].ymin);
     
   Viewport[ws_act].xmin = 0.;
   Viewport[ws_act].ymin = 0.;
   Viewport[ws_act].xmax = 1.;
   Viewport[ws_act].ymax = 1.;

   WsWindow[ws_act].xmin = 0.0;
   WsWindow[ws_act].ymin = 0.0;
   WsWindow[ws_act].xmax = 1.0;
   WsWindow[ws_act].ymax = 1.0;

   if (ratio <= 1.)
      {
      Viewport[ws_act].xmax = ratio;
      WsWindow[ws_act].xmax = ratio;
      }
          
   else
      {
      ratio = 1./ratio;
      Viewport[ws_act].ymax = ratio;
      WsWindow[ws_act].ymax = ratio;
      }

   gsetwindow  (nt, &Wind[ws_act]  ); 
   gsetviewport(nt, &Viewport[ws_act]);
   /*
   gselntran(nt);
   gsetviewportinputpri(nt, refnt, priority);
   */

   /*
   ginqavailwstypes(&wstypes);
   ws_type = wstypes.strings[3];
   */
   ginqdisplayspacesize(ws_type, &dspsz);

   rx = dspsz.device.x;
   ry = dspsz.device.y;

   WsViewport[ws_act].xmin = (0.01*rx)/2.;
   WsViewport[ws_act].xmax = WsViewport[ws_act].xmin + 0.99*rx;
   WsViewport[ws_act].ymin = (0.01*ry)/2.;
   WsViewport[ws_act].ymax = WsViewport[ws_act].ymin + 0.99*ry;

   gsetwswindow  (wsid, &WsWindow[ws_act]  );
   gsetwsviewport(wsid, &WsViewport[ws_act]);
   set_colors(wsid);
   setup[ws_act] = TRUE;
}

void set_colors(wsid)
Gint wsid;

{
   Gcobundl colorrep;
   int i, red, green, blue;

   for(i=0; i<8; ++i)
   {
      if(i==BLACK)
      {
	 red   =   0;
	 green =   0;
	 blue  =   0;
      }

      if(i==WHITE)
      {
	 red   = 255;
	 green = 255;
	 blue  = 255;
      }

      if(i==RED)
      {
	 red   = 255;
	 green =   0;
	 blue  =   0;
      }

      if(i==GREEN)
      {
	 red   =   0;
	 green = 255;
	 blue  =   0;
      }

      if(i==YELLOW)
      {
	 red   = 255;
	 green = 255;
	 blue  =   0;
      }

      if(i==BLUE)
      {
	 red   =   0;
	 green =   0;
	 blue  = 255;
      }

      if(i==MAGENTA)
      {
	 red   = 255;
	 green =   0;
	 blue  = 255;
      }

      if(i==CYAN)
      {
	 red   =   0;
	 green = 255;
	 blue  = 255;
      }

      colorrep.red   = (Gfloat) red   / 255.;
      colorrep.green = (Gfloat) green / 255.;
      colorrep.blue  = (Gfloat) blue  / 255.;

      gsetcolourrep(wsid, (Gint)i, &colorrep);
   }
}

void gks_border(x1, x2, y1, y2)

double x1, x2, y1, y2;
{
   Gpoint pts[5];

   pts[0].x = x1;
   pts[0].y = y1;
   pts[1].x = x2;
   pts[1].y = y1;
   pts[2].x = x2;
   pts[2].y = y2;
   pts[3].x = x1;
   pts[3].y = y2;
   pts[4].x = x1;
   pts[4].y = y1;

   gpolyline(5, pts);
   f_polyline(5, pts);
}

void gks_cursor(u, v)
double *u, *v;
{
   Gint     ws_id = 1;
   Gchar    *ws_type;
   Gstrlist wstypes;
   Gdspsize dspsz;

   Gloc     init;
   Glimit   earea;
   Gqloc    response;
   
   double   rx, ry;

   /*
   ginqavailwstypes(&wstypes);
   ws_type  =  wstypes.strings[3];
   */

   ginqdisplayspacesize(ws_type, &dspsz); 

   rx = dspsz.device.x;
   ry = dspsz.device.y;

   earea.xmin = 0.0;
   earea.xmax = rx;
   earea.ymin = 0.0;
   earea.ymax = ry;

   init.transform  = 1;
   init.position.x = Xmin[ws_act];
   init.position.y = Ymin[ws_act];
   
   ginitloc   (ws_id, 1, 1, &earea);
   gsetlocmode(ws_id, 1, GREQUEST, GECHO);

   greqloc(ws_id, 1, &response);
   *u = response.loc.position.x;
   *v = response.loc.position.y;
}
