#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <errno.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include "gks.h"
#include "agra.h"

#define POLY_MAXP 1024

extern int ws_act, button, windowID[], border[], use_x;
extern double xmin[], xmax[], ymin[], ymax[];

double  a[10], a1[10], a2[10], b[10], b1[10], c[10], c1[10], e[10];
double  wn[10][4];
double  wswn[11][4];

Glimit  cur_area[10];

Colormap      default_cmap;
Display	      *display;
Window        window[10];
Atom          wm_delete_window;
unsigned long gcvaluemask = 0;
GC            gc;
XGCValues     gcvalue;

int      screen_num;

int      gksopen_flag;
int      wsstate_flag[11];

int      ws_number = 0;

static int    ws_integers[10] = {21, 22, 23, 24, 25, 26, 27, 28, 29, 30};
unsigned long line_color = 1;
unsigned long area_color = 1;
unsigned long table[256];

char    *progname;
char     msg[1024];

void gescsetprogname(s)
char *s;
{
   progname = s;
}

void gopenws(wsid, conn, ws_type)
Gint   wsid;
Gchar *conn;
Gchar *ws_type;
{
   int c;
   unsigned int border_width;
   unsigned int depth;
   unsigned int background;
   unsigned int valuemask;
   unsigned int class;

   char         *v[1];
   char         *window_name, *icon_name;

   Colormap     default_cmap;
   XColor       color0, color1;
   XSizeHints   hints;
   Pixmap       icon_pixmap = None;
   Visual       *visual;
   XSetWindowAttributes attributes;

   if(!use_x)
      return;

   c=1;
   v[0] = progname;

   default_cmap = DefaultColormap(display, screen_num);

   XAllocNamedColor(display, default_cmap, "black", &color1, &color0);
   background = color1.pixel;

   depth  = DefaultDepth(display, screen_num);
   class  = InputOutput;
   visual = DefaultVisual(display, screen_num);
   valuemask = CWBackPixel | CWBitGravity | CWBackingStore;
   attributes.background_pixel = background;
   attributes.bit_gravity   = NorthWestGravity;
   attributes.backing_store = Always;

   window_name = v[0];
   icon_name = v[0];

   hints.flags  = PPosition | PSize;
   hints.x      = 0;
   hints.y      = 0;
   hints.width  = 500;
   hints.height = 400;

   window[wsid-1] = XCreateWindow(display, RootWindow(display, screen_num),
               0, 0, 500, 400, border_width, depth, class, visual, 
   	       valuemask, &attributes);

   XSetStandardProperties(display, window[wsid-1], window_name, icon_name,
			  icon_pixmap, v, c, &hints);

   XSelectInput(display, window[wsid-1], KeyPressMask | ButtonPressMask |
		ButtonReleaseMask | StructureNotifyMask);

   XMapWindow(display, window[wsid-1]);
   XSetWMProtocols (display, window[wsid-1], &wm_delete_window, 1);

   gc = XCreateGC(display, window[wsid-1], gcvaluemask, &gcvalue);
   XSetForeground(display, gc, line_color);

   windowID[wsid-1] = window[wsid-1];

   ws_integers[ws_number] = wsid;
   ws_number++;
}

void gclosews(wsid)
Gint wsid;
{
   int i, stop;

   if(!use_x)
      return;

   XDestroyWindow(display, window[wsid -1]);
   for(i=0;i<ws_number;i++)
      {
      if (ws_integers[i] == wsid)
	 {
	 stop = i;
	 break;
	 }
      }

   for (i=stop;i<ws_number-1;i++)
      ws_integers[i] = ws_integers[i+1];

   ws_number--;
}

void gactivatews(wsid)
Gint wsid;
{
   if(!use_x)
      return;

   wsstate_flag[wsid] = GACTIVE; 
}

void gdeactivatews(wsid)
Gint wsid;
{
   if(!use_x)
      return;

   wsstate_flag[wsid] = GINACTIVE;
}

void gclearws(wsid, wsnumber)
Gint wsid, wsnumber;
{
   if(!use_x)
      return;

   XClearWindow(display, window[wsid-1]);
}

void ginqwsst(wsid, state)
Gint     wsid;
Gwsstate *state;
{
   if(!use_x)
      return;

   *state = wsstate_flag[wsid];
}

void ginqopenws(ws_ids)
Gintlist *ws_ids;
{
   int i;

   if(!use_x)
      return;

   ws_ids->integers = ws_integers;
   ws_ids->number   = ws_number; 

   for (i=0; i<=ws_ids->number; i++)
      ws_ids->integers[i] = ws_integers[i];
}

void ginitloc(wsid, dev, pet, area)
Gint wsid, dev, pet;
Glimit *area;
{
   if(!use_x)
      return;

   cur_area[ws_act].xmin = area->xmin;
   cur_area[ws_act].xmax = area->xmax;
   cur_area[ws_act].ymin = area->ymin;
   cur_area[ws_act].ymax = area->ymax;
}

void greqloc(wsid, dev, response)
Gint wsid, dev;
Gqloc *response;
{
   Window       root, child;
   int          root_x, root_y;
   int          win_x, win_y;
   unsigned int keys_buttons;
   Gpoint       p1, p2;
   
   if(!use_x)
      return;

   XQueryPointer(display, window[ws_act], &root, &child, &root_x, &root_y,
		 &win_x, &win_y, &keys_buttons);

   p1.x = (double) win_x;
   p1.y = (double) win_y;

   down_up(p1, &p2);
   wsvp_wswn(p2, &p1);
   if (   p1.x <= wswn[ws_act+1][1] && p1.x >= wswn[ws_act+1][0]
       && p1.y <= wswn[ws_act+1][3] && p1.y >= wswn[ws_act+1][2]) 
      {
      vp_wn(p1, &p2);

      response->loc.position.x = p2.x;
      response->loc.position.y = p2.y;
      }

   else 
      {
      response->loc.position.x = xmin[ws_act]-100;
      response->loc.position.y = ymin[ws_act]-100;
      }

   button = keys_buttons;
}

void gsetlinecolourind(idx)
Gint idx;
{
   if(!use_x)
      return;

   line_color = table[idx];
   XSetForeground(display, gc, line_color);
   XFlush(display);
}

void gsetcolourrep(wsid, idx, rep)
Gint      wsid;
Gint      idx;
Gcobundl *rep;
{
   Colormap cmap;
   XColor   colorcell_def;

   if(!use_x)
      return;

   cmap = DefaultColormap(display, screen_num);

   colorcell_def.red   = (int) (rep->red   * 65535.);
   colorcell_def.green = (int) (rep->green * 65535.);
   colorcell_def.blue  = (int) (rep->blue  * 65535.);

   XAllocColor(display, cmap, &colorcell_def);  
   table[idx] = colorcell_def.pixel;
}

void gsetfillcolourind(idx)
Gint idx;
{
   if(!use_x)
      return;

   area_color = table[idx];
   XSetForeground(display, gc, area_color);
   XFlush(display);
}

void ginqdisplayspacesize(ws_type, dspsz)
Gchar     *ws_type;
Gdspsize  *dspsz;
{
   Window root;
   int x, y;
   unsigned int width, height;
   unsigned int border_width;
   unsigned int depth;

   if(!use_x)
      return;

   XGetGeometry(display, window[ws_act], &root, &x, &y,
		&width, &height, &border_width, &depth);
   dspsz->device.x = (double) width; 
   dspsz->device.y = (double) height; 
}

void gsetwindow(tran, Win)
Gint   tran;
Glimit *Win;
{
   if(!use_x)
      return;

   wn[tran][0] = Win->xmin;
   wn[tran][1] = Win->xmax;
   wn[tran][2] = Win->ymin;
   wn[tran][3] = Win->ymax;
}

void gsetviewport(tran, Viewport)
Gint    tran;
Glimit  *Viewport;
{
   if(!use_x)
      return;

   a1[ws_act] = (Viewport->xmax - Viewport->xmin) / (wn[tran][1] - wn[tran][0]);  
   a2[ws_act] = (Viewport->ymax - Viewport->ymin) / (wn[tran][3] - wn[tran][2]);

   b[ws_act]  = (Viewport->xmin * wn[tran][1] - Viewport->xmax * wn[tran][0])
               /(wn[tran][1] - wn[tran][0]);

   c[ws_act]  = (Viewport->ymin * wn[tran][3] - Viewport->ymax * wn[tran][2])
               /(wn[tran][3] - wn[tran][2]);
}

void gsetwswindow(wsid, WsWindow)
Gint    wsid;
Glimit  *WsWindow;
{
   if(!use_x)
      return;

   wswn[wsid][0] = WsWindow->xmin;
   wswn[wsid][1] = WsWindow->xmax;
   wswn[wsid][2] = WsWindow->ymin;
   wswn[wsid][3] = WsWindow->ymax;
}

void gsetwsviewport(wsid, WsViewport)
Gint    wsid;
Glimit  *WsViewport;
{
   double ws_ratio, dp_ratio;

   if(!use_x)
      return;

   ws_ratio = (wswn[wsid][1] - wswn[wsid][0])
	     /(wswn[wsid][3] - wswn[wsid][2]);
   
   dp_ratio = (WsViewport->xmax - WsViewport->xmin) / 
	      (WsViewport->ymax - WsViewport->ymin);

   if (dp_ratio > ws_ratio)
      {
      a[ws_act] = (WsViewport->ymax - WsViewport->ymin) / 
	          (wswn[wsid][3] - wswn[wsid][2]);  
      WsViewport->xmax=WsViewport->xmin+a[ws_act]*(wswn[wsid][1]-wswn[wsid][0]);
      }
   else
      {
      a[ws_act] = (WsViewport->xmax - WsViewport->xmin) / 
	          (wswn[wsid][1] - wswn[wsid][0]); 
      WsViewport->ymax=WsViewport->ymin+a[ws_act]*(wswn[wsid][3]-wswn[wsid][2]);
      }
   
   b1[ws_act]=(WsViewport->xmin*wswn[wsid][1] - WsViewport->xmax*wswn[wsid][0])
	     /(wswn[wsid][1] - wswn[wsid][0]);

   c1[ws_act]=(WsViewport->ymin*wswn[wsid][3] - WsViewport->ymax*wswn[wsid][2])
	     /(wswn[wsid][3] - wswn[wsid][2]);

   e[ws_act] = WsViewport->ymax + WsViewport->ymin;
}

void gpolyline(ns, pt)
Gint ns;
Gpoint *pt;
{
   XPoint        *point;
   int           i, m, maxpts;
   Gpoint        pt1, pt2;

   if(!use_x)
      return;

   maxpts = POLY_MAXP;
   point = (XPoint *)malloc((unsigned)(maxpts * sizeof(XPoint)));

   m = 0;
   for (i=0; i<ns; i++)
      {
      wn_vp(pt[i], &pt1); 
      if (   pt1.x <= wswn[ws_act+1][1] && pt1.x >= wswn[ws_act+1][0]
	  && pt1.y <= wswn[ws_act+1][3] && pt1.y >= wswn[ws_act+1][2]) 
	  {
          wswn_wsvp(pt1, &pt2);
	  up_down(pt2, &pt1);
          point[m].x = (int) pt1.x;
          point[m].y = (int) pt1.y;
	  m++;

	  if (m==maxpts)
	     {
	     maxpts += POLY_MAXP;
	     point = (XPoint *)realloc((char *)point, 
		     (unsigned int) (maxpts*sizeof(XPoint)));
	     }
	  }
      }

   XDrawLines(display, window[ws_act], gc, point, m, CoordModeOrigin); 
   XFree(point);
}

void gfillarea(ns, pt)
Gint ns;
Gpoint *pt;
{
   XPoint        point[200];

   int           i, m;
   Gpoint        pt1, pt2;

   if(!use_x)
      return;

   m = 0;
   for (i=0; i<ns; i++)
      {
      wn_vp(pt[i], &pt1); 
      if (   pt1.x <= wswn[ws_act+1][1] && pt1.x >= wswn[ws_act+1][0]
	  && pt1.y <= wswn[ws_act+1][3] && pt1.y >= wswn[ws_act+1][2]) 
	  {
          wswn_wsvp(pt1, &pt2);
	  up_down(pt2, &pt1);
          point[m].x = (int) pt1.x;
          point[m].y = (int) pt1.y;
	  m++;
	  }
      }

   XFillPolygon(display, window[ws_act], gc, point, m, Convex, CoordModeOrigin);
}

void wn_vp(p, p_new)
Gpoint p, *p_new;
{
   if(!use_x)
      return;

   p_new->x = a1[ws_act]*p.x + b[ws_act];
   p_new->y = a2[ws_act]*p.y + c[ws_act];
   /*
   if (border[ws_act])
      {
      if (p_new->x < 0.005)
	 p_new->x = wswn[ws_act+1][1];
      else
         p_new->x = wswn[ws_act+1][2];

      if (p_new->y < 0.005)
	 p_new->y = wswn[ws_act+1][3];
      else
         p_new->y = wswn[ws_act+1][4];
      }
   */
}

void vp_wn(p, p_new)
Gpoint p, *p_new;
{
   if(!use_x)
      return;

   p_new->x = (p.x - b[ws_act]) / a1[ws_act];
   p_new->y = (p.y - c[ws_act]) / a2[ws_act];
}

void wswn_wsvp(p, p_new)
Gpoint p, *p_new;
{
   if(!use_x)
      return;

   p_new->x = a[ws_act]*p.x + b1[ws_act];
   p_new->y = a[ws_act]*p.y + c1[ws_act];
}

void wsvp_wswn(p, p_new)
Gpoint p, *p_new;
{
   if(!use_x)
      return;

   p_new->x = (p.x - b1[ws_act]) / a[ws_act];
   p_new->y = (p.y - c1[ws_act]) / a[ws_act];
}

void up_down(p, p_new)
Gpoint p, *p_new;
{
   if(!use_x)
      return;

   p_new->x = p.x;
   p_new->y = -p.y + e[ws_act];
}

void down_up(p, p_new)
Gpoint p, *p_new;
{
   if(!use_x)
      return;

   p_new->x = p.x;
   p_new->y = -p.y + e[ws_act];
}


/* The following routines are trivial */ 

void gopengks(err_file, memory)
Gfile *err_file;
Glong memory;
{
   int   i;
   char  *display_name = NULL;

   if(!use_x)
      return;

   display = XOpenDisplay(display_name);
   if (!display)
   {
      sprintf(msg, "Cannot connect to X server %s\n",
	     XDisplayName(display_name));
      svcreturn(RETURN, ERROR, msg, SCALAR);
      exit(1);
   }

   wm_delete_window = XInternAtom (display, "WM_DELETE_WINDOW", False);
   screen_num = DefaultScreen(display);
   gksopen_flag = GGKOP;
   for (i=0;i<=10;i++)
      wsstate_flag[i] = GINACTIVE;
}

void gclosegks()
{
   if(!use_x)
      return;

   gksopen_flag = GGKCL;
}

void ginqavailwstypes(wstypes)
Gstrlist *wstypes;
{
   if(!use_x)
      return;

}

void ginqopst(state)
Gos *state;
{
   if(!use_x)
      return;

   *state = gksopen_flag;  
}

void gupdatews()
{
   if(!use_x)
      return;

}

void gselntran()
{
   if(!use_x)
      return;

}

void gsetlocmode(wsid, dev, mode, echo)
Gint wsid, dev;
Gimode mode;
Gesw echo;
{
   if(!use_x)
      return;

}

void gsetviewportinputpri()
{
   if(!use_x)
      return;

}

void set_cursor(s)
unsigned int s;
{
   Cursor cs;

   if(!use_x)
      return;

   cs = XCreateFontCursor(display, s);
   XDefineCursor(display, window[ws_act], cs);
}
