
/* Subset of the GKS data types need for AGRA drawing */

typedef char           Gchar;
typedef int            Gint;
typedef int            Glong;

typedef struct Gintlist 
{
   Gint number;
   Gint *integers;
}                      Gintlist;

typedef double         Gfloat;
typedef FILE           Gfile;

typedef struct Gipoint 
{
    Gint            x;
    Gint            y;
}                      Gipoint;

typedef struct Gpoint 
{
   Gfloat x;
   Gfloat y;
}                      Gpoint;

typedef enum Gcstat 
{
   GC_OK,
   GC_NOCHOICE,
   GC_NONE
}            Gcstat;

typedef struct Gchoice 
{
   Gcstat status;
   Gint   choice;
}                      Gchoice;

typedef enum Gprflag 
{
   GPROFF,
   GPRON
}                  Gprflag;


typedef union Gchoicerec 
{
   struct 
   {
      Gchar *data;
   }               pet1;

   struct 
   {
      Gint    number;
      Gprflag *enable;
      Gchar   *data;
   }               pet2;

   struct 
   {
      Gint  number;
      Gchar **strings;
      Gchar *data;
   }               pet3;

   struct 
   {
      Gint  number;
      Gchar **strings;
      Gchar *data;
   }               pet4;

   struct 
   {
      Gint  seg;
      Gint  number;
      Gint  *pickids;
      Gchar *data;
   }               pet5;

}                      Gchoicerec;

typedef struct Gcobundl 
{
   Gfloat red;
   Gfloat green;
   Gfloat blue;
}                      Gcobundl;

typedef enum Gdevunits 
{
   GDC_METRES,
   GDC_OTHER
}             Gdevunits;


typedef struct Gdspsize 
{
   Gdevunits       units;
   Gpoint          device;
   Gipoint         raster;

}                      Gdspsize;

typedef enum Gesw 
{
   GECHO,
   GNOECHO
}                      Gesw;

typedef enum Gimode 
{
   GREQUEST,
   GSAMPLE,
   GEVENT
}                      Gimode;

typedef struct Glimit 
{
   Gfloat          xmin;
   Gfloat          xmax;
   Gfloat          ymin;
   Gfloat          ymax;
}                      Glimit;

typedef struct Gloc 
{
   Gint   transform;
   Gpoint position;
}                      Gloc;

typedef enum Gacf 
{
   GCURRENT,
   GSPECIFIED
}              Gacf;

typedef enum Gasf 
{
   GBUNDLED,
   GINDIVIDUAL
}              Gasf;

typedef struct Glnbundl 
{
   Gint   type;
   Gfloat width;
   Gint   colour;
}              Glnbundl;

typedef struct Glnattr 
{
   Gasf     type;
   Gasf     width;
   Gasf     colour;
   Gint     line;
   Glnbundl bundl;
} Glnattr;

typedef enum Gpfcf 
{
   GPF_POLYLINE,
   GPF_FILLAREA
}              Gpfcf;

typedef enum Gflinter 
{
   GHOLLOW,
   GSOLID,
   GPATTERN,
   GHATCH
}              Gflinter;

typedef struct Gflbundl 
{
   Gflinter        inter;
   Gint            style;
   Gint            colour;
}              Gflbundl;

typedef struct Gflattr 
{
   Gasf            inter;
   Gasf            style;
   Gasf            colour;
   Gint            fill;
   Gflbundl        bundl;
}              Gflattr;

typedef union Glocrec 
{
   struct 
   {
      Gchar *data;
   }           pet1;

   struct 
   {
      Gchar *data;
   }           pet2;

   struct 
   {
      Gchar *data;
   }           pet3;

   struct 
   {
      Gacf    acf;
      Glnattr ln;
      Gchar   *data;
   }           pet4;

   struct 
   {
      Gpfcf pfcf;
      Gacf  acf;
      union 
      {
	 Glnattr ln;
	 Gflattr fl;
      }      attr;

      Gchar *data;
   }           pet5;

   struct 
   {
   Gchar *data;
   }           pet6;

}                      Glocrec;

typedef enum Gos 
{
   GGKCL,
   GGKOP,
   GWSOP,
   GWSAC,
   GSGOP
}                      Gos;

typedef enum Gistat 
{
   GOK,
   GNONE
}              Gistat;

typedef struct Gqloc 
{
   Gistat status;
   Gloc   loc;
}                      Gqloc;

typedef struct Gstrlist 
{
   Gint  number;
   Gchar **strings;
}                      Gstrlist;

typedef enum Gvpri 
{
   GHIGHER,
   GLOWER
}                      Gvpri;

typedef enum Gwsstate 
{
   GINACTIVE,
   GACTIVE
}                      Gwsstate;

/* function prototypes */
void gopengks(Gfile *err_file, Glong memory);
void gks_cursor(double *u, double *v);
void gsetlinecolourind(Gint idx);
void set_cursor(unsigned int s);
void gdeactivatews(Gint wsid);
void gclosews(Gint wsid);
void ginqopenws(Gintlist *ws_ids);
void gks_setup(Gint wsid);
void gescsetprogname(char *s);
void gpolyline(Gint ns, Gpoint *pt);
void ps_polyline(int num, Gpoint *pnts);
void gfillarea(Gint ns, Gpoint *pt);
void ps_fill(int num, Gpoint *pnts);
void mlabel(double lon0, double lat0, char *str, double ch);
void gsetwindow(Gint tran, Glimit *Win);
void gsetviewport(Gint tran, Glimit *Win);
void ginqdisplayspacesize(Gchar *ws_type, Gdspsize *dspsz);
void gsetwswindow(Gint wsid, Glimit *WsWindow);
void gsetwsviewport(Gint wsid, Glimit *WsViewport);
void ginitloc(Gint wsid, Gint dev, Gint pet, Glimit *area);
void set_colors(Gint wsid);
void gsetcolourrep(Gint wsid, Gint idx, Gcobundl *rep);
void gks_border(double x1, double x2, double y1, double y2);
void gsetlocmode(Gint wsid, Gint dev, Gimode mode, Gesw echo);
void greqloc(Gint wsid, Gint dev, Gqloc *response);
void gclearws(Gint wsid, Gint wsnumber);
void gsetfillcolourind(Gint idx);
void gclosegks();
void ginqopst(Gos *state); 
void ginqwsst(Gint wsid, Gwsstate *state);
void gopenws(Gint wsid, Gchar *conn, Gchar *ws_type);
void gactivatews(Gint wsid);
void wn_vp(Gpoint p, Gpoint *p_new);
void vp_wn(Gpoint p, Gpoint *p_new);
void wswn_wsvp(Gpoint p, Gpoint *p_new);
void wsvp_wswn(Gpoint p, Gpoint *p_new);
void up_down(Gpoint p, Gpoint *p_new);
void down_up(Gpoint p, Gpoint *p_new);
void gif_unscale(double x, double y, double *xout, double *yout);
void gifsize(int size);
void gif_close();
