#include <stdio.h> 
#include <stdlib.h>
#include <math.h>
#include "gks.h"
#include "agra.h"

extern int ws_act;
extern double rat[];

extern FILE *gifout[];


static double gif_xmin[10]   = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}; 
static double gif_ymin[10]   = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}; 
static double gif_xmax[10];
static double gif_ymax[10];

static double gif_xminr[10] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}; 
static double gif_yminr[10] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}; 
static double gif_xmaxr[10]; 
static double gif_ymaxr[10];

static unsigned char  color[10];
static unsigned char *dmpimg[10];

static int win_width[10], win_height[10];
static int x_out, y_out;

static void gif_scale(double x, double y, double *xout, double *yout);
/*
static int dmpline(unsigned char color, unsigned char *img, int nx, 
    int ny, double x1, double y1, double x2, double y2);
*/
static void gif_fill(int num, Gpoint *pnts);

int DEBUG = 0;   /* for xvgifwr */


double round(double x)
{
    if( x - (double) floor(x) < 0.5)
        return(floor(x));
    else
        return(ceil(x));
}


void gifsize(int size)
{
    win_width[ws_act] = size;
}


void gif_init()
{
    if(win_width[ws_act] <= 0)
        win_width[ws_act] = 500;

    gif_xmax[ws_act]   = (double) win_width[ws_act];
    gif_ymax[ws_act]   = gif_xmax[ws_act] / rat[ws_act];
    win_height[ws_act] = (int) gif_ymax[ws_act];

    if(debug)
    {
        printf("debug>  gif_init: ws_act  = %d\n", ws_act);
        printf("debug>  gif_init: gif_xmax = %-g\n", gif_xmax[ws_act]);
        printf("debug>  gif_init: gif_ymax = %-g\n", gif_ymax[ws_act]);
        printf("debug>  gif_init: rat     = %-g\n\n", rat[ws_act]);
        fflush(stdout);
    }
}


void gif_open(char * file)
{
    int i, j, nbytes;

    if (gifout[ws_act] != NULL)
       fclose(gifout[ws_act]);

    gifout[ws_act] = fopen(file, "w");

    nbytes = win_width[ws_act] * win_height[ws_act];

    if(dmpimg[ws_act])
       free(dmpimg[ws_act]);

    dmpimg[ws_act] = (unsigned char *) malloc((size_t) nbytes);

    if(debug)
    {
	printf("debug> gif_open: file   = %s\n", file);
	printf("debug> gif_open: nbytes = %d\n\n", nbytes);
        fflush(stdout);
    }

    for(j=0; j<win_height[ws_act]; ++j)
       for(i=0; i<win_width[ws_act]; ++i)
        dmpimg[ws_act][j*win_width[ws_act] + i] = 0;
}



void gif_close()
{
    int           i, colorstyle, numcols;
    unsigned char rmap[256], gmap[256], bmap[256];

    numcols = 8;
    for(i=0; i<numcols; ++i)
    {
        switch(i)
            {
            case BLACK:
	       rmap[i] = 0x00;
	       gmap[i] = 0x00;
	       bmap[i] = 0x00;
               break;
      
            case WHITE:
	       rmap[i] = 0xff;
	       gmap[i] = 0xff;
	       bmap[i] = 0xff;
               break;
      
            case RED:
	       rmap[i] = 0xff;
	       gmap[i] = 0x00;
	       bmap[i] = 0x00;
               break;
      
            case GREEN:
	       rmap[i] = 0x00;
	       gmap[i] = 0xff;
	       bmap[i] = 0x00;
               break;
      
            case YELLOW:
	       rmap[i] = 0xff;
	       gmap[i] = 0xff;
	       bmap[i] = 0x00;
               break;
      
            case BLUE:
	       rmap[i] = 0x00;
	       gmap[i] = 0x00;
	       bmap[i] = 0xff;
               break;
      
            case MAGENTA:
	       rmap[i] = 0xff;
	       gmap[i] = 0x00;
	       bmap[i] = 0xff;
               break;
      
            case CYAN:
	       rmap[i] = 0x00;
	       gmap[i] = 0xff;
	       bmap[i] = 0xff;
               break;
            }

        if(debug)
        {
	    printf("debug> gif_close: %d -> rgb = %0x %0x %0x\n", 
	        i, rmap[i], gmap[i], bmap[i]);
            fflush(stdout);
        }
    }

    colorstyle = 0;

    rewind(gifout[ws_act]);

    WriteGIF(gifout[ws_act], dmpimg[ws_act], 
	     win_width[ws_act], win_height[ws_act], 
	     rmap, gmap, bmap, numcols, colorstyle);

    fflush(gifout[ws_act]);

    if(debug)
    {
	printf("debug> GIF write successful (gif_close)\n");
        fflush(stdout);
    }
}


void gif_wind(xmin, xmax, ymin, ymax)

double xmin, xmax, ymin, ymax;
{
    gif_xminr[ws_act] = xmin;
    gif_xmaxr[ws_act] = xmax;
    gif_yminr[ws_act] = ymin;
    gif_ymaxr[ws_act] = ymax;

    if(debug)
    {
	printf("debug> gif_wind: gif_xminr = %-g\n", xmin);
	printf("debug> gif_wind: gif_xmaxr = %-g\n", xmax);
	printf("debug> gif_wind: gif_yminr = %-g\n", ymin);
	printf("debug> gif_wind: gif_ymaxr = %-g\n\n", ymax);
        fflush(stdout);
    }
}


static void gif_scale(x, y, xout, yout)
double x, y;
double *xout, *yout;
{
    x_out = FALSE;
    y_out = FALSE;

    *xout = (x - gif_xminr[ws_act])
	 / (gif_xmaxr[ws_act] - gif_xminr[ws_act]) * gif_xmax[ws_act];

    *yout = (y - gif_yminr[ws_act])
	 / (gif_ymaxr[ws_act] - gif_yminr[ws_act]) * gif_ymax[ws_act];

    *yout = gif_ymax[ws_act] - *yout;

    if (*xout < 0 || *xout > gif_xmax[ws_act])
        x_out = TRUE;

    if (*yout < 0 || *yout > gif_ymax[ws_act])
        y_out = TRUE;
}



void gif_unscale(x, y, xout, yout)
double x, y;
double *xout, *yout;
{
    x_out = FALSE;
    y_out = FALSE;

    if (x < 0 || x > gif_xmax[ws_act])
        x_out = TRUE;

    if (y < 0 || y > gif_ymax[ws_act])
        y_out = TRUE;

    *xout = x * (gif_xmaxr[ws_act] - gif_xminr[ws_act]) / gif_xmax[ws_act] 
	    + gif_xminr[ws_act];

    y = gif_ymax[ws_act] - y;

    *yout = y * (gif_ymaxr[ws_act] - gif_yminr[ws_act]) / gif_ymax[ws_act] 
	    + gif_yminr[ws_act];
}



void gif_polyline(num, pnts)
int num;
Gpoint *pnts;
{
    int i;
    double x, y;
    double ximg, yimg, ximg1, yimg1;

    if(debug)
    {
	printf("debug> gif_polyline: num = %d\n", num);
	for(i=0; i<num; ++i)
	   printf("debug> gif_polyline: (x,y) = (%8.4f,%8.4f)\n",  
	      pnts[i].x, pnts[i].y);
	printf("\n");
        fflush(stdout);
    }

    for(i=1; i<num; ++i)
    {
        x = pnts[i-1].x;
        y = pnts[i-1].y;
        gif_scale(x, y, &ximg, &yimg);
  
        if (x_out == TRUE || y_out == TRUE)
	    continue;
  
        x = pnts[i].x;
        y = pnts[i].y;
        gif_scale(x, y, &ximg1, &yimg1);
  
        if (x_out == TRUE || y_out == TRUE)
	    continue;
  
        dmpline(color[ws_act], dmpimg[ws_act], 
		win_width[ws_act], win_height[ws_act], 
		ximg, yimg, ximg1, yimg1);
    }
}



static void gif_fill(num, pnts)
int num;
Gpoint *pnts;
{
   gif_polyline(num, pnts);
}


void gif_color(colorind)
int colorind;
{
    color[ws_act] = (unsigned char) colorind;

    if(debug)
    {
	printf("debug> gif_color: color = %d\n\n", colorind);
        fflush(stdout);
    }
}


int dmpline(color, img, nx, ny, x1, y1, x2, y2)

unsigned char   color;
unsigned char  *img;
int             nx, ny;
double          x1, y1, x2, y2;
{
   int npnts, ix, jy;
   double dx, dy, x, y, xinc, yinc, m, minv;

   if(debug)
   {
       printf("debug> dmpline: color = %d\n", (int) color);
       printf("debug> dmpline: nx    = %d\n", nx);
       printf("debug> dmpline: ny    = %d\n", ny);
       printf("debug> dmpline: x1    = %-g\n", x1);
       printf("debug> dmpline: y1    = %-g\n", y1);
       printf("debug> dmpline: x2    = %-g\n", x2);
       printf("debug> dmpline: y2    = %-g\n", y2);
       printf("\n");
       fflush(stdout);
   }

   npnts = 0;

   x = x1; 
   y = y1;

   dx = x2 - x1;
   dy = y2 - y1;

   xinc = 1.;
   if(dx < 0)
      xinc = -1.;

   yinc = 1.;
   if(dy < 0)
      yinc = -1.;


   /* Horizontal line */

   if(fabs(dx) >= fabs(dy))
   {
      m = dy/dx;

      while(FOREVER)
      {
	 ix = (int)round(x);
	 jy = (int)round(y);

	 if(ix >= 0 && ix<nx && jy >= 0 && jy<ny)
	    img[jy*nx + ix] = color;

	 ++npnts;

	 x += xinc;
	 y += xinc * m;

	 if(fabs(x-x1) > fabs(dx))
	    break;
      }
      
      return(npnts);
   }


   /* Vertical line */

   else
   {
      minv = dx/dy;
      
      while(FOREVER)
      {
	 ix = (int)round(x);
	 jy = (int)round(y);

	 if(ix >= 0 && ix<nx && jy >= 0 && jy<ny)
	    img[jy*nx + ix] = color;

	 ++npnts;

	 x += yinc * minv;
	 y += yinc;

	 if(fabs(y-y1) > fabs(dy))
	    break;
      }

      return(npnts);
   }
}


void FatalError(msg)  /* for xvgifwr */
char *msg;
{
}
