#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "gks.h"
#include "agra.h"

#define MAXARG  10
#define MAXCMD  10
#define MAXSEM  500

extern int in_quote, script_flag, redr_flag, mode, ws_act;
extern int grid_color[], symbol_color[], gc_ori[], sc_ori[];

extern double sexp[], lexp[], se_ori[], le_ori[];

static int redr_open[10] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

extern char redrname[10][256];




/********************************************************************/
/*                                                                  */
/* GETCOM -- Gets the next command line, either from stdin or from  */
/* a script file.  Parses the command into arguments and returns    */
/* the command code associated with cmdv[0].                        */
/*                                                                  */
/********************************************************************/


int getcom(cmdc, cmdv)

int    *cmdc;                                  /* count of arguments */
char   *cmdv[];                                /* array of pointers  */

{
   extern FILE *scriptfile;
   extern FILE *rfile;

   int i;

   char  *p, *st;
   static char line[MAXLINE]; 


   if (redr_flag == TRUE)
   {
      if (redr_open[ws_act] == FALSE)
      {
         rfile = fopen(redrname[ws_act], "r");

         if (rfile != NULL)
            redr_open[ws_act] = TRUE;
      }

      if (redr_open[ws_act] == TRUE)
      {
         st = fgets(line, MAXLINE, rfile);

         if (st != NULL)
         {
            line[strlen(line)-1] = '\0';       /* replace '\n' by '\0' */
            p = line;
         }
   
         else
         {
            redr_flag = FALSE;
            redr_open[ws_act] = FALSE;

            fclose(rfile);
            *cmdc = 0;
            cmdv[0][0] = '\0';
            p = cmdv[0];
         }
      }

      else
      {
         redr_flag = FALSE;
         redr_open[ws_act] = FALSE;

         fclose(rfile);
         *cmdc = 0;
         cmdv[0][0] = '\0';
         p = cmdv[0];
      }
   }

   else
   {
      if (script_flag == FALSE) 
      {
	 if(gets(line) == (char *)NULL)
	 {
	    svcreturn(RETURN, ERROR, "EOF/ERROR on input", SCALAR);
	    exit(0);                      
	 }
					     
	 p = line;
      }
      
      else
      {
	 st = fgets(line, MAXLINE, scriptfile);

	 if (st != NULL)
	 {
	    line[strlen(line)-1] = '\0';       /* replace '\n' by '\0' */
	    p = line;
	 }

	 else
	 {
	    script_flag = FALSE;

	    grid_color[ws_act]   = gc_ori[ws_act];
	    symbol_color[ws_act] = sc_ori[ws_act];
	    lexp[ws_act]         = le_ori[ws_act];
	    sexp[ws_act]         = se_ori[ws_act];

	    fclose(scriptfile);

	    *cmdc = 0;
	    cmdv[0][0] = '\0';
	    p = cmdv[0];
	 }
      }  
   }

   *cmdc = 0;

   cmdv[0] = p;

   while(*p == ' '|| *p == '\t')               /* skip spaces */
      p++;
        
   while(*p != '\0')
   {
      if (*p == '"')
      {
         in_quote = TRUE;
         p++;                                  /* skip '"' */
         cmdv[*cmdc] = p;                      /* point to this argument */
         (*cmdc)++;
         p++;

         while(*p != '"')
            p++;

         *p++ = '\0';

         while(*p == ' ' || *p == '\t')
            p++;
      }

      else
      {
         cmdv[*cmdc] = p;                      /* point to this argument */
         (*cmdc)++;

         while(*p != ' ' && *p != '\t'  && *p != ';' && *p != '\0')
            p++;
                
         if (*p == ' ' || *p == '\t')
            *p++ = '\0';                       /*  terminate last cmdv[*cmdc] 
                                                   and go to next character  */

         else if (*p == ';')
	 {
            *p++ = '\0';
	 }

         while(*p == ' ' || *p == '\t')
            p++;                               /* skip rest spaces */
      }
   } 

   if (script_flag == FALSE)
   {
      if ((scriptfile = fopen(cmdv[0], "r")) != NULL)
      {
         if (mode == SERVER)
	 {
            (void) printf("[struct stat=\"OK\"]\n");
            (void) fflush(stdout);
	 }

         script_flag = TRUE;
         *cmdc = 0;
         cmdv[0][0] = '\0';
      }
   }
   
   if (cmdv[0][0] == '!')
   {
      for (i=0; i<*cmdc-1; i++)
                 cmdv[i][strlen(cmdv[i])] = ' ';

      p = cmdv[0];
      system(p+1);
      return(NULLSTR);
   }

   if(debug)
   {
      printf("\ndebug> getcom: cmdc     = %d\n", *cmdc);

      for(i=0; i<*cmdc; ++i)
         printf("debug> getcom: cmdv[%2d] = \"%s\"\n", i, cmdv[i]);

      printf("debug> getcom: cmdno    = %d\n\n", cs(cmdv[0]));
      fflush(stdout);
   }

   return(cs(cmdv[0]));
}
