#include <X11/Xlib.h>

#define TRUE           1
#define FALSE      !TRUE
#define FOREVER     TRUE

#define ERROR          0
#define OK             1

#define RETURN         0
#define SIGNAL         1

#define SCALAR         0
#define STRUCTURE      1

#define MAXVAR        30 
#define MAXLINE     4096
#define MAXMAP       100

/*************************************/
/*                                   */
/*     Coordinate Transformations    */
/*                                   */
/*************************************/

#define ECEQ           1
#define ECGA           2
#define ECSG           3
#define EQEC           4
#define EQGA           6
#define EQSG           7
#define GAEC           8
#define GAEQ           9
#define GASG          10
#define SGEC          11
#define SGEQ          12
#define SGGA          13

/*************************************/
/*                                   */
/*     Coordinate Systems            */
/*                                   */
/*************************************/

#define EC            20
#define EQ            21
#define GA            22
#define SG            23

/*************************************/
/*                                   */
/*     Projection Type               */
/*                                   */
/*************************************/

#define AITOFF        30
#define CARTESIAN     31
#define CYLINDRICAL   32
#define GNOMONIC      33
#define NCP           34
#define PLATE         35
#define ORTHOGRAPHIC  36

/**************************************/
/*                                    */
/*     Symbol Type                    */
/*                                    */
/**************************************/

#define CIRCLE       50
#define CROSS        51
#define DOT          52
#define X            53

/**************************************/
/*                                    */
/*     Point Polygon Type             */
/*                                    */
/**************************************/

#define PTYPE_OPEN      0
#define PTYPE_SKELETAL  1
#define PTYPE_STARRED   2
#define PTYPE_SOLID     3
#define PTYPE_CIRCLE    4
#define PTYPE_CROSS     5
#define PTYPE_X         6

/*************************************/
/*                                   */
/*     Curve Type                    */
/*                                   */
/*************************************/

#define CURVE        60
#define GREAT        61
#define LINEAR       62

/*************************************/
/*                                   */
/*     Color Option                  */
/*                                   */
/*************************************/

#define BLACK         0
#define WHITE         1
#define RED           2
#define GREEN         3
#define YELLOW        4
#define BLUE          5
#define MAGENTA       6
#define CYAN          7

/*************************************/
/*                                   */
/*     Mode Flag                     */
/*                                   */
/*************************************/

#define SERVER        1
#define INTERACTIVE   0

/*************************************/
/*                                   */
/*     AGRA Commands                 */
/*                                   */
/*************************************/

#define ANGLE       100
#define APPLY       101
#define BORDER      102
#define CCONV       1030
#define CD          103
#define CLOSE       104
#define CFILE       105
#define COLOR       106
#define CONTOUR     107
#define CORNERS     1071
#define CURSOR      108
#define DATA        109
#define DCS         110 
#define DEBUGFLAG   1101
#define DIR         111  
#define DRAW        1110
#define EPOCH       1112
#define EQUINOX     1113
#define ERASE       112
#define EXPAND      113
#define FFILE       114 
#define FLIPX       1140
#define GCS         115 
#define GEXPAND     1150
#define GIFLOC      1151
#define GIFSIZE     1152
#define GRID        116 
#define HEADER      117
#define HELP        118
#define ICS         1180
#define INQWINDOW   119
#define LALI        120
#define LABEL       121
#define LAT         122
#define LCIRCLE     1221
#define LCS         123
#define LDRAW       1231
#define LMOVE       1232
#define LON         124
#define LOCATOR     125
#define LROTATE     1251
#define MAP         126
#define MCENTER     127 
#define MCTYPE      128 
#define MOVE        129
#define NAXIS       1290
#define NULLSTR     130
#define OBJECT      1301
#define PCENTER     131
#define PCS         132
#define PLATEDEC    1320
#define PLATEOFF    1321
#define PLATEX      133
#define PLATEY      134
#define PLATEP      135
#define PLATERA     1350
#define PLATESCL    1351
#define PLATESIZE   1352
#define PRINT       136
#define PRINTER     137
#define PROJECTION  138
#define PSCOLOR     139
#define PSORIENT    1391
#define PSRES       1392
#define PTYPE       140
#define PWD         141
#define QUIT        142
#define READ        143
#define REDRAW      144
#define REPAINT     145
#define RESOLUTION  146
#define ROTATE      147 
#define SCALE       148
#define SET_WINDOW  149
#define SHADOW      150
#define SIZE        151 
#define STYLE       152
#define SYS         153
#define SYMBOL      154
#define SYMANG      155
#define UV          157 
#define VECTOR      1571
#define WINDOW      158

/*************************************/
/*                                   */
/*     Contour Structures            */
/*                                   */
/*************************************/

typedef struct
{
   float x;
   float y;
} CPOLY_PNT;

typedef struct
{
   int npts;
   int maxpts;
   CPOLY_PNT **pnt;
} CPOLYN;

typedef struct
{
   int npoly;
   CPOLYN **poly;
} CPOLY;



/*************************************/
/*                                   */
/*     Miscellaneous Stuff           */
/*                                   */
/*************************************/

typedef struct
{
   char proj[20];
   struct {double lon; double lat;} pcent;
   struct {double lon; double lat;} mcent;
   struct {double su;  double sv; } size;
   double maxsize;
} PARA;

int   setup[10],  labcs_done[10],  windowID[10],     border[10],    csproj[10],
     csgrid[10],      csdata[10],     cslab[10],      csloc[10],  ait_done[10],
   gno_done[10],    car_done[10],  cyl_done[10],   ncp_done[10],  pla_done[10],
   ort_done[10],      nsides[10],     ptype[10],    map_num[10],  draw_num[10], 
      erase[10],    file_pos[10], style_pos[10], grid_color[10], 
label_color[10],symbol_color[10], loc_color[10],     gc_ori[10],    sc_ori[10],
    sysproj[10],     sysgrid[10],   sysdata[10],     syslab[10],    sysloc[10],
   sysimage[10];

int in_quote, button, tr, tr_inverse, n, xcol, ycol, expcol, colrcol,
     typecol, maxlvl, contpts_max, *poly_max;


int Ndata[10][MAXMAP];


double lon0r, lat0r;

double **x, *londata[10][MAXMAP],  *latdata[10][MAXMAP];

double xmin[10],     xmax[10],     ymin[10],    ymax[10],    Xmin[10],
       Xmax[10],     Ymin[10],     Ymax[10],    sexp[10],    lexp[10], 
       mang[10],   se_ori[10],   le_ori[10],  rtwist[10],   longi[10],  
       lati[10],      rat[10],      res[10],  longi1[10],   lati1[10], 
   eqnxproj[10], eqnxgrid[10], eqnxdata[10], eqnxlab[10], eqnxloc[10], 
  eqnximage[10],    epoch[10];

double chh;
double gexpand;

void (*map[10])(), (*map_inv[10])(), (*imap)(), (*imap_inv)(),
              E(),         eclequ(),  eclgal(),     eclsgal(),
         equecl(),         equgal(), equsgal(),      galecl(), 
	 galequ(),        galsgal(), sgalecl(),     sgalequ(), 
        sgalgal();

char *flag[10], redrname[10][256], bjdata[10][1], bjproj[10][1], bjgrid[10][1];

FILE *scriptfile, *rfile, *pscript, *redrfile[10], *psout[10], *gifout[10], *fd;

Display *display;

void aitoff      ();
void cartesian   ();
void cylindrical ();
void gnomonic    ();
void ncp         ();
void plate       ();
void orthographic();
void a_inverse   ();
void ca_inverse  ();
void cy_inverse  ();
void g_inverse   ();
void nc_inverse  ();
void pl_inverse  ();
void or_inverse  ();
void jcnvc2(int isys1, double epoki, double x0, double y0,
    int isys2, double epoko, double *xnew, double *ynew, double tobsin);
void mptype(double lon0, double lat0, int ns, int t, double e, double mang);
int getcom(int *c, char *v[]);
void setcs(char *mctype, int mode, double lonc, double latc, 
    double *center1, double *center2);
int cs(char *s);
void mcurve(double lon1, double lat1, double lon2, double lat2, 
    char *curtype, char *curflag);
int read_char(int font, int nglyph);
int Isnumber(char *s);
void draw_grid(double old_lonc, double old_latc, char *flag, 
    double su, double sv, double rotate);
void mapsex(double coord, char *cstr, int hd);
void substr(char *string, char **subst, int *nsub);
void ps_color(int colorind);
int sex2dd(char *cra, char *cdec, double *ra, double *dec);
void ps_close();
void ps_wind(double xmin, double xmax, double ymin, double ymax);
void ps_init();
void ps_open(char *name, char *file);
void scale(char *mctype, PARA *mapinfo);
void drawsymbol(double lon0, double lat0, int nsides, int ptype, 
    double expand, double rotate);
int Isnumber(char *s);
void skycurve(double lon1, double lat1, double lon2, double lat2, 
    char *curtype);
void ldraw_setup(double lon0, double lat0);
void ldraw_transform(double rlon, double rlat, double *lon, double *lat);
void ldraw_rotate(double rotate);
void f_polyline(int num, Gpoint *pts);
void svcreturn (int msgtype, int status, char *str, int structflag);
void ps_clearend();
void ps_setstyle(int file_num, char *style);
void gif_wind(double xmin, double xmax, double ymin, double ymax);
void gif_init();
void gif_open(char * file);
void gif_polyline(int num, Gpoint *pnts);
void gif_color(int colorind);

int debug;
