#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/param.h>
#include <pwd.h>
#include <errno.h>

#ifndef SUNOS
#include <unistd.h>
#endif

#include "gks.h"
#include "agra.h"
#include "img.h"

#ifdef SUNOS
#include <malloc.h>
#endif

#define TTYINPUT   (LASTEvent+1)

#define MAXCOL  1024 
#define MAXWD   1024
#define MAXPT   50
#define MAXPR   10

#define MAXLVL  5 

#ifdef  DEC
#define GGKCL         0
#define GGKOP         1
#endif

int mode = INTERACTIVE, file_found = FALSE, script_flag = FALSE,
    redr_flag = FALSE, exp_found = FALSE, color_found = FALSE,
    type_found = FALSE, do_cursor = FALSE, grid_eq = TRUE, 
    gifsize_set = FALSE, ws_act = 0, use_x = TRUE, flipsign = 1;

char msgstr[1024];

int ics = 1;
int CPOLY_MAXC = 0, CPOLY_MAXCINC = 32, CPOLY_MAXPINC = 516;

int AA[4][4] = {{   0, ECEQ, ECGA, ECSG},
		{EQEC,    0, EQGA, EQSG},
		{GAEC, GAEQ,    0, GASG},
		{SGEC, SGEQ, SGGA,    0}};

static char *cs_name[5] = {"ec", "eq", "ga", "sg", "uv"};

double pi  =  3.14159265358979324;
double dtr =  0.01745329251994329;
double rtd = 57.2957795131;
double x_offset=0., y_offset=0.;

/*
void (*func[16])() = {      E,  eclequ,  eclgal,  eclsgal,
		       equecl,       E,  equgal,  equsgal,
		       galecl,  galequ,       E,  galsgal,
		      sgalecl, sgalequ, sgalgal,       E};
		      */

PARA   para[10];
CPOLY  *conts;
Gpoint *contpts;
struct img *coef_set;

/* prototypes */
void svcreturn (int msgtype, int status, char *str, int structflag);
void update_str(char *s1, char *s2);
int cntcheck(char *cmd, int cmdc, int min, int max);
void update_data(double x, double y, double x_new, double y_new);
int set_proj(char *s);
void check_ws();
static void check_setup(double xmin0, double xmax0, double ymin0, double ymax0,
    Gint ws_id);
static void open_psfile(char *file);
static void draw_data(double *lonarr, double *latarr, int ptype1, int ptype2, 
    double exp, double mang);
static int set_dcs(char *s, char *bj);
static int set_pcs(char *s, char *bj);
static int set_gcs(char *s, char *bj);
static int set_ics(char *s, char *bj);
static int guess_ics(char *s, double eqnx);
static int set_loccs(char *s, char *bj);
static int set_labcs(char *s);
static int help(char *s);
static void save_redr(int win_num, char *s);
static int fullpath(char *outpath, char *inpath);
static void ini_redr(FILE *redr_fp);
static void copyfile(char *intfile, char *outfile, int decolor);
static int init_contours();
void open_giffile(char *file);
void f_color(int color);
void trans_center(double lon, double lat, char *tmpcs1, char *tmpcs2, 
    double *plon, double *plat);


int jcgflag = 0;

int main(argc, argv)

int argc;
char **argv;
{
#ifdef SUNOS
   extern char *malloc(), *realloc();
#endif

   extern int mode, file_found, script_flag, redr_flag, exp_found, 
	      color_found, type_found, do_cursor, grid_eq, 
	      button, tr, tr_inverse, n, xcol, ycol, expcol, colrcol, 
	      typecol, ws_act, maxlvl, contpts_max, *poly_max;

   extern int setup[], labcs_done[], windowID[], border[], csproj[], 
	      csgrid[], csdata[], cslab[], csloc[], ait_done[], 
	      gno_done[], car_done[], cyl_done[], ncp_done[], pla_done[], 
	      ort_done[], nsides[], ptype[], map_num[], draw_num[], 
	      erase[], grid_color[], 
	      label_color[], symbol_color[], loc_color[], gc_ori[], 
	      sc_ori[],
	      sysproj[], sysgrid[], sysdata[], syslab[], sysloc[], sysimage[];

   extern int Ndata[10][MAXMAP];

   extern double dtr, rtd, lon0r, lat0r, chh, gexpand;

   extern double **x, *londata[10][MAXMAP], *latdata[10][MAXMAP];
   extern double xmin[], xmax[], ymin[], ymax[], Xmin[], Xmax[],
		 Ymin[], Ymax[], mang[], se_ori[], 
		 le_ori[], rtwist[], longi[], lati[], res[],
                 longi1[], lati1[],
		 eqnxproj[], eqnxgrid[], eqnxdata[], eqnxlab[], 
		 eqnxloc[], eqnximage[], epoch[];
   extern void (*map[])(), (*map_inv[])(),  (*imap_inv)();
   extern void aitoff(), gnomonic(), cylindrical(), orthographic(), 
	       plate(), ncp();
   extern void a_inverse(), g_inverse(), cy_inverse(), 
	       or_inverse(), nc_inverse(), pl_inverse();
   /*
   extern void E(), eclequ(), eclgal(), eclsgal(), equecl(), equgal(), 
	       equsgal(), galecl(), galequ(), galsgal(), sgalecl(), 
	       sgalequ(), sgalgal();
   */


   extern char *flag[], redrname[10][256], bjdata[10][1], bjproj[10][1], 
	       bjgrid[10][1];
   extern FILE *redrfile[], *psout[], *gifout[],
	       *fd;
   extern Display *display;


   int i, j, k, l, m=0, q, d, bad, stat, kno;
   int var_num = 0, va = 0;
   int cind = 1;
   int xserver_fd, ttyfd = 0;
   int decolor = 1;

   char         *p, prog[20];

   XEvent       event;
   fd_set       fdset;

   char dummy_filename[100];
   int cmdc;
   int endcol[MAXCOL], colwd[MAXCOL];
   int col_found = FALSE, x_found=FALSE, y_found=FALSE, var_found;
   int dx_found  = FALSE, dy_found = FALSE, dxcol, dycol;
   int isopen = FALSE;
   int dcs_done[10], pcs_done[10], gcs_done[10];
   int dcs_file = 1, pcs_file = 1, gcs_file = 1;
   int set_ptr = FALSE;
   int cmdcur = 0;
   int win_inq, win_mod = 0;
   int csproj_old[10]; 
   int npoly, npts, level_current=0, poly_current, pts_current;
   int pixels, lines, maxpts, maxvar, index, imap_plate=0;
   
   char data[MAXLINE], name[MAXCOL][MAXWD], var[MAXVAR][MAXWD], 
	str[MAXWD], stri[MAXWD];
   char *cmdv[MAXLINE];
   char fname[80], psfile[10][256], giffile[10][256], printer[30], comm[50], 
	csimage[4];
   char tempath[80], tmp_oldcs[10], tmp_newcs[10];
   char *prtmpfile;
   char rdcomd[MAXLINE];
   char path_tmp[500];
   char style[10][10];
   static char *count[10] = {"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};

   char *flag_file = "proj";
   char line[132], dum[132], dum1[132], *ptr, curtype[10];

   double ch_percent = 0.02;
   double glon, glat;
   double longi_tmp=0., lati_tmp=0.;
   double plon, plat;
   double u, v, xgif, ygif, u0[10], v0[10];
   double xmin_old[10], xmax_old[10], ymin_old[10], ymax_old[10];
   double ilon0=0., ilat0=0., crpix1, crpix2, cdelt1, cdelt2, 
	  naxis1, naxis2, imag_naxis1, imag_naxis2;
   double tmpx, tmpy, tmpr, reflon, reflat;
   double fac;

   double w;
   double level;

   double exp = 1., rotation = 0.;


   FILE *fp, *fq, *fimage;
   FILE *fopen();

   PARA para_old[10], dfile;

   Gchar    *conn = (char *)NULL;
   Gos      state;
   Gintlist wsopen;
   Gwsstate wsstate;
   Gint     ws_id = 1;
   Atom wm_delete_window;
   Window cur_win;
   
   debug = 0;

   gexpand = 1.0;

   for (i=0; i<10; i++)
   {
      strcpy(para[i].proj, "aitoff");
      para[i].mcent.lon      =   0.;
      para[i].mcent.lat      =   0.;
      para[i].pcent.lon      =   0.;
      para[i].pcent.lat      =   0.;
      para[i].size.su        = 360.;
      para[i].size.sv        = 180.;
      para[i].maxsize        = sqrt(para[i].size.su*para[i].size.su 
			          + para[i].size.sv*para[i].size.sv) / 2.;

      strcpy(para_old[i].proj, "aitoff");
      para_old[i].mcent.lon  = 0.;
      para_old[i].mcent.lat  = 0.;
      para_old[i].pcent.lon  = 0.;
      para_old[i].pcent.lat  = 0.;
      para_old[i].size.su    = 360.;
      para_old[i].size.sv    = 180.;

      u0[i]        = 0.;
      v0[i]        = 0.;
      xmin[i]      = -180.;
      xmax[i]      =  180.;
      ymin[i]      = -90. ;
      ymax[i]      =  90. ;
      Xmin[i]      = -240.;
      Xmax[i]      =  240.;
      Ymin[i]      = -118;
      Ymax[i]      =  118;
      xmin_old[i]  = 0.;
      xmax_old[i]  = 0.;
      ymin_old[i]  = 0.;
      ymax_old[i]  = 0.;
      res[i]       = 1700.;
      bjdata[i][0] = 'B';
      bjproj[i][0] = 'B';
      bjgrid[i][0] = 'B';
      eqnxproj[i]  = 1950.;
      eqnxgrid[i]  = 1950.;
      eqnxdata[i]  = 1950.;
      eqnxlab[i]   = 1950.;
      eqnxloc[i]   = 1950.;
      eqnximage[i] = 1950.;
      epoch[i]     = 1950.;

      rtwist[i] = 0.;
      mang[i]   = 0.;

      csproj[i]   = 1;
      csdata[i]   = 1;
      csgrid[i]   = 1;
      csloc[i]    = 1;
      cslab[i]    = 4;
      sysproj[i]  = 1;
      sysgrid[i]  = 1;
      sysdata[i]  = 1;
      syslab[i]   = 1;
      sysloc[i]   = 1;
      sysimage[i] = 1;

      csproj_old[i] = 1;

      grid_color[i]   = 5;
      label_color[i]  = 1;
      symbol_color[i] = 4;
      loc_color[i]    = 1;
      gc_ori[i]       = 5;
      sc_ori[i]       = 4;
      nsides[i]       = 3;
      ptype[i]        = PTYPE_OPEN;

      flag[i] = "proj";

      erase[i]       = FALSE;
      border[i]      = FALSE;

      longi[i] = 0.;
      lati[i]  = 0.;

      sexp[i] = 0.5;
      lexp[i] = 1.;
      se_ori[i] = 0.5;
      le_ori[i] = 1.;

      map_num[i] = 0;
      draw_num[i] = 0;

      dcs_done[i] = FALSE;
      pcs_done[i] = FALSE;
      gcs_done[i] = FALSE;

      setup[i] = FALSE;
      labcs_done[i] = FALSE;

      ait_done[i]   = TRUE;
      gno_done[i]   = FALSE;
      car_done[i]   = FALSE;
      cyl_done[i]   = FALSE;
      ncp_done[i]   = FALSE;
      pla_done[i]   = FALSE;
      ort_done[i]   = FALSE;
      map[i]        = aitoff;
      map_inv[i]    = a_inverse;
      
      *psfile[i] = '\0';
      *giffile[i] = '\0';
      *redrname[i] = '\0';

      if (getenv("EOSHOME") != NULL)
      {
         strcpy(psfile[i], getenv("EOSHOME"));
	 strcpy(giffile[i], getenv("EOSHOME"));
	 strcpy(redrname[i], getenv("EOSHOME"));
      }

      else
      {
	 strcpy(psfile[i], "/tmp");
	 strcpy(giffile[i], "/tmp");
         strcpy(redrname[i], "/tmp");
      }

      strcat(psfile[i], "/");
      strcat(giffile[i], "/");
      strcat(redrname[i], "/");
      
      strcpy(dummy_filename, "agra_XXXXXX");
      strcat(psfile[i],   mktemp(dummy_filename));
      strcpy(dummy_filename, "agra_XXXXXX");
      strcat(giffile[i],   mktemp(dummy_filename));
      strcpy(dummy_filename, "agra_XXXXXX");
      strcat(redrname[i], mktemp(dummy_filename));

      strcat(psfile[i],   ".");
      strcat(psfile[i],   count[i]);
      strcat(psfile[i],   ".ps");
      strcat(giffile[i],  ".");
      strcat(giffile[i],  count[i]);
      strcat(giffile[i],  ".gif");
      strcat(redrname[i], ".");
      strcat(redrname[i],  count[i]);
      strcat(redrname[i], ".rd");
   }

   *tempath = '\0';
   if (getenv("EOSHOME") != NULL)
      strcpy(tempath, getenv("EOSHOME"));

   else
   {
      strcpy(tempath, "/tmp");
      if (getenv("USER") != NULL)
      {
         strcat(tempath, "/");
         strcat(tempath, getenv("USER"));
      }
   }

   strcpy(dfile.proj, "aitoff");

   dfile.mcent.lon = 0.;
   dfile.mcent.lat = 0.;
   dfile.pcent.lon = 0.;
   dfile.pcent.lat = 0.;
   dfile.size.su   = 360.;
   dfile.size.sv   = 180.;

   lon0r = 0.;
   lat0r = 0.;

   tr         = AA[csdata[ws_act]][csproj[ws_act]];
   tr_inverse = AA[csproj[ws_act]][csdata[ws_act]];

   *printer  = '\0';

   maxpts = MAXPT;
   maxvar = MAXVAR;

   x = (double **) malloc((unsigned)(maxvar * sizeof(double *)));
   if (x == NULL)
   {
      svcreturn(SIGNAL, ERROR, "Can't allocate required memory.", SCALAR);
      exit(1);
   }

   for (i = 0; i < maxvar; i++)
   {
#ifdef SUNOS
      *(x+i)  =  (double *)malloc((unsigned int)(maxpts * sizeof(double)));
#else
      *(x+i)  =  (double *)malloc((size_t)(maxpts * sizeof(double)));
#endif
      
      if (x+i == NULL)
      {
	 svcreturn(SIGNAL, ERROR, "Can't allocate required memory.", SCALAR);
	 exit(1);
      }
   }
   
   for (j=0; j<10; j++)
   {
      for (i=0; i<MAXMAP; i++)
      {
#ifdef SUNOS
	 londata[j][i] = (double *)malloc((unsigned int)(maxpts 
	    * sizeof(double)));

	 latdata[j][i] = (double *)malloc((unsigned int)(maxpts 
	    * sizeof(double)));
#else
	 londata[j][i] = (double *)malloc((size_t)(maxpts * sizeof(double)));
	 latdata[j][i] = (double *)malloc((size_t)(maxpts * sizeof(double)));
#endif
	 
	 if (londata[j][i] == NULL || latdata[j][i] == NULL)
	 {
	    svcreturn(SIGNAL, ERROR, "Can't allocate required memory.", SCALAR);
	    exit(1);
	 }
      }
   }


   coef_set = (struct img *) malloc(sizeof(struct img));
   if (coef_set == NULL)
   {
      svcreturn(SIGNAL, ERROR, "Can't allocate required memory.", SCALAR);
      exit(1);
   }

   while (argc > 1)
   {
      if (argv[1][0] == '-')
      {
	 switch(argv[1][1])
	 {
	    case 'd':
	       debug = TRUE;
	       break;

	    case 's':
	       mode = SERVER;
	       break;

	    case 'x':
	       use_x = FALSE;
	       break;

	    default:
	       sprintf(msgstr, "%s is incorrect option", argv[1]);
	       svcreturn(SIGNAL, ERROR, msgstr, SCALAR);
	       break;
	 }
      }
      --argc;
      ++argv;
   }

   if (mode == INTERACTIVE)
   {
      (void) printf("> ");
      (void) fflush(stdout);
   }

   gopengks(stdout, 0);

   if(use_x)
      xserver_fd = ConnectionNumber(display);

   while(FOREVER)
   {
      if (script_flag || redr_flag)
	 event.type = TTYINPUT;

      else
      {
	 if (use_x && XPending(display))
	    XNextEvent(display, &event);

         else
	 {
	    FD_ZERO(&fdset);
	    FD_SET(ttyfd, &fdset);

	    if(use_x)
	       FD_SET(xserver_fd, &fdset);

	    if (select(FD_SETSIZE, &fdset, (fd_set *)0, (fd_set *)0,
	       (struct timeval *)0 ) < 0)
	    {
	       if (errno != EINTR)
		     svcreturn(SIGNAL, ERROR, "Select error", SCALAR);

               continue;
	    }

	    if (use_x && FD_ISSET(xserver_fd, &fdset))
	       XNextEvent(display, &event);

            else if (FD_ISSET(ttyfd, &fdset)) 
	       event.type = TTYINPUT; 

            else
	       continue;
	 }
      }




      /* Process the input. */

      switch(event.type)
      {

	 case ButtonPress:

	    if (cmdcur)
	    {
	       gks_cursor(&u, &v);
	       if (button == 256)
	       {
		  if (   u <= xmin[ws_act] || u >= xmax[ws_act]
		      || v <= ymin[ws_act] || v >= ymax[ws_act] )
		  {

		     svcreturn(SIGNAL, ERROR, "Cursor is out of range", SCALAR);
		  }

		  else
		  {
		     do_cursor = 1;
		     map_inv[ws_act](u, v, &glon, &glat);
		     /*
		     tr_inverse = AA[csproj[ws_act]][csloc[ws_act]];
		     (*func[tr_inverse])(glon, glat,
				      &longi[ws_act], &lati[ws_act]);
		     */
		     jcnvc2(sysproj[ws_act], eqnxproj[ws_act], glon, glat,
			    sysloc[ws_act],  eqnxloc[ws_act],
			    &longi[ws_act], &lati[ws_act], epoch[ws_act]);

		     gsetlinecolourind(loc_color[ws_act]);
		     drawsymbol(longi[ws_act], lati[ws_act], 4, 1, 
		     0.02*(xmax[ws_act] - xmin[ws_act]), 45.*dtr);

		     if (mode == INTERACTIVE)
		     {
			(void) printf(
			   "\n Cursor at position: (lon = %-10g, lat = %-10g)",
			    longi[ws_act], lati[ws_act]);

			(void) fflush(stdout);
		     }
		     else if (mode == SERVER)
		     {
			(void) sprintf(msgstr, 
			   "[struct stat=\"NEW\", lon=%-g, lat=%-g]", 
			   longi[ws_act], lati[ws_act]);

			svcreturn(SIGNAL, OK, msgstr, STRUCTURE);
		     }

		     do_cursor = 0;
		  }
               }

	       else if (button == 512)
	       {
		  cmdcur = 0;
		  set_cursor(XC_left_ptr);

		  if (mode == INTERACTIVE)
		  {
		     (void) printf("\n> ");
		     (void) fflush(stdout);
		  }
		  else if (mode == SERVER)
		  {
		     (void) sprintf(msgstr, "[struct stat=\"DONE\"]");

		     svcreturn(SIGNAL, OK, msgstr, STRUCTURE);
		  }
	       }
	    }

	    break;




	 case ClientMessage:

	    if ( event.xclient.data.l[0] == wm_delete_window)
	    {
	       cur_win = event.xclient.window;
	       for (i=0; i<10; i++)
	       {
		  if (windowID[i] == cur_win)
		  {
		     ws_id = i + 1;
		     break;
		  }
	       }

	       gdeactivatews(ws_id);
	       gclosews(ws_id);
	       ginqopenws(&wsopen);

	       if (wsopen.number == 0)
	       {
		  if (mode == INTERACTIVE)
		  {
		     (void) printf("> ");
		     (void) fflush(stdout);
		  }

		  else if (mode == SERVER)
		  {
		     sprintf(msgstr, 
			"[struct function=\"Close\", value=\"WARNING\"]");

		     svcreturn(SIGNAL, OK, msgstr, STRUCTURE);
		  }

		  ws_id  = 1;
		  ws_act = 0;
	       }

	       else
	       {
		  ws_id = wsopen.integers[0];
		  ws_act = ws_id - 1;
		  if (mode == INTERACTIVE)
		  {
		     (void) printf("> ");
		     (void) fflush(stdout);
		  }

                  else if (mode == SERVER)
		  {
		     sprintf(msgstr, 
			"[struct function=\"Close\", value=%d]", ws_id);

		     svcreturn(SIGNAL, OK, msgstr, STRUCTURE);
		  }
	       }
	    }

            break;




         case TTYINPUT:

            switch(getcom(&cmdc, cmdv))
	    {

	       case APPLY:

		  if (cntcheck("apply", cmdc, 1, 0))
		     break;
		  
		  if (mode == SERVER)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  para[ws_act].pcent.lon = dfile.pcent.lon;
		  para[ws_act].pcent.lat = dfile.pcent.lat;
		  para[ws_act].mcent.lon = dfile.mcent.lon;
		  para[ws_act].mcent.lat = dfile.mcent.lat;
		  para[ws_act].size.su   = dfile.size.su;
		  para[ws_act].size.sv   = dfile.size.sv;
		  strcpy(para[ws_act].proj, dfile.proj);

		  update_data(para[ws_act].pcent.lon, 
			      para[ws_act].pcent.lat,
			      para_old[ws_act].pcent.lon,
			      para_old[ws_act].pcent.lat);

		  update_data(para[ws_act].mcent.lon, 
			      para[ws_act].mcent.lat,
			      para_old[ws_act].mcent.lon,
			      para_old[ws_act].mcent.lat);

		  update_data(para[ws_act].size.su, 
			      para[ws_act].size.sv,
			      para_old[ws_act].size.su,
			      para_old[ws_act].size.sv);

		  update_str(para[ws_act].proj, para_old[ws_act].proj);
		  strcpy(para_old[ws_act].proj, para[ws_act].proj);

		  csdata[ws_act]         = dcs_file;
		  csproj[ws_act]         = pcs_file;
		  csgrid[ws_act]         = gcs_file;
		  flag[ws_act]           = flag_file;

		  lon0r = para[ws_act].pcent.lon * dtr;
		  lat0r = para[ws_act].pcent.lat * dtr;
		  set_proj(para[ws_act].proj);

		  break;




	       case BORDER:

		  if (cntcheck("border", cmdc, 1, 0))
		     break;
		  
		  border[ws_act] = 1;
		  check_ws();

		  if (pla_done[ws_act])
		     {
		     xmin[ws_act] = 1.;
		     ymin[ws_act] = 1.;
		     xmax[ws_act] = naxis1;
		     ymax[ws_act] = naxis2;
		     }

		  else
		  {
		     setcs(flag[ws_act], 0, para[ws_act].mcent.lon, 
			para[ws_act].mcent.lat, &u0[ws_act], &v0[ws_act]);

		     xmin[ws_act] = u0[ws_act] - (para[ws_act].size.su)/2.;
		     xmax[ws_act] = u0[ws_act] + (para[ws_act].size.su)/2.;
		     ymin[ws_act] = v0[ws_act] - (para[ws_act].size.sv)/2.;
		     ymax[ws_act] = v0[ws_act] + (para[ws_act].size.sv)/2.;
		  }

		  if ((xmax[ws_act]-xmin[ws_act]) > (ymax[ws_act]-ymin[ws_act]))
		     chh = ch_percent*(xmax[ws_act]-xmin[ws_act]);
		  else
		     chh = ch_percent*(ymax[ws_act]-ymin[ws_act]);

		  if (para[ws_act].size.su == 360. &&
		      para[ws_act].size.sv == 180.)
		  {
		     Xmin[ws_act] = xmin[ws_act];
		     Xmax[ws_act] = xmax[ws_act];
		     Ymin[ws_act] = ymin[ws_act];
		     Ymax[ws_act] = ymax[ws_act];
		     chh = 0.75*chh;
		  }

		  else
		  {
		     Xmin[ws_act] = xmin[ws_act] - 15.*chh;
		     Xmax[ws_act] = xmax[ws_act] + 15.*chh; 
		     Ymin[ws_act] = ymin[ws_act] - 2. *chh;
		     Ymax[ws_act] = ymax[ws_act] + 2. *chh;
		  }

		  if (setup[ws_act] == FALSE)
		     gks_setup(ws_id);
		  else
		  {
		     check_setup(xmin_old[ws_act], xmax_old[ws_act], 
			    ymin_old[ws_act], ymax_old[ws_act], ws_id);
		  }

		  if (psout[ws_act] == NULL)
		     open_psfile(psfile[ws_act]);
		  if (gifout[ws_act] == NULL)
		     open_giffile(giffile[ws_act]);

		  gsetlinecolourind(grid_color[ws_act]);
		  f_color(grid_color[ws_act]);

		  update_data(para[ws_act].pcent.lon,
			      para[ws_act].pcent.lat,
			      para_old[ws_act].pcent.lon,
			      para_old[ws_act].pcent.lat);

		  update_data(para[ws_act].mcent.lon,
			      para[ws_act].mcent.lat,
			      para_old[ws_act].mcent.lon,
			      para_old[ws_act].mcent.lat);

		  update_data(para[ws_act].size.su,
			      para[ws_act].size.sv,
			      para_old[ws_act].size.su,
			      para_old[ws_act].size.sv);

		  update_str(cs_name[csproj[ws_act]],
			     cs_name[csproj_old[ws_act]]);

		  update_str(para_old[ws_act].proj, para[ws_act].proj);

		  if (erase[ws_act]==TRUE)
		  {
		     gclearws(ws_id, 1);
		     open_psfile(psfile[ws_act]);
		     open_giffile(giffile[ws_act]);
		     f_color(grid_color[ws_act]);
		     if (!redr_flag)
		     {
			if (redrfile[ws_act] != NULL)
			   fclose(redrfile[ws_act]);
			redrfile[ws_act] = fopen(redrname[ws_act], "w");
			ini_redr(redrfile[ws_act]);
		     }
		     map_num[ws_act] = 0;
		  }

		  gks_border(xmin[ws_act], xmax[ws_act], 
			     ymin[ws_act], ymax[ws_act]);

		  xmin_old[ws_act] = xmin[ws_act];
		  xmax_old[ws_act] = xmax[ws_act];
		  ymin_old[ws_act] = ymin[ws_act];
		  ymax_old[ws_act] = ymax[ws_act];

		  para_old[ws_act].pcent.lon = para[ws_act].pcent.lon;
		  para_old[ws_act].pcent.lat = para[ws_act].pcent.lat;
		  para_old[ws_act].mcent.lon = para[ws_act].mcent.lon;
		  para_old[ws_act].mcent.lat = para[ws_act].mcent.lat;
		  para_old[ws_act].size.su   = para[ws_act].size.su;
		  para_old[ws_act].size.sv   = para[ws_act].size.sv;
		  csproj_old[ws_act]       = csproj[ws_act];
		  strcpy(para_old[ws_act].proj, para[ws_act].proj);

		  if (redr_flag == FALSE)
		     save_redr(ws_act, "border");

		  erase[ws_act] = FALSE;
		  border[ws_act] = 0;

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

	          break;




	    case CCONV:

		  if (cntcheck("cconv", cmdc, 5, 0))
		     break;
		  
		  longi_tmp = atof(cmdv[1]);
		  lati_tmp  = atof(cmdv[2]);
		  strcpy(tmp_oldcs, cmdv[3]);
		  strcpy(tmp_newcs, cmdv[4]);

		  trans_center(longi_tmp, lati_tmp, tmp_oldcs, tmp_newcs,
			   &plon, &plat);

		  if (mode == SERVER && !redr_flag && !script_flag)
		  {
		     sprintf(msgstr, "[struct plon=%-g, plat=%-g]",
			glon, glat);

		     svcreturn(RETURN, OK, msgstr, STRUCTURE);
		  }
		  else
		  {
		     printf("(%-g, %-g) %s -> (%-g, %-g) %s\n", 
			longi_tmp, lati_tmp, tmp_oldcs, glon, glat, tmp_newcs);
		     fflush(stdout);
		  }

		  break;





	       case CD:

		  if (cntcheck("cd", cmdc, 1, 2))
		     break;
		  
		  if (cmdc == 1)
		  {
		     if (!fullpath(path_tmp, "~"))
			printf("undefined directory\n");
		  }

		  else if (cmdv[1][0] == '~')
		  {
		     if (!fullpath(path_tmp, cmdv[1]))
		     {
			svcreturn(RETURN, ERROR, 
			   "cd: Undefined directory.", SCALAR);

			break;
		     }
		  }

		  else 
		  {
		     *path_tmp = '\0';
		     strcpy(path_tmp, cmdv[1]);
		  }

		  if (chdir(path_tmp) != 0)
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf("%s is unreachable.\n", path_tmp);
			(void) fflush(stdout);
		     }
		     else
		     {
			sprintf(msgstr, "cd: %s is unreachable.", path_tmp);
			svcreturn(RETURN, ERROR, msgstr, SCALAR);
			break;
		     }
		  }

		  if (mode == SERVER && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;





	       case CURSOR:

		  if(!use_x)
		  {
		     svcreturn(RETURN, ERROR, 
			"cursor: No interactive window in this mode.", SCALAR);
		     break;
		  }

		  if (cntcheck("cursor", cmdc, 1, 0))
		     break;
		  
		  ginqopst(&state);

		  if (state == GGKCL)
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf("Can't open graphics.\n");
			(void) fflush(stdout);
		     }

		     else if (mode == SERVER)
			svcreturn(RETURN, ERROR, 
			   "cursor: Can't open graphics.", SCALAR);
			
		     break;
		  }

		  else 
		  {
		     ginqopenws(&wsopen);
		     if (wsopen.number == 0)
		     {
			if (mode == INTERACTIVE)
			{
			   (void) printf("Can't open window.\n");
			   (void) fflush(stdout);
			}

			else if (mode == SERVER)
			   svcreturn(RETURN, ERROR, 
			      "cursor: Can't open window.", SCALAR);
			
			break;
		     }

		     else
		     {
			set_cursor(XC_crosshair);
			cmdcur = 1;
		     }
		  }

		  if (mode == SERVER && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

	          break;





	       case CLOSE:

		  if (cntcheck("close", cmdc, 1, 0))
		     break;
		  
		  isopen = FALSE; 

		  ginqopenws(&wsopen);
		  for (i=0; i<wsopen.number; i++)
		  {
		     if (wsopen.integers[i] == ws_id)
		     {
			isopen = TRUE;
			gdeactivatews(ws_id);
			gclosews(ws_id);
			break;
		     }
		  }

		  if (isopen == FALSE)
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf("Window %d is not open.\n", ws_id);
			(void) fflush(stdout);
		     }

		     else if (mode == SERVER)
			svcreturn(RETURN, ERROR, "Window is not open.", SCALAR);
		     
		     break;
		  }

		  if (mode == SERVER && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;





	       case DCS:

		  if (cntcheck("dcs", cmdc, 2, 4))
		     break;

		  strcpy(bjdata[ws_act], "B"); 
		  eqnxdata[ws_act] = 1950.;

		  if (cmdc == 3)
		  {
		     if (!Isnumber(cmdv[2]))
		     {
		        strcpy(bjdata[ws_act], cmdv[2]);
			if (bjdata[ws_act][0] == 'B')
			   eqnxdata[ws_act] = 1950.;
                        else if (bjdata[ws_act][0] == 'J')
			   eqnxdata[ws_act] = 2000.;
		     }
		     else
		     {
		        eqnxdata[ws_act] = atof(cmdv[2]);
			if (eqnxproj[ws_act] < 2000.)
			   strcpy(bjdata[ws_act], "B");
                        else
			   strcpy(bjdata[ws_act], "J");
		     }
		  }

		  else if (cmdc == 4)
		  {
		     strcpy(bjdata[ws_act], cmdv[2]);
		     eqnxdata[ws_act] = atof(cmdv[3]);
		  }

		  if(set_dcs(cmdv[1], bjdata[ws_act]))
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf("Invalid system.\n");
			(void) fflush(stdout);
		     }

		     else if (mode == SERVER)
			svcreturn(RETURN, ERROR, 
			   "dcs: Invalid system.", SCALAR);
		     
		     break;
		  }

		  if (!pcs_done[ws_act])
		     csproj[ws_act] = csdata[ws_act];

		  if (!gcs_done[ws_act])
		     csgrid[ws_act] = csdata[ws_act];

                  if (csgrid[ws_act] == 1)
		     grid_eq = TRUE;
                  else
		     grid_eq = FALSE;
		  dcs_done[ws_act] = TRUE;

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;





	       case DEBUGFLAG:

		  if (cntcheck("debug", cmdc, 1, 0))
		     break;
		  
		  if (mode == SERVER)
		  {
		     svcreturn(RETURN, ERROR, 
		     "No debug in server mode", SCALAR);

		     break;
		  }

		  debug = !debug;
		  (void) printf("debug flag = %d\n", debug);
		  (void) fflush(stdout);

		  break;





	       case DIR:

		  if (cntcheck("dir", cmdc, 1, 0))
		     break;
		  
		  if (mode == SERVER)
		  {
		     svcreturn(RETURN, ERROR, 
		     "dir: No directory command in server mode", SCALAR);

		     break;
		  }

		  stat = system("ls");
		  if(stat < 0)
		  {
		     (void) printf("'ls' command failed.\n");
		     (void) fflush(stdout);
		  }

		  break;





	       case DOT:

		  if (cntcheck("dot", cmdc, 1, 4))
		     break;
		  
		  if(cmdc > 2)
		  {
		     longi[ws_act] = atof(cmdv[1]);
		     lati[ws_act]  = atof(cmdv[2]);
		     if (longi[ws_act] >  180.) longi[ws_act] -= 360.;
		     if (longi[ws_act] < -180.) longi[ws_act] += 360.;
		  }

		  check_ws();

		  if (setup[ws_act] == FALSE)
		     gks_setup(ws_id);

		  else
		     check_setup(xmin_old[ws_act], xmax_old[ws_act],
				 ymin_old[ws_act], ymax_old[ws_act], ws_id);

                  if (psout[ws_act] == NULL)
		     open_psfile(psfile[ws_act]);
                  if (gifout[ws_act] == NULL)
		     open_giffile(giffile[ws_act]);

		  gsetlinecolourind(grid_color[ws_act]);
		  f_color(grid_color[ws_act]);

		  update_data(para[ws_act].pcent.lon,
			      para[ws_act].pcent.lat,
			      para_old[ws_act].pcent.lon,
			      para_old[ws_act].pcent.lat);

                  update_data(para[ws_act].mcent.lon,
			      para[ws_act].mcent.lat,
                              para_old[ws_act].mcent.lon,
			      para_old[ws_act].mcent.lat);
                  
		  update_data(para[ws_act].size.su,
			      para[ws_act].size.sv,
			      para_old[ws_act].size.su,
			      para_old[ws_act].size.sv);

		  update_str(para_old[ws_act].proj, para[ws_act].proj);
		  update_str(cs_name[csproj[ws_act]], cs_name[csproj_old[ws_act]]);

		  if ((xmax[ws_act]-xmin[ws_act]) > (ymax[ws_act]-ymin[ws_act]))
		     exp = 0.01*sexp[ws_act]*(xmax[ws_act] - xmin[ws_act]);
		  else
		     exp = 0.01*sexp[ws_act]*(ymax[ws_act] - ymin[ws_act]);

		  gsetlinecolourind(symbol_color[ws_act]);
		  gsetfillcolourind(symbol_color[ws_act]);
		  f_color(symbol_color[ws_act]);

		  drawsymbol(longi[ws_act], lati[ws_act], nsides[ws_act], 
			 ptype[ws_act], exp, mang[ws_act]);

		  if (mode == SERVER && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;





	       case DRAW:
		  
		  if (cntcheck("draw", cmdc, 3, 4))
		     break;

		  jcgflag = 1;
                  if (setup[ws_act] == FALSE)
		     gks_setup(ws_id);
                  
		  longi1[ws_act] = atof(cmdv[1]);
		  lati1[ws_act]  = atof(cmdv[2]);

		  if(cmdc == 4)
		     strcpy(curtype, cmdv[3]);
		  else
		     strcpy(curtype, "great");

		  gsetlinecolourind(symbol_color[ws_act]);

		  f_color(symbol_color[ws_act]);

		  skycurve( longi[ws_act], lati[ws_act], 
			 longi1[ws_act], lati1[ws_act], curtype); 

		  longi[ws_act] = longi1[ws_act];
		  lati[ws_act]  = lati1[ws_act];

		  ldraw_setup(longi[ws_act], lati[ws_act]);

		  jcgflag = 0;

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;





	       case LCIRCLE:

		  if (cntcheck("lcircle", cmdc, 2, 0))
		     break;
		  
		  jcgflag = 1;
                  if (setup[ws_act] == FALSE)
		     gks_setup(ws_id);
                  
		  tmpr = atof(cmdv[1]);

		  reflon = longi[ws_act];
		  reflat = lati[ws_act];

		  gsetlinecolourind(symbol_color[ws_act]);

		  f_color(symbol_color[ws_act]);

		  ldraw_setup(longi[ws_act], lati[ws_act]);

		  for(i=0; i<360; ++i)
		  {
		     tmpx = tmpr * cos(i*dtr);
		     tmpy = tmpr * sin(i*dtr);

		     ldraw_transform(tmpx, tmpy, 
				     &longi1[ws_act], &lati1[ws_act]);

                     if(i == 0)
		     {
			longi[ws_act] = longi1[ws_act];
			lati[ws_act]  = lati1[ws_act];
		     }

		     skycurve( longi[ws_act], lati[ws_act], 
			      longi1[ws_act], lati1[ws_act], "great"); 

		     longi[ws_act] = longi1[ws_act];
		     lati[ws_act]  = lati1[ws_act];
		  }

		  longi[ws_act] = reflon;
		  lati[ws_act]  = reflat;

		  jcgflag = 0;

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;





	       case LDRAW:
		  
		  if (cntcheck("ldraw", cmdc, 3, 0))
		     break;

		  jcgflag = 1;
                  if (setup[ws_act] == FALSE)
		     gks_setup(ws_id);
                  
		  tmpx = atof(cmdv[1]);
		  tmpy = atof(cmdv[2]);

		  ldraw_transform(tmpx, tmpy, 
				  &longi1[ws_act], &lati1[ws_act]);

		  gsetlinecolourind(symbol_color[ws_act]);

		  f_color(symbol_color[ws_act]);

		  skycurve( longi[ws_act], lati[ws_act], 
			 longi1[ws_act], lati1[ws_act], "great"); 

		  longi[ws_act] = longi1[ws_act];
		  lati[ws_act]  = lati1[ws_act];

		  jcgflag = 0;

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;




	       case LMOVE:

		  if (cntcheck("lmove", cmdc, 3, 0))
		     break;
		  
		  tmpx = atof(cmdv[1]);
		  tmpy = atof(cmdv[2]);

		  ldraw_transform(tmpx, tmpy, 
				  &longi[ws_act], &lati[ws_act]);

		  if (longi[ws_act] >  180.) longi[ws_act] -= 360.;
		  if (longi[ws_act] < -180.) longi[ws_act] += 360.;

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;




	       case LROTATE:

		  if (cntcheck("lrotate", cmdc, 2, 0))
		     break;
		  
		  tmpr = atof(cmdv[1]);

		  ldraw_rotate(tmpr);

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;




	       case EPOCH:

		  if (cntcheck("epoch", cmdc, 2, 0))
		     break;

		  epoch[ws_act] = atof(cmdv[1]);
		  break;



	       case ERASE:

		  if (cntcheck("erase", cmdc, 1, 0))
		     break;
	       
		  isopen              = FALSE;
		  setup[ws_act]       = FALSE;

		  ginqopenws(&wsopen);
		  for (i=0; i<wsopen.number; i++)
		  {
		     if (wsopen.integers[i] == ws_id)
		     {
			isopen = TRUE;
			gclearws(ws_id, 1);
			open_psfile(psfile[ws_act]);
			open_giffile(giffile[ws_act]);
			f_color(grid_color[ws_act]);

			if (redrfile[ws_act] != NULL)
			   fclose(redrfile[ws_act]);

			redrfile[ws_act] = fopen(redrname[ws_act], "w");
			ini_redr(redrfile[ws_act]);
			map_num[ws_act] = 0;

			break;
		     }
		  }

		  if (isopen == FALSE)
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf("Window %d is not open\n", ws_id);
			(void) fflush(stdout);
		     }

		     else
			svcreturn(RETURN, ERROR, "Window is not open", SCALAR);

		     break;
		  }

		  if (mode == SERVER && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;




	       case COLOR:

		  if (cntcheck("color", cmdc, 2, 3))
		     break;
		  
		  color_found = FALSE;

		  if (cmdc >= 2)
		  {
		     if (Isnumber(cmdv[1]))
			cind = atoi(cmdv[1]);

		     else
		     {
			for (i=0; i<var_num; i++)
			   if (strcmp(cmdv[1], var[i]) ==0)
			   {
			      colrcol = i;
			      color_found = TRUE;
			   }

			if (color_found == FALSE)
			{
			   switch(cs(cmdv[1]))
			   {
			      case   BLACK: cind = 0; break;
			      case   WHITE: cind = 1; break;
			      case     RED: cind = 2; break;
			      case   GREEN: cind = 3; break;
			      case  YELLOW: cind = 4; break;
			      case    BLUE: cind = 5; break;
			      case MAGENTA: cind = 6; break;
			      case    CYAN: cind = 7; break;

			      default:
				 bad = 1;
				 if (mode == INTERACTIVE)
				 {
				    (void) printf("Illegal color.\n");
				    (void) fflush(stdout);
				 }

				 else if (mode == SERVER)
				    svcreturn(RETURN, ERROR, 
				    "color: Illegal color.", SCALAR);
			      break;
			  }

			  if(bad == 1)
			  {
			     bad = 0;
			     break;
			  }
		       }
		    }

		     if (cmdc == 2)
		     {
			 label_color[ws_act] = cind;
		 	  grid_color[ws_act] = cind;
			symbol_color[ws_act] = cind;
			   loc_color[ws_act] = cind;
		     }

		     else if (cmdc == 3)
		     {
			switch(cs(cmdv[2]))
			{
			   case   LABEL:  label_color[ws_act] = cind; break;
			   case    GRID:   grid_color[ws_act] = cind; break;
			   case  SYMBOL: symbol_color[ws_act] = cind; break;
			   case LOCATOR:    loc_color[ws_act] = cind; break;
			}
		     }
		  }

		  if (!script_flag)
		  {
		     gc_ori[ws_act] = grid_color[ws_act];
		     sc_ori[ws_act] = symbol_color[ws_act];
		  }

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);
		  
		  break;





	       case CONTOUR:

		  imap_plate=0;
		  if (cntcheck("contour", cmdc, 1, 2))
		     break;
		  

		  if (cmdc == 2)
		  {
		     level_current = 0;
		     poly_current  = 0;
		     pts_current   = 0;

		     if (fimage != 0)
			(void) fclose(fimage);

		     if ((fimage = fopen(cmdv[1], "r")) == NULL)
		     {
			if (mode == INTERACTIVE)
			{
			   (void) printf("file %s not found\n", cmdv[1]);
			   (void) fflush(stdout);
			}

			else if (mode == SERVER)
			   svcreturn(RETURN, ERROR, "file not found", SCALAR);

			break;
		     }

		     else
		     {
			if (init_contours() == 1)
			   break;

			while(fgets(line, MAXLINE, fimage) != (char *)NULL)
			{
			   line[strlen(line)-1] = '\0';

			   strcpy(dum, line);
		  
			   if (!strncmp(dum, "pixels", 6))
			   {
			      ptr = dum + 11;
			      pixels = atoi(ptr);
			   }

			   else if (!strncmp(dum, "lines", 5))
			   {
			      ptr = dum + 11;
			      lines = atoi(ptr);
			   }

			   else if (!strncmp(dum, "glong", 5))
			   {
			      ptr = dum + 11;
			      ilon0 = atof(ptr);
			   }

			   else if (!strncmp(dum, "glat", 4))
			   {
			      ptr = dum + 11;
			      ilat0 = atof(ptr);
			   }

			   else if (!strncmp(dum, "cdelt1", 6))
			   {
			      ptr = dum + 11;
			      cdelt1 = atof(ptr);
			   }

			   else if (!strncmp(dum, "cdelt2", 6))
			   {
			      ptr = dum + 11;
			      cdelt2 = atof(ptr);
			   }

			   else if (!strncmp(dum, "crpix1", 6))
			   {
			      ptr = dum + 11;
			      crpix1 = atof(ptr);
			   }

			   else if (!strncmp(dum, "crpix2", 6))
			   {
			      ptr = dum + 11;
			      crpix2 = atof(ptr);
			   }

			   else if (!strncmp(dum, "maptype", 7))
			   {
			      ptr = dum + 12;
			      if (!strncmp(ptr, "gno", 3))
				 imap_inv = g_inverse;
			      else if (!strncmp(ptr, "ait", 3))
				 imap_inv = a_inverse;
			      else if (!strncmp(ptr, "cyl", 3) 
				    || !strncmp(ptr, "lin", 3))
				 imap_inv = cy_inverse;
                              else if (!strncmp(ptr, "ncp", 3))
				 imap_inv = nc_inverse;
                              else if (!strncmp(ptr, "ort", 3))
				 imap_inv = or_inverse;
                              else if (!strncmp(ptr, "car", 3))
				 imap_inv = ca_inverse;
                              else if (!strncmp(ptr, "pla", 3))
			      {
				 imap_plate = 1;
				 imap_inv = pl_inverse;
			      }
			      else 
			      {
				 if (mode == INTERACTIVE)
				 {
			            (void) printf("Illegal projection type\n");
			            (void) fflush(stdout);
				 }
			         else if (mode == SERVER)
				 {
			            svcreturn(RETURN, ERROR, 
			            "projection: Illegal projection type", 
				    SCALAR);
				 }
				 break;
			      }
			   }

			   else if (!strncmp(dum, "csys", 4))
			   {
			      ptr = dum + 12;
			      strcpy(csimage, ptr);
			   }

			   else if (!strncmp(dum, "equinox", 7))
			   {
			      ptr = dum + 11;
			      eqnximage[ws_act] = atof(ptr);
			      guess_ics(csimage, eqnximage[ws_act]);
			   }

			   else if (!strncmp(dum, "epoch", 5))
			   {
			      ptr = dum + 11;
			      epoch[ws_act] = atof(ptr);
			   }

			   else if (!strncmp(dum, "pixels", 6))
			   {
			      ptr = dum + 11;
			      imag_naxis1 = atof(ptr);
			   }

			   else if (!strncmp(dum, "lines", 5))
			   {
			      ptr = dum + 11;
			      imag_naxis2 = atof(ptr);
			   }

			   else if (!strncmp(dum, "platescale", 10))
			   {
			      ptr = dum + 11;
			      coef_set->plt_scale = atof(ptr);
			   }

			   else if (!strncmp(dum, "platera", 7))
			   {
			      ptr = dum + 11;
			      coef_set->plate_ra = atof(ptr)*dtr;
			   }

			   else if (!strncmp(dum, "platedec", 8))
			   {
			      ptr = dum + 11;
			      coef_set->plate_dec = atof(ptr)*dtr;
			   }

			   else if (!strncmp(dum, "platexsz", 8))
			   {
			      ptr = dum + 11;
			      coef_set->x_pixel_size = atof(ptr);
			   }

			   else if (!strncmp(dum, "plateysz", 8))
			   {
			      ptr = dum + 11;
			      coef_set->y_pixel_size = atof(ptr);
			   }

			   else if (!strncmp(dum, "platexoff", 8))
			   {
			      ptr = dum + 11;
			      coef_set->x_pixel_offset = atof(ptr);
			   }

			   else if (!strncmp(dum, "plateyoff", 8))
			   {
			      ptr = dum + 11;
			      coef_set->y_pixel_offset = atof(ptr);
			   }

			   else if (!strncmp(dum, "amdx", 4))
			   {
			      *dum1='\0';
			      strcpy(dum1, dum);
			      dum1[10] = '\0';
			      ptr=dum1+4;
			      index = atoi(ptr);
			      ptr=dum+11;
			      coef_set->amd_x_coeff[index-1] = atof(ptr);
			   }

			   else if (!strncmp(dum, "amdy", 4))
			   {
			      *dum1='\0';
			      strcpy(dum1, dum);
			      dum1[10] = '\0';
			      ptr=dum1+4;
			      index = atoi(ptr);
			      ptr=dum+11;
			      coef_set->amd_y_coeff[index-1] = atof(ptr);
			   }

			   else if (!strncmp(dum, "ppo", 3))
			   {
			      *dum1='\0';
			      strcpy(dum1, dum);
			      dum1[10] = '\0';
			      ptr=dum1+3;
			      index = atoi(ptr);
			      ptr=dum+11;
			      coef_set->ppo_coeff[index-1] = atof(ptr);
			   }

			   else if (!strncmp(dum, "#l", 2))
			   {
			      dum[16] = '\0';
			      ptr = dum + 2;
			      level = atof(ptr);
			      ptr = line + 17;
			      npoly = atoi(ptr);
			      conts[level_current].npoly = npoly;
			      poly_current = 0;
			   }

			   else if (!strncmp(dum, "#c", 2))
			   {
			      dum[12]    = '\0';
			      ptr = dum + 2;
			      poly_current = atoi(ptr);
			      ptr  = line + 15;
			      npts = atoi(ptr); 
			      conts[level_current].poly[poly_current]->npts = npts;
			      pts_current  = 0;
			   }

			   else if (pts_current < npts)
			   {
			      dum[12] = '\0';
			      ptr = line + 13;

			      conts[level_current].poly[poly_current]->pnt[pts_current]->x = atof(dum);
			      conts[level_current].poly[poly_current]->pnt[pts_current]->y = atof(ptr);
			      pts_current++;

			      if (pts_current == conts[level_current].poly[poly_current]->maxpts)
			      {
				 conts[level_current].poly[poly_current]->maxpts 
				 += CPOLY_MAXPINC;
				 conts[level_current].poly[poly_current]->pnt
				    = (CPOLY_PNT **) realloc((char *) 
				 conts[level_current].poly[poly_current]->pnt, 
				 (unsigned)(conts[level_current].poly[poly_current]->maxpts
				      * sizeof(CPOLY_PNT *)));

				 for (j=pts_current; 
				     j<conts[level_current].poly[poly_current]->maxpts; 
				     ++j)
				 {
				    conts[level_current].poly[poly_current]->pnt[j]
				    = (CPOLY_PNT *) 
				    malloc((unsigned)(sizeof(CPOLY_PNT)));
				    if (conts[level_current].poly[poly_current]->pnt[j] == NULL)
				    {
				       svcreturn(SIGNAL, ERROR, "Can't allocate required memory.", SCALAR);
				       exit(1);
				    }
				 }
			      }

			      if (pts_current == contpts_max)
			      {
				 contpts_max += CPOLY_MAXPINC;
				 contpts = (Gpoint *)realloc((char *)contpts, 
					   (unsigned int) 
					   (contpts_max*sizeof(Gpoint)));
			      }

			      if (pts_current == npts)
			      {
				 poly_current++;

				 if (poly_current == poly_max[level_current])
				 {
				    poly_max[level_current] += CPOLY_MAXCINC;
				    conts[level_current].poly
				    = (CPOLYN **)
				    realloc((char *) conts[level_current].poly,
				    (unsigned)(poly_max[level_current] * sizeof(CPOLYN *)));
			   
				    for(i=poly_current; i<poly_max[level_current]; ++i)
				    {
				       conts[level_current].poly[i] 
				       = (CPOLYN *)
					 malloc((unsigned)(sizeof(CPOLYN)));
                                       if (conts[level_current].poly[i] == NULL)
				       {
					  svcreturn(SIGNAL, ERROR, "Can't allocate required memory.", SCALAR);
					  exit(1);
				       }

				       conts[level_current].poly[i]->npts = 0;
				       conts[level_current].poly[i]->maxpts = CPOLY_MAXPINC;

				       conts[level_current].poly[i]->pnt
				       = (CPOLY_PNT **)
				       malloc((unsigned)(CPOLY_MAXPINC * sizeof(CPOLY_PNT *)));
				       if (conts[level_current].poly[i]->pnt == NULL)
				       {
					  svcreturn(SIGNAL, ERROR, "Can't allocate required memory.", SCALAR);
					  exit(1);
				       }

				       for(j=0; j<CPOLY_MAXPINC; ++j)
				       {
					  conts[level_current].poly[i]->pnt[j]
					  = (CPOLY_PNT *)
					 malloc((unsigned)(sizeof(CPOLY_PNT)));
					 if (conts[level_current].poly[i]->pnt[j] == NULL)
					 {
					    svcreturn(SIGNAL, ERROR, "Can't allocate required memory.", SCALAR);
					    exit(1);
					 }
				       }
				    }
				 }
			      }

			      if (pts_current == npts && poly_current == npoly)
			      {
				 level_current++;
				 if (level_current == maxlvl)
				 {
				    maxlvl += MAXLVL;
				    poly_max = (int *)realloc((char *)poly_max,
					       (unsigned)(maxlvl * sizeof(int)));
				    conts = (CPOLY *)realloc((char *)conts,
				    (unsigned)(maxlvl * sizeof(CPOLY)));

				    for (i=level_current; i<maxlvl; i++)
				    {
				       poly_max[i] = CPOLY_MAXC;
				       conts[i].npoly = 0;
				       conts[i].poly  = (CPOLYN **)
						 malloc((unsigned)(CPOLY_MAXC * 
						 sizeof(CPOLYN *)));
				       if (conts[i].poly == NULL)
				       {
					  svcreturn(SIGNAL, ERROR, "Can't allocate required memory.", SCALAR);
					  exit(1);
				       }

				       for (j=0; j<CPOLY_MAXC; ++j)
				       {
					   conts[i].poly[j] = (CPOLYN *)
						 malloc((unsigned)(sizeof(CPOLYN)));
					   if (conts[i].poly[j] == NULL)
					   {
					      svcreturn(SIGNAL, ERROR, "Can't allocate required memory.", SCALAR);
					      exit(1);
					   }
					   conts[i].poly[j]->npts = 0;
					   conts[i].poly[j]->maxpts = CPOLY_MAXPINC;

					   conts[i].poly[j]->pnt
					   = (CPOLY_PNT **) malloc((unsigned)
					     (CPOLY_MAXPINC * sizeof(CPOLY_PNT *)));
					   if (conts[i].poly[j]->pnt == NULL)
					   {
					      svcreturn(SIGNAL, ERROR, "Can't allocate required memory.", SCALAR);
					      exit(1);
					   }
					   for (k=0; k<CPOLY_MAXPINC; ++k)
					   {
					      conts[i].poly[j]->pnt[k] = (CPOLY_PNT *)
					      malloc((unsigned)(sizeof(CPOLY_PNT)));
					      if (conts[i].poly[j]->pnt[k] == NULL)
					      {
					         svcreturn(SIGNAL, ERROR, "Can't allocate required memory.", SCALAR);
						 exit(1);
					      }
					   }
				       }
				    }
				 }
			      }
			   }
			}
		     }
		  }

		     check_ws();
		  
		     if (pla_done[ws_act])
		     {
		        xmin[ws_act] = 1.;
		        ymin[ws_act] = 1.;
		        xmax[ws_act] = naxis1;
		        ymax[ws_act] = naxis2;
		     }

		     else
		     {
		        setcs(flag[ws_act], 0, para[ws_act].mcent.lon,
		          para[ws_act].mcent.lat, &u0[ws_act], &v0[ws_act]);

		        xmin[ws_act] = u0[ws_act] - (para[ws_act].size.su)/2.;
		        xmax[ws_act] = u0[ws_act] + (para[ws_act].size.su)/2.;
		        ymin[ws_act] = v0[ws_act] - (para[ws_act].size.sv)/2.;
		        ymax[ws_act] = v0[ws_act] + (para[ws_act].size.sv)/2.;
		     }

		     if (   (xmax[ws_act]-xmin[ws_act]) 
		          > (ymax[ws_act]-ymin[ws_act]))
		         chh = ch_percent*(xmax[ws_act]-xmin[ws_act]);
		     else
		         chh = ch_percent*(ymax[ws_act]-ymin[ws_act]);

		     if (para[ws_act].size.su == 360. &&
		         para[ws_act].size.sv == 180.)
		     {
		        Xmin[ws_act] = xmin[ws_act];
		        Xmax[ws_act] = xmax[ws_act];
		        Ymin[ws_act] = ymin[ws_act];
		        Ymax[ws_act] = ymax[ws_act];
			chh = 0.75*chh;
		     }

		     else
		     {
		        Xmin[ws_act] = xmin[ws_act] - 15.*chh;
		        Xmax[ws_act] = xmax[ws_act] + 15.*chh; 
		        Ymin[ws_act] = ymin[ws_act] - 2. *chh;
		        Ymax[ws_act] = ymax[ws_act] + 2. *chh;
		     }

		     if (setup[ws_act] == FALSE)
			gks_setup(ws_id);

		     else
			check_setup(xmin_old[ws_act], xmax_old[ws_act],
				 ymin_old[ws_act], ymax_old[ws_act], ws_id);

		     if (psout[ws_act] == NULL)
			open_psfile(psfile[ws_act]);
		     if (gifout[ws_act] == NULL)
			open_giffile(giffile[ws_act]);
		
		     gsetlinecolourind(grid_color[ws_act]);
		     f_color(grid_color[ws_act]);

		     update_data(para[ws_act].pcent.lon,
			      para[ws_act].pcent.lat,
			      para_old[ws_act].pcent.lon,
			      para_old[ws_act].pcent.lat);

		     update_data(para[ws_act].mcent.lon,
			      para[ws_act].mcent.lat,
			      para_old[ws_act].mcent.lon,
			      para_old[ws_act].mcent.lat);

		     update_data(para[ws_act].size.su,
			      para[ws_act].size.sv,
			      para_old[ws_act].size.su,
			      para_old[ws_act].size.sv);

		     update_str(para_old[ws_act].proj, para[ws_act].proj);
		     update_str(cs_name[csproj[ws_act]], cs_name[csproj_old[ws_act]]);

		     if (erase[ws_act]==TRUE)
		     {
			gclearws(ws_id, 1);
			open_psfile(psfile[ws_act]);
			open_giffile(giffile[ws_act]);
			f_color(grid_color[ws_act]);
			if (!redr_flag)
			{
			   if (redrfile[ws_act] != NULL)
			   fclose(redrfile[ws_act]);
			   redrfile[ws_act] = fopen(redrname[ws_act], "w");
			   ini_redr(redrfile[ws_act]);
			}
		     }

		     tr = AA[ics][csproj[ws_act]];

		     for (i=0; i<level_current; i++)
		     {
			for (j=0; j<conts[i].npoly; ++j)
			{
			   kno=0;
			   for (k=0; k<conts[i].poly[j]->npts; ++k)
			   {
			      lon0r = ilon0 * dtr;
			      lat0r = ilat0 * dtr;
			      if (imap_plate != TRUE)
			      {
				 if(cdelt2 >= 0)
			         imap_inv(-cdelt1*(conts[i].poly[j]->pnt[k]->x
				               +0.5-crpix1),
			                   cdelt2*(conts[i].poly[j]->pnt[k]->y
				               +0.5-crpix2), &glon, &glat);
				 else
				 imap_inv(-cdelt1*(conts[i].poly[j]->pnt[k]->x
					       +0.5-crpix1),
			       cdelt2*(imag_naxis2-(conts[i].poly[j]->pnt[k]->y
					       +0.5)-crpix2), &glon, &glat);

			      }
			      else 
			      {
			         imap_inv(conts[i].poly[j]->pnt[k]->x+0.5,
			               conts[i].poly[j]->pnt[k]->y+0.5, 
				       &glon, &glat);
			      }
		              jcnvc2(sysimage[ws_act], eqnximage[ws_act], 
				     glon, glat, 
				     sysproj[ws_act], eqnxproj[ws_act], 
				     &longi[ws_act], &lati[ws_act], 
				     epoch[ws_act]);
			      lon0r = para[ws_act].pcent.lon * dtr;
			      lat0r = para[ws_act].pcent.lat * dtr;

			      map[ws_act](longi[ws_act], lati[ws_act], 
				          &tmpx, &tmpy);

			      if (tmpx >= xmin[ws_act] && 
				  tmpx <= xmax[ws_act] &&
				  tmpy >= ymin[ws_act] &&
				  tmpy <= ymax[ws_act])
				 {
				     contpts[kno].x=tmpx;
				     contpts[kno].y=tmpy;
				     kno++;
				 }
			   }
			   gpolyline(kno,   contpts);
			   f_polyline(kno, contpts);
			}
		     }
		  
		     xmin_old[ws_act] = xmin[ws_act];
		     xmax_old[ws_act] = xmax[ws_act];
		     ymin_old[ws_act] = ymin[ws_act];
		     ymax_old[ws_act] = ymax[ws_act];

		     para_old[ws_act].pcent.lon = para[ws_act].pcent.lon;
		     para_old[ws_act].pcent.lat = para[ws_act].pcent.lat;
		     para_old[ws_act].mcent.lon = para[ws_act].mcent.lon;
		     para_old[ws_act].mcent.lat = para[ws_act].mcent.lat;
		     para_old[ws_act].size.su   = para[ws_act].size.su;
		     para_old[ws_act].size.sv   = para[ws_act].size.sv;
		     csproj_old[ws_act]       = csproj[ws_act];
		     strcpy(para_old[ws_act].proj, para[ws_act].proj);

		     if (redr_flag == FALSE)
			save_redr(ws_act, "contour");

		     erase[ws_act] = FALSE;

		     flipsign = 1;

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);
		  
		  break;





	       case CORNERS:
		  if (cntcheck("corners", cmdc, 1, 0))
		     break;

		  if (pla_done[ws_act])
		  {
		     xmin[ws_act] = 1.;
		     ymin[ws_act] = 1.;
		     xmax[ws_act] = naxis1;
		     ymax[ws_act] = naxis2;
		  }

		  else
		  {
		     setcs(flag[ws_act], 0, para[ws_act].mcent.lon,
			para[ws_act].mcent.lat, &u0[ws_act], &v0[ws_act]);
		     
		     xmin[ws_act] = u0[ws_act] - (para[ws_act].size.su)/2.;
		     xmax[ws_act] = u0[ws_act] + (para[ws_act].size.su)/2.;
		     ymin[ws_act] = v0[ws_act] - (para[ws_act].size.sv)/2.;
		     ymax[ws_act] = v0[ws_act] + (para[ws_act].size.sv)/2.;
		  }

		  map_inv[ws_act](xmin[ws_act], ymin[ws_act], 
				  &longi_tmp, &lati_tmp);
                  jcnvc2(sysproj[ws_act], eqnxproj[ws_act], longi_tmp, lati_tmp,
		         sysgrid[ws_act], eqnxgrid[ws_act], &glon, &glat, 
			 epoch[ws_act]);
		  printf("left lower corner is at (%-g, %-g)\n", 
			  glon, glat);

		  map_inv[ws_act](xmin[ws_act], ymax[ws_act], 
				  &longi_tmp, &lati_tmp);
                  jcnvc2(sysproj[ws_act], eqnxproj[ws_act], longi_tmp, lati_tmp,
		         sysgrid[ws_act], eqnxgrid[ws_act], &glon, &glat, 
			 epoch[ws_act]);
		  printf("left upper corner is at (%-g, %-g)\n", 
			  glon, glat);

		  map_inv[ws_act](xmax[ws_act], ymin[ws_act], 
				  &longi_tmp, &lati_tmp);
                  jcnvc2(sysproj[ws_act], eqnxproj[ws_act], longi_tmp, lati_tmp,
		         sysgrid[ws_act], eqnxgrid[ws_act], &glon, &glat, 
			 epoch[ws_act]);
		  printf("right lower corner is at (%-g, %-g)\n", 
			  glon, glat);

		  map_inv[ws_act](xmax[ws_act], xmax[ws_act], 
				  &longi_tmp, &lati_tmp);
                  jcnvc2(sysproj[ws_act], eqnxproj[ws_act], longi_tmp, lati_tmp,
		         sysgrid[ws_act], eqnxgrid[ws_act], &glon, &glat, 
			 epoch[ws_act]);
		  printf("right upper corner is at (%-g, %-g)\n", 
			  glon, glat);

		  break;

	       case GCS:

		  if (cntcheck("gcs", cmdc, 2, 4))
		     break;
		  
		  strcpy(bjgrid[ws_act], "B"); 
		  eqnxgrid[ws_act] = 1950.;

		  if (cmdc == 3)
		  {
		     if (!Isnumber(cmdv[2]))
		     {
		        strcpy(bjgrid[ws_act], cmdv[2]);
			if (bjgrid[ws_act][0] == 'B')
			   eqnxgrid[ws_act] = 1950.;
                        else if (bjgrid[ws_act][0] == 'J')
			   eqnxgrid[ws_act] = 2000.;
		     }
		     else
		     {
		        eqnxgrid[ws_act] = atof(cmdv[2]);
			if (eqnxproj[ws_act] < 2000.)
			   strcpy(bjgrid[ws_act], "B");
                        else
			   strcpy(bjgrid[ws_act], "J");
		     }
		  }

		  else if (cmdc == 4)
		  {
		     strcpy(bjgrid[ws_act], cmdv[2]);
		     eqnxgrid[ws_act] = atof(cmdv[3]);
		  }

		  if(set_gcs(cmdv[1], bjgrid[ws_act]))
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf("Invalid system.\n");
			(void) fflush(stdout);
		     }

		     else if (mode == SERVER)
			svcreturn(RETURN, ERROR, 
			   "gcs: Invalid system.", SCALAR);
		     
		     break;
		  }

		  gcs_done[ws_act] = TRUE;

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;



	       case GEXPAND:

		  if (cntcheck("gexpand", cmdc, 2, 2))
		     break;
		  
		  if (cmdc == 2)
		  {
		     if (Isnumber(cmdv[1]))
			gexpand = atof(cmdv[1]); 
		     else
			gexpand = 1.0;
		  }
		  
		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;





	       case GIFLOC:
	       
		  if (cntcheck("gifloc", cmdc, 3, 3))
		     break;
		  
		  if (!gifsize_set)
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf("ERROR: GIF size must be set first.\n");
			(void) fflush(stdout);
		     }

		     else
		     {
			sprintf(msgstr, "GIF size must be set first.");
			svcreturn(RETURN, ERROR, msgstr, SCALAR);
		     }
		  }
		  else
		  {
		     if (Isnumber(cmdv[1])
		     &&  Isnumber(cmdv[2]))
		     {
			xgif = atof(cmdv[1]);
			ygif = atof(cmdv[2]);

			gif_unscale(xgif, ygif, &u, &v);
			map_inv[ws_act](u, v, &glon, &glat);

			if (mode == INTERACTIVE)
			{
			   (void) printf(
			      "GIF pixel is at: (lon = %-10g, lat = %-10g)\n",
			       glon, glat);

			   (void) fflush(stdout);
			}
			else if (mode == SERVER)
			{
			   (void) printf(
			      "[struct stat=\"OK\", lon=%-g, lat=%-g]\n", 
			       glon, glat);
			   (void) fflush(stdout);
			}

			break;
		     }
		     else
		     {
			if (mode == INTERACTIVE)
			{
			   (void) printf("ERROR: Invalid GIF location (\"%s\",\"%s\").\n", 
			      cmdv[1], cmdv[2]);
			   (void) fflush(stdout);
			}

			else
			{
			   sprintf(msgstr, "Invalid GIF location (\"%s\",\"%s\").\n", 
			      cmdv[1], cmdv[2]);
			   svcreturn(RETURN, ERROR, msgstr, SCALAR);
			}
		     }
		  }

		  break;



	       case GIFSIZE:
	       
		  if (cntcheck("gifsize", cmdc, 2, 2))
		     break;
		  
		  if (gifout[ws_act] != NULL)
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf("ERROR: GIF size must be set before first drawing command.\n");
			(void) fflush(stdout);
		     }

		     else
		     {
			sprintf(msgstr, "GIF size must be set before first drawing command.");
			svcreturn(RETURN, ERROR, msgstr, SCALAR);
		     }
		  }
		  else
		  {
		     if (Isnumber(cmdv[1]))
		     {
			gifsize(atoi(cmdv[1]));
			gifsize_set = TRUE;
		     }
		     else
		     {
			if (mode == INTERACTIVE)
			{
			   (void) printf("ERROR: Invalid GIF size \"%s\".\n", 
			      cmdv[1]);
			   (void) fflush(stdout);
			}

			else
			{
			   sprintf(msgstr, "Invalid GIF size \"%s\".", 
			      cmdv[1]);
			   svcreturn(RETURN, ERROR, msgstr, SCALAR);
			}
		     }
		  }

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);
		  
		  break;



	       case GRID:

		  if (cntcheck("grid", cmdc, 1, 0))
		     break;
		  
		  check_ws();

		  if (pla_done[ws_act])
		     {
		     xmin[ws_act] = 1.;
		     ymin[ws_act] = 1.;
		     xmax[ws_act] = naxis1;
		     ymax[ws_act] = naxis2;
		     }

		  else
		     {
		     setcs(flag[ws_act], 0, para[ws_act].mcent.lon, 
			para[ws_act].mcent.lat, &u0[ws_act], &v0[ws_act]);

		     xmin[ws_act] = u0[ws_act] - (para[ws_act].size.su)/2.;
		     xmax[ws_act] = u0[ws_act] + (para[ws_act].size.su)/2.;
		     ymin[ws_act] = v0[ws_act] - (para[ws_act].size.sv)/2.;
		     ymax[ws_act] = v0[ws_act] + (para[ws_act].size.sv)/2.;

		     }
                  
		  if (   (xmax[ws_act]-xmin[ws_act]) 
		       > (ymax[ws_act]-ymin[ws_act]))
		      chh = ch_percent*(xmax[ws_act]-xmin[ws_act]);
		  else
		      chh = ch_percent*(ymax[ws_act]-ymin[ws_act]);

		  if (para[ws_act].size.su == 360. &&
		      para[ws_act].size.sv == 180.)
		  {
		     Xmin[ws_act] = xmin[ws_act];
		     Xmax[ws_act] = xmax[ws_act];
		     Ymin[ws_act] = ymin[ws_act];
		     Ymax[ws_act] = ymax[ws_act];
		     chh = 0.75*chh;
		  }

		  else
		  {
		     Xmin[ws_act] = xmin[ws_act] - 15.*chh;
		     Xmax[ws_act] = xmax[ws_act] + 15.*chh; 
		     Ymin[ws_act] = ymin[ws_act] - 2. *chh;
		     Ymax[ws_act] = ymax[ws_act] + 2. *chh;
		  }

		  if (setup[ws_act] == FALSE)
		     gks_setup(ws_id);

		  else
		     check_setup(xmin_old[ws_act], xmax_old[ws_act], 
				 ymin_old[ws_act], ymax_old[ws_act], ws_id);

		  if (psout[ws_act] == NULL)
		     open_psfile(psfile[ws_act]);
		  if (gifout[ws_act] == NULL)
		     open_giffile(giffile[ws_act]);

		  gsetlinecolourind(grid_color[ws_act]);
		  f_color(grid_color[ws_act]);

		  update_data(para[ws_act].pcent.lon, 
			      para[ws_act].pcent.lat,
			      para_old[ws_act].pcent.lon,
			      para_old[ws_act].pcent.lat);

		  update_data(para[ws_act].mcent.lon, 
			      para[ws_act].mcent.lat,
			      para_old[ws_act].mcent.lon,
			      para_old[ws_act].mcent.lat);

		  update_data(para[ws_act].size.su, 
			      para[ws_act].size.sv,
			      para_old[ws_act].size.su,
			      para_old[ws_act].size.sv);

		  update_str(para_old[ws_act].proj, para[ws_act].proj);
		  update_str(cs_name[csproj[ws_act]], cs_name[csproj_old[ws_act]]);

		  if (erase[ws_act]==TRUE)
		  {
		     gclearws(ws_id, 1);
		     open_psfile(psfile[ws_act]);
		     open_giffile(giffile[ws_act]);
		     f_color(grid_color[ws_act]);
		     if (!redr_flag)
		     {
			if (redrfile[ws_act] != NULL)
			   fclose(redrfile[ws_act]);
			redrfile[ws_act] = fopen(redrname[ws_act], "w");
			ini_redr(redrfile[ws_act]);
		     }

		     map_num[ws_act] = 0;
		  }

		  draw_grid(para[ws_act].mcent.lon, para[ws_act].mcent.lat, 
			    flag[ws_act], para[ws_act].size.su, 
			    para[ws_act].size.sv, rotation);

		  xmin_old[ws_act] = xmin[ws_act];
		  xmax_old[ws_act] = xmax[ws_act];
		  ymin_old[ws_act] = ymin[ws_act];
		  ymax_old[ws_act] = ymax[ws_act];

		  para_old[ws_act].pcent.lon = para[ws_act].pcent.lon;
		  para_old[ws_act].pcent.lat = para[ws_act].pcent.lat;
		  para_old[ws_act].mcent.lon = para[ws_act].mcent.lon;
		  para_old[ws_act].mcent.lat = para[ws_act].mcent.lat;
		  para_old[ws_act].size.su   = para[ws_act].size.su;
		  para_old[ws_act].size.sv   = para[ws_act].size.sv;
		  csproj_old[ws_act]       = csproj[ws_act];
		  strcpy(para_old[ws_act].proj, para[ws_act].proj);

		  if (redr_flag == FALSE)
		     save_redr(ws_act, "grid");

		  erase[ws_act] = FALSE;

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  flipsign = 1;

		  break;





	       case FFILE:


		  if (cntcheck("file", cmdc, 2, 0))
		     break;
		  

		  m = 0;
		  if (fp != 0)
		     (void) fclose(fp);

		  if ((fp = fopen(cmdv[1], "r")) == NULL)
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf("file %s not found.\n", cmdv[1]);
			(void) fflush(stdout);
		     }

		     else if (mode == SERVER)
			svcreturn(RETURN, ERROR, 
			   "file: File not found.", SCALAR);

		     break;
		  }

		  else
		  {
		     file_found = TRUE;

		     while(1)
		     {
			strcpy(data, "");

			if(fgets(data, MAXLINE, fp) == (char *)NULL)
			   break;

                        if(data[0] != '\\')
			   break;
		     }

		     m = 0;
		     l = 0;
		     for(i = 0; i < (int) strlen(data); ++i)
		     {
			if (data[i] == '\n')
			   break;
	    
			else if (data[i] == '|')
			{
			   endcol[m] = i;
			   name[m][l] = '\0';
			   ++m;
			   l = 0;
			}
	  
			else if (data[i] != '-' && data[i] != ' ')
			{
			   name[m][l] = data[i];
			   ++l;
			}
		     }

		     colwd[0] = endcol[0];

		     for (i=1; i<m; i++)
			  colwd[i] = endcol[i] - endcol[i-1];
		  }

		  if (mode == SERVER && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;




	       
	       case FLIPX:
		  if (cntcheck("flipx", cmdc, 1, 0))
		     break;
		  
		  flipsign = -1;
		  break;


	       case LABEL:

		  if (cmdc == 1)
		  {
		     if (mode == SERVER && !redr_flag )
			svcreturn(RETURN, ERROR, 
			   "label: No label text specified.", SCALAR);
		     
		     else
		     {
			(void) printf("No label text specified.\n");
			(void) fflush(stdout);
		     }

		     break;
		  }
		  
                  jcgflag = 1;
                  if (setup[ws_act] == FALSE)
                     gks_setup(ws_id);

		  p = cmdv[1];
		  for (i=1; i<cmdc-1; i++)
		     cmdv[i][strlen(cmdv[i])] = ' ';

		  for (i=0; i<(int) strlen(p); i++)
		     stri[i] = p[i];
		  stri[strlen(p)] = '\0';

		  if ((xmax[ws_act]-xmin[ws_act]) > (ymax[ws_act]-ymin[ws_act]))
		     chh = ch_percent*lexp[ws_act]*(xmax[ws_act]-xmin[ws_act]);
		  else
		     chh = ch_percent*lexp[ws_act]*(ymax[ws_act]-ymin[ws_act]);

		  if (psout[ws_act] == NULL)
		     open_psfile(psfile[ws_act]);
		  if (gifout[ws_act] == NULL)
		     open_giffile(giffile[ws_act]);

		  gsetlinecolourind(label_color[ws_act]);
		  f_color(label_color[ws_act]);
		  mlabel(longi[ws_act], lati[ws_act], stri, chh);

		  if (redr_flag == FALSE)
		  {
		     *rdcomd = '\0';
		     strcpy(rdcomd, "label ");
		     strcat(rdcomd, stri);
		     save_redr(ws_act, rdcomd);
		  }

		  flipsign = 1;

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;





	       case LALI:

		  if (cntcheck("lalign", cmdc, 2, 0))
		     break;
		  
		  labcs_done[ws_act] = FALSE;
		  if(set_labcs(cmdv[1]))
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf("Invalid system.\n");
			(void) fflush(stdout);
		     }

		     else if (mode == SERVER)
			svcreturn(RETURN, ERROR, 
			   "lalign: Invalid system.", SCALAR);
		     
		     break;
		  }


		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;




	       case LCS:

		  if (cntcheck("lcs", cmdc, 2, 4))
		     break;
		  
		  strcpy(bjdata[ws_act], "B"); 
		  eqnxloc[ws_act] = 1950.;

		  if (cmdc == 3)
		  {
		     if (!Isnumber(cmdv[2]))
		     {
		        strcpy(bjdata[ws_act], cmdv[2]);
			if (bjdata[ws_act][0] == 'B')
			   eqnxloc[ws_act] = 1950.;
                        else if (bjdata[ws_act][0] == 'J')
			   eqnxloc[ws_act] = 2000.;
		     }
		     else
		        eqnxloc[ws_act] = atof(cmdv[2]);
		  }

		  else if (cmdc == 4)
		     eqnxloc[ws_act] = atof(cmdv[3]);

		  if(set_loccs(cmdv[1], bjdata[ws_act]))
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf("Invalid system.\n");
			(void) fflush(stdout);
		     }

		     else if (mode == SERVER)
			svcreturn(RETURN, ERROR, 
			   "lcs: Invalid system.", SCALAR);
		     
		     break;
		  }


		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;





	       case EXPAND:

		  if (cntcheck("expand", cmdc, 2, 3))
		     break;
		  
		  exp_found = FALSE;

		  if (cmdc == 2)
		  {
		     if (Isnumber(cmdv[1]))
		     {
			lexp[ws_act] = atof(cmdv[1]); 
			sexp[ws_act] = atof(cmdv[1]);
		     }
		     else
		     {
			for (i=0; i<var_num; i++)
			   if (strcmp(cmdv[1], var[i]) ==0)
			   {
			      expcol = i;
			      exp_found = TRUE;
			   }
		     }
		  }
		  
		  else if (cmdc == 3)
		  {
		     switch(cs(cmdv[2]))
		     {
			case LABEL:
			   lexp[ws_act] = atof(cmdv[1]);
			   break;

			case SYMBOL:
			   sexp[ws_act] = atof(cmdv[1]);
			   break;
		     }
		  }

		  if (!script_flag)
		  {
		     le_ori[ws_act] = lexp[ws_act];
		     se_ori[ws_act] = sexp[ws_act];
		  }

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;





	       case HEADER:

		  if (cntcheck("header", cmdc, 1, 0))
		     break;
		  

		  if (mode == INTERACTIVE)
		  {
		     for (i=0; i<m; i++)
			(void) printf(" %s | ",name[i]);
		     (void) printf("\n");
		     (void) fflush(stdout);
		  }
		  
		  else if (mode == SERVER)
		  {
		     printf("[struct stat=\"OK\", return=");
		     printf("[struct count=%d, value=[array ", m);

		     for (i=0; i<m-1; i++)
			(void) printf("\"%s\", ",name[i]);

		     (void) printf("\"%s\"]]]\n",name[m-1]);
		     (void) fflush(stdout);
		  }

		  break;





	       case HELP:

		  if (cntcheck("help", cmdc, 1, 2))
		     break;
		  
		  if (mode == SERVER)
		  {
		     svcreturn(RETURN, ERROR, 
			"help: No help available in server mode", SCALAR);

		     break;
		  }

		  if (cmdc == 1)
		  {
		     if (getenv("AGRADIR") != NULL)
		     {
			*fname = '\0'; 
			strcpy(fname, getenv("AGRADIR"));
			strcat(fname, "/help/help");
			fq = fopen(fname, "r");
		     }

		     else
		     {
			*fname = '\0'; 
			strcpy(fname, AGRADIR);
			strcat(fname, "/help/help");
			fq = fopen(fname, "r");

			if (fq == NULL)
			{
			   *fname = '\0';
			   strcpy(fname, ".");
			   strcat(fname, "/help/help");
			   fq = fopen(fname, "r"); 
			}
		     }

		     if (fq != NULL)
		     {
			while ((d = getc(fq)) != EOF)
			   printf("%c", d);
			
			fclose(fq);
		     }

		     else
			printf("No help file found.\n");
		  }

		  else if (cmdc == 2)
		     if(help(cmdv[1]))
			printf("No help for \"%s\".", cmdv[1]);

		  (void) fflush(stdout);
		  break;





	       case ICS:

		  if (cntcheck("dcs", cmdc, 2, 4))
		     break;

		  strcpy(bjdata[ws_act], "B");
		  eqnxdata[ws_act] = 1950.;

		  if (cmdc == 3)
		  {
		     if (!Isnumber(cmdv[2]))
		     {
			strcpy(bjdata[ws_act], cmdv[2]);
			if (bjdata[ws_act][0] == 'B')
			   eqnximage[ws_act] = 1950.;
                        else if (bjdata[ws_act][0] == 'J')
			   eqnximage[ws_act] = 2000.;
		     }
		     else
		     {
			eqnximage[ws_act] = atof(cmdv[2]);
			if (eqnximage[ws_act] < 2000.)
			   strcpy(bjdata[ws_act], "B");
			else
			   strcpy(bjdata[ws_act], "J");
		     }
		  }

		  else if (cmdc == 4)
		  {
		     strcpy(bjdata[ws_act], cmdv[2]);
		     eqnximage[ws_act] = atof(cmdv[3]);
                  }

                  if(set_ics(cmdv[1], bjdata[ws_act]))
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf("Invalid system.\n");
			(void) fflush(stdout);
		     }

		     else if (mode == SERVER)
			svcreturn(RETURN, ERROR,
			   "dcs: Invalid system.", SCALAR);
		     
		     break;
		  }

		  break;

	       case INQWINDOW:

		  if (cntcheck("inqwindow", cmdc, 3, 0))
		     break;
		  
		  isopen = FALSE;
		  ginqopst(&state);

		  if (state == GGKCL)
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf("No windows open.\n");
			(void) fflush(stdout);
		     }

		     else if (mode == SERVER)
			svcreturn(RETURN, ERROR, "No windows open.", SCALAR);

		     break;
		  }

		  else
		  {
		     win_inq = atoi(cmdv[1]);
		     win_mod = atoi(cmdv[2]);
		     ginqopenws(&wsopen);
		     for (i=0; i<wsopen.number; i++)
		     {
			if (wsopen.integers[i] == win_inq)
			{
			   isopen = TRUE;
			   if (mode == SERVER)
			      svcreturn(RETURN, OK, NULL, SCALAR);
			   break;
			}
		     }

		     if (isopen == FALSE)
		     {
			if (mode == SERVER)
			{
			   if (win_mod == 0)
			   {
			      sprintf(msgstr, 
				 "inqwindow: Window %d is not open.", win_inq);
			      svcreturn(RETURN, ERROR, msgstr, SCALAR);
			   }
			   else if (win_mod == 1)
			      svcreturn(RETURN, ERROR, 
				 "Window isn't open.", SCALAR);
			}
		     }
		  }

		  break;





	       case MOVE:

		  if (cntcheck("move", cmdc, 3, 0))
		     break;
		  
		  longi[ws_act] = atof(cmdv[1]);
		  lati[ws_act]  = atof(cmdv[2]);
		  if (longi[ws_act] >  180.) longi[ws_act] -= 360.;
		  if (longi[ws_act] < -180.) longi[ws_act] += 360.;

		  ldraw_setup(longi[ws_act], lati[ws_act]);

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;





	    case MAP:

		  if (cntcheck("map", cmdc, 3, 0))
		     break;
		  

		  if (map_num[ws_act] > MAXMAP) 
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf(
			   "Too many maps, please erase one of the screens.\n");
			(void) fflush(stdout);
		     }

		     else if (mode == SERVER)
			svcreturn(RETURN, ERROR, 
			   "Too many maps, please erase one of the screens.", 
			    SCALAR);

		     break;
		  }


		  x_found = FALSE;
		  y_found = FALSE;


		  for (i=0; i<var_num; i++)
		  {
		     if (strcmp(cmdv[1], var[i]) ==0)
		     {
			xcol = i;
			x_found = TRUE;
		     }

		     if (strcmp(cmdv[2], var[i]) ==0)
		     {
			ycol = i;
			y_found = TRUE;
		     }
		  }

		  if (!x_found || !y_found)
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf("Data is not defined\n");
			(void) fflush(stdout);
		     }

		     else if (mode == SERVER)
			svcreturn(RETURN, ERROR, 
			   "Data is not defined", SCALAR);

		     break;
		  }

		  else
		  {
		     check_ws();

		     setcs(flag[ws_act], 0, para[ws_act].mcent.lon, 
			   para[ws_act].mcent.lat, &u0[ws_act], &v0[ws_act]);

		     xmin[ws_act] = u0[ws_act] - (para[ws_act].size.su)/2.;
		     xmax[ws_act] = u0[ws_act] + (para[ws_act].size.su)/2.;
		     ymin[ws_act] = v0[ws_act] - (para[ws_act].size.sv)/2.;
		     ymax[ws_act] = v0[ws_act] + (para[ws_act].size.sv)/2.;
		     if (   (xmax[ws_act]-xmin[ws_act]) 
		          > (ymax[ws_act]-ymin[ws_act]))
		         chh = ch_percent*(xmax[ws_act]-xmin[ws_act]);
		     else
		         chh = ch_percent*(ymax[ws_act]-ymin[ws_act]);

		     if (para[ws_act].size.su == 360. &&
		         para[ws_act].size.sv == 180.)
		     {
		        Xmin[ws_act] = xmin[ws_act];
		        Xmax[ws_act] = xmax[ws_act];
		        Ymin[ws_act] = ymin[ws_act];
		        Ymax[ws_act] = ymax[ws_act];
			chh = 0.75*chh;
		     }

		     else
		     {
		        Xmin[ws_act] = xmin[ws_act] - 15.*chh;
		        Xmax[ws_act] = xmax[ws_act] + 15.*chh; 
		        Ymin[ws_act] = ymin[ws_act] - 2. *chh;
		        Ymax[ws_act] = ymax[ws_act] + 2. *chh;
		     }

		     if (setup[ws_act] == FALSE)
			gks_setup(ws_id);

		     else
			check_setup(xmin_old[ws_act], xmax_old[ws_act], 
				    ymin_old[ws_act], ymax_old[ws_act], ws_id);

		     if (psout[ws_act] == NULL)
			open_psfile(psfile[ws_act]);
		     if (gifout[ws_act] == NULL)
			open_giffile(giffile[ws_act]);

		     if ((xmax[ws_act]-xmin[ws_act]) > (ymax[ws_act]-ymin[ws_act]))
		     {
			exp = 0.01*sexp[ws_act]*(xmax[ws_act]-xmin[ws_act]);
			x_offset *= (xmax[ws_act]-xmin[ws_act]);
			y_offset *= (xmax[ws_act]-xmin[ws_act]);
                     }

		     else
		     {
			exp = 0.01*sexp[ws_act]*(ymax[ws_act]-ymin[ws_act]);
			x_offset *= (ymax[ws_act]-ymin[ws_act]);
			y_offset *= (ymax[ws_act]-ymin[ws_act]);
                     }

		     gsetlinecolourind(symbol_color[ws_act]);
		     gsetfillcolourind(symbol_color[ws_act]);
		     f_color(symbol_color[ws_act]);

		     update_data(para[ws_act].pcent.lon, 
				 para[ws_act].pcent.lat,
				 para_old[ws_act].pcent.lon,
				 para_old[ws_act].pcent.lat);

		     update_data(para[ws_act].mcent.lon, 
				 para[ws_act].mcent.lat,
				 para_old[ws_act].mcent.lon,
				 para_old[ws_act].mcent.lat);

		     update_data(para[ws_act].size.su, 
				 para[ws_act].size.sv,
				 para_old[ws_act].size.su,
				 para_old[ws_act].size.sv);

		     update_str(para[ws_act].proj, para_old[ws_act].proj);

		     update_str(cs_name[csproj[ws_act]], cs_name[csproj_old[ws_act]]);

		     if (erase[ws_act]==TRUE)
		     {
			gclearws(ws_id, 1);
			open_psfile(psfile[ws_act]);
			open_giffile(giffile[ws_act]);
			f_color(symbol_color[ws_act]);

			if (!redr_flag)
			{
			   if (redrfile[ws_act] != NULL)
			      fclose(redrfile[ws_act]);
			   redrfile[ws_act] = fopen(redrname[ws_act], "w");
			   ini_redr(redrfile[ws_act]);
			   map_num[ws_act] = 0;
			}
		     }

		     if (!redr_flag)
		     {
			draw_data(x[xcol], x[ycol], nsides[ws_act], 
			       ptype[ws_act], exp, mang[ws_act]);

			Ndata[ws_act][map_num[ws_act]] = n;

			*rdcomd = '\0';
			strcpy(rdcomd, "map ");
			strcat(rdcomd, cmdv[1]);
			strcat(rdcomd, " ");
			strcat(rdcomd, cmdv[2]);
			save_redr(ws_act, rdcomd);

			map_num[ws_act]++;
		     }

		     else
		     {
			draw_data(londata[ws_act][draw_num[ws_act]], 
				  latdata[ws_act][draw_num[ws_act]], 
				  nsides[ws_act], ptype[ws_act], 
				  exp, mang[ws_act]);
			draw_num[ws_act]++;
		     }

		     xmin_old[ws_act] = xmin[ws_act];
		     xmax_old[ws_act] = xmax[ws_act];
		     ymin_old[ws_act] = ymin[ws_act];
		     ymax_old[ws_act] = ymax[ws_act];

		     para_old[ws_act].pcent.lon = para[ws_act].pcent.lon;
		     para_old[ws_act].pcent.lat = para[ws_act].pcent.lat;
		     para_old[ws_act].mcent.lon = para[ws_act].mcent.lon;
		     para_old[ws_act].mcent.lat = para[ws_act].mcent.lat;
		     para_old[ws_act].size.su = para[ws_act].size.su;
		     para_old[ws_act].size.sv = para[ws_act].size.sv;
		     csproj_old[ws_act]       = csproj[ws_act];
		     strcpy(para_old[ws_act].proj, para[ws_act].proj);

		     erase[ws_act] = FALSE;

		     if (mode == SERVER && !redr_flag && !script_flag)
			svcreturn(RETURN, OK, NULL, SCALAR);
		  }

		  flipsign = 1;

		  break;





	       case MCENTER:

		  if (cntcheck("mcenter", cmdc, 3, 0))
		     break;
		  

		  if (!Isnumber(cmdv[1]) && !Isnumber(cmdv[2])) 
		  {
		     if ((sex2dd(cmdv[1], cmdv[2], 
			         &para[ws_act].mcent.lon, 
			         &para[ws_act].mcent.lat)) != 0)
		     {
			if (mode == SERVER)
			   svcreturn(RETURN, ERROR, "Syntax error", SCALAR);

			else if (mode == INTERACTIVE)
			{
			   (void) printf("Syntax error\n");
			   (void) fflush(stdout);
			}

			break;
		     }
		  }

		  else if (Isnumber(cmdv[1]) && Isnumber(cmdv[2]))
		  {
		     para[ws_act].mcent.lon = atof(cmdv[1]);
		     para[ws_act].mcent.lat = atof(cmdv[2]);
		  }

		  else
		  {
		     if (mode == SERVER)
			svcreturn(RETURN, ERROR, 
			   "mcenter: Both arguments should have same format.",
			   SCALAR);
			
		     else if (mode == INTERACTIVE)
		     {
			(void) printf("Both arguments should have same format.\n");
			(void) fflush(stdout);
		     }

		     break;
		  }

		  if (para[ws_act].mcent.lon >  180.) 
		      para[ws_act].mcent.lon -= 360.;

		  if (para[ws_act].mcent.lon < -180.) 
		      para[ws_act].mcent.lon += 360.;

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;





	       case MCTYPE:

		  if (cntcheck("mctype", cmdc, 2, 0))
		     break;
		  
		  switch(cs(cmdv[1]))
		  {
		     case       DATA: flag[ws_act] = "data"; break;
		     case       GRID: flag[ws_act] = "grid"; break;
		     case PROJECTION: flag[ws_act] = "proj"; break;
		     case         UV: flag[ws_act] =   "uv"; break;
		  }

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;




	       case NULLSTR:
	       break;



	       case PCENTER:

		  if (cntcheck("pcenter", cmdc, 3, 0))
		     break;
		  
		  if (!Isnumber(cmdv[1]) && !Isnumber(cmdv[2])) 
		  {
		     if ((sex2dd(cmdv[1], cmdv[2], 
			         &para[ws_act].pcent.lon, 
			         &para[ws_act].pcent.lat)) != 0)
		     {
			if (mode == SERVER)
			   svcreturn(RETURN, ERROR, "Syntax error", SCALAR);
			   
			else if (mode == INTERACTIVE)
			{
			   (void) printf("Syntax error\n");
			   (void) fflush(stdout);
			}
		     }
		  }

		  else if (Isnumber(cmdv[1]) && Isnumber(cmdv[2]))
		  {
		     para[ws_act].pcent.lon = atof(cmdv[1]);
		     para[ws_act].pcent.lat = atof(cmdv[2]);
		  }

		  else
		  {
		     if (mode == SERVER)
			svcreturn(RETURN, ERROR, 
			   "pcenter: Both arguments should have same format.", 
			    SCALAR);
			
		     else if (mode == INTERACTIVE)
		     {
			(void) printf("Both arguments should have same format.\n");
			(void) fflush(stdout);
		     }

		     break;
		  }

		  if (para[ws_act].pcent.lon >  180.) 
		      para[ws_act].pcent.lon -= 360.;

		  if (para[ws_act].pcent.lon < -180.) 
		      para[ws_act].pcent.lon += 360.;

		  lon0r = para[ws_act].pcent.lon * dtr;
		  lat0r = para[ws_act].pcent.lat * dtr;

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;





	       case PCS:

		  if (cntcheck("pcs", cmdc, 2, 4))
		     break;
		  
		  strcpy(bjproj[ws_act], "B"); 
		  eqnxproj[ws_act] = 1950.;

		  if (cmdc == 3)
		  {
		     if (!Isnumber(cmdv[2]))
		     {
		        strcpy(bjproj[ws_act], cmdv[2]);
			if (bjproj[ws_act][0] == 'B')
			   eqnxproj[ws_act] = 1950.;
                        else if (bjproj[ws_act][0] == 'J')
			   eqnxproj[ws_act] = 2000.;
		     }
		     else
		     {
		        eqnxproj[ws_act] = atof(cmdv[2]);
			if (eqnxproj[ws_act] < 2000.)
			   strcpy(bjproj[ws_act], "B");
                        else
			   strcpy(bjproj[ws_act], "J");
		     }
		  }

		  else if (cmdc == 4)
		  {
		     strcpy(bjproj[ws_act], cmdv[2]);
		     eqnxproj[ws_act] = atof(cmdv[3]);
                  }

		  if(set_pcs(cmdv[1], bjproj[ws_act]))
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf("Invalid system.\n");
			(void) fflush(stdout);
		     }

		     else if (mode == SERVER)
			svcreturn(RETURN, ERROR, 
			   "pcs: Invalid system.", SCALAR);
		     
		     break;
		  }


		  if (!gcs_done[ws_act])
		  {
		     if (dcs_done[ws_act])
		     {
			csgrid[ws_act] = csdata[ws_act];
			strcpy(bjgrid[ws_act], bjdata[ws_act]);
			eqnxgrid[ws_act] = eqnxdata[ws_act]; 
			sysgrid[ws_act]  = sysdata[ws_act];
		     }
		     else 
		     {
			csgrid[ws_act] = csproj[ws_act];
			strcpy(bjgrid[ws_act], bjproj[ws_act]);
			eqnxgrid[ws_act] = eqnxproj[ws_act]; 
			sysgrid[ws_act]  = sysproj[ws_act];
                     }
                     if (csgrid[ws_act] == 1)
			grid_eq = TRUE;
                     else
			grid_eq = FALSE;
		  }

		  pcs_done[ws_act] = TRUE;

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;





	       case PLATEDEC:

		  if (cntcheck("platedec", cmdc, 2, 0))
		     break;
                  
		  coef_set->plate_dec = atof(cmdv[1]) * dtr;

		  break;

	       case PLATEX:

		  if (cntcheck("platex", cmdc, 21, 0))
		     break;
                  
		  for (i=0; i<20; i++)
		     coef_set->amd_x_coeff[i] = atof(cmdv[i+1]);

		  break;





               case PLATEY:

		  if (cntcheck("platey", cmdc, 21, 0))
		     break;
                  
		  for (i=0; i<20; i++)
		     coef_set->amd_y_coeff[i] = atof(cmdv[i+1]);

		  break;





	       case PLATEOFF:
		  
		  if (cntcheck("platey", cmdc, 3, 0))
		     break;

		  coef_set->x_pixel_offset = atof(cmdv[1]);
		  coef_set->y_pixel_offset = atof(cmdv[2]);

		  break;



	       case PLATEP:
		  
		  if (cntcheck("platey", cmdc, 7, 0))
		     break;
                  
		  for (i=0; i<6; i++)
		     coef_set->ppo_coeff[i] = atof(cmdv[i+1]);

		  break;





	       case PLATERA:

		  if (cntcheck("platera", cmdc, 2, 0))
		     break;
                  
		  coef_set->plate_ra = atof(cmdv[1]) * dtr;

		  break;

	       case PLATESCL:

		  if (cntcheck("platescl", cmdc, 2, 0))
		     break;

                  coef_set->plt_scale = atof(cmdv[1]);

		  break;

	       case PLATESIZE:
		  
		  if (cntcheck("platesize", cmdc, 3, 0))
		     break;

		  coef_set->x_pixel_size = atof(cmdv[1]);
		  coef_set->y_pixel_size = atof(cmdv[2]);

		  break;

	       case NAXIS:
		  if (cntcheck("platesize", cmdc, 3, 0))
		    break;

                  naxis1 = atof(cmdv[1]);
		  naxis2 = atof(cmdv[2]);

		  break;

	       case PRINT: 

		  if (cntcheck("print", cmdc, 1, 2))
		     break;
		  
		  if (psout[ws_act] == NULL && gifout[ws_act] == NULL)
		  {
		     if (mode == SERVER)
			svcreturn(RETURN, ERROR, "print: The screen is empty.", 
			   SCALAR);
			
		     else if (mode == INTERACTIVE)
		     {
			(void) printf("The screen is empty.\n");
			(void) fflush(stdout);
		     }

		     break;
		  }
		  
		  if (psout[ws_act] != NULL)
		     ps_close();
		  if (gifout[ws_act] != NULL)
		     gif_close();

		  if (cmdc == 1)
		     set_ptr = TRUE;

		  else if (cmdc == 2)
		  {
		     p = cmdv[1];
		     if(strlen(cmdv[1]) > 4)
			p = cmdv[1] + strlen(cmdv[1]) - 4;

		     if (strcmp(p, ".gif") == 0)
		     {
	                copyfile(giffile[ws_act], cmdv[1], 2);
                     }
		     else 
		     {
		        if (decolor)
		   	   copyfile(psfile[ws_act], cmdv[1], 1);
		        else
		   	   copyfile(psfile[ws_act], cmdv[1], 0);
		     }

		     set_ptr  = FALSE;
		  }

		  if (set_ptr == TRUE)
		  {
		     if (strlen(printer) == 0)
		     {
			if (getenv("AGRAPRN") != NULL)
			{
			   *printer = '\0';
			   strcpy(printer, getenv("AGRAPRN"));
			}

			else 
			{
			   *printer = '\0';
			   strcpy(printer, AGRAPRN);
			   if (strlen(printer) == 0)
			   {
			      *printer = '\0';
			      strcpy(printer, "lpr");
			   }
			}
		     }

		     prtmpfile = tempnam(tempath, "AGRA_");

		     if (decolor)
			copyfile(psfile[ws_act], prtmpfile, 1);
		     else
			copyfile(psfile[ws_act], prtmpfile, 0);
                     
		     *comm = '\0';
		     strcat(comm, printer);
		     strcat(comm, " ");
		     strcat(comm, prtmpfile);

		     stat = system(comm);

		     if(stat < 0)
		     {
			(void) printf("Printer command failed.\n");
			(void) fflush(stdout);
		     }
		  }

		  ps_clearend();

		  if (mode == SERVER && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;





	       case PRINTER:

		  if (cntcheck("printer", cmdc, 2, 99999999))
		     break;
		  
		  set_ptr = FALSE;

		  *printer = '\0';

		  for (i=1; i<cmdc; i++)
		  {
		     strcat(printer, cmdv[i]);
		     strcat(printer, " ");
		  }

		  set_ptr = TRUE;

		  if (mode == SERVER && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;





	       case PROJECTION:

		  if (cntcheck("projection", cmdc, 2, 0))
		     break;
		  
		  switch(cs(cmdv[1]))
		  {
		     case AITOFF:
			strcpy(para[ws_act].proj, "aitoff");
			break;

		     case CARTESIAN:
			strcpy(para[ws_act].proj, "cartesian");
			break;

		     case CYLINDRICAL:
		     case LINEAR:
			strcpy(para[ws_act].proj, "cylindrical");
			break;

		     case GNOMONIC:
			strcpy(para[ws_act].proj, "gnomonic");
			break;

                     case NCP:
			strcpy(para[ws_act].proj, "ncp");
			break;

		     case PLATE:
			strcpy(para[ws_act].proj, "plate");
			break;

		     case ORTHOGRAPHIC:
			strcpy(para[ws_act].proj, "orthographic");
			break;

		     default:
			bad = 1;

			if (mode == INTERACTIVE)
			{
			   (void) printf("Illegal projection type\n");
			   (void) fflush(stdout);
			}

			else if (mode == SERVER)
			   svcreturn(RETURN, ERROR, 
			      "projection: Illegal projection type", SCALAR);

			break;
		  }

		  if(bad == 1)
		  {
		     bad = 0;
		     break;
		  }

		  set_proj(para[ws_act].proj);

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;





	       case PSCOLOR:

		  if (cntcheck("pscolor", cmdc, 2, 0))
		     break;
		  
		  if(strncmp(cmdv[1], "off", 3) == 0)
                     decolor = 1;
		  else if (strncmp(cmdv[1], "on", 2) == 0)
		     decolor = 0;

		  if (mode == SERVER && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;




	       
	       case PTYPE:
	       
		  if (cntcheck("ptype", cmdc, 2, 3))
		     break;
		  
		  type_found = FALSE;

		  if (cmdc == 2)
		  {
		     for (i=0; i<var_num; i++)
			if (strcmp(cmdv[1], var[i]) ==0)
			{
			   typecol = i;
			   type_found = TRUE;
			}

		     if (type_found == FALSE)
		     {
			switch(cs(cmdv[1]))
			{
			   case CIRCLE:
			      nsides[ws_act] = 0;
			      ptype[ws_act]  = PTYPE_CIRCLE;
			      break; 

			   case CROSS:
			      nsides[ws_act] = 4;
			      ptype[ws_act]  = PTYPE_CROSS;
			      break;

			   case X:
			      nsides[ws_act] = 4;
			      ptype[ws_act]  = PTYPE_X;
			      break; 

			   default:
			      bad = 1;

			      if (mode == INTERACTIVE)
			      {
				 (void) printf("Illegal symbol option.\n");
				 (void) fflush(stdout);
			      }

			      else if (mode == SERVER)
				 svcreturn(RETURN, ERROR, 
				    "ptype: Illegal symbol option.", SCALAR);

			      break;
			}
		     }
		  }

		  else if (cmdc == 3)
		  {
		     nsides[ws_act] = atoi(cmdv[1]);
		     ptype [ws_act] = atoi(cmdv[2]);

		     if ((nsides[ws_act] < 2) && (ptype[ws_act] != 4))
			nsides[ws_act] = 2;
		  }

		  if(bad == 1)
		  {
		     bad = 0;
		     break;
		  }

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;





	       case PWD:

		  if (cntcheck("pwd", cmdc, 1, 0))
		     break;
		  
		  if (mode == SERVER)
		  {
		     svcreturn(RETURN, ERROR, 
			"pwd: Cannot get directory in server mode.", SCALAR);

		     break;
		  }
#ifdef SUNOS
		  getwd(path_tmp);
#else
		  getcwd(path_tmp, 500);
#endif
		  (void) printf("%s\n", path_tmp);
		  (void) fflush(stdout);

		  break;




	       
	       case QUIT:

		  if (cntcheck("quit", cmdc, 1, 0))
		     break;
		  
		  ginqopenws(&wsopen);

		  for (i=0; i<wsopen.number; i++)
		  {
		     gdeactivatews(wsopen.integers[i]);
		     gclosews(wsopen.integers[i]);
		  }

		  gclosegks();

		  if (fp != 0)
		     (void) fclose(fp);

		  if (fd != 0)
		     (void) fclose(fd);

		  for (i=0; i<10; i++)
		  {
		     remove(psfile[i]);
		     remove(giffile[i]);
		     if ( psout[i] != NULL)
			(void) fclose(psout[i]);
		     if ( gifout[i] != NULL)
			(void) fclose(gifout[i]);

		     remove(redrname[i]);
		     if (redrfile[i] != NULL)
			(void) fclose(redrfile[i]);
		  }

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  exit(0);

		  break;




	    
	       case READ:

		  if (cntcheck("read", cmdc, 3, 0))
		     break;
		  
		  var_found = FALSE;
		  col_found = FALSE;

		  maxpts = MAXPT;

		  if (Isnumber(cmdv[2]))
		  {
		     q = atoi(cmdv[2]) - 1;

		     if (q < m)
			col_found = TRUE;
		  }

		  else
		  {
		     for (i=0; i<m; i++)
			if (strcmp(cmdv[2], name[i]) == 0)
			{
			   q = i;
			   col_found = TRUE;
			}
		  }

		  if (col_found == TRUE)
		  {
		     for (i=0; i<var_num; i++)
			if (strcmp(cmdv[1], var[i]) == 0)
			{
			   va = i;
			   var_found = TRUE;
			   break;
			}

		     if (var_found == FALSE)
		     {
			va = var_num;

			for (i=0; i<(int) strlen(cmdv[1]); i++)
			   var[va][i] = cmdv[1][i];

			var[va][strlen(cmdv[1])] = '\0';
			var_num++;
		     }

		     rewind(fp);

		     while(1)
		     {
			if(fgets(data, MAXLINE, fp) == (char *)NULL)
			   break;
			
                        if(data[0] != '\\' && data[0] != '|')
			   break;
		     }

		     n = 0;
		     while(1)
		     {
			k = 0;
			for(i = 0; i < m; ++i)
			{
			   for (j=0; j < colwd[i]; ++j)
			      str[j] = data[k + j];
			   str[colwd[i]] = '\0';

			   if (sscanf(str, "%lf", &w) == 1)
			   {
			      if (i==q)
				 x[va][n] = w;
			   }

			   k += colwd[i];
			}

			n++;

			if ( n == maxpts)
			{
			   maxpts += MAXPT;
#ifdef SUNOS
			   x[va] = (double *)realloc((char *)x[va],
					  (unsigned int) (maxpts * sizeof(double)));
#else
			   x[va] = (double *)realloc((void *)x[va],
					  (size_t)(maxpts * sizeof(double)));
#endif

			}

			if(fgets(data, MAXLINE, fp) == (char *)NULL)
			   break;
		     }

		     if (mode == SERVER && !redr_flag && !script_flag)
			svcreturn(RETURN, OK, NULL, SCALAR);

		     
		     break;
		  }

		  else
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf("No column named '%s'\n", cmdv[2]); 
			(void) fflush(stdout);
		     }

		     else if (mode == SERVER)
		     {
			(void) sprintf(msgstr, "read: No column named '%s'", 
			   cmdv[2]);

			svcreturn(RETURN, ERROR, msgstr, SCALAR);
		     }
		  }

		  break;





	       case REDRAW:

		  if (cntcheck("redraw", cmdc, 1, 0))
		     break;
		  
		  ginqopst(&state);

		  if (state == GGKCL)
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf("Cannot open graphics.\n");
			(void) fflush(stdout);
		     }

		     else if (mode == SERVER)
			svcreturn(RETURN, ERROR, 
			   "redraw: Cannot open graphics.", SCALAR);
		     
		     break;
		  }

		  else
		  {
		     ginqopenws(&wsopen);

		     if (wsopen.number == 0)
		     {
			if (mode == INTERACTIVE)
			{
			   (void) printf("No window open.\n");
			   (void) fflush(stdout);
			}

			else if (mode == SERVER)
			   svcreturn(RETURN, ERROR, 
			      "redraw: No window open.", SCALAR);

			break;
		     }

		     else
		     {
			if (redrfile[ws_act] != NULL) 
			{
			   rewind(redrfile[ws_act]);
			   ini_redr(redrfile[ws_act]);
			}

			gclearws(ws_id, 1);
			setup[ws_act]       = FALSE;
			redr_flag           = TRUE;
			draw_num[ws_act]    = 0;
			open_psfile(psfile[ws_act]);
			open_giffile(giffile[ws_act]);
		     }
		  }

		  if (mode == SERVER && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break; 





	       case PSORIENT:

		  if (cntcheck("psorient", cmdc, 2, 0))
		     break;
		  
		  strcpy(style[ws_act], cmdv[1]);
		  ps_setstyle(ws_act, style[ws_act]);

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;




	       case PSRES:
                  if (cntcheck("psres", cmdc, 2, 0))
		     break;

                  res[ws_act] = atof(cmdv[1]);

		  break;


	       case ROTATE:

		  if (cntcheck("rotate", cmdc, 2, 0))
		     break;
		  
		  if (!Isnumber(cmdv[1]))
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf(
			   "Rotation should be in decimal degrees.\n");
			(void) fflush(stdout);
		     }

		     else if (mode == SERVER)
			svcreturn(RETURN, ERROR, 
			   "rotate: Rotation should be in decimal degrees.", 
			    SCALAR);

		     break;
		  }
		     
		  rotation         = atof(cmdv[1]);
		  rtwist[ws_act]   = rotation * dtr;

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;





	       case SCALE:

		  if (cmdc != 1 && cmdc != 3)
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf("Invalid parameter count for command.\n");
			(void) fflush(stdout);
		     }

		     else if (mode == SERVER)
			svcreturn(RETURN, ERROR, 
			   "scale: Invalid parameter count for command.", 
			    SCALAR);
		     
		     break;
		  }

		  x_found = FALSE;
		  y_found = FALSE;

		  if (cmdc == 1)
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf("\nCurrent parameters are:\n\n");
			(void) printf("Data Coordinate System: %s\n",
				       cs_name[csdata[ws_act]]);
			(void) printf("Proj Coordinate System: %s\n",
				       cs_name[csproj[ws_act]]);
			(void) printf("Grid Coordinate System: %s\n",
				       cs_name[csgrid[ws_act]]);
			(void) printf("Map Center Type       : %s\n",
				       flag[ws_act]);
			(void) printf("Projection Center     : %-g, ", 
				       para[ws_act].pcent.lon);
			(void) printf("%-g\n", para[ws_act].pcent.lat);
			(void) printf("Image Center          : %-g, ", 
				       para[ws_act].mcent.lon);
			(void) printf("%-g\n", para[ws_act].mcent.lat);
			(void) printf("Image Size            : %-g, ", 
				       para[ws_act].size.su);
			(void) printf("%-g\n", para[ws_act].size.sv);
			(void) printf("Projection Type       : %s\n\n",
				       para[ws_act].proj);
			(void) fflush(stdout);
		     }

		     else if (mode == SERVER)
		     {
			(void) printf("[struct stat=\"OK\", return=[struct ");
			(void) printf("dcs=\"%s\", ", cs_name[csdata[ws_act]]); 
			(void) printf("pcs=\"%s\", ", cs_name[csproj[ws_act]]); 
			(void) printf("gcs=\"%s\", ", cs_name[csgrid[ws_act]]); 
			(void) printf("flag=\"%s\", ",flag[ws_act]); 
			(void) printf("plon=%-g, ",   para[ws_act].pcent.lon);
			(void) printf("plat=%-g, ",   para[ws_act].pcent.lat);
			(void) printf("mlon=%-g, ",   para[ws_act].mcent.lon);
			(void) printf("mlat=%-g, ",   para[ws_act].mcent.lat);
			(void) printf("su=%-g, ",     para[ws_act].size.su);
			(void) printf("sv=%-g, ",     para[ws_act].size.sv);
			(void) printf("proj=\"%s\"]]\n",   para[ws_act].proj);
			(void) fflush(stdout);
		     }
		     
		     break;
		  }

		  else if (cmdc == 3)
		  {
		     for (i=0; i<var_num; i++)
		     {
			if (strcmp(cmdv[1], var[i]) == 0)
			{
			   xcol = i;
			   x_found = TRUE;
			}

			if (strcmp(cmdv[2], var[i]) == 0)
			{
			   ycol = i;
			   y_found = TRUE;
			}
		     }

		     if (x_found && y_found)
		     {
			scale(flag[ws_act], &dfile);
			dcs_file = csdata[ws_act];
			pcs_file = csproj[ws_act];
			gcs_file = csgrid[ws_act];
			flag_file = flag[ws_act];
			lon0r = para[ws_act].pcent.lon * dtr;
			lat0r = para[ws_act].pcent.lat * dtr;

			if (mode == SERVER && !redr_flag && !script_flag)
			{
			   (void) printf("[struct stat=\"OK\", ");
			   (void) printf("return=[struct ");
			   (void) printf("plon=%-g, ",    dfile.pcent.lon);
			   (void) printf("plat=%-g, ",    dfile.pcent.lat);
			   (void) printf("mlon=%-g, ",    dfile.mcent.lon);
			   (void) printf("mlat=%-g, ",    dfile.mcent.lat);
			   (void) printf("su=%-g, ",    dfile.size.su);
			   (void) printf("sv=%-g, ",    dfile.size.sv);
			   (void) printf("proj=\"%s\"]]\n",  dfile.proj);
			   (void) fflush(stdout);
			}

			else if (mode == INTERACTIVE)
			   {
			   (void) printf("\nRecommended parameters are:\n\n");
			   (void) printf("Data Coordinate System: %s\n",
				       cs_name[csdata[ws_act]]);
			   (void) printf("Proj Coordinate System: %s\n",
				       cs_name[csproj[ws_act]]);
			   (void) printf("Grid Coordinate System: %s\n",
				       cs_name[csgrid[ws_act]]);
			   (void) printf("Map Center Type       : %s\n",
				       flag[ws_act]);
			   (void) printf("Projection Center     : %-g, ", 
					  dfile.pcent.lon);
			   (void) printf("%-g\n", dfile.pcent.lat);
			   (void) printf("Image Center          : %-g, ", 
					  dfile.mcent.lon);
			   (void) printf("%-g\n", dfile.mcent.lat);
			   (void) printf("Image Size            : %-g, ", 
					  dfile.size.su);
			   (void) printf("%-g\n", dfile.size.sv);
			   (void) printf("Projection Type       : %s\n\n",
					  dfile.proj);
			   (void) fflush(stdout);
			}

			break;
		     }

		     else
		     {
			if (mode == SERVER)
			   svcreturn(RETURN, ERROR, 
			      "scale: Data not found, please read first.", 
			       SCALAR);

			else
			{
			   if (x_found == FALSE)
			      (void) printf("Varible %s not found.\n", cmdv[1]);

			   if (y_found == FALSE)
			      (void) printf("Varible %s not found.\n", cmdv[2]);
			}

			break;
		     }
		  }

		  break;





	       case SET_WINDOW:

		  if (cntcheck("set_window", cmdc, 1, 0))
		     break;
		  
		  ginqopst(&state);
		  
		  if (state == GGKCL)
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf("Cannot open graphics.\n");
			(void) fflush(stdout);
		     }

		     else if (mode == SERVER)
			svcreturn(RETURN, ERROR, 
			   "set_window: Cannot open graphics.", SCALAR);

		     break;
		  }

		  ginqopenws(&wsopen);

		  if (wsopen.number == 0)
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf("No windows open.\n");
			(void) fflush(stdout);
		     }

		     else if (mode == SERVER)
			svcreturn(RETURN, ERROR, 
			   "set_window: No windows open.", SCALAR);
		     
		     break;
		  }
		  
		  if (mode == SERVER && !redr_flag && !script_flag)
		  {
		     sprintf(msgstr, "%d", wsopen.integers[0]);
		     svcreturn(RETURN, OK, msgstr, SCALAR);
		  }

		  break;





	       case SHADOW:

		  if (cntcheck("size", cmdc, 3, 0)) 
		     break;

		  x_offset = atof(cmdv[1]);
		  y_offset = atof(cmdv[2]);

		  if (mode == SERVER)
		     svcreturn(RETURN, OK, NULL, SCALAR);
		  break;





	       case SIZE:

		  if (cntcheck("size", cmdc, 3, 0))
		     break;
		  
		  if (!Isnumber(cmdv[1]) || !Isnumber(cmdv[2]))
		  {
		     if (mode == SERVER)
			svcreturn(RETURN, ERROR, 
			   "size: Both arguments must be numbers.", SCALAR);
			
		     else if (mode == INTERACTIVE)
		     {
			(void) printf("Both arguments must be numbers.\n");
			(void) fflush(stdout);
		     }

		     break;
		  }

		  else
		  {
		     para[ws_act].size.su = atof(cmdv[1]);
		     para[ws_act].size.sv = atof(cmdv[2]);
		     para[ws_act].maxsize = 
			sqrt(para[ws_act].size.su*para[ws_act].size.su 
			   + para[ws_act].size.sv*para[ws_act].size.sv) / 2.;
		  }

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;






	    case SYMANG:

		  if (cntcheck("symangle", cmdc, 2, 0))
		     break;
		  
		  mang[ws_act] = atof(cmdv[1]) * dtr;

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;





	    case SYS:

	       if (mode == SERVER)
	       {
		  svcreturn(RETURN, ERROR, 
		     "sys: No system() calls allowed from server.", SCALAR);
		  
		  break;
	       }

	       p = cmdv[1];

	       for (i=1; i < cmdc-1; i++)
		  cmdv[i][strlen(cmdv[i])] = ' ';

	       stat = system(p);

	       if(stat < 0)
	       {
		  (void) printf("System() command failed.\n");
		  (void) fflush(stdout);
	       }

	       break;





	    case VECTOR:
	       
	       if (cntcheck("map", cmdc, 6, 0))
	          break;
		  
	       x_found  = FALSE;
	       y_found  = FALSE;
	       dx_found = FALSE;
	       dy_found = FALSE;

	       for (i=0; i<var_num; i++)
	       {
	          if (strcmp(cmdv[1], var[i]) ==0)
		  {
		     xcol = i;
		     x_found = TRUE;
		  }

		  if (strcmp(cmdv[2], var[i]) ==0)
		  {
		     ycol = i;
		     y_found = TRUE;
		  }

	          if (strcmp(cmdv[3], var[i]) ==0)
		  {
		     dxcol = i;
		     dx_found = TRUE;
		  }

		  if (strcmp(cmdv[4], var[i]) ==0)
		  {
		     dycol = i;
		     dy_found = TRUE;
		  }
	       }

	       fac = atof(cmdv[5]);

	       if (!x_found || !y_found || !dx_found || !dy_found)
	       {
	          if (mode == INTERACTIVE)
	          {
		     (void) printf("Data is not defined\n");
		     (void) fflush(stdout);
	          }

	       else if (mode == SERVER)
		  svcreturn(RETURN, ERROR, 
		   "Data is not defined", SCALAR);

	       break;
	       }

	       else
	       {
	          check_ws();

		  setcs(flag[ws_act], 0, para[ws_act].mcent.lon, 
		     para[ws_act].mcent.lat, &u0[ws_act], &v0[ws_act]);

		  xmin[ws_act] = u0[ws_act] - (para[ws_act].size.su)/2.;
		  xmax[ws_act] = u0[ws_act] + (para[ws_act].size.su)/2.;
		  ymin[ws_act] = v0[ws_act] - (para[ws_act].size.sv)/2.;
		  ymax[ws_act] = v0[ws_act] + (para[ws_act].size.sv)/2.;
		  if (   (xmax[ws_act]-xmin[ws_act]) 
		       > (ymax[ws_act]-ymin[ws_act]))
		      chh = ch_percent*(xmax[ws_act]-xmin[ws_act]);
		  else
		      chh = ch_percent*(ymax[ws_act]-ymin[ws_act]);

		  if (para[ws_act].size.su == 360. &&
		      para[ws_act].size.sv == 180.)
		  {
		     Xmin[ws_act] = xmin[ws_act];
		     Xmax[ws_act] = xmax[ws_act];
		     Ymin[ws_act] = ymin[ws_act];
		     Ymax[ws_act] = ymax[ws_act];
		     chh = 0.75*chh;
		  }

		  else
		  {
		     Xmin[ws_act] = xmin[ws_act] - 15.*chh;
		     Xmax[ws_act] = xmax[ws_act] + 15.*chh; 
		     Ymin[ws_act] = ymin[ws_act] - 2. *chh;
		     Ymax[ws_act] = ymax[ws_act] + 2. *chh;
		  }

		  if (setup[ws_act] == FALSE)
		     gks_setup(ws_id);

		  else
		     check_setup(xmin_old[ws_act], xmax_old[ws_act], 
			         ymin_old[ws_act], ymax_old[ws_act], ws_id);

		  if (psout[ws_act] == NULL)
		     open_psfile(psfile[ws_act]);
		  if (gifout[ws_act] == NULL)
		     open_giffile(giffile[ws_act]);

		  if ((xmax[ws_act]-xmin[ws_act]) > (ymax[ws_act]-ymin[ws_act]))
		  {
		     exp = 0.01*sexp[ws_act]*(xmax[ws_act]-xmin[ws_act]);
		     x_offset *= (xmax[ws_act]-xmin[ws_act]);
		     y_offset *= (xmax[ws_act]-xmin[ws_act]);
                  }

		  else
		  {
		     exp = 0.01*sexp[ws_act]*(ymax[ws_act]-ymin[ws_act]);
		     x_offset *= (ymax[ws_act]-ymin[ws_act]);
		     y_offset *= (ymax[ws_act]-ymin[ws_act]);
                  }

		  gsetlinecolourind(symbol_color[ws_act]);
		  gsetfillcolourind(symbol_color[ws_act]);
		  f_color(symbol_color[ws_act]);

		  update_data(para[ws_act].pcent.lon, 
			 para[ws_act].pcent.lat,
			 para_old[ws_act].pcent.lon,
			 para_old[ws_act].pcent.lat);

		  update_data(para[ws_act].mcent.lon, 
			 para[ws_act].mcent.lat,
			 para_old[ws_act].mcent.lon,
			 para_old[ws_act].mcent.lat);

		  update_data(para[ws_act].size.su, 
			 para[ws_act].size.sv,
			 para_old[ws_act].size.su,
			 para_old[ws_act].size.sv);

		  update_str(para[ws_act].proj, para_old[ws_act].proj);

		  update_str(cs_name[csproj[ws_act]], cs_name[csproj_old[ws_act]]);

		  if (erase[ws_act]==TRUE)
		  {
		     gclearws(ws_id, 1);
		     open_psfile(psfile[ws_act]);
		     open_giffile(giffile[ws_act]);
		     f_color(symbol_color[ws_act]);
		  }

		  for (i=0; i<n; i++)
		  {
		      skycurve(x[xcol][i], x[ycol][i], 
			       x[xcol][i]+x[dxcol][i]*fac, 
			       x[ycol][i]+x[dycol][i]*fac, "great");   
		  }

		  xmin_old[ws_act] = xmin[ws_act];
		  xmax_old[ws_act] = xmax[ws_act];
		  ymin_old[ws_act] = ymin[ws_act];
		  ymax_old[ws_act] = ymax[ws_act];

		  para_old[ws_act].pcent.lon = para[ws_act].pcent.lon;
		  para_old[ws_act].pcent.lat = para[ws_act].pcent.lat;
		  para_old[ws_act].mcent.lon = para[ws_act].mcent.lon;
		  para_old[ws_act].mcent.lat = para[ws_act].mcent.lat;
		  para_old[ws_act].size.su = para[ws_act].size.su;
		  para_old[ws_act].size.sv = para[ws_act].size.sv;
		  csproj_old[ws_act]       = csproj[ws_act];
		  strcpy(para_old[ws_act].proj, para[ws_act].proj);

		  erase[ws_act] = FALSE;

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);
	       }
	       break;

	    case WINDOW:

		  if (cntcheck("window", cmdc, 1, 3))
		     break;
		  
		  isopen = FALSE;
		  *prog = '\0';
		  strcat(prog, "AGRA Map Window ");

		  if (cmdc == 1)
		  {
		     if (mode == INTERACTIVE)
		     {
			(void) printf("Current window is %d\n", ws_act+1);
			(void) fflush(stdout);
		     }

		     else if (mode == SERVER)
		     {
			sprintf(msgstr, "%d",  ws_act+1);
			svcreturn(RETURN, OK, msgstr, SCALAR);
		     }

		     break;
		  }

		  if (cmdc == 2)
		  {
		     ws_id = atoi(cmdv[1]);
		     strcat(prog, cmdv[1]);

		     ginqopst(&state);
		     if (state == GGKCL)
			gopengks(stdout, 0);

		     if (ws_id > 10)
		     {
			if (mode == INTERACTIVE)
			{
			   (void) printf(
			      "The maximum number of windows is 10.\n");
			   (void) fflush(stdout);
			}

			else if (mode == SERVER)
			   svcreturn(RETURN, ERROR, 
			      "window: The maximum number of windows is 10.", 
			       SCALAR);

			break;
		     }

		     ws_act = ws_id - 1;
		     lon0r = para[ws_act].pcent.lon * dtr;
		     lat0r = para[ws_act].pcent.lat * dtr;
		     ginqopenws(&wsopen);

		     for (i=0; i<wsopen.number; i++)
		     {
			if (wsopen.integers[i] == ws_id)
			{
			   isopen = TRUE;
			   ginqwsst(ws_id, &wsstate);
			   if (wsstate == GINACTIVE)
			      gactivatews(ws_id);
			}
			else
			{
			   ginqwsst(wsopen.integers[i], &wsstate);
			   if (wsstate == GACTIVE)  
			      gdeactivatews(wsopen.integers[i]);
			}
		     }

		     if (isopen == FALSE) 
		     {
			gescsetprogname(prog);
			gopenws(ws_id, conn, conn);
			gactivatews(ws_id);
			gks_setup(ws_id);
		     }
		  }

		  if (mode == SERVER && !redr_flag && !script_flag)
		     svcreturn(RETURN, OK, NULL, SCALAR);

		  break;





	       default:
		  if (mode == INTERACTIVE)
		  {
		     (void) printf("%s: Not command.\n", cmdv[0]);
		     (void) fflush(stdout);
		  }

		  else if (mode == SERVER)
		  {
		     sprintf(msgstr, "%s: Not command.", cmdv[0]);
		     svcreturn(RETURN, ERROR, msgstr, SCALAR);
		  }
				   
		  break;
	    }

	    if (mode == INTERACTIVE && !script_flag && !redr_flag && !cmdcur)
	    {
	       (void) printf("> ");
	       (void) fflush(stdout);
	    }
      }
   }
}





void check_ws()
{
   Gchar    *conn = (char *)NULL;
   Gos      state;
   Gintlist wsopen;

   ginqopst(&state);
   if (state == GGKCL)
      gopengks(stdout, 0);

   ginqopenws(&wsopen);
   if (wsopen.number == 0)
   {
      gescsetprogname("AGRA Map Window 1");
      gopenws(1, conn, conn);
      gactivatews(1);
      set_colors(1);
      ws_act = 0;
   }
}




static void check_setup(xmin0, xmax0, ymin0, ymax0, ws_id)

double xmin0, xmax0, ymin0, ymax0;
Gint ws_id;

{
   if (   (fabs(xmin0-xmin[ws_act]) < 1.0e-4) 
       && (fabs(xmax0-xmax[ws_act]) < 1.0e-4)
       && (fabs(ymin0-ymin[ws_act]) < 1.0e-4)
       && (fabs(ymax0-ymax[ws_act]) < 1.0e-4)) 
      setup[ws_act] = TRUE;
   else
      setup[ws_act] = FALSE;

   if (setup[ws_act] == FALSE)
   {
      gclearws(ws_id, 1);
      if (!redr_flag)
      {
         if (redrfile[ws_act] != NULL)
            fclose(redrfile[ws_act]);
         redrfile[ws_act] = fopen(redrname[ws_act], "w");
	 ini_redr(redrfile[ws_act]);
      }

      map_num[ws_act] = 0;
      gks_setup(ws_id);
   }
}




void open_psfile(file)

char *file;

{
   rat[ws_act] = (Xmax[ws_act]-Xmin[ws_act])/(Ymax[ws_act]-Ymin[ws_act]);
   ps_wind(Xmin[ws_act], Xmax[ws_act], Ymin[ws_act], Ymax[ws_act]);
   ps_init();
   ps_open("AGRA Mapping", file);
}


void open_giffile(file)

char *file;

{
   rat[ws_act] = (Xmax[ws_act]-Xmin[ws_act])/(Ymax[ws_act]-Ymin[ws_act]);
   gif_wind(Xmin[ws_act], Xmax[ws_act], Ymin[ws_act], Ymax[ws_act]);
   gif_init();
   gif_open(file);
}



static void draw_data(lonarr, latarr, nsides, ptype, exp, mang)
int    nsides, ptype;
double *lonarr, *latarr;
double exp, mang;
{
   int i, gno_out;
   double glon, glat, u, v;
   double x0, y0, z0, x1, y1, z1;
   
   x0 = cos(lon0r) * cos(lat0r);
   y0 = sin(lon0r) * cos(lat0r);
   z0 = sin(lat0r);
   
   gno_out = 0;

   tr = AA[csdata[ws_act]][csproj[ws_act]];

   if (redr_flag)
      n=Ndata[ws_act][draw_num[ws_act]];

   for (i=0; i<n; i++)
    {
       if (exp_found == TRUE)
       {
	  if ((xmax[ws_act]-xmin[ws_act]) >= (ymax[ws_act]-ymin[ws_act]))
	     exp = 0.01 * x[expcol][i] * (xmax[ws_act]-xmin[ws_act]);
          else
	     exp = 0.01 * x[expcol][i] * (ymax[ws_act]-ymin[ws_act]);
       }

       if (color_found == TRUE)
	  gsetlinecolourind((int)x[colrcol][i]);

       if (type_found == TRUE)
       {
	  nsides = (int) (x[typecol][i]/10.);
	  ptype  = (int) (x[typecol][i] - nsides*10.);
       }

       if (*latarr > 90. || *latarr < -90.)
       {
	  if (mode == SERVER)
	  {
	     sprintf(msgstr, "Latitute %-g is out of range", *latarr);
	     svcreturn(SIGNAL, ERROR, msgstr, SCALAR);
	  }
	  else if (mode == INTERACTIVE)
	  {
	     (void) printf("Latitute %-g is out of range\n", *latarr);
	     (void) fflush(stdout);
	  }
       }

       else
       {
	  /*
          (*func[tr])(*lonarr, *latarr, &glon, &glat);
	  */
          jcnvc2(sysdata[ws_act], eqnxdata[ws_act], *lonarr, *latarr,
		 sysproj[ws_act], eqnxproj[ws_act], &glon, &glat, epoch[ws_act]);

	  if (gno_done[ws_act])
	  {
	     x1 = cos(glon * dtr) * cos(glat * dtr);
	     y1 = sin(glon * dtr) * cos(glat * dtr);
	     z1 = sin(glat * dtr);

	     if ( x0*x1 + y0*y1 + z0*z1  > 0. )
		gno_out = 0;
	     else
		gno_out = 1;
	  }

          map[ws_act](glon, glat, &u, &v);
          if ((u >= xmin[ws_act] && u <= xmax[ws_act]) && 
	      (v >= ymin[ws_act] && v <= ymax[ws_act]) && !gno_out)
              drawsymbol(*lonarr-x_offset, *latarr-y_offset,
			 nsides, ptype, exp, mang);
       }

       lonarr++;
       latarr++;
    }
}




static int set_dcs(s, bj)
char *s, *bj;
{
   switch(cs(s))
   {
      case EC:
	 csdata[ws_act] = 0;
	 if (*bj == 'B')
	    sysdata[ws_act] = 3;
	 else if (*bj == 'J')
	    sysdata[ws_act] = 13;
         break;

      case EQ:
	 csdata[ws_act] = 1;
	 if (*bj == 'B')
	    sysdata[ws_act] = 1;
	 else if (*bj == 'J')
	    sysdata[ws_act] = 0;
	 break;

      case GA:
	 csdata[ws_act] = 2;
	 sysdata[ws_act] = 2;
	 break;

      case SG:
	 csdata[ws_act] = 3;
	 sysdata[ws_act] = 4;
	 break;

      default:
	 return(1);
	 break;
   }

   return(0);
}




static int set_pcs(s, bj)
char *s, *bj;
{
   switch(cs(s))
   {
      case EC:
         csproj[ws_act] = 0;
	 if (*bj == 'B')
            sysproj[ws_act] = 3;
         else if (*bj == 'J')
	    sysproj[ws_act] = 13;
         break;

      case EQ:
         csproj[ws_act] = 1;
	 if (*bj == 'B')
	    sysproj[ws_act] = 1;
         else if (*bj == 'J')
	    sysproj[ws_act] = 0;
         break;

      case GA:
         csproj[ws_act]  = 2;
	 sysproj[ws_act] = 2;
         break;

      case SG:
         csproj[ws_act]  = 3;
	 sysproj[ws_act] = 4;
         break;

      default:
	 return(1);
         break;
   }

   return(0);
}



static int set_gcs(s, bj)
char *s, *bj;
{
   switch(cs(s))
   {
      case EC:
         csgrid[ws_act] = 0;
	 if (*bj == 'B')
	    sysgrid[ws_act] = 3;
         else if (*bj == 'J')
	    sysgrid[ws_act] = 13;
         grid_eq = FALSE;
         break;

      case EQ:
         csgrid[ws_act] = 1;
	 if (*bj == 'B')
	    sysgrid[ws_act] = 1;
         else if (*bj == 'J')
	    sysgrid[ws_act] = 0;
         grid_eq = TRUE;
         break;

      case GA:
         csgrid[ws_act]  = 2;
	 sysgrid[ws_act] = 2;
         grid_eq = FALSE;
         break;

      case SG:
         csgrid[ws_act]  = 3;
	 sysgrid[ws_act] = 4;
         grid_eq = FALSE;
         break;

      default:
	 return(1);
   }

   return(0);
}

static int set_ics(s, bj)
char *s, *bj;
{
   switch(cs(s))
   {
      case EC:
	 if (*bj == 'B')
	    sysimage[ws_act] = 3;
	 else if (*bj == 'J')
	    sysimage[ws_act] = 13;
         break;

      case EQ:
	 if (*bj == 'B')
	    sysimage[ws_act] = 1;
	 else if (*bj == 'J')
	    sysimage[ws_act] = 0;
	 break;

      case GA:
	 sysimage[ws_act] = 2;
	 break;

      case SG:
	 sysimage[ws_act] = 4;
	 break;

      default:
	 return(1);
	 break;
   }

   return(0);
}



static int guess_ics(s, eqnx)
char *s; 
double eqnx;
{
   switch(cs(s))
   {
      case EC:
	 if (eqnx < 2000.)
	    sysimage[ws_act] = 3;
	 else 
	    sysimage[ws_act] = 13;
         break;

      case EQ:
	 if (eqnx < 2000.)
	    sysimage[ws_act] = 1;
	 else 
	    sysimage[ws_act] = 0;
	 break;

      case GA:
	 csdata[ws_act] = 2;
	 sysimage[ws_act] = 2;
	 break;

      case SG:
	 csdata[ws_act] = 3;
	 sysimage[ws_act] = 4;
	 break;

      default:
	 return(1);
	 break;
   }

   return(0);
}

static int set_loccs(s, bj)
char *s, *bj;
{
   switch(cs(s))
   {
      case EC:
         csloc[ws_act] = 0;
	 if (*bj == 'B')
	    sysloc[ws_act] = 3;
	 else if (*bj == 'J')
	    sysloc[ws_act] = 13;
         break;

      case EQ:
         csloc[ws_act] = 1;
	 if (*bj == 'B')
	    sysloc[ws_act] = 1;
	 else if (*bj == 'J')
	    sysloc[ws_act] = 0;
         break;

      case GA:
         csloc[ws_act] = 2;
	 sysloc[ws_act] = 2;
         break;

      case SG:
         csloc[ws_act] = 3;
	 sysloc[ws_act] = 4;
         break;

      default:
	 return(1);
         break;
   }

   return(0);
}




static int set_labcs(s)
char *s;
{
   switch(cs(s))
   {
      case EC:
         cslab[ws_act] = 0;
         labcs_done[ws_act] = TRUE;
         break;

      case EQ:
         cslab[ws_act] = 1;
         labcs_done[ws_act] = TRUE;
         break;

      case GA:
         cslab[ws_act] = 2;
         labcs_done[ws_act] = TRUE;
         break;

      case SG:
         cslab[ws_act] = 3;
         labcs_done[ws_act] = TRUE;
         break;

      case UV:
	 cslab[ws_act] = 4;
         labcs_done[ws_act] = FALSE;
         break;

      default:
	 return(1);
         break;
   }

   return(0);
}



int set_proj(s)
char *s;
{
   ait_done[ws_act] = FALSE;
   gno_done[ws_act] = FALSE;
   car_done[ws_act] = FALSE;
   cyl_done[ws_act] = FALSE;
   ncp_done[ws_act] = FALSE;
   pla_done[ws_act] = FALSE;
   ort_done[ws_act] = FALSE;

   switch(cs(s))
   {
      case AITOFF:
         map[ws_act]      = aitoff;
         map_inv[ws_act]  = a_inverse;
	 ait_done[ws_act] = TRUE;
         break;

      case CARTESIAN:
	 map[ws_act]      = cartesian;
	 map_inv[ws_act]  = ca_inverse;
	 car_done[ws_act] = TRUE;
	 break;

      case CYLINDRICAL:
         map[ws_act]      = cylindrical;
         map_inv[ws_act]  = cy_inverse;
	 cyl_done[ws_act] = TRUE;
         break;

      case GNOMONIC:
         map[ws_act]      = gnomonic;
         map_inv[ws_act]  = g_inverse;
	 gno_done[ws_act] = TRUE;
         break;

      case NCP:
	 map[ws_act]      = ncp;
	 map_inv[ws_act]  = nc_inverse;
	 ncp_done[ws_act] = TRUE;
	 break;

      case PLATE:
	 map[ws_act]      = plate;
	 map_inv[ws_act]  = pl_inverse;
	 pla_done[ws_act] = TRUE;
	 break;

      case ORTHOGRAPHIC:
	 map[ws_act]      = orthographic;
	 map_inv[ws_act]  = or_inverse;
	 ort_done[ws_act] = TRUE;
	 break;

      default:
	 return(1);
         break;
   }

   return(0);
}



void E(lon, lat, glon, glat)

double lon, lat, *glon, *glat;
{
   *glon = lon;
   *glat = lat;
}



static int help(s)
char *s;
{
   int c;
   char fname[80];

   FILE *fq;
   
   if (getenv("AGRADIR") != NULL)
   {
      *fname = '\0';
      strcpy(fname, getenv("AGRADIR"));
      strcat(fname, "/help/");
      strcat(fname, s);
      fq = fopen(fname, "r");
   }

   else 
   {
      *fname = '\0'; 
      strcpy(fname, AGRADIR);
      strcat(fname, "/help/");
      strcat(fname, s);
      fq = fopen(fname, "r");

      if (fq == NULL)
      {
	 *fname = '\0';
         strcpy(fname, "./help/");
	 strcat(fname, s);
         fq = fopen(fname, "r"); 
      }
   }

   if (fq != NULL)
   {
      while ((c = getc(fq)) != EOF)
	 printf("%c", c);
      fclose(fq);
   }

   else
      return(1);

   return(0);
}



void update_data(x, y, x_new, y_new)
double x, y, x_new, y_new;
{
   if (erase[ws_act] == FALSE) 
   {
      if (fabs(x - x_new) > 1.0e-4 || fabs(y - y_new) > 1.0e-4 )
         erase[ws_act] = TRUE;
   }
}



void update_str(s1, s2)
char *s1, *s2;
{
   if (erase[ws_act] == FALSE)
   {
      if (strncmp(s1, s2, 2) != 0)
      {
	 erase[ws_act] = TRUE;
      }
   }
}



static void save_redr(win_num, s)
int win_num;
char *s;
{
   int i;

   if (redrfile[win_num] == NULL)
   {
      redrfile[win_num] = fopen(redrname[win_num], "w");
      ini_redr(redrfile[win_num]);
   }

   else
      fseek(redrfile[win_num], 0, 2);

   if (   strncmp(s, "border",  4) == 0
       || strncmp(s, "contour", 4) == 0)
      fprintf(redrfile[win_num], "color %d grid\n", grid_color[ws_act]);

   else if (strncmp(s, "grid", 4) == 0)
   {
      fprintf(redrfile[win_num], "gcs %s %s %-g\n", 
		      cs_name[csgrid[ws_act]], bjgrid[ws_act], eqnxgrid[ws_act]);
      fprintf(redrfile[win_num], "color %d grid\n", grid_color[ws_act]);
   }

  else  if (strncmp(s, "map", 3) == 0)
   {
      if (Ndata[ws_act][map_num[ws_act]] > MAXPT)
      {
#ifdef SUNOS
	 londata[ws_act][map_num[ws_act]] = (double *)
	          realloc((char *)londata[ws_act][map_num[ws_act]], 
		  (unsigned int) (Ndata[ws_act][map_num[ws_act]] * 
		  sizeof(double)));
	 latdata[ws_act][map_num[ws_act]] = (double *)
		  realloc((char *)latdata[ws_act][map_num[ws_act]], 
		  (unsigned int) (Ndata[ws_act][map_num[ws_act]] * 
		  sizeof(double)));
#else
	 londata[ws_act][map_num[ws_act]] = (double *)
		  realloc((void *)londata[ws_act][map_num[ws_act]], 
		  (size_t) (Ndata[ws_act][map_num[ws_act]] * sizeof(double)));
	 latdata[ws_act][map_num[ws_act]] = (double *)
		  realloc((void *)latdata[ws_act][map_num[ws_act]], 
		  (size_t) (Ndata[ws_act][map_num[ws_act]] * sizeof(double)));
#endif
      }

      for (i=0; i<Ndata[ws_act][map_num[ws_act]]; i++)
      {
         londata[ws_act][map_num[ws_act]][i] = x[xcol][i];
         latdata[ws_act][map_num[ws_act]][i] = x[ycol][i];
      }

      fprintf(redrfile[win_num], "dcs %s %s %-g\n", 
		  cs_name[csdata[ws_act]], bjdata[ws_act], eqnxdata[ws_act]);
      fprintf(redrfile[win_num], "color %d symbol\n", 
		  symbol_color[ws_act]);
      fprintf(redrfile[win_num], "expan %-g symbol\n", 
		  sexp[ws_act]);
      fprintf(redrfile[win_num], "symang %-g\n", 
		  mang[ws_act]);
      fprintf(redrfile[win_num], "ptype %d %d \n", 
		  nsides[ws_act], ptype[ws_act]);
   }

   else if (strncmp(s, "label", 5) == 0)
   {
      fprintf(redrfile[win_num], "lcs %s\n", cs_name[csloc[ws_act]]);
      fprintf(redrfile[win_num], "la %s\n", cs_name[cslab[ws_act]]);
      fprintf(redrfile[win_num], "color %d  label\n", 
	      label_color[ws_act]);
      fprintf(redrfile[win_num], "expan %-g label\n", 
	      lexp[ws_act]);
      fprintf(redrfile[win_num], "move %-g %-g\n", 
	      longi[ws_act], lati[ws_act]);
   }

   fprintf(redrfile[win_num], "%s\n", s);
   fflush(redrfile[win_num]);
}



static int fullpath(outpath, inpath)
char *outpath, *inpath;
{
    char *getenv();
    char *o, *p;
    struct passwd *pw;
    char person[40];

    strcpy(outpath, inpath);

    if (inpath[0] == '~')
    {
	/* expand the tilde */
	for (p = person, o = &inpath[1]; *o && *o != '/'; *p++ = *o++)
		;
	*p = '\0';
	if (person[0] == '\0')
	{
	    p = getenv("HOME");
	    if (p == NULL)
	    {
		printf("HOME environment variable is undefined");
		return(0);
	    }
	    strcpy(outpath, p);
	}
	else
	{
	    pw = getpwnam(person);
	    if (pw == NULL)
	    {
		printf("cannot find home directory for %s", person);
		return (0);
	    }
	    strcpy(outpath, pw->pw_dir);
	}
	strcat(outpath, o);
    }
    return(1);
}



static void ini_redr(redr_fp)
FILE *redr_fp;
{
   fprintf(redr_fp, "proj %10s\n", para[ws_act].proj); 
   fprintf(redr_fp, "mctype %4s\n", flag[ws_act]); 
   fprintf(redr_fp, "pcs %s %s %-5g\n", 
		     cs_name[csproj[ws_act]], bjproj[ws_act], eqnxproj[ws_act]);
   fprintf(redr_fp, "pcent %-16g %-16g\n", 
		     para[ws_act].pcent.lon, para[ws_act].pcent.lat); 
   fprintf(redr_fp, "mcent %-16g %-16g\n", 
		     para[ws_act].mcent.lon, para[ws_act].mcent.lat); 
   fprintf(redr_fp, "size %-16g %-16g\n",
		     para[ws_act].size.su, para[ws_act].size.sv);
   fprintf(redr_fp, "rotate %-16g\n", rtwist[ws_act]*rtd);
   fflush(redr_fp);
}


static void copyfile(intfile, outfile, decolor)
int  decolor;
char *intfile, *outfile;
{
   int  d, flag;
   char str[MAXLINE];
   FILE *ifp, *ofp;

   ifp = fopen(intfile, "r");
   ofp = fopen(outfile, "w");

   flag = 0;

   if (decolor != 2)
   {
      while ( (fgets(str, MAXLINE, ifp)) != (char *)NULL )
      {
         if (decolor==0)
            fputs(str, ofp);

         else
         {
            if(flag == 0)
            {
	       if(strncmp(str, "%!color", 7) != 0)
	          fputs(str, ofp);
               else
	          flag = 1;
            }
            else
   	       flag = 0;
         }
      
      }
   }
   
   else 
   {
      while ((d = getc(ifp)) != EOF)
	 putc(d, ofp);
   }

   fclose(ifp);
   fclose(ofp);
}



static int init_contours()
{
   int i, j, k;

   if (conts == (CPOLY *)(NULL))
   {
   maxlvl = MAXLVL;
   poly_max = (int   *)malloc((unsigned)(maxlvl * sizeof(int)));
   if (poly_max == NULL)
   {
      fprintf(stderr, "Can't allocate required memory.\n");
      return 1;
   }
   conts    = (CPOLY *)malloc((unsigned)(maxlvl * sizeof(CPOLY)));
   if (conts == NULL)
   {
      fprintf(stderr, "Can't allocate required memory.\n");
      return 1;
   }

   CPOLY_MAXC = CPOLY_MAXCINC;
   for (i=0; i<maxlvl; i++)
   {
       poly_max[i] = CPOLY_MAXC;
       conts[i].npoly = 0;
       conts[i].poly  = (CPOLYN **)
		         malloc((unsigned)(CPOLY_MAXC * sizeof(CPOLYN *)));
      
       if (conts[i].poly == NULL)
       {
	  fprintf(stderr, "Can't allocate required memory.\n");
	  return 1;
       }

       for (j=0; j<CPOLY_MAXC; ++j)
       {
           conts[i].poly[j] = (CPOLYN *)malloc((unsigned)(sizeof(CPOLYN)));
	   if (conts[i].poly[j] == NULL)
	   {
	      fprintf(stderr, "Can't allocate required memory.\n");
	      return 1;
	   }
	   conts[i].poly[j]->npts = 0;
	   conts[i].poly[j]->maxpts = CPOLY_MAXPINC;

	   conts[i].poly[j]->pnt
	   = (CPOLY_PNT **) malloc((unsigned)
			   (CPOLY_MAXPINC * sizeof(CPOLY_PNT *)));
	   if (conts[i].poly[j]->pnt == NULL)
	   {
	      fprintf(stderr, "Can't allocate required memory.\n");
	      return 1;
	   }

           for (k=0; k<CPOLY_MAXPINC; ++k)
           { 
	       conts[i].poly[j]->pnt[k] = (CPOLY_PNT *)
	       malloc((unsigned)(sizeof(CPOLY_PNT)));
	       if (conts[i].poly[j]->pnt[k] == NULL)
	       {
		  fprintf(stderr, "Can't allocate required memory.\n");
		  return 1;
	       }
           }
       }
   }
   }

   if (contpts == (Gpoint *)NULL)
   {
      contpts_max = CPOLY_MAXPINC;
      contpts     = (Gpoint *)malloc((unsigned)(contpts_max * sizeof(Gpoint)));
      if (contpts == NULL)
      {
	 fprintf(stderr, "Can't allocate required memory.\n");
	 return 1;
      }
   }
   
   return 0;
}



void svcreturn (msgtype, status, str, structflag)

/*---------------------------------------------------------------------------*/
/*                                                                           */
/*  Prints out message, wrapping it a structure and accounting for           */
/*  quotes, as a signal.                                                     */
/*                                                                           */
/*---------------------------------------------------------------------------*/

int   msgtype;
int   status;
char* str;
int   structflag;
{
   int i;

   if(msgtype == SIGNAL)
      printf("SIGNAL: ");

   if(status == OK)
      printf("[struct stat=\"OK\"");
   else
      printf("[struct stat=\"ERROR\"");

   if(!str)
   {
      printf("]\n");
      fflush(stdout);
      return;
   }

   printf(", return=");

   if(!structflag)
      putchar('"');

   for(i=0; i<(int)strlen(str); ++i)
   {
      if(str[i] == '\n')
      {
	 putchar('\\');
	 putchar('n');
      }
      else if(!structflag && str[i] == '"')
      {
	 putchar('\\');
	 putchar('"');
      }
      else
	 putchar(str[i]);
   }

   if(!structflag)
      putchar('"');

   printf("]\n");
   fflush(stdout);
}




int cntcheck(cmd, cmdc, min, max)

char *cmd;
int cmdc, min, max;
{
   if(max == 0)
   {
      if(cmdc != min)
      {
	 if (mode == INTERACTIVE)
	 {
	    (void) printf("ERROR: Incorrect parameter count for command.\n");
	    (void) fflush(stdout);
	 }

	 else
	 {
	    sprintf(msgstr, "%s: Incorrect parameter count for command.", cmd);
	    svcreturn(RETURN, ERROR, msgstr, SCALAR);
	 }

	 return(1);
      }
   }

   else
   {
      if(cmdc < min || cmdc > max)
      {
	 if (mode == INTERACTIVE)
	 {
	    (void) printf("ERROR: Invalid parameter count for command.\n");
	    (void) fflush(stdout);
	 }

	 else
	 {
	    sprintf(msgstr, "%s: Invalid parameter count for command.", cmd);
	    svcreturn(RETURN, ERROR, msgstr, SCALAR);
	 }

	 return(1);
      }
   }

   return(0);
}

void f_polyline(num, pts)
int num;
Gpoint *pts;
{
   ps_polyline(num, pts);
   gif_polyline(num, pts);
}

void f_color(color)
int color;
{
   ps_color(color);
   gif_color(color);
}



void trans_center(lon, lat, tmpcs1, tmpcs2, plon, plat)
double lon, lat;
char   *tmpcs1, *tmpcs2;
double *plon, *plat;
{
   int coord1, coord2;
   double glon, glat;

   switch(cs(tmpcs1))
   {
      case EC: coord1 = 0; break;
      case EQ: coord1 = 1; break;
      case GA: coord1 = 2; break;
      case SG: coord1 = 3; break;
   }

   switch(cs(tmpcs2))
   {
      case EC: coord2 = 0; break;
      case EQ: coord2 = 1; break;
      case GA: coord2 = 2; break;
      case SG: coord2 = 3; break;
   }

   /*
   tran = AA[coord1][coord2];
   (*func[tran])(lon, lat, &glon, &glat);
   */


   *plon = glon;
   *plat = glat;
}
