/* wpix.c  (write pixels) */
/* %W% %E% %U% */
/* #Copyright (C) 1992,1993 California Institute of Technology. */
/* #U.S. Government Sponsorship under NASA Contract NAS7-918 */
/* #is acknowledged. */
/* jan 1993 bitpix = -64 IRAF pixtype = 7 */

#include <unistd.h>
#include <sys/file.h>
#include <math.h>
#include <string.h>
#include <fcntl.h>
#include "im.h"
#include "irafhdr.h"

#ifdef NOTDEF
#ifndef finite
extern int      finite(double);
#endif /* finite */
#endif /* NOTDEF */

#ifdef ALPHA
#include <file.h>
#include <unixio.h>
#endif /* ALPHA */

struct fid_struct *f;

extern int im_rawflag;
static int write_bytes();
static int do_wpix_setup();

/******* *******
 return codes:
-3 = bad fid
-2 = bad file status (open for read, error, etc.)
-1 = wrong data type
 0 = no more room to write pixels
 n = ok: number of pixels written
******* *******/

/*---------------------------------------------------------*/

static float *pix_ptr;
static double *dbl_ptr;

/*---------------------------------------------------------*/

int
im_wpix_i(fid,buffer,n_pix)
int fid;
int buffer[];
int n_pix;
{
   int n_bytes;

   if (IM_set_fid(fid)) return(-3);

   if (f->val_bitpix != 32) return(-2);

   if (n_pix < 0) return(IM_w_rewind(f->cur_window));

   if (f->need_wpix_setup) { if(do_wpix_setup()<0) return(-2); }

   n_bytes = n_pix * 4;
   if (f->file_type == Type_fits && !im_rawflag ) IM_swap_4((unsigned char *)buffer,n_bytes);
   n_bytes = write_bytes((unsigned char *)buffer,n_bytes);
   if (n_bytes<=0) return(n_bytes);
   return(n_bytes/4);
   
}


/*---------------------------------------------------------*/

int
im_wpix_s(fid,buffer,n_pix)
int fid;
short int buffer[];
int n_pix;
{
   int n_bytes;

   if (IM_set_fid(fid)) return(-3);

   if (f->val_bitpix != 16) return(-2);
   
   if (n_pix < 0) return(IM_w_rewind(f->cur_window));

   if (f->need_wpix_setup) { if(do_wpix_setup()<0) return(-2); }

   n_bytes = n_pix + n_pix;
   if (f->file_type == Type_fits && !im_rawflag ) 
       IM_swap_2((unsigned char *)buffer,n_bytes);
   n_bytes = write_bytes((unsigned char *)buffer,n_bytes);
   if (n_bytes <= 0) return(n_bytes);
   return(n_bytes/2);
}

/*---------------------------------------------------------*/


int
im_wpix_c(fid,buffer,n_pix)
int fid;
unsigned char buffer[];
int n_pix;
{

   if (IM_set_fid(fid)) return(-3);

   if (f->val_bitpix != 8) return(-2);
   
   if (n_pix < 0) return(IM_w_rewind(f->cur_window));

   if (f->need_wpix_setup) { if(do_wpix_setup()<0) return(-2); }

   n_pix = write_bytes((unsigned char *)buffer,n_pix);
   return(n_pix);
}

/*---------------------------------------------------------*/


int
im_wpix_r(fid,buffer,n_pix)
int fid;
float buffer[];
int n_pix;
{
   union {double *dbl; float *flt; int *hex;} temp;
   int i;
   int n_bytes;
   int min, max;
   float fmin, fmax;

   int *i_32;
   short int *i_16;
   unsigned char *i_8;
   float value_NaN;

   if (IM_set_fid(fid)) return(-3);

   if (n_pix < 0) return(IM_w_rewind(f->cur_window));

   if (f->need_wpix_setup) { if(do_wpix_setup()<0) return(-2); }

   im_blank(&value_NaN);

   for(temp.flt = buffer+n_pix-1; temp.flt>=buffer; temp.flt--) {
      if ( (*temp.hex & 0x7F800000) == 0x7F800000) *temp.flt = value_NaN;
   }

   if (f->val_offset || f->val_scale!=1.0)
    for(pix_ptr = buffer; pix_ptr<buffer+n_pix; pix_ptr++) {
       *pix_ptr = (*pix_ptr - f->val_offset) / f->val_scale;
   }


   n_bytes = n_pix * f->bytes_per_pix;

   switch(f->val_bitpix) {
      case 8:
       i_8 = (unsigned char *)buffer;
       min = 0;
       max = 255;
       if (f->val_blank_flag == 0) f->val_blank = 0;
       else {
          if (f->val_blank <= 0) min = f->val_blank+1;
          if (f->val_blank >  0) max = f->val_blank-1;
       }
       fmin = min; fmax = max;
       for (i=0; i<n_pix; i++) {
          if (!FINITE((double) buffer[i])) *i_8 = f->val_blank;
          else if (buffer[i] >= fmax) *i_8 = max;
          else if (buffer[i] <= fmin) *i_8 = min;
          else                       *i_8 = buffer[i] + 0.5;
          i_8++;
       }
       break;

      case 16:
       i_16 = (short int *)buffer;
       min = -32768;
       max = 32767;
       if (f->val_blank_flag == 0) f->val_blank = -32768;
       if (f->val_blank <= 0) min = f->val_blank+1;
       if (f->val_blank >  0) max = f->val_blank-1;
       fmin = min; fmax = max;
       for (i=0; i<n_pix; i++) {
          if (!FINITE((double) buffer[i])) *i_16 = f->val_blank;
          else if (buffer[i] >= fmax) *i_16 = max;
          else if (buffer[i] <= fmin) *i_16 = min;
          else if (buffer[i] >= 0  ) *i_16 = buffer[i] + 0.5;
          else                       *i_16 = buffer[i] - 0.5;
          i_16++;
       }
       if (f->file_type == Type_fits ) IM_swap_2((unsigned char *)buffer,n_bytes);
       break;

      case 32:

       i_32 = (int *)buffer;

       min = -2147483647; /* -2**31 */
       max =  2147483647;
       if (f->val_blank_flag ==  0) f->val_blank = -2147483647; /* -2**31 */
       if (f->val_blank <= 0) min = f->val_blank+1;
       if (f->val_blank >  0) max = f->val_blank-1;
       fmin = min; fmax = max;
       for (i=0; i<n_pix; i++) {
          if (!FINITE((double) buffer[i])) *i_32 = f->val_blank;
          else if (buffer[i] >= fmax) *i_32 = max;
          else if (buffer[i] <= fmin) *i_32 = min;
          else if (buffer[i] >= 0  )  *i_32 = buffer[i] + 0.5;
          else                        *i_32 = buffer[i] - 0.5;
          i_32++;
       }
       if (f->file_type == Type_fits ) IM_swap_4((unsigned char *)buffer,n_bytes);
       break;

      case -32:
       if (f->file_type == Type_iraf) {
          for(i=0; i<n_pix; i++) {
             if (!FINITE((double) buffer[i]))
	     {
		 /* RBH CHANGED */
		 if (f->val_blank_flag)
		     buffer[i] = f->val_blank;
		 else
		     buffer[i] = 0;
	     /* END RBH CHANGED */
	     }
          }
       }
       if (f->file_type == Type_fits ) IM_swap_4((unsigned char *)buffer,n_bytes);
       break;

      default:
       return(-2); /* Writing r*4 into r*8 isn't allowed */
   }
   
   n_bytes = write_bytes((unsigned char *)buffer,n_bytes);

   if (n_bytes <= 0) return(n_bytes);
   return(n_bytes / f->bytes_per_pix);
}
/*---------------------------------------------------------*/


int
im_wpix_d(fid,buffer,n_pix)
int fid;
double buffer[];
int n_pix;
{
   union {double *dbl; float *flt; int *hex;} temp;
   int i;
   int n_bytes;
   int min, max;
   float fmin, fmax;

   float *r_32;
   int *i_32;
   short int *i_16;
   unsigned char *i_8;
   double value_NaN;

   if (IM_set_fid(fid)) return(-3);

   if (n_pix < 0) return(IM_w_rewind(f->cur_window));

   if (f->need_wpix_setup) { if(do_wpix_setup()<0) return(-2); }

   im_blankd(&value_NaN);

   if (im_byteorder() == 1)
   {
       for(temp.dbl = buffer+n_pix-1; temp.dbl>=buffer; temp.dbl--) {
        if ( (*temp.hex & 0x7FF00000) == 0x7FF00000) *temp.dbl = value_NaN;
       }
   }
   else
   {
       for(temp.dbl = buffer+n_pix-1; temp.dbl>=buffer; temp.dbl--) {
        if ( (*(temp.hex+1) & 0x7FF00000) == 0x7FF00000) *temp.dbl = value_NaN;
       }
   }

   if ((f->val_offset || f->val_scale!=1.0) && f->val_bitpix > 0)
    for(dbl_ptr = buffer; dbl_ptr<buffer+n_pix; dbl_ptr++) {
       *dbl_ptr = (*dbl_ptr - f->val_offset) / f->val_scale;
   }


   n_bytes = n_pix * f->bytes_per_pix;

   switch(f->val_bitpix) {
      case 8:
       i_8 = (unsigned char *)buffer;
       min = 0;
       max = 255;
       if (f->val_blank_flag == 0) f->val_blank = 0;
       else {
          if (f->val_blank <= 0) min = f->val_blank+1;
          if (f->val_blank >  0) max = f->val_blank-1;
       }
       fmin = min; fmax = max;
       for (i=0; i<n_pix; i++) {
          if (!FINITE(buffer[i])) *i_8 = f->val_blank;
          else if (buffer[i] >= fmax) *i_8 = max;
          else if (buffer[i] <= fmin) *i_8 = min;
          else                       *i_8 = buffer[i] + 0.5;
          i_8++;
       }
       break;

      case 16:
       i_16 = (short int *)buffer;
       min = -32768;
       max = 32767;
       if (f->val_blank_flag == 0) f->val_blank = -32768;
       if (f->val_blank <= 0) min = f->val_blank+1;
       if (f->val_blank >  0) max = f->val_blank-1;
       fmin = min; fmax = max;
       for (i=0; i<n_pix; i++) {
          if (!FINITE(buffer[i])) *i_16 = f->val_blank;
          else if (buffer[i] >= fmax) *i_16 = max;
          else if (buffer[i] <= fmin) *i_16 = min;
          else if (buffer[i] >= 0  ) *i_16 = buffer[i] + 0.5;
          else                       *i_16 = buffer[i] - 0.5;
          i_16++;
       }
       if (f->file_type == Type_fits ) IM_swap_2((unsigned char *)buffer,n_bytes);
       break;

      case 32:

       i_32 = (int *)buffer;

       min = -2147483647; /* -2**31 */
       max =  2147483647;
       if (f->val_blank_flag ==  0) f->val_blank = -2147483647; /* -2**31 */
       if (f->val_blank <= 0) min = f->val_blank+1;
       if (f->val_blank >  0) max = f->val_blank-1;
       fmin = min; fmax = max;
       for (i=0; i<n_pix; i++) {
          if (!FINITE(buffer[i])) *i_32 = f->val_blank;
          else if (buffer[i] >= fmax) *i_32 = max;
          else if (buffer[i] <= fmin) *i_32 = min;
          else if (buffer[i] >= 0  )  *i_32 = buffer[i] + 0.5;
          else                        *i_32 = buffer[i] - 0.5;
          i_32++;
       }
       if (f->file_type == Type_fits ) IM_swap_4((unsigned char *)buffer,n_bytes);
       break;

      case -32:
       r_32 = (float *)buffer;
       for(i=0; i<n_pix; i++) {
          if (f->file_type == Type_iraf) 
             if (!FINITE(buffer[i]))
	     {
		 /* RBH CHANGED */
		 if (f->val_blank_flag)
		     buffer[i] = f->val_blank;
		 else
		     buffer[i] = 0;
	     /* END RBH CHANGED */
	     }
          *r_32++ = buffer[i];
       }
       if (f->file_type == Type_fits ) IM_swap_4((unsigned char *)buffer,n_bytes);
       break;

      case -64:
       if (f->file_type == Type_iraf) {
          for(i=0; i<n_pix; i++) {
             if (!FINITE(buffer[i]))
	     {
		 /* RBH CHANGED */
		 if (f->val_blank_flag)
		     buffer[i] = f->val_blank;
		 else
		     buffer[i] = 0;
	     /* END RBH CHANGED */
	     }
          }
       }
       if (f->file_type == Type_fits ) IM_swap_8((unsigned char *)buffer,n_bytes);
       break;

   }
   
   n_bytes = write_bytes((unsigned char *)buffer,n_bytes);

   if (n_bytes <= 0) return(n_bytes);
   return(n_bytes / f->bytes_per_pix);
}

/*---------------------------------------------------------*/

static int write_bytes(buffer,n_bytes_to_do)
unsigned char buffer[];
int n_bytes_to_do;
{
   struct window_struct *w;
   int n_bytes_done;
   int actual_bytes;
   int now_bytes;
   int dim;
   int i;

   if (f->mode == 1) return(-2);

   if (f->cur_window== 0) IM_init_w();
   w = f->cur_window;

   n_bytes_done = 0;
   if (n_bytes_to_do > w->total_bytes_left_to_write)
     n_bytes_to_do = w->total_bytes_left_to_write;

   while (n_bytes_to_do > 0) {

      if(f->unix_pix_fid)
       lseek(f->unix_pix_fid, (long) f->io_offset+w->cur_byte_write, 0);
      if (n_bytes_to_do > w->line_bytes_left_to_write)
        now_bytes = w->line_bytes_left_to_write;
        else now_bytes = n_bytes_to_do;
      if(f->unix_pix_fid)
       actual_bytes = write(f->unix_pix_fid, buffer, (unsigned int)now_bytes);
      else actual_bytes = fwrite(buffer,1,now_bytes,stdout);
      if (actual_bytes < 0) return(-2);

      buffer += actual_bytes;
      n_bytes_done += actual_bytes;
      n_bytes_to_do -= actual_bytes;
      w->cur_byte_write += actual_bytes;
      w->line_bytes_left_to_write -= actual_bytes;
   
      if (w->line_bytes_left_to_write <=0) {
         w->cur_byte_write += w->skip_bytes;
         w->line_bytes_left_to_write = w->line_bytes;

         w->left_to_write[2] --;
         for (i=2; (i<f->val_naxis[0]) && (w->left_to_write[i]==0); i++) {
            if (i==2) dim = f->bytes_per_pix;
            dim *= f->val_naxis[i-1];
            w->cur_byte_write += (f->val_naxis[i] - w->naxis_take[i]) * dim;
            w->left_to_write[i] = w->naxis_take[i];
            w->left_to_write[i+1] --;
         }
      }

   }
 
   w->total_bytes_left_to_write -= n_bytes_done;
   return(n_bytes_done);

}


/*---------------------------------------------------------*/

static int do_wpix_setup()
{
   int n;

   f->need_wpix_setup = 0;

   n = strlen(f->hdr_filename);
   if      (strcmp(&f->hdr_filename[n-4],".imh") == 0) f->file_type=Type_iraf;
   else if (strcmp(&f->hdr_filename[n-4],".zzh" ) == 0) f->file_type=Type_zz;
   else if (strcmp(&f->hdr_filename[n-5],".fits") == 0) f->file_type=Type_fits;
   else if (strcmp(&f->hdr_filename[n-4],".fit") == 0) f->file_type=Type_fits;
   else if (strcmp(f->hdr_filename,"-") == 0) f->file_type = Type_fits;
   else if (f->file_type == Type_iraf) strcat(f->hdr_filename,".imh");
   else if (f->file_type == Type_zz) strcat(f->hdr_filename,".zzh");
   else {
      strcat(f->hdr_filename,".fits");
      f->file_type = Type_fits;
   }

   switch (f->file_type) {

      case Type_fits:
       if (strcmp(f->hdr_filename,"-") != 0) 
        f->unix_hdr_fid = open(f->hdr_filename,O_RDWR|O_CREAT|O_TRUNC,0664);
       if (f->unix_hdr_fid < 0) {
          return(-2);
       }
       strcpy(f->pix_filename,f->hdr_filename);
       f->unix_pix_fid = f->unix_hdr_fid;
       f->io_offset = ((f->n_headers+3+35)/36) * 2880;
       if (f->unix_pix_fid == 0) IM_write_hdr();
       break;

      case Type_zz:
       n = strlen(f->hdr_filename);
       strcpy(f->pix_filename,f->hdr_filename);
       strcpy(f->pix_filename+n-3,"zzp");
       f->unix_pix_fid = open(f->pix_filename,O_RDWR|O_CREAT|O_TRUNC,0664);
       if (f->unix_pix_fid < 0) return(-2);
       break;

      case Type_iraf:
       if (f->bytes_per_pix == 1) return(-2); /*  IRAF doesn't do BITPIX=8 */
       n = strlen(f->hdr_filename);
       strcpy(f->pix_filename,f->hdr_filename);
       strcpy(f->pix_filename+n-3,"pix");
       f->unix_pix_fid = open(f->pix_filename,O_RDWR|O_CREAT|O_TRUNC,0664);
       if (f->unix_pix_fid < 0) return(-2);
       f->io_offset = SZ_PIXHDR;
       break;

      case Type_S:
       break;

      case Type_unknown:
       break;

   } /* end switch */
   return(0); /* RBH added */
}


/*---------------------------------------------------------*/

int
IM_w_rewind(w)
struct window_struct *w;
{
   int i;
   if (f->cur_window== 0) {IM_init_w(); if(w==0) w=f->cur_window;}
   w->cur_byte_write = w->start_byte;
   w->total_bytes_left_to_write = w->total_bytes;
   w->line_bytes_left_to_write = w->line_bytes;
   for (i=2; i < f->val_naxis[0]; i++) w->left_to_write[i] = w->naxis_take[i];
   return(w->total_bytes / f->bytes_per_pix);
}


