/* wkey.c  (write keyword value) */
/* %W% %E% %U% */
/* #Copyright (C) 1992, California Institute of Technology. */
/* #U.S. Government Sponsorship under NASA Contract NAS7-918 */
/* #is acknowledged. */

#include "im.h"
#include <string.h>

static char text[120];
struct fid_struct *f;

/* function prototypes */
#ifdef _NO_PROTO
static set_kwd();
#else
static int set_kwd(int id, char keyword[]);
#endif /* _NO_PROTO */


/******* *******
 return codes:
-3 = bad fid
-2 = illegal keyword or value
 0 = ok, but not a real header card
 n = ok: number of header card put into
******* *******/

/*---------------------------------------------------------*/

static int set_kwd(id,keyword)
int id;
char keyword[];
/* returns: >0 if OK, 0 if not a real card,   -2 if error,   -3 if bad id */
{
   int stat;
   char card[80];

   if (IM_set_fid(id)) return(-3);

   sprintf(card,"%-8.8s= %s",keyword,text);

   stat = IM_card_find(keyword);
   if (stat>0) stat = IM_card_replace(card);
   else {
      stat = IM_card_add(card);
   }

   return(stat);
}
/*---------------------------------------------------------*/

int
im_wkey_i(id,value,keyword)
int id;
int value;
char keyword[];
{
   sprintf(text,"%20d",value);
   return(set_kwd(id,keyword));
}

/*---------------------------------------------------------*/

int
im_wkey_r(fid,value,keyword)
int fid;
double value;
char keyword[];
{
   char *c;
   int stat;

   sprintf(text," %19.10G",value);

   for (c=text; *c && *c!='.'; c++);
   /* add decimal if none */
   if (*c=='\0') {
      for (c=text+1; *c; c++) *(c-1) = *c; *(c-1) = '.';
   }
   stat = set_kwd(fid,keyword);
   return(stat);
}

/*---------------------------------------------------------*/

int
im_wkey_d(fid,value,keyword)
int fid;
double value;
char keyword[];
{
   char *c;
   sprintf(text," %19.10G",value);
   for (c=text; *c && *c!='.'; c++);
   /* add decimal if none */
   if (*c=='\0') {for (c=text+1; *c; c++) *(c-1) = *c; *(c-1) = '.';}
   return(set_kwd(fid,keyword));
}

/*---------------------------------------------------------*/

int
im_wkey_c(id,ptr,keyword)
int id;
char *ptr;
char keyword[];
{

   if (ptr == 0) return(-2);

   sprintf(text,"'%-8.68s'",ptr);
   return(set_kwd(id,keyword));
}

/*---------------------------------------------------------*/

int
im_wkey_l(fid,value,keyword)
int fid;
int value;
char keyword[];
{
   if (value) strcpy(text,"                   T");
   else       strcpy(text,"                   F");
   return(set_kwd(fid,keyword));
}

/*---------------------------------------------------------*/

int
im_wkey_t(fid,ptr,keyword)
int fid;
char *ptr;
char keyword[];
{
   int n;
   char *c;
   char *card;
   int flag = 0; /* set !=0 if in a quoted string */

   if (IM_set_fid(fid)) return(-3);

   switch(keyword[0]) {

      case '/': /* comments */
       card = f->cur_header->text;
       c = card+10;
       while (*c!='\0' && (*c!='/' || flag==1) && c<card+75) {
          if (*c == '\'') {if (flag) flag=0; else flag=1;}
          c++;
       }
       while (c < card+30) *c++ = ' '; /* don't start before col 30 */
       *c++ = ' '; *c++ = '/'; *c++ = ' ';
       n = card - c + 80;
       strncpy(c,ptr, (unsigned) n);
       c = card+80;
       *c = '\0';
       return(1);

      case 'e': /* add new card at end */
         f->cur_header = f->last_header;
	 /*FALLTHROUGH*/

      case 'a': /* add after current card */
         return(IM_card_add(ptr));

      case 'r': /* replace current card */
         return(IM_card_replace(ptr));

      case 'd': /* delete current card */
         return(IM_card_delete());

   };

   return(-2);
}
