/* window.c */
/* %W% %E% %U% */
/* #Copyright (C) 1992, California Institute of Technology. */
/* #U.S. Government Sponsorship under NASA Contract NAS7-918 */
/* #is acknowledged. */

#include "im.h"

extern struct fid_struct *f;

int
im_dwin(fid,window,takes,skips)
int fid;
int window;
int takes[10];
int skips[10];
/* return -3=illegal fid,  -2=illegal window num,  0=OK */
{
   int i;
   int dimension_bytes; /* number of bytes up to dimension i */
   struct window_struct *w; /* new window */
   struct window_struct *v; /* "current" window */

   if (IM_set_fid(fid)) return(-3);

   if (f->cur_window == 0) IM_init_w();

   if (window <= 0 || window >= MAX_WINDOWS) return(-2);
      
   v = f->cur_window;
   w = &f->windows[window];

   /* save parameters */
   for (i=1; i <= takes[0]; i++) {
      w->naxis_skip[i] = skips[i] + v->naxis_skip[i];
      w->naxis_take[i] = takes[i];
   }
   for (i=takes[0]+1; i<=f->val_naxis[0]; i++) {
      w->naxis_skip[i] = v->naxis_skip[i];
      w->naxis_take[i] = v->naxis_take[i];
   }
   for (i=1; i<=f->val_naxis[0]; i++) { /* adjust if out of range */
      if(w->naxis_skip[i] < 0)  {
         w->naxis_take[i] += w->naxis_skip[i];
         w->naxis_skip[i] = 0;
      }
      else if(w->naxis_skip[i] >= f->val_naxis[i])
        w->naxis_skip[i] = f->val_naxis[i];

      if(w->naxis_take[i] < 0)  w->naxis_take[i] = 0;
      if(w->naxis_take[i] + w->naxis_skip[i] > f->val_naxis[i])
         w->naxis_take[i] = f->val_naxis[i] - w->naxis_skip[i];
   }

   w->line_bytes = w->naxis_take[1] * f->bytes_per_pix;
   w->skip_bytes = f->bytes_per_pix *
       (f->val_naxis[1] - w->naxis_take[1] + f->line_skip_pix);
   w->start_byte =  w->naxis_skip[1] * f->bytes_per_pix;

   w->total_bytes = w->naxis_take[1] * f->bytes_per_pix;
   dimension_bytes = (f->val_naxis[1]+ f->line_skip_pix) * f->bytes_per_pix;
   for (i=2; i<=f->val_naxis[0]; i++) {
      w->start_byte  += w->naxis_skip[i] * dimension_bytes;
      w->total_bytes *= w->naxis_take[i];
      dimension_bytes *= f->val_naxis[i];
   }

   IM_r_rewind(w);
   IM_w_rewind(w);

   return(0);
}


int
im_swin(fid,window)
int fid;
int window;
/* return -3=illegal fid,  -2=illegal window num,  0=OK */
{

   if (IM_set_fid(fid)) return(-3);

   if (f->cur_window == 0) IM_init_w();

   if (window<0 || window>=MAX_WINDOWS) return(-2);

   if (f->windows[window].total_bytes < 0) return(-2);

   f->cur_window = &f->windows[window];
   return(0);
}

/****************************************************/

void
IM_init_w()
/* initialize window 0 */
{
   int i;
   struct window_struct *w;

   w = f->cur_window = &f->windows[0];

   for (i=1; i<=f->val_naxis[0]; i++) w->naxis_take[i] = f->val_naxis[i];

   w->line_bytes = f->val_naxis[1] * f->bytes_per_pix;
   w->skip_bytes = f->line_skip_pix * f->bytes_per_pix;
   w->start_byte = 0;
   w->total_bytes = f->n_pixels * f->bytes_per_pix;

   IM_r_rewind(w);
   IM_w_rewind(w);
}
