/* setw1.c */
/* %W% %E% %U% */
/* process sub-image specifier and set-up window 1 */
/* #Copyright (C) 1992, California Institute of Technology. */
/* #U.S. Government Sponsorship under NASA Contract NAS7-918 */
/* #is acknowledged. */

#include <stdio.h>
#include "im.h"
#include "rwc.h"

#define SIZE_PIPE_BUF 120

int
IM_setw1(f,skips,takes)
/* parse the ascii window specification into skips and takes */
struct fid_struct *f;
int skips[];
int takes[];
/* returns -4 if illegal sub-image specifier */
{

   int stat;
   struct rwc_struct rwc_block;

   takes[0] = 0;

   if (*(f->subset_text)) {
      if((stat = rwc_fid(&rwc_block,f->id)) != 0)
	  return (-4);
   
      if((stat = rwcf(&rwc_block,f->subset_text,skips,takes)) != 0)
	  return (-4);
   }

   return(0);
}
