/*   map_struct.h   */
/* Copyright (C) 1992, California Institute of Technology. */
/* U.S. Government Sponsorship under NASA Contract NAS7-918 */
/* is acknowledged. */

/* map projection data structure  */

#include <math.h>
#ifndef PI
#ifdef M_PI
#define PI M_PI
#else
#define PI 3.14159265358979323846
#endif
#endif

#define RAD_PER_DEG (PI/180.0)
#define DEG_PER_RAD (180.0/PI)
#define TWO_PI (PI * 2.0)

#define MAGIC_NUMBER 172737

struct map_struct {
  /* set by mapf or mapi */
  /*** these first 6 doubles not to change (used by custom functions) */
   double dlon; /* lon - lon0 */
   double lat; /* radians */
   double x, y;
  /* set by map_set */
   double sin_lat0;
   double cos_lat0;
   int magic;
   enum {P_AIT,P_TAN,P_SIN,P_ARC,P_POL,P_custom,P_linear} proj_type;
   char map_coord_type; /* r e g */
   double lon0; /* radians */
   double lat0; /* radians */
   double x_scale; /* pix per radian */
   double y_scale; /* pix per radian */
   double x0; /* offset to center */
   double y0; /* offset to center */
   double twist_angle1; /* radians */
   double twist_angle2; /* radians */
   int (* custom_mapf)();
   int (* custom_mapi)();
};

/* function prototypes */
#ifdef _NO_PROTO
int map_set ();
int mapf_string();
int map_hms();
int mapf();

#else

int map_set (struct map_struct *p, char   ctype1[], char   ctype2[],
    double cdelt1, double cdelt2, double crval1, double crval2,
    double crpix1, double crpix2, double crota1, double crota2);
int mapf_string(struct map_struct *p, char string[], double *out_x, double *out_y);
int map_hms(char string[], double *value);
int mapf(struct map_struct *p, int coord_type, double in_lon,
    double in_lat, double *out_x, double *out_y);
#endif /* _NO_PROTO */
