/* map_string.c */
/* Copyright (C) 1992, California Institute of Technology. */
/* U.S. Government Sponsorship under NASA Contract NAS7-918 */
/* is acknowledged. */

#include "map_struct.h"
#include <stdio.h>

/* mapf_string computes x,y given a coordinate string and map_block */

int
mapf_string(map_block,string,out_x,out_y)
struct map_struct *map_block;
char string[];
double *out_x;
double *out_y;
/* returns:
    0 = OK
   -1 = no latitude specified (+ or - sign)
   -2 = cannot translate longitude value
   -3 = cannot translate latitude value
   -4 = bad coordinate type (r e g)
   -5 = bad map_block
*/
{
   char in_ctype;
   char *lon_ptr;
   char *lat_ptr;
   double in_lon, in_lat;
   int stat;

/* figgure out coordinate type */
   switch(*string) {
      case 'r': case 'R': in_ctype = 'r'; break;
      case 'e': case 'E': in_ctype = 'e'; break;
      case 'g': case 'G': in_ctype = 'g'; break;
      default: in_ctype = '\0';
   } /* end switch */

   if (in_ctype) lon_ptr = string+1;
   else          lon_ptr = string;

/* find beginning of "lat" in the string */
   for (lat_ptr=lon_ptr+1; (*lat_ptr!='+'&&*lat_ptr!='-')&&*lat_ptr; lat_ptr++);
   if (*lat_ptr=='\0') return(-1);

/* figgure out in_lon  and in_lat */

   stat = map_hms(lat_ptr,&in_lat);
   if (stat<0) return(-3);

   *lat_ptr = '\0';
   stat = map_hms(lon_ptr,&in_lon);
   if (stat<0) return(-2);
   if (stat>0) if (in_ctype=='\0') in_ctype = 'r';

   if (in_ctype == '\0') return(-4);

   stat = mapf(map_block,in_ctype,in_lon,in_lat,out_x,out_y);
   if (stat) return(-5);

   return(0);
}



int
map_hms(string,value)
char string[];
double *value;
/* =0 if no hms found(normal value)  =1 if hms    -1 if illegal */
{
   char *c;
   char *field_ptr[4];  /* RBH changes dimension from 3 to 4  11-8-94 */
   char field_type[3];
   float field_value[3];
   int n_fields;
   int n;

/* break up fields of the string */
   if (string[0]>'9') return(-1);
   n_fields = 0;
   c = string;
   field_ptr[0]=c;
   while (*c++) if (*c=='h' || *c=='d' || *c=='m' || *c=='s') {
      field_type[n_fields] = *c;
      n_fields++;
      if (n_fields >=4) return(-1);
      *c++ = '\0';
      field_ptr[n_fields] = c;
   }

   if (n_fields == 0) {
      sscanf(string,"%lf",value);
      return(0);
   }

   for (n=0; n<n_fields; n++) sscanf(field_ptr[n],"%f",&field_value[n]);

   if (field_type[0] == 'h') for (n=0; n<n_fields; n++) field_value[n] *= 15.0;
   else if (field_type[0] != 'd') return(-1);
   if (field_ptr[0][0] == '-') for(n=1; n<n_fields; n++) field_value[n] *= -1.0;
   *value = field_value[0];

   if (n_fields >= 2) {
      if (field_type[1] != 'm') return(-1);
      *value += field_value[1] / 60.0; 
   }

   if (n_fields >= 3) {
      if (field_type[2] != 's') return(-1);
      *value += field_value[2] / 3600.0; 
   }

   return(1);

}
