#include <sys/types.h>
#include <time.h>
#include <sys/time.h>
#include <sys/timeb.h>
/* %W% %E% %U% */
/* #Copyright (C) 1996, California Institute of Technology. */
/* #U.S. Government Sponsorship under NASA Contract NAS7-918 */
/* #is acknowledged. */

#define	SECONDS_1970_TO_1980	315532800


/* get_iraf_time -- get local time, seconds, epoch 1980.  */

int
get_iraf_time()
{
   long time_var;
   int dst;
   time_t timez, gmt, lcltime;
#ifdef VMS
   struct timeb time_info;
#endif /* VMS */
   struct tm *tm_time;
	
   /* get GMT */
   gmt = time((time_t *) 0);
	
#ifdef VMS
   /* get timezone */
   ftime(&time_info);
   timez = time_info.timezone * 60;

#else  /* not VMS */
    tm_time = gmtime(&gmt);
    lcltime = mktime(tm_time);
    timez = gmt - lcltime;
#endif /* VMS */

   /* adjust to local standard time */
   time_var = gmt + timez;

   /* adjust to daylight savings time, if in effect */
   dst = localtime(&gmt)->tm_isdst;
   if (dst == 1) time_var += 3600;

   return (time_var - SECONDS_1970_TO_1980);
}
