/* irafhdr.h */
/* %W% %E% %U% */
/* #Copyright (C) 1992, California Institute of Technology. */
/* #U.S. Government Sponsorship under NASA Contract NAS7-918 */
/* #is acknowledged. */
#define  IM_MAXDIM       7          /* maximum dimension of image  */
#define  SZ_IMMAGIC     12          /* used to verify structure    */
#define  SZ_IMPIXFILE  160          /* name of pixel storage file  */
#define  SZ_IMHDRFILE  160          /* name of header storage file */
#define  SZ_IMTITLE    160          /* image title string          */
#define  SZ_IMHIST    1024          /* image history record        */
#define  SZ_BUNIT       20          /* brightness units string     */
#define  SZ_CTYPE       20          /* coord axes units string     */
#define  SZ_HDR       2052          /* offset to FITS card images  */
#define  SZ_PIXHDR       1024          /* offset to pixels */
  

/* Disk resident header. */

struct IMHDR
    {
    char    im_magic[SZ_IMMAGIC];      /* contains the string "imhdr"  */
    long    im_hdrlen;                 /* length of image header       */
    long    im_pixtype;                /* datatype of the pixels       */
    long    im_ndim;                   /* number of dimensions         */
    long    im_len[IM_MAXDIM];         /* length of the dimensions     */
    long    im_physlen[IM_MAXDIM];     /* physical length (as stored)  */
    long    im_ssmtype;                /* type of subscript mapping    */
    long    im_lutoff;                 /* offset to subscript map luts */
    long    im_pixoff;                 /* offset of the pixels         */
    long    im_hgmoff;                 /* offset of hgm pixels         */
    long    im_blist;                  /* offset of bad pixel list     */
    long    im_szblist;                /* size of bad pixel list       */
    long    im_nbpix;                  /* number of bad pixels         */
    long    im_ctime;                  /* time of image creation       */
    long    im_mtime;                  /* time of last modify          */
    long    im_limtime;                /* time min,max computed        */
    float   im_max;                    /* max pixel value              */
    float   im_min;                    /* min pixel value              */

    long    hgm_time;                  /* time when hgm was computed   */
    long    hgm_len;                   /* number of bins in hgm        */
    long    hgm_npix;                  /* npix used to compute hgm     */
    float   hgm_min;                   /* min hgm value                */
    float   hgm_max;                   /* max hgm value                */
    float   hgm_integral;              /* integral of hgm              */
    float   hgm_mean;                  /* mean value                   */
    float   hgm_variance;              /* variance about mean          */
    float   hgm_skewness;              /* skewness of hgm              */
    float   hgm_mode;                  /* modal value of hgm           */
    float   hgm_lcut;                  /* low cutoff value             */
    float   hgm_hcut;                  /* high cutoff value            */
    long    hgm_dummy[8];              /* fill out to 20 for HGM (JCG) */

    long    ct_valid;                  /* (y/n) is structure valid?    */
    float   ct_bscale;                 /* pixval scale factor          */
    float   ct_bzero;                  /* pixval offset                */
    float   ct_crval[IM_MAXDIM];       /* value at pixel               */
    float   ct_crpix[IM_MAXDIM];       /* index of pixel               */
    float   ct_cdelt[IM_MAXDIM];       /* increment along axis         */
    float   ct_crota[IM_MAXDIM];       /* rotation angle               */
    char    ct_bunit[SZ_BUNIT];        /* pixval ("brightness") units  */
    char    ct_ctype[SZ_CTYPE];        /* coord units string           */
    long    ct_dummy[10];              /* fill out to 50 for CT  (JCG) */

    char    im_pixfile[SZ_IMPIXFILE];  /* name of pixel storage file   */
    char    im_hdrfile[SZ_IMHDRFILE];  /* name of header storage file  */
    char    im_title[SZ_IMTITLE];      /* image name string            */
    char    im_history[SZ_IMHIST];     /* history comment string       */
    };
