/* Fortran bindings to the IM image access routines */
/* %W% %E% %U% */
/* #Copyright (C) 1992, California Institute of Technology. */
/* #U.S. Government Sponsorship under NASA Contract NAS7-918 */
/* #is acknowledged. */
#include <string.h>
#include "im.h"

/******   _wkey_   subs *****/
int imwkeyi_(fid, value, keyword, keyword_len)
int *fid;
int *value;
char *keyword;
long int keyword_len;
{
   char keyword_copy[400];

   while(keyword[keyword_len-1] == ' ') keyword_len--;
   strncpy(keyword_copy, keyword, keyword_len);
   keyword_copy[keyword_len] = '\0';

   return(im_wkey_i(*fid, *value, keyword_copy));
}

int imwkeyl_(fid, value, keyword, keyword_len)
int *fid;
int *value;
char *keyword;
long int keyword_len;
{
   char keyword_copy[400];

   while(keyword[keyword_len-1] == ' ') keyword_len--;
   strncpy(keyword_copy, keyword, keyword_len);
   keyword_copy[keyword_len] = '\0';

   return(im_wkey_l(*fid, *value, keyword_copy));
}

int imwkeyr_(fid, value, keyword, keyword_len)
int *fid;
float *value;
char *keyword;
long int keyword_len;
{
   char keyword_copy[400];

   while(keyword[keyword_len-1] == ' ') keyword_len--;
   strncpy(keyword_copy, keyword, keyword_len);
   keyword_copy[keyword_len] = '\0';

   return(im_wkey_r(*fid, *value, keyword_copy));
}

int imwkeyd_(fid, value, keyword, keyword_len)
int *fid;
double *value;
char *keyword;
long int keyword_len;
{
   char keyword_copy[400];

   while(keyword[keyword_len-1] == ' ') keyword_len--;
   strncpy(keyword_copy, keyword, keyword_len);
   keyword_copy[keyword_len] = '\0';

   return(im_wkey_d(*fid, *value, keyword_copy));
}

int imwkeyc_(fid, value, keyword, value_len, keyword_len)
int *fid;
char *value;
char *keyword;
long int keyword_len;
long int value_len;
{
   char keyword_copy[400];
   char value_copy[400];

   while(keyword[keyword_len-1] == ' ') keyword_len--;
   strncpy(keyword_copy, keyword, keyword_len);
   keyword_copy[keyword_len] = '\0';

   while(value[value_len-1] == ' ') value_len--;
   strncpy(value_copy, value, value_len);
   value_copy[value_len] = '\0';

   return(im_wkey_c(*fid, value_copy, keyword_copy));
}

int imwkeyt_(fid, value, keyword, value_len, keyword_len)
int *fid;
char *value;
char *keyword;
long int keyword_len;
long int value_len;
{
   char keyword_copy[400];
   char value_copy[400];

   while(keyword[keyword_len-1] == ' ') keyword_len--;
   strncpy(keyword_copy, keyword, keyword_len);
   keyword_copy[keyword_len] = '\0';
   if (keyword_copy[0]>='A' && keyword_copy[0]<='Z') /* convert to lower case*/
    keyword_copy[0] = keyword_copy[0] - 'A' + 'a';

   while(value[value_len-1] == ' ') value_len--;
   strncpy(value_copy, value, value_len);
   value_copy[value_len] = '\0';


   return(im_wkey_t(*fid, value_copy, keyword_copy));
}


/******   _rkey_   subs *****/
int imrkeyi_(fid, value, keyword, keyword_len)
int *fid;
int *value;
char *keyword;
long int keyword_len;
{
   char keyword_copy[400];

   while(keyword[keyword_len-1] == ' ') keyword_len--;
   strncpy(keyword_copy, keyword, keyword_len);
   keyword_copy[keyword_len] = '\0';

   return(im_rkey_i(*fid, value, keyword_copy));
}

int imrkeyl_(fid, value, keyword, keyword_len)
int *fid;
int *value;
char *keyword;
long int keyword_len;
{
   char keyword_copy[400];

   while(keyword[keyword_len-1] == ' ') keyword_len--;
   strncpy(keyword_copy, keyword, keyword_len);
   keyword_copy[keyword_len] = '\0';

   return(im_rkey_l(*fid, value, keyword_copy));
}

int imrkeyr_(fid, value, keyword, keyword_len)
int *fid;
float *value;
char *keyword;
long int keyword_len;
{
   char keyword_copy[400];

   while(keyword[keyword_len-1] == ' ') keyword_len--;
   strncpy(keyword_copy, keyword, keyword_len);
   keyword_copy[keyword_len] = '\0';

   return(im_rkey_r(*fid, value, keyword_copy));
}

int imrkeyd_(fid, value, keyword, keyword_len)
int *fid;
double *value;
char *keyword;
long int keyword_len;
{
   char keyword_copy[400];

   while(keyword[keyword_len-1] == ' ') keyword_len--;
   strncpy(keyword_copy, keyword, keyword_len);
   keyword_copy[keyword_len] = '\0';

   return(im_rkey_d(*fid, value, keyword_copy));
}

int imrkeyc_(fid, value, keyword, value_len, keyword_len)
int *fid;
char *value;
char *keyword;
long int keyword_len;
long int value_len;
{
   char keyword_copy[400];
   char value_copy[80];
   int stat, i;

   while(keyword[keyword_len-1] == ' ') keyword_len--;
   strncpy(keyword_copy, keyword, keyword_len);
   keyword_copy[keyword_len] = '\0';

   stat = im_rkey_c(*fid, value_copy, keyword_copy);

   /* pad out returned string with spaces */
   if (stat >= 0) {
      for (i = 0; i < value_len; i++) {
         if (value_copy[i]) value[i] = value_copy[i];
         else break;
      }
      for (; i < value_len; i++) value[i] = ' ';
   }

   return(stat);
}

int imrkeyt_(fid, value, keyword, value_len, keyword_len)
int *fid;
char *value;
char *keyword;
long int keyword_len;
long int value_len;
{
   char keyword_copy[400];
   char value_copy[84];
   int stat, i;

   while(keyword[keyword_len-1] == ' ') keyword_len--;
   strncpy(keyword_copy, keyword, keyword_len);
   keyword_copy[keyword_len] = '\0';

   stat = im_rkey_t(*fid, value_copy, keyword_copy);

   /* pad out returned string with spaces */
   if (stat >= 0) {
      for (i = 0; i < value_len; i++) {
         if (value_copy[i]) value[i] = value_copy[i];
         else break;
      }
      for (; i < value_len; i++) value[i] = ' ';
   }

   return(stat);
}


/******   _open   and _close  *****/
int imopen_(filename,mode,filename_len,mode_len)
char *filename;
char *mode;
long int filename_len;
long int mode_len;
{
   char filename_copy[128];
   char mode_copy[12];

   while(filename[filename_len-1] == ' ') filename_len--;
   strncpy(filename_copy, filename, filename_len);
   filename_copy[filename_len] = '\0';

   while(mode[mode_len-1] == ' ') mode_len--;
   strncpy(mode_copy, mode, mode_len);
   mode_copy[mode_len] = '\0';
   if (mode_copy[0]>='A' && mode_copy[0]<='Z') /* be sure lower case */
      mode_copy[0] = mode_copy[0] - 'A' + 'a';

   return(im_open(filename_copy,mode_copy));
}

int imclose_(fid)
int *fid;
{
   return(im_close(*fid));
}



/******   _wpix_    subs ******/

int imwpixd_(fid,buffer,bufsiz)
int *fid;
double *buffer;
int *bufsiz;
{
   return(im_wpix_d(*fid,buffer,*bufsiz));
}

int imwpixr_(fid,buffer,bufsiz)
int *fid;
float *buffer;
int *bufsiz;
{
   return(im_wpix_r(*fid,buffer,*bufsiz));
}

int imwpixi_(fid,buffer,bufsiz)
int *fid;
int *buffer;
int *bufsiz;
{
   return(im_wpix_i(*fid,buffer,*bufsiz));
}

int imwpixs_(fid,buffer,bufsiz)
int *fid;
short *buffer;
int *bufsiz;
{
   return(im_wpix_s(*fid,buffer,*bufsiz));
}

int imwpixc_(fid,buffer,bufsiz)
int *fid;
char *buffer;
int *bufsiz;
{
   return(im_wpix_c(*fid,(unsigned char *)buffer,*bufsiz));
}


/******   _rpix_    subs ******/
int imrpixd_(fid,buffer,bufsiz)
int *fid;
double *buffer;
int *bufsiz;
{
   return(im_rpix_d(*fid,buffer,*bufsiz));
}

int imrpixr_(fid,buffer,bufsiz)
int *fid;
float *buffer;
int *bufsiz;
{
   return(im_rpix_r(*fid,buffer,*bufsiz));
}

int imrpixi_(fid,buffer,bufsiz)
int *fid;
int *buffer;
int *bufsiz;
{
   return(im_rpix_i(*fid,buffer,*bufsiz));
}

int imrpixs_(fid,buffer,bufsiz)
int *fid;
short int *buffer;
int *bufsiz;
{
   return(im_rpix_s(*fid,buffer,*bufsiz));
}

int imrpixc_(fid,buffer,bufsiz)
int *fid;
char *buffer;
int *bufsiz;
{
   return(im_rpix_c(*fid, (unsigned char *)buffer, *bufsiz));
}


/**************  imblank_  **************/
void
imblank_(pointer)
float *pointer;
{
   im_blank(pointer);
}


/******** imdwin & imswin  *******/
int imdwin_(fid,window,takes,skips)
int *fid;
int *window;
int takes[];
int skips[];
{
   return(im_dwin(*fid,*window,takes,skips));
}

int imswin_(fid,window)
int *fid;
int *window;
{
   return(im_swin(*fid,*window));
}


/********  im_hdr  im_file  &  im_key  *******/

int imhdr_(new_fid,old_fids,option,option_len)
int *new_fid;
int old_fids[];
char *option;
long int option_len;
{
   char option_copy[84];

   while(option[option_len-1] == ' ') option_len--;
   strncpy(option_copy, option, option_len);
   option_copy[option_len] = '\0';
   
   return(im_hdr(*new_fid,old_fids,option_copy));
}

int imfile_(fid,option,option_len)
int *fid;
char *option;
long int option_len;
{
   char option_copy[84];

   while(option[option_len-1] == ' ') option_len--;
   strncpy(option_copy, option, option_len);
   option_copy[option_len] = '\0';
   if (option_copy[0]>='A' && option_copy[0]<='Z') /* convert to lower case*/
    option_copy[0] = option_copy[0] - 'A' + 'a';

   return(im_file(*fid,option_copy));
}

int imkey_(result,result_len,base,n,base_len)
char base[];
int *n;
char result[];
long int base_len;
long int result_len;
{
   int i;
   int concat_len;
   char *concat;
   char base_copy[84];

   while(base[base_len-1] == ' ') base_len--;
   strncpy(base_copy, base, base_len);
   base_copy[base_len] = '\0';
   
   concat = im_key(base_copy,*n);
   strncpy(result,concat,result_len);

   concat_len = strlen(concat); /* pad out with blanks */
   for(i=concat_len; i<result_len; i++) result[i] = ' ';

   return(0);
}
int imraw_(v)
int *v;
{ return(im_raw(*v));}
