/* im.h */
/* %W% %E% %U% */
/* #Copyright (C) 1992, California Institute of Technology. */
/* #U.S. Government Sponsorship under NASA Contract NAS7-918 */
/* #is acknowledged. */

#include <stdio.h>
#include <sys/file.h>

#ifndef MAXPATHLEN
#define MAXPATHLEN 1024
#endif /* MAXPATHLEN */

#ifdef USE_ISINFINITE
/* compiler has function isfinite()  (C99) */
#define FINITE(x) isfinite(x)
#else
/* compiler has function finite()  (BSD) */
#define FINITE(x) finite(x)
#endif /* NEEDS_ISINFINITE */


#define IM_MAGIC 0x7B01

#define N_HDRS_PER_BLK 50
#define MAX_WINDOWS 5

struct header_struct { /* header cards are in a linked list */
   char text[81];
   struct header_struct *next; /* pointer to next header card */
   struct header_struct *prev; /* pointer to previous header card */
};

struct hdr_blk_struct {
   struct header_struct headers[N_HDRS_PER_BLK];
   struct hdr_blk_struct *next;
};

struct window_struct {
   int naxis_skip[9];
   int naxis_take[9];
   int left_to_read[9];
   int left_to_write[9];
   int start_byte;
   int total_bytes;
   int line_bytes;
   int skip_bytes;
   int cur_byte_read;
   int total_bytes_left_to_read;
   int line_bytes_left_to_read;
   int cur_byte_write;
   int total_bytes_left_to_write;
   int line_bytes_left_to_write;
   int axis_len_real[10];  /* index to real (naxisn>1) axes  [0]=# */
}; 

struct fid_struct {
   struct fid_struct *llink, *rlink;
   int id;
   int mode; /* closed=0, read=1, write=2, update=3 */
   enum {Type_unknown, Type_fits, Type_zz, Type_iraf, Type_S} file_type;
   char user_filename[MAXPATHLEN];
   char hdr_filename[MAXPATHLEN];
   char pix_filename[MAXPATHLEN];
   char subset_text[64];
   int unix_hdr_fid;
   int unix_pix_fid;

   int bytes_per_pix; /* 1, 2, 4 , 8 */
   int n_pixels; /* product of all the NAXIS's */
   int io_offset; /* seek position to first pixel in file */
   int line_skip_pix; /* number of pad pixels at end of each line (IRAF) */
   int need_wpix_setup; /* write mode and setup needed before wpix */
   struct hdr_blk_struct *header_blocks;

   /* binary values from the header ... defaults in { }  */
   int val_bitpix;     /* {0} value of BITPIX keyword */
   int val_naxis[10];  /* {0} [0]=number of axes, [n>0]=length of axis */
   int val_blank_flag; /* {0} 0=none   1=yes  */
   int val_blank;      /* {0} value of BLANK keyword */
   double val_scale;    /* {1.} value of BSCALE keyword */
   double val_offset;   /* {0.} value of BZERO keyword */

   int n_headers;
   struct header_struct *cur_header; /* pointer to "current" header card */
   struct header_struct *first_header; /* pointer to first header card */
   struct header_struct *last_header ; /* pointer to last header card */
   struct header_struct *free_header ; /* pointer to last header card */

   struct window_struct *cur_window;
   struct window_struct windows[MAX_WINDOWS];

   int magic; /* magic number */
};


/* function prototypes for internal IM routines  */
/*  (prototypes for user callable functions are in im_proto.h) */

#ifdef _NO_PROTO

struct fid_struct *new_fid();
void destroy_fid();
int IM_set_fid();
int IM_card_add();
int IM_setw1();
int IM_w_rewind();
int IM_write_hdr();
int IM_card_find();
int IM_card_replace();
int IM_card_delete();
int kwd_isvalid();
int get_iraf_time();
int IM_r_rewind();
void IM_init_w();
int map_coord();
void IM_swap_4();
void IM_swap_2();
void IM_swap_8();
int im_raw();
int im_byteorder();

#else

struct fid_struct *new_fid();
void destroy_fid(struct fid_struct *p);
int IM_set_fid(int id);
int IM_card_add(char card[]);
int IM_setw1(struct fid_struct *f, int skips[], int takes[]);
int IM_w_rewind(struct window_struct *w);
int IM_write_hdr();
int IM_card_find(char keyword[8]);
int IM_card_replace(char card[]);
int IM_card_delete();
int kwd_isvalid(char *card);
int get_iraf_time();
int IM_r_rewind(struct window_struct *w);
void IM_init_w();
int map_coord(int in_type, double in_lon, double in_lat, int out_type,
    double *out_lon, double *out_lat);
void IM_swap_4(unsigned char buffer[], int n);
void IM_swap_2(unsigned char buffer[], int n);
void IM_swap_8(unsigned char buffer[], int n);
int im_raw(int v);
int im_byteorder(void);

#endif /* _NO_PROTO */

#include "im_proto.h"
