/* hdr.c  */
/* %W% %E% %U% */
/* #Copyright (C) 1992, California Institute of Technology. */
/* #U.S. Government Sponsorship under NASA Contract NAS7-918 */
/* #is acknowledged. */

#include "im.h"
#include <string.h>

#define MAXINS 50

extern struct fid_struct *f;
char *im_history_line = (char *)0; /* user accessible history line */ 
  /* If this is not a NULL pointer or a pointer to a null string, */
  /* then it must point to a <MODIFIABLE> string of 72 chars length      */

int
im_hdr(new_id,old_ids,options)
int new_id;
int old_ids[];
char options[]; /* "c" if want check all images are same 
                   "h" if only want history coppied
                 */
{
   int n_fids;
   char card[82];
   int stat;
   int idindex;
   int first_history;
   struct fid_struct *new_fid;
   struct fid_struct *old_fids0;

   if (options == 0) options = "";

   if (options[0] =='c') return(-2);
    /************************************************
     im_hdr: multi-image consistency check not implemented yet
     first, if CRPIX's differ and CTYPE is linear, try to adjust CRPIX,CRVAL
      ERR:
          BUNIT differing
          effective NAXISn differing
          geom differing CTYPE or >= 1 pixel
      WARN:
          geom differing < 1 pixel
      ****************************************************/
    if (IM_set_fid(new_id)) return(-3);
    new_fid = f;

   /* set in file_type */
   if (new_fid->file_type == Type_unknown) {
      if (old_ids[0])
      {
	   if (IM_set_fid(old_ids[0])) return(-3);
	   old_fids0 = f;
	   new_fid->file_type = old_fids0->file_type;
      }
   }
   
   /* get boundary info from all files */

#ifdef NOTDEF
   i = 0;
   for (fidptr=old_fids; *fidptr; fidptr++) {
      if (i > MAXINS) return(-1);
      i++;
   }
   n_fids = i;
#endif /* NOTDEF */

   /* count number of input files */
   for (n_fids = 0; old_ids[n_fids] ; n_fids++)
   {
      if (n_fids > MAXINS) return(-1);
   }

   /* copy "real" (non-history) header cards from first file */
   if (options[0] != 'h' && old_ids[0]) {
      stat = im_rkey_t(old_ids[0],card,"1");
      if (stat <0) return(stat);
      while (stat>=0) {

	 /* START RBH DELETE 
         if ( new_fid->file_type == Type_iraf
           && strncmp(card,"BLANK   ",8) == 0);
         else 
	 END RBH DELETE */
	 if (strncmp(card,"HISTORY ",8) != 0) {
             im_wkey_t(new_id,card,"end");
         }
         stat = im_rkey_t(old_ids[0],card,"+");
      }
   }
   /* START RBH DELETE
   if ( new_fid->file_type == Type_iraf) {
      im_wkey_t(new_fid, "BLANK   = 0" ,"end");
   }
     END RBH DELETE */

   /* copy history from all files */
   for (idindex = 0; old_ids[idindex]; idindex++) {
      first_history = 1;
      stat = im_rkey_t(old_ids[idindex], card, "1");
      if (stat <0) return(-2); /* probably illegal fid */
      while (stat>=0) {
         if (card[0] == 'H') if (strncmp(card+1,"ISTORY ",7) == 0) {
            if (first_history) { /* See if IPAC HISTORY cards */
               if (card[8] != '*') {
                  im_wkey_t(new_id,"HISTORY *0 (imported)","end");
               }
               first_history = 0;
            } /* end if first_history */
            im_wkey_t(new_id,card,"end");
         } /* end if HISTORY */
      stat = im_rkey_t(old_ids[idindex], card, "+");
      } /* end while stat>=0 */
      if (first_history) { /* See if no HISTORY cards */
         im_wkey_t(new_id,"HISTORY *0 (imported)","end");
      }
   }

/* store history info for THIS process */

   if(im_history_line != (char *)0 )
     if(*im_history_line != '\0'){
       im_history_line[71] = '\0';
       sprintf(card,"HISTORY *%d %s",n_fids,im_history_line);
       im_wkey_t(new_id,card,"end");
     }

   return(0);
}
