/* file.c (im_file and other misc. im_ programs */
/* %W% %E% %U% */
/* #Copyright (C) 1992, California Institute of Technology. */
/* #U.S. Government Sponsorship under NASA Contract NAS7-918 */
/* #is acknowledged. */

#include "im.h"
#include <math.h>

extern struct fid_struct *f;

int
im_file(id,operation)
int id;
char operation[];
{

   struct header_struct *h, *save_h;
   char buffer[2880];
   int b;

   if (IM_set_fid(id)) return(-3);

   switch(operation[0]) {

      case 'p': /* print header */
       printf("------- ");
       switch (f->file_type) {
          case Type_fits: printf("FITS"); break;
          case Type_zz: printf("ZZ"); break;
          case Type_iraf: printf("IRAF"); break;
          case Type_S: printf("S"); break;
          default:printf("????"); break;
       }
       printf(" file={%s}\n",f->user_filename);
       printf("1234567890123456789012345678901234567890");
       printf("123456789012345678901234567890123456789\n");
       save_h = f->cur_header;
       b = im_rkey_t(id,buffer,"1");
       while (b >= 0) {
          printf("%s\n",buffer);
          b = im_rkey_t(id,buffer,"+");
       }
       printf("-------\n");
       f->cur_header = save_h;
       return(0);

      case 'q': /* print headers with pointers for debug */
       printf("n_headers = %d\n",f->n_headers);
       h = f->last_header;
         printf("last %p %p %p %s\n", 
	     (void *) h, (void *) h->prev, (void *) h->next, h->text); 
       h = f->cur_header;
         printf("cur %p %p %p %s\n", 
	     (void *) h, (void *) h->prev, (void *) h->next, h->text); 
       for (h=f->first_header; h; h=h->next)
         printf("%p %p %p %s\n", 
	     (void *) h, (void *) h->prev, (void *) h->next, h->text); 
       for (h=f->free_header; h; h=h->next)
         printf("free %p %p %s\n", (void *) h, (void *) h->next, h->text); 
       return(0);
   }
   return(0);
  
}


/*---------------------------------------------------------*/
void
im_blankd(ptr)
double *ptr;
{
    union
    {
	double a;
	int i[2];
    } un;

    un.i[0] = 0x7fffffff;
    un.i[1] = 0xffffffff;
    *ptr = un.a;
}

void
im_blank(ptr)
float *ptr;
{
    union
    {
	float a;
	int i;
    } un;

    un.i = 0xffffffff;
    *ptr = un.a;
}


/*---------------------------------------------------------*/

char
*im_key(base,n)
char *base;
int n;
{
   static char str[16];
   sprintf(str,"%s%d",base,n);
   return(str);
}

