/* close.c */
/* %W% %E% %U% */
/* #Copyright (C) 1992, California Institute of Technology. */
/* #U.S. Government Sponsorship under NASA Contract NAS7-918 */
/* #is acknowledged. */

#include "im.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#ifdef ALPHA
#include <file.h>
#include <unixio.h>
#endif /* ALPHA */

extern struct fid_struct *f;

int
im_close(id)
int id;
{

   struct hdr_blk_struct *block, *next_block;
   char *zeroes;
   int pad;
   int stat;
   int total_pix_bytes;
   float dummy[1];

   if (IM_set_fid(id)) return(-3);

   switch(f->mode) {

   case 1:  /* read */
    break;

   case 2:  /* write */
   case 3:  /* update */
    dummy[0] = 0.0;
    if (f->need_wpix_setup != 0) im_wpix_r(f->id, dummy, 0); /* force initialization */
    /* pad out pixel area of file if FITS */
    if (f->file_type == Type_fits) {
       total_pix_bytes = f->n_pixels * f->bytes_per_pix;
       pad = total_pix_bytes % 2880;
       if (pad) {
          pad = 2880 - pad;
          zeroes = (char *) calloc(1,pad);
          if (f->unix_pix_fid) write(f->unix_pix_fid,zeroes,(unsigned int) pad);
          else fwrite(zeroes,1,pad,stdout);
          free(zeroes);
       }
    }
    if (f->unix_pix_fid) {
       stat = IM_write_hdr();
       if (stat <0) return(stat);
    }
    break;


   default:  /* error */
    return(-3);

   }; /* end switch */

   stat = close(f->unix_pix_fid);
   if (stat != 0)
    stat = -2;
   f->unix_pix_fid = -1;
   f->mode = 0;
   f->magic = 0;
   for (block=f->header_blocks; block;) {
      next_block = block->next;
      free(block);
      block = next_block;
   }
   destroy_fid(f);

   return(stat);
}
