/* header.c (internal subroutines for handling header cards) */
/* %W% %E% %U% */
/* Copyright (C) 1992,1993, California Institute of Technology. */
/* U.S. Government Sponsorship under NASA Contract NAS7-918     */
/* is acknowledged.                                             */
/* Jan 1993, add bitpix = -64    <rick@ipac.caltech.edu>        */

#include "im.h"
#include <stdlib.h>
#include <string.h>

struct fid_struct *f; /* current fid */

/* function prototypes */
#ifdef _NO_PROTO
static int kwd_special();
#else
static int kwd_special(char card[]);
#endif /* _NO_PROTO */

int
IM_card_add(card)
char card[80];
/* returns:   illegal<0   special=0   OK=1  */
{
   struct header_struct *h; /* current header card */
   struct header_struct *new; /* new header card */
   struct hdr_blk_struct *new_block; /* new header block */
   int i;

   if (f->free_header == 0) { /* allocate a block if needed */
      new_block = (struct hdr_blk_struct *) malloc
           (sizeof(struct hdr_blk_struct));
      new_block->next = f->header_blocks;
      f->header_blocks = new_block;

      f->free_header = new = new_block->headers;
      for (i=0; i<N_HDRS_PER_BLK-1; i++) { new->next = new+1; new++;}
      new->next = 0;
   }

   new = f->free_header;
   strncpy(new->text,card,80);
   new->text[80] = '\0';

   i = kwd_special(new->text);
   if (i <= 0) return(i); /* not an actual card  or illegal card */

   f->free_header = new->next;

   h = f->cur_header;
      
   new->prev = h;
   
   if (h) {
      new->next = h->next;
      h->next = new;
   }
   else {
      new->next = f->first_header;
      f->first_header = new;
   }

   if (new->next) (new->next)->prev = new;
   else f->last_header = new;

   f->cur_header = new;

   f->n_headers ++;
   return(1);
}



int
IM_card_replace(card)
char card[];
/* returns:   illegal<0   special=0   OK=1 */
{
   struct header_struct *h; /* current header card */
   int stat;

   h = f->cur_header;

   if (h == 0) return(-1); /* no-op if no "current" header card */

   /* delete special effect of replaced card unless same keyword coming */
   if (strncmp(h->text,card,8) != 0) {
      h->text[10]='\0';
      kwd_special(h->text);
   }

   stat = kwd_special(card);
   if (stat <= 0) return(stat);

   strncpy(h->text,card,80);
   h->text[80] = '\0';
   return(1);

}



int
IM_card_delete()
/* returns:   illegal<0   special=0(not deleted)  ok=1 */

{
   struct header_struct *h; /* current header card */

   h = f->cur_header;

   if (h == 0) return(-1); /* no-op if no "current" header card */

   h->text[10]='\0';
   kwd_special(h->text);

   if (h->next) f->cur_header = h->next; /* re-set cur_header */
   else f->cur_header = h->prev;

   if (h->next) (h->next)->prev = h->prev; /* reset "prev" pointer of "next" */
   else          f->last_header = h->prev;

   if (h->prev) (h->prev)->next = h->next; /* reset "next" pointer of "prev" */
   else          f->first_header = h->next;

   h->next = f->free_header; /* return to the "free" list */
   f->free_header = h;

   f->n_headers --;

   return(1);
}


int
IM_card_find(keyword)
/* starts search at the NEXT card */
/* resets cur_header if found */
/* not found=-1, found before current=1, at=2, after=3, error<-1, no action=0*/
char keyword[8];
{
   struct header_struct *h; /* current header card */
   struct header_struct *try; /* pointers to header cards */

   int n;
   int return_code;
   char tmp_key[8], *c;

   if (keyword == 0) {f->cur_header = 0; return(0);}

   n = strlen(keyword);
   if (n  > 8) return(-2);
   strncpy(tmp_key,keyword,8);
   for (c=tmp_key+n; c <= tmp_key+7; c++) *c = ' ';

   h = f->cur_header;

   if (h==0) h=f->last_header;
   if (h==0) {
      return(-1);
   }

   try = h->next;
   return_code = 3;
   for (;;)  {
      if (try==0) {
         try = f->first_header;
         return_code = 1;
      }
      if (strncmp(tmp_key,try->text,8) == 0) /* found */ {
         f->cur_header = try;
         if (h == try) return_code = 2;
         break;
       }
      if (try == h) {
         return_code = -1;
         break;
      }
      try = try->next;
   }

   if (return_code>0) f->cur_header = try;
   return(return_code);
}


static int kwd_special(card)
char card[80];
/* check this header card; if it contains a special keyword, save info */
/* return:  1=OK  0=legal,but don't add  -2 =illegal value */
{
   int n, i;

   switch(card[0]) {

      case 'B':
       if (strncmp(&card[1],"ITPIX  ",7) == 0) {
          if (card[10] ==0) n = 0;
          else {
             sscanf(&card[10],"%d",&n);
             switch(n) {
                case   8: i = 1; break;
                case  16: i = 2; break;
                case  32: i = 4; break;
                case -32: i = 4; break;
                case -64: i = 8; break;
                default: return(-2);
             }
          }
          f->val_bitpix = n;
          f->bytes_per_pix = i;
          break;

       }
       if (strncmp(&card[1],"LANK   ",7) == 0) {
          if (card[10]) {
             f->val_blank_flag = 1;
             sscanf(&card[10],"%d",&f->val_blank);
          }
          else {
             f->val_blank = 0;
             f->val_blank_flag = 0;
          }
          break;

       }
       if (strncmp(&card[1],"SCALE  ",7) == 0) {
          if (card[10]) sscanf(&card[10],"%lg",&f->val_scale);
          else f->val_scale = 1.0;
          break;

       }
       if (strncmp(&card[1],"ZERO   ",7) == 0) {
          if (card[10]) sscanf(&card[10],"%lg",&f->val_offset);
          else f->val_offset = 0.0;
          break;

       }
       if (strncmp(&card[1],"LOCKED ",7) == 0) {
          return(0); /* don't save BLOCKED card */
       }

       break;
   
      case 'E':

       if ( strncmp(&card[1],"ND     ",7) == 0 ) {
          return(0); /* don't save END card */
       }

       if (strncmp(&card[1],"XTEND  ",7) == 0) {
          return(0); /* don't save EXTEND card */
       }

       break;
   
      case 'N':

       if (strncmp(&card[1],"AXIS",4) == 0) {
          if (card[6]!=' ') break; 
          if (card[5] == ' ') i=0;  else i = card[5] - '0';
          if (i<0 || i>9) return(-2);

          if (card[10] == 0) f->val_naxis[i] = 0;
          else {
             sscanf(&card[10],"%d",&f->val_naxis[i]);
             if (f->val_naxis[i] < 0) return(-2);
          }
          for (n=1,i=1; i<=f->val_naxis[0]; i++)  n *= f->val_naxis[i];
          f->n_pixels = n;
          break;
       } /* end if NAXIS */

       break;
   
      case 'S':
       if ( strncmp(&card[1],"IMPLE  ",7) == 0 ) return(0);

       break;
   
   } /* end switch card[0] */

   return(1);
}

/*
 * does this card contain a "special" keyword? if so does it refer to
 * a valid one?  i.e. NAXISn where n is greater than the NAXIS value is
 * an invalid key.
 */

int
kwd_isvalid(card)
char *card;
{
   if((strncmp(card,"NAXIS",5) == 0 || 
       strncmp(card,"CRPIX",5) == 0 ||
       strncmp(card,"CTYPE",5) == 0 ||
       strncmp(card,"CROTA",5) == 0 ||
       strncmp(card,"CRVAL",5) == 0 ) && card[5] != ' ' )
       if(atoi(&card[5]) > f->val_naxis[0]) return 0;

   return 1;
}
