#include "skyflux.h"
#include "fits.h"
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/mtio.h>
#include <sys/file.h>
#define BUFSIZ  32768

#ifdef VAX
#define TAPENAME "/dev/rmt12"
#else
#define TAPENAME "/dev/nrtp0"
#endif VAX

char buf[BUFSIZ];

main()
{
    int mfd;
    int filnbr, tappos;
    int pid;
    int i, blksiz;
    char *p, *pt;
    char tmpstr[70];
    int rdstat, wrstat;
    struct mtop  mstop;
    int lines;

    mfd = open(TAPENAME, 0, 0);

    if (mfd < 0)
    {
	perror(TAPENAME);
	return;
    }
    tappos = 1;
    filnbr = 0;   /* will be incremented by 1 (default) */

    while (TRUE)
    {
    printf("\n  ********** tape file number = %d  ********\n",tappos);
    blksiz = first_block(mfd, buf, BUFSIZ);
    /*
    printf("tapescan block size = %d\n",blksiz);
    */

    switch (blksiz)
    {
    case 0:
	printf("end of tape\n");
	pid = fork();
	if (pid == 0)
	    rewind(mfd);
	exit(0);
	break;

    case -1:
	printf("tape read error .. aborting\n");
	exit(0);
	break;

    case 2880:
	/* it is a FITS tape */

#ifdef JUP
	swab(buf, buf, blksiz);  /* swap bytes */
#endif JUP
	do
	{

	pt = buf;
	for (i=0;i<36 ; i++, pt+=80)
	{
	    *(pt+79) = '\0';
	    puts(pt);

	    if (bcmp( pt, "END     ", 8) == 0)
		    goto ended;
	}
	    rdstat = next_block(mfd, buf, blksiz);
#ifdef JUP
	    swab(buf, buf, rdstat);  /* swap bytes */
#endif JUP
	} while (rdstat == blksiz);
    ended:
	tappos++;

	break;

    case 5030:
	printf("starting 5030\n");
	/* it is a blocked VICAR tape */

#ifdef JUP
	swab(buf, buf, 360);  /* swap bytes */
#endif JUP
	ascii(buf,360);
	bcopy(&buf[24], tmpstr, 8);
	tmpstr[8] = '\0';
	blksiz = atoi(tmpstr);
	lines = atoi(&buf[16]);
	p = buf;
	i = 0;
	while (endofhdr(p) == FALSE)
	{
	    p += 1006;
	    i ++;
	    if (i == 5)
	    {
		rdstat = read(mfd, buf, 5030);
		p = buf;
		i = 0;
	    }
#ifdef JUP
	    swab(p, p, 360);  /* swap bytes */
#endif JUP
	    ascii(p, 360);
	}
	tappos++;
	break;

    case 360:
	printf("starting 360\n");
	/* it is an unblocked VICAR tape */

#ifdef JUP
	swab(buf, buf, 360);  /* swap bytes */
#endif JUP
	ascii(buf, 360);
	bcopy(&buf[24], tmpstr, 8);
	tmpstr[8] = '\0';
	blksiz = atoi(tmpstr);
	printf("new blocksize=%d\n",blksiz);
	vicarhd();
	while (endofhdr(buf) == FALSE)
	{
	    rdstat = read(mfd, buf, 5030);
	    printf("rdstat=%d\n",rdstat);
#ifdef JUP
	    swab(buf, buf, 360);  /* swap bytes */
#endif JUP
	    ascii(buf, 360);
	    vicarhd();
	}
	tappos++;
	break;

    default:
	printf("unknown tape type (not FITS or VICAR)\n");
	printf("block size = %d\n",blksiz);
	do
	{
	    blksiz = read(mfd, buf, BUFSIZ);
	    printf("block size = %d\n",blksiz);
	} while (blksiz != 0);
	pid = fork();
	if (pid == 0)
	    rewind(mfd);
	exit(0);
	break;
    }

	mstop.mt_op = MTFSF;
	mstop.mt_count = 1;
	ioctl(mfd, MTIOCTOP, &mstop);
    }
}

endofhdr(p)
/*  look for end of VICAR header in 5 lines beginning at p */
char *p;
{
    int i;

    for (i=0; i<5; i++)
    {
	if (*(p+71) == 'L')
	    return(TRUE);
	p += 72;
    }
    return(FALSE);
}

vicarhd()
{
    char *pt;
    int i;

	pt = buf;
	for (i=0;i<5 ; i++, pt+=72)
	{
	    *(pt+70) = '\0';
	    printf("%s\n", pt);
	    if (*(pt+71) == 'L')
	    return;
	}
}

ascii(p,n)
/* convert n bytes of ebcdic to ascii */
char *p;
int n;
{
    int i, j;
    static int trans[256] = {0,1,2,3,0x9c,0x9,0x86,0x7f,0x97,0x8d,0x8e,0xb,0xc,
	0xd,0xe,0xf,0x10,0x11,0x12,0x13,0x9d,0x85,8,0x87,0x18,0x19,0x92,
	0x8f,0x1c,0x1d,0x1e,0x1f,
	0x80,0x81,0x82,0x83,0x84,0xa,0x17,0x1b,0x88,0x89,0x8a,0x8b,0x8c,5,
	6,7,0x90,0x91,0x16,0x93,0x94,0x95,0x96,4,0x98,0x99,0x9a,0x9b,0x14,0x15,
	0x9e,0x1a,0x20,0xa0,0xa1,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0x5b,
	0x2e,0x3c,0x28,0x2b,0x21,0x26,0xa9,0xaa,0xab,0xac,0xad,0xae,0xaf,
	0xb0,0xb1,0x5d,0x24,0x2a,0x29,0x3b,0x5e,0x2d,0x2f,0xb2,0xb3,0xb4,0xb5,
	0xb6,0xb7,0xb8,0xb9,0x7c,0x2c,0x25,0x5f,0x3e,0x3f,0xba,0xbb,0xbc,0xbd,
	0xbe,0xbf,0xc0,0xc1,0xc2,0x60,0x3a,0x23,0x40,0x27,0x3d,0x22,0xc3,0x61,
	0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,
	0xca,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0x70,0x71,0x72,0xcb,0xcc,0xcd,
	0xce,0xcf,0xd0,0xd1,0x7e,0x73,0x74,0x75,0x76,0x77,0x78,0x79,
	0x7a,0xd2,0xd3,0xd4,0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xdb,0xdc,0xdd,
	0xde,0xdf,0xe0,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0x7b,0x41,0x42,
	0x43,0x44,0x45,0x46,0x47,0x48,0x49,0xe8,0xe9,0xea,0xeb,0xec,0xed,
	0x7d,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,0x50,0x51,0x52,0xee,0xef,
	0xf0,0xf1,0xf2,0xf3,0x5c,0x9f,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5a,
	0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0x30,0x31,0x32,0x33,0x34,0x35,0x36,
	0x37,0x38,0x39,0xfa,0xfb,0xfc,0xfd,0xfe,0xff};

    for (i=0; i<n; i++)
    {
	j = *p & 0xff;
	*p = trans[j];
	p++;
    }
}

rewind(mfd)
int mfd;
{
    struct mtop  mstop;

    if (mfd>=0)
    {
	mstop.mt_op = MTREW;
	mstop.mt_count = 1;
	ioctl(mfd, MTIOCTOP, &mstop);
    }
}
