#define BUFSIZ  32768
#define NULL 0


static int blksiz;
static char *bufptr, *bufadr;

first_block(mmfd, his_bufptr, his_bytes)
int mmfd, his_bytes;
char *his_bufptr;     /* must be 2880 bytes */
{
    char *malloc();

    if (bufadr == NULL)
	bufadr = malloc(BUFSIZ);
    if (bufadr == NULL)
	printf("first_block: malloc failed\n");
    blksiz = read(mmfd, bufadr, BUFSIZ);
    printf("block size = %d\n",blksiz);
    if (blksiz <= 0)
    {
	free(bufadr);
	bufadr = NULL;
	return(blksiz);
    }
    if ((blksiz % 2880 == 0) && (blksiz != 2880))
    {
	/* its a blocked FITS tape */
	bufptr = bufadr;
	bcopy(bufptr, his_bufptr, 2880);  /* give him the first 2880 */
	return(2880);               /* make it look like unblocked FITS */
    }
    else
    {
	/* we will not be doing any unblocking */
	if (blksiz > his_bytes) 
	{
	    blksiz = -1;
	}
	if (blksiz > 0)
	    bcopy(bufadr, his_bufptr, blksiz);
	free(bufadr);
	bufadr = NULL;
	return(blksiz);
    }
}

next_block(mmfd, his_bufptr, his_bytes)
int mmfd, his_bytes;
char *his_bufptr;
{
    if (bufadr == NULL)
    {
	/* this will happen for unblocked FITS tapes */
	return(read(mmfd, his_bufptr, his_bytes));
    }

    /* were working on a blocked FITS tape */
    bufptr += 2880;             /* move to next logical block */
    if (bufptr - bufadr >= blksiz)
    {
	blksiz = read(mmfd, bufadr, blksiz);
	if (blksiz <= 0)
	{
	    free(bufadr);
	    bufadr = NULL;
	    return(blksiz);
	}
	bufptr = bufadr;
    }
    bcopy(bufptr, his_bufptr, 2880);
    return(2880);
}
