#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include "svclib.h"

#define SLEEP_DURATION 2


main(argc, argv)

int    argc;
char **argv;
{
    int    status, i, j, handle;
    char   cmdstr[256], val[256], *retstr;
    char *answer;
    char filename[4][256];
    char *geom[4];
    int ttyfd, n_bytes_read;
    char ttybuf[81];
    struct timeval timeout;
    fd_set fdset;

    ttyfd = fileno(stdin);

    handle = svc_init("skyview -ads");
    if (handle == SVC_ERROR)
    {
	printf("cannot start skyview\n");
	exit(1);
    }


    /* FILE */

    strcpy(cmdstr, "cd /imaging/images/test");
    status = svc_send(handle, cmdstr);
    if (status == SVC_ERROR)
    {
	printf("error sending command to skyview\n");
	exit(1);
    }
    retstr = svc_receive(handle);
    if (retstr == NULL)
    {
	printf("error receiving result from skyview\n");
	exit(1);
    }


    strcpy(filename[0] , "i253b1h0.fit");
    strcpy(filename[1] , "i253b2h0.fit");
    strcpy(filename[2] , "i253b3h0.fit");
    strcpy(filename[3] , "i253b4h0.fit");
    geom[0] = "=+100+100";
    geom[1] = "=+200+100";
    geom[2] = "=+300+100";
    geom[3] = "=+400+100";

    for (j = 0; j < 4; j++)
    {
	for (i = 0; i <= 3; i++)
	{
	    sprintf(cmdstr, "frame %d", i);
	    svc_send(handle, cmdstr);
	    retstr = svc_receive(handle);

	    sprintf(cmdstr, "pa %s %s", filename[i], geom[i]);
	    svc_send(handle, cmdstr);
	    retstr = svc_receive(handle);
	}
	/* wait for either timeout or tty event */
	FD_ZERO(&fdset);
	FD_SET(ttyfd, &fdset);
	timeout.tv_sec = SLEEP_DURATION;
	timeout.tv_usec = 0;
	status = select(FD_SETSIZE, &fdset, (fd_set *) 0,(fd_set *) 0, &timeout);
	if (status < 0)
	{
	    perror("select error");
	    continue;
	}
	else if (status == 0)
	{
	    /*EMPTY*/
	    /* got the timeout - sleep is done */
	}
	else if (FD_ISSET(ttyfd, &fdset))
	{
	    n_bytes_read = read(ttyfd, ttybuf, 80);
	    printf("n_bytes_read = %d\n", n_bytes_read);

	    for(;;)
	    {
	    printf("Click left button on bad image;  to continue click middle button on an image\n");
	    svc_send(handle, "point");
	    retstr = svc_receive(handle);
	    answer = svc_val(retstr, "filename", val);
	    if (answer)
		printf("    filename = [%s]\n", val);
	    else
		break;
	    }
	}

	svc_send(handle, "er");
	retstr = svc_receive(handle);
    }


    /* QUIT */

    strcpy(cmdstr, "quit");
    svc_send(handle, cmdstr);
    retstr = svc_receive(handle);

    svc_close(handle);
}
