/* /imaging/config/beta/contrib/server/sample2.c */
#include <stdio.h>
#include <stdlib.h>
#include "svclib.h"

main(argc, argv)
int    argc;
char *argv[];
{
    int  handle;
    int status;

    char *retstr;
    char lat[25], lon[25], pixel_value[25], units[25];

    handle = svc_init("skyview -server");
    if (handle == SVC_ERROR)
    {
	printf("cannot start skyview\n");
	exit(1);
    }

    status = svc_send(handle, "pa /imaging/images/test/c1632b1");
    if (status == SVC_ERROR)
    {
	printf("error sending command to skyview\n");
	exit(1);
    }
    retstr = svc_receive(handle);
    if (retstr == NULL)
    {
	printf("error receiving result from skyview\n");
	exit(1);
    }

    status = svc_send(handle, "point 5h33m41.26s -6d53m48.9s");
    if (status == SVC_ERROR)
    {
	printf("error sending command to skyview\n");
	exit(1);
    }
    retstr = svc_receive(handle);
    if (retstr == NULL)
    {
	printf("error receiving result from skyview\n");
	exit(1);
    }
    if (!svc_val(retstr, "center.coord.x", lat))
    {
	printf("error fetching center.coord.x\n");
	exit(1);
    }
    if (!svc_val(retstr, "center.coord.y", lon))
    {
	printf("error fetching center.coord.y\n");
	exit(1);
    }
    if (!svc_val(retstr, "center.pixel_value", pixel_value))
    {
	printf("error fetching center.pixel_value\n");
	exit(1);
    }
    if (!svc_val(retstr, "center.units", units))
    {
	printf("error fetching center.units\n");
	exit(1);
    }
    printf("lat = %s  lon = %s  pixel_value %s %s\n", 
	lat, lon, pixel_value, units);


    svc_close(handle);
}
