/* imstats.c  (image statistics program) */
static char version[] = "@(#)imstats.c %I% %E%";

#include <math.h>

main(argc,argv)
int argc;
char *argv[];
{
#define BUFSIZE 32768
#define MAXINFILES 32

   char infiles[MAXINFILES][64];
   int n_infiles;

   float buffer[BUFSIZE];

   int fid;
   int k;
   int naxis1, naxis2;
   int s;
   int n;

   double sum;
   double sum_squares;
   float min, max;
   int n_values;
   double avg;
   double variance, std_dev;

   par_f(infiles,"in,-");
   par_a(&n_infiles,"in,1,32");
   if (par_g(argc,argv) <0) return(-1);
   par_vers(version+4);

   printf(
    "|   MEAN   |  MINIMUM  |  MAXIMUM  | STD.DEV. |    N  |  IMAGE                |\n");

   for (k=0; k<n_infiles; k++) {
      fid = im_open(infiles[k],"r-");
      if (fid < 0) {
         msg1(1,-2,"Cannot read image file %s",infiles[k]);
         continue;
      }

      im_rkey_i(fid,&naxis1,"NAXIS1");
      im_rkey_i(fid,&naxis2,"NAXIS2");

      sum  = sum_squares = 0;
      n_values = 0;
      for (n=1; n; ) {
         n = im_rpix_r(fid,buffer,BUFSIZE);
         for (s=0; s<n; s++) {
            if (buffer[s] == buffer[s]) {
               sum += buffer[s];
               sum_squares += buffer[s] * buffer[s];
               if (n_values ==0) min = max = buffer[s];
               else {
                  if (buffer[s] > max) max = buffer[s];
                  else if (buffer[s] < min) min = buffer[s];
               }
               n_values ++;
            }
         }
      }

      im_close(fid);

      if (n_values) {
         avg = sum / n_values;
         if (n_values > 1) variance = (sum_squares - sum*avg) / (n_values);
         else              variance = 0;
          /* 
             variance =  ( (x1-avg)**2 + (x2-avg)**2 + ... ) / (n)
                      = (sum_sq - sum*sum/n) / (n)
           */
      }
      else avg = variance = min = max = 0;
      if (variance>0) std_dev = sqrt(variance);
      else            std_dev = 0;

      printf("%#11.5g %#11.5g %#11.5g %#10.5g%8d %s\n",
       avg, min, max, std_dev, n_values, infiles[k]);
   }

   msg(711,0,"DONE");
}

