/* histogram.c  (image histogram program) */
static char version[] = "@(#)histogram.c %I% %E%";

main(argc,argv)
int argc;
char *argv[];
{
#define BUFSIZE 32768
#define MAXBINS 10000
 /* if change MAXBINS, also change in par_f call below */

   char infile[64];
   int n_bins;
   float min_bin;
   float max_bin;
   int want_zeroes;

   float buffer[BUFSIZE];

   int fid;
   int s;
   int n;
   int i;
   float base_value;
   float bin_size;
   float val;
   float one_percent;

   int bin[MAXBINS+1];
   float datamin;
   float datamax;
   int n_values;
   int n_blanks;

   par_f(infile,"in,-");
   par_r(&min_bin,"min,0,,,Value corresponding to lowest bin");
   par_r(&max_bin,"max,0,,,Value corresponding to highest bin");
   par_i(&n_bins,"nbins,31,1,100000,Number of bins");
   par_i(&want_zeroes,"zeroes,1,0,1,Should print empty bins (1=yes, 0=no)");
   if (par_g(argc,argv) <0) return(-1);
   par_vers(version+4);

   if (min_bin== 0 && max_bin==0) {
      if (strcmp(infile,"-")==0) 
       msg(3,-1,"parameter error: min and max must be specified if in = -");
      fid = im_open(infile,"r");
      if (fid < 0) msg(3,-2,"Cannot read image file");

      /* min&max prescan */
      datamax = -1.0;
      datamin =  1.0;
      for (n=1; n; ) {
         n = im_rpix_r(fid,buffer,BUFSIZE);
         for (s=0; s<n; s++) {
            if (buffer[s] == buffer[s]) {
               if (datamin <= datamax) {
                  if (buffer[s] < datamin) datamin = buffer[s];
                  if (buffer[s] > datamax) datamax = buffer[s];
               }
               else {
                  datamin = datamax = buffer[s];
               }
            }
         }
      }
      im_rpix_r(fid,buffer,-1); /* "rewind" pixels */
      min_bin = datamin;
      max_bin = datamax;
   }

   else if (min_bin < max_bin) {
      fid = im_open(infile,"r-");
      if (fid < 0) msg(3,-2,"Cannot read image file");
   }

   else {
     msg(3,-1,"parameter error: max must be greater than min");
   }


   datamax = -1.0;
   datamin =  1.0;

   for (i=0; i<n_bins; i++) bin[i]=0;
   n_values = 0;

   bin_size = (max_bin - min_bin) / (n_bins-1);
   base_value = min_bin - bin_size/2;

   for (n=1; n; ) {
      n = im_rpix_r(fid,buffer,BUFSIZE);
      for (s=0; s<n; s++) {
         if (buffer[s] == buffer[s]) {
            i = (buffer[s] - base_value) / bin_size;
            if (i<0) i=0;
            if (i>=n_bins) i=n_bins-1;
            bin[i] ++;
            n_values ++;

            if (datamin <= datamax) {
               if (buffer[s] < datamin) datamin = buffer[s];
               if (buffer[s] > datamax) datamax = buffer[s];
            }
            else { datamin = datamax = buffer[s]; }

         }
         else n_blanks ++;
      }
   }
   im_close(fid);

   printf("\\C IMAGE = %s\n",infile);
   printf("\\C plmode = histogram\n");
   printf("\\R DATAMAX = %g\n",datamax);
   printf("\\R DATAMIN = %g\n",datamin);
   printf("\\I NVALUES = %d\n",n_values);
   printf("\\I NBLANKS = %d\n",n_blanks);

   printf("|  VALUE  |    %%  | cum %% |     N  |  cum N |\n");

   one_percent = 100.0 / n_values;
   val = min_bin;
   n = 0;
   for (i=0; i<n_bins; i++) {
      n += bin[i];
      if (want_zeroes || bin[i])
        printf("%#10.4G %7.3f %7.3f%9d%9d\n",
          val,bin[i]*one_percent,n*one_percent,bin[i],n);
      val += bin_size;
   }
   msg(711,0,"DONE");

}


