/* conductor.c :: handles application specific setup and takedown of
 *               images, that is the before and after housekeeping
 *               chores involved with getting images to and from,
 *               a unary operator (the engine).
 *
 *    Rick Ebert  October,1987       rick@ipac.caltech.edu
 *     modified to use the New image i/o routines: October, 1988
 *     Image Flip routine            April 1, 1992
 */
#include <stdio.h>
#include <math.h>
#include "squawk.h"
#include "imaginfo.h"

typedef unsigned char  BYTE;

void squawk(level,message)
enum error_level level;
char *message;
{
     fprintf(stderr,"%s\n", message);
     if(level == Terminal) exit(-1);
     return ;
}

int
conductor(ifilname, ofilname, hflip, vflip)
char *ifilname, *ofilname;
int hflip, vflip;
{

	int iimdes, oimdes;
	int fids[2];
	int counter;
	int lc;   /* Number of require live pixels, derived from live_pct */
	char string[81], skey[9];
	char *bufptr, *malloc();
	BYTE *inptr, *outptr;
	BYTE *iptr, *optr, *t;
        struct imaginfo  inputimag, outputimag;
	
	int hindex, vindex;
	float blank;
	int iblank;
	int bitpix;
	int bytepix; /* number of bytes per pixel */
	int    axis[2];
	double cdelt[2];
	double crpix[2];
	int    crpix_exist[2];
	/* version number for HISTORY card */
        static char history_version[] = "V1.0";

        extern int debug;  /* main set this up for us */
	int intdebug, i, j;      /* for storing return codes etc. debug use */
	int npixels;

	if((iimdes =im_open(ifilname, READ))  < 0)
		squawk(Terminal, "Error opening input file");

        inputimag.fid = iimdes;

        /* open output file */
	if((oimdes =im_open(ofilname, WRITE))  < 0)
		squawk(Terminal, "Error opening input file");

        outputimag.fid = oimdes;
/* get generally useful image information                    */

        if(getimaginfo(&inputimag) != 2)
	   squawk(Terminal,"Input must 2 dimensional image or subimage");
       
	npixels = inputimag.npixels;
	sprintf(skey,"BITPIX");
        if(im_rkey_i(inputimag.fid, &bitpix, skey) < 0)
	   squawk(Terminal,"Error getting imageinfo");

/* Set-up more of the inputimag struct */
        if (bitpix < 0) /* a floating point pixel */
	     im_blank(&blank);
	else {
	     if(im_rkey_i(inputimag.fid, &iblank, skey) < 0)
		squawk(Terminal,"Error getting imageinfo");
        }

        for(i=0, j=0; i < inputimag.ndim && j < 2; i++)
	   if (inputimag.naxis[i] > 1) {
	      sprintf(skey,"CDELT%d",i+1);
	      axis[j] = i+1; /* axis is FITS axis number */
              if(im_rkey_d(inputimag.fid, &cdelt[j], skey) < 0)
                  cdelt[j] = 1.0;
	      sprintf(skey,"CRPIX%d",i+1);
              crpix_exist[j] = 1;
              if(im_rkey_d(inputimag.fid, &crpix[j], skey) < 0)
                  crpix_exist[j] = 0;
              j++;
           }
	if(debug >5) fprintf(stderr,"Found Cdelts %g %g\n", cdelt[0], cdelt[1]);
	if(debug >5) fprintf(stderr,"Found Crpix  %g %g\n", crpix[0], crpix[1]);
	/* setup for default -- make CDELTS positive */
        if (cdelt[0] > 0 && cdelt[1] > 0 && hflip == 0 && vflip == 0 ){
	   fprintf(stderr,"Image already has positive CDELT's\n");
	   return(0);
        }
	if (hflip == 0 && vflip == 0) {
	    if (cdelt[0] < 0) hflip++;
	    if (cdelt[1] < 0) vflip++;
        }
   /* Other conditions are user specified -- flip h & v only as she wants */ 
	if(debug >5)
           fprintf(stderr,"Decided to Flip: %s %s %s\n",
                                             (hflip)?"Horizontally":"",
					     (hflip && vflip)?"and":"",
					     (vflip)?"Vertically":"");

	outputimag.npixels = inputimag.npixels;
        bytepix = (abs(bitpix)/8);

/* create some space to read in the pixels    */
	if(debug >5) fprintf(stderr,"Going to malloc pixptr\n");
	if((bufptr = malloc(npixels * bytepix)) == (char *) 0)
		squawk(Terminal, "Can't get enough image memory");

	inptr = (BYTE *) bufptr;  /* pixptr points to pixel buffer */

/* create some space for output pixels    */
	
	if(debug >5) fprintf(stderr,"Going to malloc outptr\n");
	if((bufptr = malloc(npixels * bytepix)) == (char *) 0)
		squawk(Terminal, "Can't get enough output image memory");

	outptr = (BYTE *) bufptr;  /* outptr points to output pixel buffer */

/* read in the pixels */
	if(debug >5) fprintf(stderr,"Going to read pixels\n");
    switch(bitpix){
      case -32:
	if(im_rpix_r(iimdes, (float *) inptr, npixels) != npixels)
		squawk(Terminal, "Error reading pixels");
        break;
      case 32:
	if(im_rpix_i(iimdes, (int *) inptr, npixels) != npixels)
		squawk(Terminal, "Error reading pixels");
        break;
      case 16:
	if(im_rpix_s(iimdes, (short *) inptr, npixels) != npixels)
		squawk(Terminal, "Error reading pixels");
        break;
      case 8:
	if(im_rpix_c(iimdes, (BYTE *) inptr, npixels) != npixels)
		squawk(Terminal, "Error reading pixels");
        break;
    }
	/* copy input header to output image...*/

	if(debug >5) fprintf(stderr,"Copy header...\n");
	fids[0]=iimdes;
	fids[1]=0;
	im_hdr(oimdes, fids, (char *) 0);

/* perform the operation on the pixel buffer (*pixptr) here */


/* update the header to agree with the new image in the output */

/* add a comment to say what we've done                         */
	 if(debug >5) fprintf(stderr,"Update the header\n");
	sprintf(string,
	  "HISTORY Flipped %s %s %s (IPAC flip %s)", (hflip)?"horizontal":"",
						     (vflip && hflip)?"and":"",
						     (vflip)?"vertically":"",
	                                             history_version); 
	im_wkey_t(oimdes, string, AT_END);
	if(hflip){
	  sprintf(string,"CDELT%d", axis[0]);
	  if(im_wkey_d(oimdes,(- cdelt[0]),string) < 0)
		squawk(Terminal, "Updating CDELT");
	  if(crpix_exist[0]){
	      if (debug>5) fprintf(stderr,"CRPIX%d was %g\n", axis[0], crpix[0]);
	      if (debug>5) fprintf(stderr,"NAXIS%d is %d\n", axis[0], inputimag.naxis[axis[0]-1]);
	      crpix[0]=1.0-crpix[0]+inputimag.naxis[axis[0]-1];
	      sprintf(string,"CRPIX%d", axis[0]);
	      if(im_wkey_d(oimdes,crpix[0],string) < 0)
		  squawk(Terminal, "Updating CRPIX");
	      if (debug>5) fprintf(stderr,"CRPIX%d is now %g\n", axis[0], crpix[0]);
          }
        }
	if(vflip){
	  sprintf(string,"CDELT%d", axis[1]);
	  if(im_wkey_d(oimdes,(- cdelt[1]),string) < 0)
		squawk(Terminal, "Updating output header");
	  if(crpix_exist[1]){
	      if (debug>5) fprintf(stderr,"CRPIX%d was %g\n", axis[1], crpix[1]);
	      if (debug>5) fprintf(stderr,"NAXIS%d is %d\n", axis[1], inputimag.naxis[axis[1]-1]);
	      crpix[1]=1.0-crpix[1]+inputimag.naxis[axis[1]-1];
	      sprintf(string,"CRPIX%d", axis[1]);
	      if(im_wkey_d(oimdes,crpix[1],string) < 0)
		  squawk(Terminal, "Updating CRPIX");
	      if (debug>5) fprintf(stderr,"CRPIX%d is now %g\n", axis[1], crpix[1]);
          }
        }

/* do the work */
   iptr = inptr;
   hindex = bytepix * ((hflip)?-1:1);
   vindex = inputimag.naxis[axis[0]-1] * bytepix * ((vflip)?-1:1);
   counter = npixels;

   if(hflip && vflip)                             /* initially point at:     */
    optr = (outptr + ((npixels-1)* bytepix));                  /* last pixel */
   else if(vflip)
    optr = (outptr + ((npixels-1)* bytepix) +vindex+bytepix ); /* end of last line */
   else if(hflip)
     optr = (outptr + vindex - bytepix );         /* last pixel of first line */

 /* flip whichever -- with hindex and vindex and starting points set GO! */

   if(debug >5) fprintf(stderr,"!FLIP! them pixels...\n");
   while(counter){ 
         for(i=0,t=optr;i<inputimag.naxis[axis[0]-1];i++,counter--){
	    memcpy(t, iptr, bytepix);
	    iptr+= bytepix;
	    t   += hindex;
         }
         optr += vindex;
   }
  if(debug >8) fprintf(stderr,"HEY! These ain't pixels they is flapjacks...\n");

/* No fixup needed -- all we did is move the pix around a little */

/* write the pixel buffer to the output image, and close up shop */
/* Make no more changes to the header after this line!           */

      if(debug >5) fprintf(stderr,"Write the new pixels\n");

    switch(bitpix){
      case -32:
	if(im_wpix_r(oimdes, (float *) outptr, npixels) != npixels)
 		squawk(Terminal, "Error writing pixels to output");
        break;
      case 32:
	if(im_wpix_i(oimdes, (int *) outptr, npixels) != npixels)
 		squawk(Terminal, "Error writing pixels to output");
        break;
      case 16:
	if(im_wpix_s(oimdes, (short *) outptr, npixels) != npixels)
 		squawk(Terminal, "Error writing pixels to output");
        break;
      case 8:
	if(im_wpix_c(oimdes, (BYTE *) outptr, npixels) != npixels)
 		squawk(Terminal, "Error writing pixels to output");
        break;
    }
/* we're done! */
	if(debug >5) fprintf(stderr,"Close the images\n");
	if(im_close(iimdes) < 0)
		squawk(Tolerable,"Error closing input image");
	if(im_close(oimdes) < 0)
		squawk(Tolerable,"Error closing output image");

	/* TODO: should free all buffer before exiting */
	free((void *) inptr);
	free((void *) outptr);
	return(0);  /* Successful Completion */

}

/* get generally useful image information                    */
/* imag->fid must be valid.. ie the image is already open    */
/* return the number of real image dimensions in the image   */
/*   i.e. the number of NAXISn's with lengths greater than 1 */
int
getimaginfo(imag)
struct imaginfo *imag;
{
     extern int debug;
     char skey[9];
     int counter;
     int realdims;

    if(debug>5)
	fprintf(stderr,"getinfo> entry\n");

        im_blank(&imag->blank);  /* whaddaya mean "BLANK" ? */
#if EBUG
    if(debug>5)
	fprintf(stderr,"getinfo> get naxis\n");
#endif
/* number of axes in this image */
	if(im_rkey_i(imag->fid, &imag->ndim, "NAXIS") < 0)
		squawk(Terminal,"Error getting imageinfo");
/* now get the length of each of them... */
    if(debug>5)
	fprintf(stderr,"getinfo> get naxisn's\n");

	realdims = 0;
	imag->npixels = 1;
	for(counter=0; counter < imag->ndim; counter++){
	sprintf(skey,"NAXIS%d",counter+1);
	if(im_rkey_i(imag->fid, &imag->naxis[counter], skey) < 0)
		squawk(Terminal,"Error getting imageinfo");
	imag->npixels *= imag->naxis[counter];   /* calculate total # of pixels */
	if (imag->naxis[counter] > 1) realdims++;
	}
/* TODO:: get DATAMAX,DATAMIN, BSCALE & BZERO too */
        return(realdims); 
}
