#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <malloc.h>
#include <ctype.h>

static void badline();

main(argc, argv)
int argc;
char **argv;
{
    int file_d, rdstat, i, naxis, bitpix;
    int linecount, linenbr, column;
    char *buff, *pt, *endpt, *thisline, naxis_str[20];
    char strng[20];
    unsigned bufsiz;

    if (argc != 2)
    {
	printf("usage:  fitscheck <filename>\n");
	exit(1);
    }

    /* try for read only */
    file_d = open(argv[1], O_RDONLY, 0644);
    if (file_d < 0)
    {
	perror(argv[1]);
	exit(1);
    }

    bufsiz = 2880;
    buff = malloc(bufsiz);

    if ((rdstat = read(file_d,buff,2880)) != 2880)
    {
	printf("\nerror:  could only read %d bytes from file - minimum header is 2880 bytes\n", rdstat);
	if (rdstat < 80)
	    exit(1);
	/* pad out with spaces */
	for (i = rdstat; i < 2880; i++)
	    buff[i] = ' ';
    }

    if (strncmp(buff, "SIMPLE  =                    T", 30) != 0)
    {
	printf("Probable non-FITS file - first line is not\n");
	printf("SIMPLE  =                    T\n");
    }

    /* look for END */
    pt = buff;
    linecount = 0;
    for (;;)
    {
	for (i=0;i<36 ; i++, pt+=80, linecount++)
	{
	    if (strncmp(pt, "END     ", 8) == 0)
	    {
		/* later: check that cols 9-80 are spaces */
		break;
	    }
	}
	if (i != 36)
	    break;  /* found it */

	bufsiz += 2880;
	buff = realloc(buff, bufsiz);
	if (buff == NULL)
	{
	    printf("error:  unable to allocate enough memory\n");
	    exit(1);
	}
	pt = linecount * 80 + buff;
	if ((rdstat = read(file_d,pt,2880)) != 2880)
	{
	    if (rdstat == 0)
	    {
		printf("\nno END keyword in header\n");
		exit(1);
	    }
	    printf("\n    Last block of header is shorter that 2880 characters\n");

	    for (i = rdstat; i < 2880; i++)
		pt[i] = ' ';   /* pad with spaces */
	}
    }

    endpt = pt;   /* save location of END */

    /* check that last block is padded with spaces */
    for (i++, pt+=80; i < 36; i++, pt+=80)
    {
	if (*pt != ' ')
	{
	    printf("error:  final block of header is not filled with spaces after END keyword\n");
	}
    }

    /* check each line for formatting */
    pt = buff;
    linenbr = 1;
    while (pt < endpt)
    {
	thisline = pt - 1;
	/* line may contain no control characters (newline, null, etc.) */
	for (column = 1; column < 81; column++)
	    if ((!isascii(thisline[column])) || (iscntrl(thisline[column])))
	    {
		badline(linenbr, pt, 
		    "line contains a control character");
		break;
	    }
	/* keyword must be all caps */
	for (column = 1; column < 9; column++)
	    if ((isupper(thisline[column])) || 
		(isdigit(thisline[column])) ||
		(thisline[column] == ' ')   ||
		(thisline[column] == '-')   ||
		(thisline[column] == '_')   )
	    {
		continue;
	    }
	    else
	    {
		badline(linenbr, pt, 
		    "keyword has lower case characters");
		break;
	    }
	if ((strncmp(pt, "COMMENT ", 8) == 0) || (strncmp(pt, "HISTORY ", 8) == 0))
	    goto next_one;
	if (thisline[9] != '=')
	    badline(linenbr, pt, "no equal sign in column 9");
	if (thisline[10] != ' ')
	    badline(linenbr, pt, "column 10 must be a space");

	/* first non-blank must be quote or digit or + or - or T */
	for (column = 10; column < 80; column++)
	{
	    if (thisline[column] != ' ')
	    {
		switch(thisline[column])
		{
		    case 'T':
		    case 'F':
			if (column != 30)
			{
			    badline(linenbr, pt, 
				"logical T or F must be in column 30");
			}
			break;
		    case '\'':
			if (column != 11)
			{
			    badline(linenbr, pt, 
				"string quote mark must be in column 11");
			}
			/* find end of string */
			for (i = column+1; i < 81; i++)
			{
			    if (thisline[i] == '\'')
				break;
			    
			}
			if ((i - column) < 9)
			badline(linenbr, pt,
			    "string is shorter than 8 characters");

			if (i == 81)
			    badline(linenbr, pt,
				"no ending string quote");

			break;
		}
		break;
	    }
	}
	
next_one:
	pt += 80;
	linenbr++;
    }

    /* check required keywords */
    if (strncmp(buff+80, "BITPIX  ", 8) != 0)
    {
	badline(2, buff+80, "second line must be BITPIX");
    }
    else
    {
	bitpix = atoi(buff+89);
	switch(bitpix)
	{
	    case 8:
	    case 16:
	    case 32:
	    case -32:
	    case -64:
		break;
	    default:
		badline(2, buff+80, "BITPIX is not 8, 16, 32, -32, or -64");
	}
    }

    if (strncmp(buff+160, "NAXIS   ", 8) != 0)
    {
	badline(3, buff+160, "third line must be NAXIS");
	naxis = 0;
    }
    else
	naxis = atoi(buff+169);
    linenbr = 4;
    pt = buff + 240;
    for (i = 1; i <= naxis; i++)
    {
	strcpy(naxis_str, "NAXIS");
	sprintf(strng, "%d", i);
	strcat(naxis_str, strng);
	strcat(naxis_str, "   ");
	if (strncmp(pt, naxis_str, 8) != 0)
	    printf("error:  line %d should be %s\n", linenbr, naxis_str);
	pt+=80;
	linenbr++;
    }

    /* check if any more NAXIS cards */
    while (pt < endpt)
    {
	if (strncmp(pt, "NAXIS",5) == 0)
	    badline(linenbr, pt, "extra NAXIS line");

	pt+=80;
	linenbr++;
    }

    /* check projection type */
    linenbr = 4;
    pt = buff + 240;
    while (pt < endpt)
    {
	if ((strncmp(pt, "CTYPE1", 6) == 0) || (strncmp(pt, "CTYPE2", 6) == 0))
	{
	    if ((strncmp(pt+15, "-TAN", 4) == 0) ||
		(strncmp(pt+15, "-SIN", 4) == 0) ||
		(strncmp(pt+15, "-NCP", 4) == 0) ||
		(strncmp(pt+15, "-AIT", 4) == 0) ||
		(strncmp(pt+15, "----", 4) == 0) ||
		(strncmp(pt+15, "    ", 4) == 0))
	    {
		/*EMPTY*/
	    }
	    else
		badline(linenbr, pt, "projection type not recognized");
	}
	if (strncmp(pt, "PROJTYPE", 8) == 0)
	{
	    badline(linenbr, pt, 
		"warning:  PROJTYPE is not a standard FITS keyword");
	}

	if (strncmp(pt, "BLANK   ", 8) == 0)
	{
	    if (bitpix < 0)
		badline(linenbr, pt, 
		    "illegal to have BLANK in a floating point image");
	}

	pt += 80;
	linenbr++;
    }

    close(file_d);
}

static void
badline(n, ptr, msg)
int n;
char *ptr, *msg;
{
    printf("\nerror in line %d:\n%.80s\n   %s\n\n", n, ptr, msg);
}
