#! /bin/csh
# Generate a sequence of demonstrations for the convolver
# and it does a time on the convolution as well
#  usage:  csh thisfile >& outfile
#
#  This second demonstration is from Perry's suggestion
#  to use an original image that simulates an IRAS source.
#
date
# First make the test image...
buildimg img.fit 128 128 gauss 8 4 30 20 10 10000 verbosity=0
# now make the kernel
buildimg gkernel.fit 15 15 gauss 4 4 0 0 0 1 verbosity=0
# now do the convolution
time convolve img.fit imgconv.fit gkernel.fit 50 verbosity=0
# Now for show and tell, make a kernel image the is the same scale as
# the image...
buildimg shokernel.fit 127 127 gauss 4 4 0 0 0 1 verbosity=0
# and mask off the pixels that aren't really in the kernel
alias imset "/usr/proto/work/try_IM/imset"
imset shokernel.fit 0 1 1 127 56
imset shokernel.fit 0 1 72 127 56
imset shokernel.fit 0 1 57 56 15
imset shokernel.fit 0 72 57 56 15
date
