/* command line parameter fetching routine */
/* debug stuff too */
#include <stdio.h>
#include "squawk.h"
struct lsp {
    char  imgfile[64];
    char  outfile[64];
    char  kernel[64];
    int   normal;
    float live_pct;
} lpars;
int debug;    /* any routine in the package needs access to this. */

struct lsp *get_params(argc, argv)
int argc;
char *argv[];
{

     char message[80];
     double ceil();

     par_f(lpars.imgfile,"IMAGE,,File containing image to convolve");
     par_f(lpars.outfile,"RESULT,,File to contain convolved image");
     par_f(lpars.kernel,"KERNEL,,File containing convolution kernel");
     par_r(&lpars.live_pct,"ACTIVE_AREA,50,100,0,Require this percentage of non-blank image pixels under the kernel");
     par_i(&lpars.normal,"NORMALIZE,1,1,0,Normalize output with kernel sum.");
     par_i(&debug,"VERBOSITY,1,99,0,Debugging level, check the documentation.");

     if (par_g(argc, argv))
              squawk(Terminal,"Didn't get the input parameters.");

     /* Debug stuff */

     if(debug > 1){

     fprintf(stderr,"Debug level set to %d\n", debug);
     fprintf(stderr,"\nInput parameters are:\n");
     fprintf(stderr,"IMAGE=%s\n",lpars.imgfile);
     fprintf(stderr,"RESULT=%s\n",lpars.outfile);
     fprintf(stderr,"KERNEL=%s\n",lpars.kernel);
     fprintf(stderr,"ACTIVE_AREA=%f\n",lpars.live_pct);
     fprintf(stderr,"NORMALIZE=%s\n",(lpars.normal)?"True":"False");
     fprintf(stderr,"DEBUG=%d\n",debug);
     }

     /* Done with getting and checking the inputs, we should be self
      * sufficient now. 
      * return a pointer to the parameter structure
      */

     return( &lpars);
}

main(argc,argv)
int argc;
char *argv[];
{

    struct lsp *sp;

    sp = get_params(argc, argv);

    conductor(sp->imgfile, sp->outfile, sp->kernel, sp->live_pct, sp->normal);

    exit(0);
}
