/* conv.c   code chunk to do a general convolution with a general
 * n by m kernel in 2 dimensions.
 *    adapted by  rick ebert 27 March 1989 and before.  rick@ipac.caltech.edu
 */
/*
 * some conventions:
 *  all lower case names  xxxxx  are program variables
 *  all capitals          XXXXX  are #defines
 *  up-down words         Xxxxx  are enum types
 */
/*
 * read_pixel() is counted on to return the value of the pixel requested
 *  even if it is off the real image, that is it must return the pixel
 * value of off image pixels by applying boundary conditions.
 *
 * write_pixel() records one pixel in a safe place and does not affect the
 * input image pixels in any way.
 *
 */
#include <stdio.h>
#include "imaginfo.h"

/* Maybe this is the crude way of dealing with pixel I/O, but it's fast
 * and it'll work...
 * inpix and outpix are pointers to the pixel buffers setup by the
 * conductor routine (see architectural notes).
 * We then #define the read_pixel and write_pixel routines so they are
 * compiled in (a function inliner would be the best way to handle this...
 * but defining the functions so they are usable, that's another thing!
 */
extern PIXEL *inpix, *outpix;
#define read_pixel(c,r) (c<0||c>=samples||r<0||r>=lines)?blank:*(inpix+(r*samples)+c)
#define write_pixel(c,r,v) *(outpix+(r*samples)+c)=v


/* the declaration of this function may change */
int
conv(iptr, kernel, kn, km, lc)
struct imaginfo *iptr;
float *kernel; /* an array containing the n by m kernel */
int km;           /* size of kernel in sample axis (naxis1) */
int kn;           /* size of kernel in line axis   (naxis2) */
int lc;     /* live count, this many pixels in the input must be non-blank
             * otherwise the result pixel will be blank
             */
{

register int i, j, n, m, live_count;
int rn, rm;
double sum, ksum;
float *kptr, pix, blank;
/* float read_pixel(), get_blank(); */
int samples;  /* number of samples in the input image (naxis1) */
int lines;    /* number of lines in the input image   (naxis2) */
int axes[2];  /* to contain the 2 length of the input axes */
extern int debug;

/* set range of kernel loop variables */
/* this is so the kernel loops can range from -[kn/2] to +[kn/2] */
rn = kn/2;
rm = km/2;

/* set local vars from the struct */
blank = iptr->blank;
    nlengths(iptr, axes, 2);
samples = axes[0];
lines = axes[1];

/* move over the entire image */
 for (j = 0 ; j < lines ; j++){                     /* the lines */
   for(i = 0; i < samples ; i++){                   /* the samples */
      sum = 0;                          /* reset cumulative convolution sum */
      ksum = 0;                         /* reset cumulative kernel sum */
      live_count = 0;                   /* reset live pixel counter */
      kptr = kernel+(km*kn-1);          /* reset kernel pointer */
					/* make that  kptr = kernel; and you
					 * get correlation!
					 */
   /* this pair of loops does the convolution for each pixel */
      for(n = -rn ; n <= rn ; n++) {
        for(m = -rm ; m <= rm ; m++){
           pix = read_pixel((i+m),(j+n));
              sum += pix * (*kptr);
	      ksum += (*kptr);
              live_count++;
           
	   kptr--;  /* even if the pixel is blank we still have to increment */
		    /* decrement for convolution, increment for correllation */
        }
      } /* end of  per pixel for loop */
	sum /= ksum;
        write_pixel(i,j, (float) sum);
	
    }
 }
  return(0); /* if we finish it "must" be OK, right? */
}
