/* conductor.c :: handles application specific setup and takedown of
 *               images, that is the before and after housekeeping
 *               chores involved with getting images to and from,
 *               a unary operator (the engine).
 *
 *    Rick Ebert  October,1987       rick@ipac.caltech.edu
 *     modified to use the New image i/o routines: October, 1988
 */
#include <stdio.h>
#include <math.h>
#include "squawk.h"
#include "imaginfo.h"

/* the kludge stuff... These pointers are external and are used to pass
 * the buffer locations to the read_pixel and write_pixel #defines in conv.c
 */
PIXEL *inpix, *outpix;

int
conductor(ifilname, ofilname, kernelname, live_pct, normalize)
char *ifilname, *ofilname, *kernelname;
float live_pct;
int normalize;
{

	int iimdes, oimdes;
	int fids[2];
	int counter;
	int lc;   /* Number of require live pixels, derived from live_pct */
	int ksize[2]; /* kernel width(samples) and height(lines) resp. */
	char string[81], skey[9];
	char *bufptr, *malloc();
	PIXEL *pixptr, *outptr;
        struct imaginfo  inputimag, outputimag, kernelimag;
	PIXEL *kptr;  /* pointer to the kernel */
	PIXEL *pixtmp, tmp; /* for just any ol' thing */
	void conv();
	/* version number for HISTORY card */
        static char history_version[] = "V3.0";

        extern int debug;  /* main set this up for us */
	int intdebug, i, j;      /* for storing return codes etc. debug use */
	int npixels;

	if((iimdes =im_open(ifilname, READ))  < 0)
		squawk(Terminal, "Error opening input file");

        inputimag.fid = iimdes;

        /* open output file */
	if((oimdes =im_open(ofilname, WRITE))  < 0)
		squawk(Terminal, "Error opening input file");

        outputimag.fid = oimdes;
/* get generally useful image information                    */

        if(getimaginfo(&inputimag) != 2)
	   squawk(Terminal,"Input must 2 dimensional image or subimage");
       
	npixels = inputimag.npixels;

/* Set-up more of the inputimag struct */
	outputimag.blank = inputimag.blank;
        inputimag.bscale = 1;
	inputimag.b_zero  = 0;
	outputimag.npixels = inputimag.npixels;

/* create some space to read in the pixels    */
	if(debug >5) fprintf(stderr,"Going to malloc pixptr\n");
	if((bufptr = malloc(npixels * SIZPIXEL)) == (char *) 0)
		squawk(Terminal, "Can't get enough image memory");

	pixptr = (PIXEL *) bufptr;  /* pixptr points to pixel buffer */
	inpix = pixptr; /* part of the conv inline kludge */

/* create some space for output pixels    */
	
	if(debug >5) fprintf(stderr,"Going to malloc outptr\n");
	if((bufptr = malloc(npixels * SIZPIXEL)) == (char *) 0)
		squawk(Terminal, "Can't get enough output image memory");

	outptr = (PIXEL *) bufptr;  /* outptr points to output pixel buffer */
	outpix = outptr; /* part of the conv inline kludge */

/* read in the pixels */
	if(debug >5) fprintf(stderr,"Going to read pixels\n");
	if(im_rpix_r(iimdes, pixptr, npixels) != npixels)
		squawk(Terminal, "Error reading pixels");
#ifdef DEBUG
 if(debug == 12){
        fprintf(stderr,"conductor: debug: Print out all pixels going in...\n");
 for (j = 0 ; j < inputimag.naxis[2]; j++)          /* the lines */
   for(i = 0; i < inputimag.naxis[1]; i++)          /* the samples */
     fprintf(stderr,"%f ", *inpix++);
     fprintf(stderr,"\nEnd of input pixel buffer\n");
     inpix = pixptr; /* reset after use */
  }
#endif
	/* copy input header to output image...*/

	if(debug >5) fprintf(stderr,"Copy header...\n");
	fids[0]=iimdes;
	fids[1]=0;
	im_hdr(oimdes, fids, (char *) 0);

/* perform the operation on the pixel buffer (*pixptr) here */

	/*user_defined_function();*/
	if((kernelimag.fid =im_open(kernelname, READ))  < 0)
		squawk(Terminal, "Error opening kernel file");
        if(getimaginfo(&kernelimag) != 2)
		squawk(Terminal, "Kernel image is not 2 dimensional!");
        nlengths(&kernelimag, ksize, 2);

	/* check for odd sizes... there Must be a center pixel */
	for(i=0; i< 2; i++)
	   if(! (ksize[i]%2))
           squawk(Terminal,
	      "Kernel must have sides with ODD (3,5,7,9...) lengths");

	if(debug >5) fprintf(stderr,"Going to malloc kptr\n");
	if((bufptr = malloc(kernelimag.npixels * SIZPIXEL)) == (char *) 0)
		squawk(Terminal, "Can't get enough memory for the kernel");

	kptr = (PIXEL *) bufptr;
/* read in the kernel */
   if(debug >5) fprintf(stderr,"Going to read kernel\n");
   if(im_rpix_r(kernelimag.fid, kptr, kernelimag.npixels) != kernelimag.npixels)
		squawk(Terminal, "Error reading kernel");
	
   pixtmp = kptr;
   for(i=0, j=0 ; i<kernelimag.npixels; i++, pixtmp++)
    if(! finite(*pixtmp))
      {
	 *pixtmp = 0.0; /* treat blanks in kernel as zero */
         if(! j) squawk(Warning, "Blanks in Kernel read as zero");
	 j++;
      }
	/* the percent *live* specified by the user as # pixels */
	lc = ceil((double) live_pct/100.0 * kernelimag.npixels);

	if(debug>9){
	 fprintf(stderr,"Got the Kernel:\n");
         for(j=0;j<ksize[1];j++){
          for(i=0;i<ksize[0];i++) fprintf(stderr,"%5.3f ",
	            *(kptr+(j*ksize[0] + i)));
         fprintf(stderr,"\n");
        }
	}
        /*
	 * We use the general convolver
	 */
	if(debug >5) fprintf(stderr,"Going to do the convolution\n");
	conv(&inputimag, kptr, ksize[1], ksize[0], lc, normalize);

/* update the header to agree with the new image in the output */

/* add a comment to say what we've done                         */
	 if(debug >5) fprintf(stderr,"Update the header\n");
	sprintf(string,
	  "HISTORY Convolved with kernel %s (IPAC convolve %s)",
	     kernelname, history_version); 
	im_wkey_t(oimdes, string, AT_END);

/* The fix-up business goes here...
 *  Get the new datamax and datamin, calculate a new bscale and bzero if
 *  needed etc.  Adjust the rest of the header.
 */
        /* fix-up-function(); */
	hdrclean(outptr, &outputimag );
/* write the pixel buffer to the output image, and close up shop */
/* Make no more changes to the header after this line!           */

	if(debug >5) fprintf(stderr,"Write the new pixels\n");
	if(im_wpix_r(oimdes, outptr, npixels) != npixels) 
 		squawk(Terminal, "Error writing pixels to output");

/* we're done! */
	if(debug >5) fprintf(stderr,"Close the images\n");
	if(im_close(iimdes) < 0)
		squawk(Tolerable,"Error closing input image");
	if(im_close(oimdes) < 0)
		squawk(Tolerable,"Error closing output image");
	if(im_close(kernelimag.fid) < 0)
		squawk(Tolerable,"Error closing kernel file");

	/* TODO: should free all buffer before exiting */
	return(0);  /* Successful Completion */

}
