/*  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	ptile  - estimate percentile from histogram

						gene kopan   ipac/cit
						started       1/28/91
    Modified to be compatible with flatten -- B. Penprase 6/10/92
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/*
 * Copyright (C) 1992, California Institute of Technology.
 * U.S. Government Sponsorship under NASA Contract NAS7-918
 * is acknowledged.
 */
#include <math.h>

ptile ( nb, h, ntot, tile, ptile )

/*        arguments:
		nb	number of bins in histogram
		h	pointer to first bin
		ntot	cumulative sum of histogram
		tile 	float fractional value of required percentile
		ptile	float index of computed bin of tile      
*/

int	nb,ntot,h[];
float  	*ptile,tile;
{
	int	ncum,ntile,itile,itilo;
	float	ftile;

	ncum = itile = itilo = 0; ftile = tile*(1+ntot); ntile = ftile + 0.6;
	while( itile < nb && (ncum += h[itile]) < ntile )
		{	if( h[itile] ) itilo = itile;
			itile++;
		}
	if( itile == 0 )   { *ptile = 0.0; return( 0 ); }
	if( ncum < ntile ) { *ptile = nb-1; return( 0 ); }
	*ptile = itile + 0.5 - (ncum-ftile)*(itile-itilo)/(float)h[itile];
	return( 1 );
}
